package io.qt.quick;


/**
 * <p>Low-level storage for graphics primitives in the Qt Quick Scene Graph</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsggeometry.html">QSGGeometry</a></p>
 */
public class QSGGeometry extends io.qt.QtObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcAttributeSet = null;
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsggeometry.html#AttributeType-enum">QSGGeometry::AttributeType</a></p>
     */
    public enum AttributeType implements io.qt.QtEnumerator {
        UnknownAttribute(0),
        PositionAttribute(1),
        ColorAttribute(2),
        TexCoordAttribute(3),
        TexCoord1Attribute(4),
        TexCoord2Attribute(5);

        private AttributeType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static AttributeType resolve(int value) {
            switch (value) {
            case 0: return UnknownAttribute;
            case 1: return PositionAttribute;
            case 2: return ColorAttribute;
            case 3: return TexCoordAttribute;
            case 4: return TexCoord1Attribute;
            case 5: return TexCoord2Attribute;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsggeometry.html#DataPattern-enum">QSGGeometry::DataPattern</a></p>
     */
    public enum DataPattern implements io.qt.QtEnumerator {
        AlwaysUploadPattern(0),
        StreamPattern(1),
        DynamicPattern(2),
        StaticPattern(3);

        private DataPattern(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DataPattern resolve(int value) {
            switch (value) {
            case 0: return AlwaysUploadPattern;
            case 1: return StreamPattern;
            case 2: return DynamicPattern;
            case 3: return StaticPattern;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsggeometry.html#DrawingMode-enum">QSGGeometry::DrawingMode</a></p>
     */
    public enum DrawingMode implements io.qt.QtEnumerator {
        DrawPoints(0),
        DrawLines(1),
        DrawLineLoop(2),
        DrawLineStrip(3),
        DrawTriangles(4),
        DrawTriangleStrip(5),
        DrawTriangleFan(6);

        private DrawingMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static DrawingMode resolve(int value) {
            switch (value) {
            case 0: return DrawPoints;
            case 1: return DrawLines;
            case 2: return DrawLineLoop;
            case 3: return DrawLineStrip;
            case 4: return DrawTriangles;
            case 5: return DrawTriangleStrip;
            case 6: return DrawTriangleFan;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsggeometry.html#Type-enum">QSGGeometry::Type</a></p>
     */
    public enum Type implements io.qt.QtEnumerator {
        ByteType(5120),
        UnsignedByteType(5121),
        ShortType(5122),
        UnsignedShortType(5123),
        IntType(5124),
        UnsignedIntType(5125),
        FloatType(5126),
        Bytes2Type(5127),
        Bytes3Type(5128),
        Bytes4Type(5129),
        DoubleType(5130);

        private Type(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Type resolve(int value) {
            switch (value) {
            case 5120: return ByteType;
            case 5121: return UnsignedByteType;
            case 5122: return ShortType;
            case 5123: return UnsignedShortType;
            case 5124: return IntType;
            case 5125: return UnsignedIntType;
            case 5126: return FloatType;
            case 5127: return Bytes2Type;
            case 5128: return Bytes3Type;
            case 5129: return Bytes4Type;
            case 5130: return DoubleType;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>QSGGeometry::Attribute describes a single vertex attribute in a QSGGeometry</p>
     * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsggeometry-attribute.html">QSGGeometry::Attribute</a></p>
     */
    public static class Attribute extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        /**
         * <p>Overloaded function for {@link #create(int, int, int, boolean)}
         *  with <code>isPosition = false</code>.</p>
         */
        public static io.qt.quick.QSGGeometry.Attribute create(int pos, int tupleSize, int primitiveType) {
            return create(pos, tupleSize, primitiveType, (boolean)false);
        }
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry-attribute.html#create">QSGGeometry::Attribute::create(int,int,int,bool)</a></p>
         */
        public native static io.qt.quick.QSGGeometry.Attribute create(int pos, int tupleSize, int primitiveType, boolean isPosition);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry-attribute.html#createWithAttributeType">QSGGeometry::Attribute::createWithAttributeType(int,int,int,QSGGeometry::AttributeType)</a></p>
         */
        public static io.qt.quick.QSGGeometry.Attribute createWithAttributeType(int pos, int tupleSize, int primitiveType, io.qt.quick.QSGGeometry.AttributeType attributeType){
            return createWithAttributeType_native_int_int_int_QSGGeometry_AttributeType(pos, tupleSize, primitiveType, attributeType.value());
        }
        
        private native static io.qt.quick.QSGGeometry.Attribute createWithAttributeType_native_int_int_int_QSGGeometry_AttributeType(int pos, int tupleSize, int primitiveType, int attributeType);
        
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGGeometry.AttributeType attributeType(){
            return io.qt.quick.QSGGeometry.AttributeType.resolve(attributeType_native(QtJambi_LibraryUtilities.internal.nativeId(this)));
        }
        
        @io.qt.QtUninvokable
        private native int attributeType_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final boolean isVertexCoordinate(){
            return isVertexCoordinate_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native boolean isVertexCoordinate_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final int position(){
            return position_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int position_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final int tupleSize(){
            return tupleSize_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int tupleSize_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final int type(){
            return type_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int type_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Attribute(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public Attribute clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native Attribute clone_native(long __this_nativeId);
    }
    /**
     * <p>QSGGeometry::AttributeSet describes how the vertices in a QSGGeometry are built up</p>
     * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsggeometry-attributeset.html">QSGGeometry::AttributeSet</a></p>
     */
    public static class AttributeSet extends io.qt.QtObject
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public AttributeSet(io.qt.quick.QSGGeometry.Attribute[] attributes, int stride){
            super((QPrivateConstructor)null);
            initialize_native(this, attributes, stride);
        }
        
        private native static void initialize_native(AttributeSet instance, io.qt.quick.QSGGeometry.Attribute[] attributes, int stride);
        
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGGeometry.Attribute[] attributes(){
            return attributes_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.quick.QSGGeometry.Attribute[] attributes_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final int count(){
            return count_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int count_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final int stride(){
            return stride_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int stride_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected AttributeSet(QPrivateConstructor p) { super(p); } 
        
        public AttributeSet(java.util.Collection<Attribute> attributes, int stride){
            this(attributes.toArray(new Attribute[attributes.size()]), stride);
        }
    }
    /**
     * <p>QSGGeometry::Point2D struct is a convenience struct for accessing 2D Points</p>
     * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsggeometry-point2d.html">QSGGeometry::Point2D</a></p>
     */
    public static class Point2D extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public Point2D(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(Point2D instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry-point2d.html#set">QSGGeometry::Point2D::set(float,float)</a></p>
         */
        @io.qt.QtUninvokable
        public final void set(float nx, float ny){
            set_native_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny);
        }
        
        @io.qt.QtUninvokable
        private native void set_native_float_float(long __this__nativeId, float nx, float ny);
        
        @io.qt.QtUninvokable
        public final void setX(float x){
            setX_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), x);
        }
        
        @io.qt.QtUninvokable
        private native void setX_native_float(long __this__nativeId, float x);
        
        @io.qt.QtUninvokable
        public final float x(){
            return x_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float x_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setY(float y){
            setY_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), y);
        }
        
        @io.qt.QtUninvokable
        private native void setY_native_float(long __this__nativeId, float y);
        
        @io.qt.QtUninvokable
        public final float y(){
            return y_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float y_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Point2D(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public Point2D clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native Point2D clone_native(long __this_nativeId);
    }
    /**
     * <p>QSGGeometry::TexturedPoint2D struct is a convenience struct for accessing 2D Points with texture coordinates</p>
     * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsggeometry-texturedpoint2d.html">QSGGeometry::TexturedPoint2D</a></p>
     */
    public static class TexturedPoint2D extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public TexturedPoint2D(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(TexturedPoint2D instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry-texturedpoint2d.html#set">QSGGeometry::TexturedPoint2D::set(float,float,float,float)</a></p>
         */
        @io.qt.QtUninvokable
        public final void set(float nx, float ny, float ntx, float nty){
            set_native_float_float_float_float(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, ntx, nty);
        }
        
        @io.qt.QtUninvokable
        private native void set_native_float_float_float_float(long __this__nativeId, float nx, float ny, float ntx, float nty);
        
        @io.qt.QtUninvokable
        public final void setTx(float tx){
            setTx_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), tx);
        }
        
        @io.qt.QtUninvokable
        private native void setTx_native_float(long __this__nativeId, float tx);
        
        @io.qt.QtUninvokable
        public final float tx(){
            return tx_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float tx_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setTy(float ty){
            setTy_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), ty);
        }
        
        @io.qt.QtUninvokable
        private native void setTy_native_float(long __this__nativeId, float ty);
        
        @io.qt.QtUninvokable
        public final float ty(){
            return ty_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float ty_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setX(float x){
            setX_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), x);
        }
        
        @io.qt.QtUninvokable
        private native void setX_native_float(long __this__nativeId, float x);
        
        @io.qt.QtUninvokable
        public final float x(){
            return x_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float x_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setY(float y){
            setY_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), y);
        }
        
        @io.qt.QtUninvokable
        private native void setY_native_float(long __this__nativeId, float y);
        
        @io.qt.QtUninvokable
        public final float y(){
            return y_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float y_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected TexturedPoint2D(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public TexturedPoint2D clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native TexturedPoint2D clone_native(long __this_nativeId);
    }
    /**
     * <p>QSGGeometry::ColoredPoint2D struct is a convenience struct for accessing 2D Points with a color</p>
     * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsggeometry-coloredpoint2d.html">QSGGeometry::ColoredPoint2D</a></p>
     */
    public static class ColoredPoint2D extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public ColoredPoint2D(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(ColoredPoint2D instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry-coloredpoint2d.html#set">QSGGeometry::ColoredPoint2D::set(float,float,uchar,uchar,uchar,uchar)</a></p>
         */
        @io.qt.QtUninvokable
        public final void set(float nx, float ny, byte nr, byte ng, byte nb, byte na){
            set_native_float_float_unsigned_char_unsigned_char_unsigned_char_unsigned_char(QtJambi_LibraryUtilities.internal.nativeId(this), nx, ny, nr, ng, nb, na);
        }
        
        @io.qt.QtUninvokable
        private native void set_native_float_float_unsigned_char_unsigned_char_unsigned_char_unsigned_char(long __this__nativeId, float nx, float ny, byte nr, byte ng, byte nb, byte na);
        
        @io.qt.QtUninvokable
        public final void setA(byte a){
            setA_native_unsigned_char(QtJambi_LibraryUtilities.internal.nativeId(this), a);
        }
        
        @io.qt.QtUninvokable
        private native void setA_native_unsigned_char(long __this__nativeId, byte a);
        
        @io.qt.QtUninvokable
        public final byte a(){
            return a_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native byte a_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setB(byte b){
            setB_native_unsigned_char(QtJambi_LibraryUtilities.internal.nativeId(this), b);
        }
        
        @io.qt.QtUninvokable
        private native void setB_native_unsigned_char(long __this__nativeId, byte b);
        
        @io.qt.QtUninvokable
        public final byte b(){
            return b_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native byte b_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setG(byte g){
            setG_native_unsigned_char(QtJambi_LibraryUtilities.internal.nativeId(this), g);
        }
        
        @io.qt.QtUninvokable
        private native void setG_native_unsigned_char(long __this__nativeId, byte g);
        
        @io.qt.QtUninvokable
        public final byte g(){
            return g_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native byte g_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setR(byte r){
            setR_native_unsigned_char(QtJambi_LibraryUtilities.internal.nativeId(this), r);
        }
        
        @io.qt.QtUninvokable
        private native void setR_native_unsigned_char(long __this__nativeId, byte r);
        
        @io.qt.QtUninvokable
        public final byte r(){
            return r_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native byte r_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setX(float x){
            setX_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), x);
        }
        
        @io.qt.QtUninvokable
        private native void setX_native_float(long __this__nativeId, float x);
        
        @io.qt.QtUninvokable
        public final float x(){
            return x_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float x_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setY(float y){
            setY_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), y);
        }
        
        @io.qt.QtUninvokable
        private native void setY_native_float(long __this__nativeId, float y);
        
        @io.qt.QtUninvokable
        public final float y(){
            return y_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native float y_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected ColoredPoint2D(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public ColoredPoint2D clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native ColoredPoint2D clone_native(long __this_nativeId);
    }

    
    /**
     * <p>Overloaded constructor for {@link #QSGGeometry(io.qt.quick.QSGGeometry.AttributeSet, int, int, int)}
     *  with <code>indexType = 5123</code>.</p>
     */
    public QSGGeometry(io.qt.quick.QSGGeometry.AttributeSet attribs, int vertexCount, int indexCount) {
        this(attribs, vertexCount, indexCount, (int)5123);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QSGGeometry(io.qt.quick.QSGGeometry.AttributeSet, int, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>indexCount = 0</code></li>
     * <li><code>indexType = 5123</code></li>
     * </ul>
     */
    public QSGGeometry(io.qt.quick.QSGGeometry.AttributeSet attribs, int vertexCount) {
        this(attribs, vertexCount, (int)0, (int)5123);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#QSGGeometry">QSGGeometry::QSGGeometry(QSGGeometry::AttributeSet,int,int,int)</a></p>
     */
    public QSGGeometry(io.qt.quick.QSGGeometry.AttributeSet attribs, int vertexCount, int indexCount, int indexType){
        super((QPrivateConstructor)null);
        java.util.Objects.requireNonNull(attribs, "Argument 'attribs': null not expected.");
        initialize_native(this, attribs, vertexCount, indexCount, indexType);
        __rcAttributeSet = attribs;
    }
    
    private native static void initialize_native(QSGGeometry instance, io.qt.quick.QSGGeometry.AttributeSet attribs, int vertexCount, int indexCount, int indexType);
    
    /**
     * <p>Overloaded function for {@link #allocate(int, int)}
     *  with <code>indexCount = 0</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void allocate(int vertexCount) {
        allocate(vertexCount, (int)0);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#allocate">QSGGeometry::allocate(int,int)</a></p>
     */
    @io.qt.QtUninvokable
    public final void allocate(int vertexCount, int indexCount){
        allocate_native_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), vertexCount, indexCount);
    }
    
    @io.qt.QtUninvokable
    private native void allocate_native_int_int(long __this__nativeId, int vertexCount, int indexCount);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#attributeCount">QSGGeometry::attributeCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int attributeCount(){
        return attributeCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int attributeCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#attributes">QSGGeometry::attributes()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGGeometry.Attribute[] attributes(){
        return attributes_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGGeometry.Attribute[] attributes_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#drawingMode">QSGGeometry::drawingMode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int drawingMode(){
        return drawingMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int drawingMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#indexCount">QSGGeometry::indexCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int indexCount(){
        return indexCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int indexCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#indexData">QSGGeometry::indexData()</a></p>
     */
    @io.qt.QtUninvokable
    public final java.nio.Buffer indexData(){
        return indexData_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.nio.Buffer indexData_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#indexDataPattern">QSGGeometry::indexDataPattern()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGGeometry.DataPattern indexDataPattern(){
        return io.qt.quick.QSGGeometry.DataPattern.resolve(indexDataPattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int indexDataPattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#indexType">QSGGeometry::indexType()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int indexType(){
        return indexType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int indexType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#lineWidth">QSGGeometry::lineWidth()const</a></p>
     */
    @io.qt.QtUninvokable
    public final float lineWidth(){
        return lineWidth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native float lineWidth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#markIndexDataDirty">QSGGeometry::markIndexDataDirty()</a></p>
     */
    @io.qt.QtUninvokable
    public final void markIndexDataDirty(){
        markIndexDataDirty_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void markIndexDataDirty_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#markVertexDataDirty">QSGGeometry::markVertexDataDirty()</a></p>
     */
    @io.qt.QtUninvokable
    public final void markVertexDataDirty(){
        markVertexDataDirty_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void markVertexDataDirty_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#setDrawingMode">QSGGeometry::setDrawingMode(uint)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDrawingMode(int mode){
        setDrawingMode_native_unsigned_int(QtJambi_LibraryUtilities.internal.nativeId(this), mode);
    }
    
    @io.qt.QtUninvokable
    private native void setDrawingMode_native_unsigned_int(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#setIndexDataPattern">QSGGeometry::setIndexDataPattern(QSGGeometry::DataPattern)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setIndexDataPattern(io.qt.quick.QSGGeometry.DataPattern p){
        setIndexDataPattern_native_QSGGeometry_DataPattern(QtJambi_LibraryUtilities.internal.nativeId(this), p.value());
    }
    
    @io.qt.QtUninvokable
    private native void setIndexDataPattern_native_QSGGeometry_DataPattern(long __this__nativeId, int p);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#setLineWidth">QSGGeometry::setLineWidth(float)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setLineWidth(float w){
        setLineWidth_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), w);
    }
    
    @io.qt.QtUninvokable
    private native void setLineWidth_native_float(long __this__nativeId, float w);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#setVertexDataPattern">QSGGeometry::setVertexDataPattern(QSGGeometry::DataPattern)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setVertexDataPattern(io.qt.quick.QSGGeometry.DataPattern p){
        setVertexDataPattern_native_QSGGeometry_DataPattern(QtJambi_LibraryUtilities.internal.nativeId(this), p.value());
    }
    
    @io.qt.QtUninvokable
    private native void setVertexDataPattern_native_QSGGeometry_DataPattern(long __this__nativeId, int p);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#sizeOfIndex">QSGGeometry::sizeOfIndex()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int sizeOfIndex(){
        return sizeOfIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int sizeOfIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#sizeOfVertex">QSGGeometry::sizeOfVertex()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int sizeOfVertex(){
        return sizeOfVertex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int sizeOfVertex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#vertexCount">QSGGeometry::vertexCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int vertexCount(){
        return vertexCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int vertexCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#vertexData">QSGGeometry::vertexData()</a></p>
     */
    @io.qt.QtUninvokable
    private final long vertexData_private(){
        return vertexData_private_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native long vertexData_private_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#vertexDataPattern">QSGGeometry::vertexDataPattern()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGGeometry.DataPattern vertexDataPattern(){
        return io.qt.quick.QSGGeometry.DataPattern.resolve(vertexDataPattern_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int vertexDataPattern_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#defaultAttributes_ColoredPoint2D">QSGGeometry::defaultAttributes_ColoredPoint2D()</a></p>
     */
    public native static io.qt.quick.QSGGeometry.AttributeSet defaultAttributes_ColoredPoint2D();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#defaultAttributes_Point2D">QSGGeometry::defaultAttributes_Point2D()</a></p>
     */
    public native static io.qt.quick.QSGGeometry.AttributeSet defaultAttributes_Point2D();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#defaultAttributes_TexturedPoint2D">QSGGeometry::defaultAttributes_TexturedPoint2D()</a></p>
     */
    public native static io.qt.quick.QSGGeometry.AttributeSet defaultAttributes_TexturedPoint2D();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#updateColoredRectGeometry">QSGGeometry::updateColoredRectGeometry(QSGGeometry*,QRectF)</a></p>
     */
    public static void updateColoredRectGeometry(io.qt.quick.QSGGeometry g, io.qt.core.QRectF rect){
        updateColoredRectGeometry_native_QSGGeometry_ptr_cref_QRectF(QtJambi_LibraryUtilities.internal.checkedNativeId(g), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    private native static void updateColoredRectGeometry_native_QSGGeometry_ptr_cref_QRectF(long g, long rect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#updateRectGeometry">QSGGeometry::updateRectGeometry(QSGGeometry*,QRectF)</a></p>
     */
    public static void updateRectGeometry(io.qt.quick.QSGGeometry g, io.qt.core.QRectF rect){
        updateRectGeometry_native_QSGGeometry_ptr_cref_QRectF(QtJambi_LibraryUtilities.internal.checkedNativeId(g), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    private native static void updateRectGeometry_native_QSGGeometry_ptr_cref_QRectF(long g, long rect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsggeometry.html#updateTexturedRectGeometry">QSGGeometry::updateTexturedRectGeometry(QSGGeometry*,QRectF,QRectF)</a></p>
     */
    public static void updateTexturedRectGeometry(io.qt.quick.QSGGeometry g, io.qt.core.QRectF rect, io.qt.core.QRectF sourceRect){
        updateTexturedRectGeometry_native_QSGGeometry_ptr_cref_QRectF_cref_QRectF(QtJambi_LibraryUtilities.internal.checkedNativeId(g), QtJambi_LibraryUtilities.internal.checkedNativeId(rect), QtJambi_LibraryUtilities.internal.checkedNativeId(sourceRect));
    }
    
    private native static void updateTexturedRectGeometry_native_QSGGeometry_ptr_cref_QRectF_cref_QRectF(long g, long rect, long sourceRect);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGGeometry(QPrivateConstructor p) { super(p); } 
    
    public native VertexData<?> vertexData();
    
    private static native ColoredPoint2D getColoredPoint2D(long pointer, int index);
    
    private static native void setColoredPoint2D(long pointer, int index, ColoredPoint2D value);
    
    private static native TexturedPoint2D getTexturedPoint2D(long pointer, int index);
    
    private static native void setTexturedPoint2D(long pointer, int index, TexturedPoint2D value);
    
    private static native Point2D getPoint2D(long pointer, int index);
    
    private static native void setPoint2D(long pointer, int index, Point2D value);
    
    public static class VertexData<T extends io.qt.QtObjectInterface>{
        public VertexData(long pointer, int size) {
            super();
            this.pointer = pointer;
            this.size = size;
        }
        
        final long pointer;
        final int size;
    
        @io.qt.QtUninvokable
        public T get(int index) {
            throw new UnsupportedOperationException();
        }
        
        @io.qt.QtUninvokable
        public void set(int index, T value) {
            throw new UnsupportedOperationException();
        }
    }
    
    public static class ColoredPoint2DVertexData extends VertexData<ColoredPoint2D>{
        public ColoredPoint2DVertexData(long pointer, int size) {
            super(pointer, size);
        }
    
        @Override
        public ColoredPoint2D get(int index) {
            if(index<0 || index>=size)
                throw new ArrayIndexOutOfBoundsException();
            return getColoredPoint2D(pointer, index);
        }
    
        @Override
        public void set(int index, ColoredPoint2D value) {
            if(index<0 || index>=size)
                throw new ArrayIndexOutOfBoundsException();
            setColoredPoint2D(pointer, index, value);
        }
    }
    
    public static class TexturedPoint2DVertexData extends VertexData<TexturedPoint2D>{
        public TexturedPoint2DVertexData(long pointer, int size) {
            super(pointer, size);
        }
    
        @Override
        public TexturedPoint2D get(int index) {
            if(index<0 || index>=size)
                throw new ArrayIndexOutOfBoundsException();
            return getTexturedPoint2D(pointer, index);
        }
    
        @Override
        public void set(int index, TexturedPoint2D value) {
            if(index<0 || index>=size)
                throw new ArrayIndexOutOfBoundsException();
            setTexturedPoint2D(pointer, index, value);
        }
    }
    
    public static class Point2DVertexData extends VertexData<Point2D>{
        public Point2DVertexData(long pointer, int size) {
            super(pointer, size);
        }
    
        @Override
        public Point2D get(int index) {
            if(index<0 || index>=size)
                throw new ArrayIndexOutOfBoundsException();
            return getPoint2D(pointer, index);
        }
    
        @Override
        public void set(int index, Point2D value) {
            if(index<0 || index>=size)
                throw new ArrayIndexOutOfBoundsException();
            setPoint2D(pointer, index, value);
        }
    }
}
