package io.qt.quick;


/**
 * <p>Allows low level rendering of a scene graph</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgengine.html">QSGEngine</a></p>
 */
public class QSGEngine extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSGEngine.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgengine.html#CreateTextureOption-enum">QSGEngine::CreateTextureOption</a></p>
     * 
     * @see CreateTextureOptions
     */
    public enum CreateTextureOption implements io.qt.QtFlagEnumerator {
        TextureHasAlphaChannel(1),
        TextureOwnsGLTexture(4),
        TextureCanUseAtlas(8),
        TextureIsOpaque(16);

        private CreateTextureOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public CreateTextureOptions asFlags() {
            return new CreateTextureOptions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public CreateTextureOptions combined(CreateTextureOption e) {
            return new CreateTextureOptions(this, e);
        }

        /**
         * Creates a new {@link CreateTextureOptions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static CreateTextureOptions flags(CreateTextureOption ... values) {
            return new CreateTextureOptions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static CreateTextureOption resolve(int value) {
            switch (value) {
            case 1: return TextureHasAlphaChannel;
            case 4: return TextureOwnsGLTexture;
            case 8: return TextureCanUseAtlas;
            case 16: return TextureIsOpaque;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link CreateTextureOption}
     */
    public static final class CreateTextureOptions extends io.qt.QFlags<CreateTextureOption> implements Comparable<CreateTextureOptions> {
        private static final long serialVersionUID = 0xd11b032d1df5e09bL;

        /**
         * Creates a new CreateTextureOptions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public CreateTextureOptions(CreateTextureOption ... args){
            super(args);
        }

        /**
         * Creates a new CreateTextureOptions with given <code>value</code>.
         * @param value
         */
        public CreateTextureOptions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new CreateTextureOptions
         */
        @Override
        public final CreateTextureOptions combined(CreateTextureOption e){
            return new CreateTextureOptions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final CreateTextureOptions setFlag(CreateTextureOption e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final CreateTextureOptions setFlag(CreateTextureOption e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this CreateTextureOptions.
         * @return array of enum entries
         */
        @Override
        public final CreateTextureOption[] flags(){
            return super.flags(CreateTextureOption.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final CreateTextureOptions clone(){
            return new CreateTextureOptions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(CreateTextureOptions other){
            return Integer.compare(value(), other.value());
        }
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QSGEngine(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QSGEngine() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgengine.html#QSGEngine">QSGEngine::QSGEngine(QObject*)</a></p>
     */
    public QSGEngine(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSGEngine instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgengine.html#createImageNode">QSGEngine::createImageNode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGImageNode createImageNode(){
        return createImageNode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGImageNode createImageNode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgengine.html#createNinePatchNode">QSGEngine::createNinePatchNode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGNinePatchNode createNinePatchNode(){
        return createNinePatchNode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGNinePatchNode createNinePatchNode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgengine.html#createRectangleNode">QSGEngine::createRectangleNode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGRectangleNode createRectangleNode(){
        return createRectangleNode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGRectangleNode createRectangleNode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgengine.html#createRenderer">QSGEngine::createRenderer()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGAbstractRenderer createRenderer(){
        return createRenderer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGAbstractRenderer createRenderer_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #createTextureFromId(int, io.qt.core.QSize, io.qt.quick.QSGEngine.CreateTextureOptions)}.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture createTextureFromId(int id, io.qt.core.QSize size, io.qt.quick.QSGEngine.CreateTextureOption ... options){
        return createTextureFromId(id, size, new io.qt.quick.QSGEngine.CreateTextureOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #createTextureFromId(int, io.qt.core.QSize, io.qt.quick.QSGEngine.CreateTextureOptions)}
     *  with <code>options = new io.qt.quick.QSGEngine.CreateTextureOptions(0)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture createTextureFromId(int id, io.qt.core.QSize size) {
        return createTextureFromId(id, size, new io.qt.quick.QSGEngine.CreateTextureOptions(0));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgengine.html#createTextureFromId">QSGEngine::createTextureFromId(uint,QSize,CreateTextureOptions)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture createTextureFromId(int id, io.qt.core.QSize size, io.qt.quick.QSGEngine.CreateTextureOptions options){
        return createTextureFromId_native_uint_cref_QSize_QFlags_QSGEngine_CreateTextureOption__constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id, QtJambi_LibraryUtilities.internal.checkedNativeId(size), options.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGTexture createTextureFromId_native_uint_cref_QSize_QFlags_QSGEngine_CreateTextureOption__constfct(long __this__nativeId, int id, long size, int options);
    
    /**
     * <p>Overloaded function for {@link #createTextureFromImage(io.qt.gui.QImage, io.qt.quick.QSGEngine.CreateTextureOptions)}.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture createTextureFromImage(io.qt.gui.QImage image, io.qt.quick.QSGEngine.CreateTextureOption ... options){
        return createTextureFromImage(image, new io.qt.quick.QSGEngine.CreateTextureOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #createTextureFromImage(io.qt.gui.QImage, io.qt.quick.QSGEngine.CreateTextureOptions)}
     *  with <code>options = new io.qt.quick.QSGEngine.CreateTextureOptions(0)</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture createTextureFromImage(io.qt.gui.QImage image) {
        return createTextureFromImage(image, new io.qt.quick.QSGEngine.CreateTextureOptions(0));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgengine.html#createTextureFromImage">QSGEngine::createTextureFromImage(QImage,CreateTextureOptions)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture createTextureFromImage(io.qt.gui.QImage image, io.qt.quick.QSGEngine.CreateTextureOptions options){
        return createTextureFromImage_native_cref_QImage_QFlags_QSGEngine_CreateTextureOption__constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(image), options.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGTexture createTextureFromImage_native_cref_QImage_QFlags_QSGEngine_CreateTextureOption__constfct(long __this__nativeId, long image, int options);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgengine.html#initialize">QSGEngine::initialize(QOpenGLContext*)</a></p>
     * 
     * @deprecated QSGEngine is going to be removed in Qt 6.0. Use QQuickRenderControl instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void initialize(io.qt.gui.QOpenGLContext context){
        initialize_native_QOpenGLContext_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(context));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void initialize_native_QOpenGLContext_ptr(long __this__nativeId, long context);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgengine.html#invalidate">QSGEngine::invalidate()</a></p>
     */
    @io.qt.QtUninvokable
    public final void invalidate(){
        invalidate_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void invalidate_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgengine.html#rendererInterface">QSGEngine::rendererInterface()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGRendererInterface rendererInterface(){
        return rendererInterface_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGRendererInterface rendererInterface_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGEngine(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QSGEngine(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QSGEngine instance, QDeclarativeConstructor constructor);
    
}
