package io.qt.quick;


/**
 * <p>Serves as a baseclass for geometry based nodes</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgbasicgeometrynode.html">QSGBasicGeometryNode</a></p>
 */
public abstract class QSGBasicGeometryNode extends io.qt.quick.QSGNode
{
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcRendererClipList = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcGeometry = null;
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcRendererMatrix = null;
    
    
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGClipNode clipList(){
        return clipList_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGClipNode clipList_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgbasicgeometrynode.html#geometry-1">QSGBasicGeometryNode::geometry()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGGeometry geometry(){
        return geometry_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGGeometry geometry_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.gui.QMatrix4x4 matrix(){
        return matrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QMatrix4x4 matrix_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgbasicgeometrynode.html#setGeometry">QSGBasicGeometryNode::setGeometry(QSGGeometry*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setGeometry(io.qt.quick.QSGGeometry geometry){
        setGeometry_native_QSGGeometry_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(geometry));
        if (flags().isSet(QSGNode.Flag.OwnsGeometry)) {
            QtJambi_LibraryUtilities.internal.setCppOwnership(geometry);
        }
        if (!flags().isSet(QSGNode.Flag.OwnsGeometry)) {
            __rcGeometry = geometry;
        }
    }
    
    @io.qt.QtUninvokable
    private native void setGeometry_native_QSGGeometry_ptr(long __this__nativeId, long geometry);
    
    @io.qt.QtUninvokable
    public final void setRendererClipList(io.qt.quick.QSGClipNode c){
        setRendererClipList_native_const_QSGClipNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(c));
        __rcRendererClipList = c;
    }
    
    @io.qt.QtUninvokable
    private native void setRendererClipList_native_const_QSGClipNode_ptr(long __this__nativeId, long c);
    
    @io.qt.QtUninvokable
    public final void setRendererMatrix(io.qt.gui.QMatrix4x4 m){
        setRendererMatrix_native_const_QMatrix4x4_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), m);
        __rcRendererMatrix = m;
    }
    
    @io.qt.QtUninvokable
    private native void setRendererMatrix_native_const_QMatrix4x4_ptr(long __this__nativeId, io.qt.gui.QMatrix4x4 m);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGBasicGeometryNode(QPrivateConstructor p) { super(p); } 
    
}
