package io.qt.quick;


/**
 * <p>Gives access to the scene graph nodes and rendering of a QSGEngine</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html">QSGAbstractRenderer</a></p>
 */
public abstract class QSGAbstractRenderer extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcRootNode = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSGAbstractRenderer.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QSGAbstractRenderer {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        protected void nodeChanged(io.qt.quick.QSGNode node, io.qt.quick.QSGNode.DirtyState state){
            nodeChanged_native_QSGNode_ptr_QFlags_QSGNode_DirtyStateBit_(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(node), state.value());
        }
        @io.qt.QtUninvokable
        private native void nodeChanged_native_QSGNode_ptr_QFlags_QSGNode_DirtyStateBit_(long __this__nativeId, long node, int state);
        
        
        @Override
        @io.qt.QtUninvokable
        public void renderScene(int fboId){
            renderScene_native_uint(QtJambi_LibraryUtilities.internal.nativeId(this), fboId);
        }
        @io.qt.QtUninvokable
        private native void renderScene_native_uint(long __this__nativeId, int fboId);
        
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#ClearModeBit-enum">QSGAbstractRenderer::ClearModeBit</a></p>
     * 
     * @see ClearMode
     */
    public enum ClearModeBit implements io.qt.QtFlagEnumerator {
        ClearColorBuffer(1),
        ClearDepthBuffer(2),
        ClearStencilBuffer(4);

        private ClearModeBit(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public ClearMode asFlags() {
            return new ClearMode(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public ClearMode combined(ClearModeBit e) {
            return new ClearMode(this, e);
        }

        /**
         * Creates a new {@link ClearMode} from the entries.
         * @param values entries
         * @return new flag
         */
        public static ClearMode flags(ClearModeBit ... values) {
            return new ClearMode(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ClearModeBit resolve(int value) {
            switch (value) {
            case 1: return ClearColorBuffer;
            case 2: return ClearDepthBuffer;
            case 4: return ClearStencilBuffer;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link ClearModeBit}
     */
    public static final class ClearMode extends io.qt.QFlags<ClearModeBit> implements Comparable<ClearMode> {
        private static final long serialVersionUID = 0x6c430f92239f7496L;

        /**
         * Creates a new ClearMode where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public ClearMode(ClearModeBit ... args){
            super(args);
        }

        /**
         * Creates a new ClearMode with given <code>value</code>.
         * @param value
         */
        public ClearMode(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new ClearMode
         */
        @Override
        public final ClearMode combined(ClearModeBit e){
            return new ClearMode(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final ClearMode setFlag(ClearModeBit e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final ClearMode setFlag(ClearModeBit e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this ClearMode.
         * @return array of enum entries
         */
        @Override
        public final ClearModeBit[] flags(){
            return super.flags(ClearModeBit.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final ClearMode clone(){
            return new ClearMode(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(ClearMode other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#MatrixTransformFlag-enum">QSGAbstractRenderer::MatrixTransformFlag</a></p>
     * 
     * @see MatrixTransformFlags
     */
    public enum MatrixTransformFlag implements io.qt.QtFlagEnumerator {
        MatrixTransformFlipY(1);

        private MatrixTransformFlag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public MatrixTransformFlags asFlags() {
            return new MatrixTransformFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public MatrixTransformFlags combined(MatrixTransformFlag e) {
            return new MatrixTransformFlags(this, e);
        }

        /**
         * Creates a new {@link MatrixTransformFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static MatrixTransformFlags flags(MatrixTransformFlag ... values) {
            return new MatrixTransformFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static MatrixTransformFlag resolve(int value) {
            switch (value) {
            case 1: return MatrixTransformFlipY;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link MatrixTransformFlag}
     */
    public static final class MatrixTransformFlags extends io.qt.QFlags<MatrixTransformFlag> implements Comparable<MatrixTransformFlags> {
        private static final long serialVersionUID = 0x22d6b02f43f9996L;

        /**
         * Creates a new MatrixTransformFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public MatrixTransformFlags(MatrixTransformFlag ... args){
            super(args);
        }

        /**
         * Creates a new MatrixTransformFlags with given <code>value</code>.
         * @param value
         */
        public MatrixTransformFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new MatrixTransformFlags
         */
        @Override
        public final MatrixTransformFlags combined(MatrixTransformFlag e){
            return new MatrixTransformFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final MatrixTransformFlags setFlag(MatrixTransformFlag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final MatrixTransformFlags setFlag(MatrixTransformFlag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this MatrixTransformFlags.
         * @return array of enum entries
         */
        @Override
        public final MatrixTransformFlag[] flags(){
            return super.flags(MatrixTransformFlag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final MatrixTransformFlags clone(){
            return new MatrixTransformFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(MatrixTransformFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#sceneGraphChanged">QSGAbstractRenderer::sceneGraphChanged()</a></p>
     */
    public final Signal0 sceneGraphChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QSGAbstractRenderer(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    protected QSGAbstractRenderer() {
        this((io.qt.core.QObject)null);
    }
    
    protected QSGAbstractRenderer(io.qt.core.QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSGAbstractRenderer instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#clearColor">QSGAbstractRenderer::clearColor()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor clearColor(){
        return clearColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor clearColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#clearMode">QSGAbstractRenderer::clearMode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGAbstractRenderer.ClearMode clearMode(){
        return new io.qt.quick.QSGAbstractRenderer.ClearMode(clearMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int clearMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#deviceRect">QSGAbstractRenderer::deviceRect()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRect deviceRect(){
        return deviceRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRect deviceRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#projectionMatrix">QSGAbstractRenderer::projectionMatrix()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QMatrix4x4 projectionMatrix(){
        return projectionMatrix_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QMatrix4x4 projectionMatrix_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.gui.QMatrix4x4 projectionMatrixWithNativeNDC(){
        return projectionMatrixWithNativeNDC_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QMatrix4x4 projectionMatrixWithNativeNDC_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#rootNode">QSGAbstractRenderer::rootNode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGRootNode rootNode(){
        return rootNode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGRootNode rootNode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#setClearColor">QSGAbstractRenderer::setClearColor(QColor)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setClearColor(io.qt.gui.QColor color){
        setClearColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setClearColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>Overloaded function for {@link #setClearMode(io.qt.quick.QSGAbstractRenderer.ClearMode)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setClearMode(io.qt.quick.QSGAbstractRenderer.ClearModeBit ... mode){
        setClearMode(new io.qt.quick.QSGAbstractRenderer.ClearMode(mode));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#setClearMode">QSGAbstractRenderer::setClearMode(ClearMode)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setClearMode(io.qt.quick.QSGAbstractRenderer.ClearMode mode){
        setClearMode_native_QFlags_QSGAbstractRenderer_ClearModeBit_(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    @io.qt.QtUninvokable
    private native void setClearMode_native_QFlags_QSGAbstractRenderer_ClearModeBit_(long __this__nativeId, int mode);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#setDeviceRect">QSGAbstractRenderer::setDeviceRect(QRect)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDeviceRect(io.qt.core.QRect rect){
        setDeviceRect_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @io.qt.QtUninvokable
    private native void setDeviceRect_native_cref_QRect(long __this__nativeId, long rect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#setDeviceRect-1">QSGAbstractRenderer::setDeviceRect(QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setDeviceRect(io.qt.core.QSize size){
        setDeviceRect_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setDeviceRect_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#setProjectionMatrix">QSGAbstractRenderer::setProjectionMatrix(QMatrix4x4)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setProjectionMatrix(io.qt.gui.QMatrix4x4 matrix){
        setProjectionMatrix_native_cref_QMatrix4x4(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(matrix));
    }
    
    @io.qt.QtUninvokable
    private native void setProjectionMatrix_native_cref_QMatrix4x4(long __this__nativeId, long matrix);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#setProjectionMatrixToRect">QSGAbstractRenderer::setProjectionMatrixToRect(QRectF)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setProjectionMatrixToRect(io.qt.core.QRectF rect){
        setProjectionMatrixToRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @io.qt.QtUninvokable
    private native void setProjectionMatrixToRect_native_cref_QRectF(long __this__nativeId, long rect);
    
    /**
     * <p>Overloaded function for {@link #setProjectionMatrixToRect(io.qt.core.QRectF, io.qt.quick.QSGAbstractRenderer.MatrixTransformFlags)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setProjectionMatrixToRect(io.qt.core.QRectF rect, io.qt.quick.QSGAbstractRenderer.MatrixTransformFlag ... flags){
        setProjectionMatrixToRect(rect, new io.qt.quick.QSGAbstractRenderer.MatrixTransformFlags(flags));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#setProjectionMatrixToRect-1">QSGAbstractRenderer::setProjectionMatrixToRect(QRectF,MatrixTransformFlags)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setProjectionMatrixToRect(io.qt.core.QRectF rect, io.qt.quick.QSGAbstractRenderer.MatrixTransformFlags flags){
        setProjectionMatrixToRect_native_cref_QRectF_QFlags_QSGAbstractRenderer_MatrixTransformFlag_(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect), flags.value());
    }
    
    @io.qt.QtUninvokable
    private native void setProjectionMatrixToRect_native_cref_QRectF_QFlags_QSGAbstractRenderer_MatrixTransformFlag_(long __this__nativeId, long rect, int flags);
    
    @io.qt.QtUninvokable
    public final void setProjectionMatrixWithNativeNDC(io.qt.gui.QMatrix4x4 matrix){
        setProjectionMatrixWithNativeNDC_native_cref_QMatrix4x4(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(matrix));
    }
    
    @io.qt.QtUninvokable
    private native void setProjectionMatrixWithNativeNDC_native_cref_QMatrix4x4(long __this__nativeId, long matrix);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#setRootNode">QSGAbstractRenderer::setRootNode(QSGRootNode*)</a></p>
     * 
     * @deprecated QSGAbstractRenderer is no longer going to be public in Qt 6.0. QSGEngine-based workflows are expected to migrate to QQuickRenderControl instead.
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final void setRootNode(io.qt.quick.QSGRootNode node){
        setRootNode_native_QSGRootNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(node));
        __rcRootNode = node;
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native void setRootNode_native_QSGRootNode_ptr(long __this__nativeId, long node);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#setViewportRect">QSGAbstractRenderer::setViewportRect(QRect)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setViewportRect(io.qt.core.QRect rect){
        setViewportRect_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @io.qt.QtUninvokable
    private native void setViewportRect_native_cref_QRect(long __this__nativeId, long rect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#setViewportRect-1">QSGAbstractRenderer::setViewportRect(QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setViewportRect(io.qt.core.QSize size){
        setViewportRect_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setViewportRect_native_cref_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#viewportRect">QSGAbstractRenderer::viewportRect()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRect viewportRect(){
        return viewportRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRect viewportRect_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    protected abstract void nodeChanged(io.qt.quick.QSGNode node, io.qt.quick.QSGNode.DirtyState state);
    
    @io.qt.QtUninvokable
    private native void nodeChanged_native_QSGNode_ptr_QFlags_QSGNode_DirtyStateBit_(long __this__nativeId, long node, int state);
    
    /**
     * <p>Overloaded function for {@link #renderScene(int)}
     *  with <code>fboId = 0</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void renderScene() {
        renderScene((int)0);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qsgabstractrenderer.html#renderScene">QSGAbstractRenderer::renderScene(uint)</a></p>
     */
    @io.qt.QtUninvokable
    public abstract void renderScene(int fboId);
    
    @io.qt.QtUninvokable
    private native void renderScene_native_uint(long __this__nativeId, int fboId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QSGAbstractRenderer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QSGAbstractRenderer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QSGAbstractRenderer instance, QDeclarativeConstructor constructor);
    
}
