package io.qt.quick;


/**
 * <p>The window for displaying a graphical QML scene</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qquickwindow.html">QQuickWindow</a></p>
 */
public class QQuickWindow extends io.qt.gui.QWindow
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickWindow.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickwindow.html#CreateTextureOption-enum">QQuickWindow::CreateTextureOption</a></p>
     * 
     * @see CreateTextureOptions
     */
    public enum CreateTextureOption implements io.qt.QtFlagEnumerator {
        TextureHasAlphaChannel(1),
        TextureHasMipmaps(2),
        TextureOwnsGLTexture(4),
        TextureCanUseAtlas(8),
        TextureIsOpaque(16);

        private CreateTextureOption(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public CreateTextureOptions asFlags() {
            return new CreateTextureOptions(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public CreateTextureOptions combined(CreateTextureOption e) {
            return new CreateTextureOptions(this, e);
        }

        /**
         * Creates a new {@link CreateTextureOptions} from the entries.
         * @param values entries
         * @return new flag
         */
        public static CreateTextureOptions flags(CreateTextureOption ... values) {
            return new CreateTextureOptions(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static CreateTextureOption resolve(int value) {
            switch (value) {
            case 1: return TextureHasAlphaChannel;
            case 2: return TextureHasMipmaps;
            case 4: return TextureOwnsGLTexture;
            case 8: return TextureCanUseAtlas;
            case 16: return TextureIsOpaque;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link CreateTextureOption}
     */
    public static final class CreateTextureOptions extends io.qt.QFlags<CreateTextureOption> implements Comparable<CreateTextureOptions> {
        private static final long serialVersionUID = 0xd11b032d1df5e09bL;

        /**
         * Creates a new CreateTextureOptions where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public CreateTextureOptions(CreateTextureOption ... args){
            super(args);
        }

        /**
         * Creates a new CreateTextureOptions with given <code>value</code>.
         * @param value
         */
        public CreateTextureOptions(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new CreateTextureOptions
         */
        @Override
        public final CreateTextureOptions combined(CreateTextureOption e){
            return new CreateTextureOptions(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final CreateTextureOptions setFlag(CreateTextureOption e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final CreateTextureOptions setFlag(CreateTextureOption e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this CreateTextureOptions.
         * @return array of enum entries
         */
        @Override
        public final CreateTextureOption[] flags(){
            return super.flags(CreateTextureOption.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final CreateTextureOptions clone(){
            return new CreateTextureOptions(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(CreateTextureOptions other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickwindow.html#RenderStage-enum">QQuickWindow::RenderStage</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum RenderStage implements io.qt.QtEnumerator {
        BeforeSynchronizingStage(0),
        AfterSynchronizingStage(1),
        BeforeRenderingStage(2),
        AfterRenderingStage(3),
        AfterSwapStage(4),
        NoStage(5);

        private RenderStage(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static RenderStage resolve(int value) {
            switch (value) {
            case 0: return BeforeSynchronizingStage;
            case 1: return AfterSynchronizingStage;
            case 2: return BeforeRenderingStage;
            case 3: return AfterRenderingStage;
            case 4: return AfterSwapStage;
            case 5: return NoStage;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickwindow.html#SceneGraphError-enum">QQuickWindow::SceneGraphError</a></p>
     */
    public enum SceneGraphError implements io.qt.QtEnumerator {
        ContextNotAvailable(1);

        private SceneGraphError(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static SceneGraphError resolve(int value) {
            switch (value) {
            case 1: return ContextNotAvailable;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickwindow.html#TextRenderType-enum">QQuickWindow::TextRenderType</a></p>
     */
    public enum TextRenderType implements io.qt.QtEnumerator {
        QtTextRendering(0),
        NativeTextRendering(1);

        private TextRenderType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static TextRenderType resolve(int value) {
            switch (value) {
            case 0: return QtTextRendering;
            case 1: return NativeTextRendering;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Describes some of the RHI's graphics state at the point of a beginExternalCommands() call</p>
     * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qquickwindow-graphicsstateinfo.html">QQuickWindow::GraphicsStateInfo</a></p>
     */
    public static class GraphicsStateInfo extends io.qt.QtObject
        implements java.lang.Cloneable
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        public GraphicsStateInfo(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(GraphicsStateInfo instance);
        
        @io.qt.QtUninvokable
        public final void setCurrentFrameSlot(int currentFrameSlot){
            setCurrentFrameSlot_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), currentFrameSlot);
        }
        
        @io.qt.QtUninvokable
        private native void setCurrentFrameSlot_native_int(long __this__nativeId, int currentFrameSlot);
        
        @io.qt.QtUninvokable
        public final int currentFrameSlot(){
            return currentFrameSlot_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int currentFrameSlot_native(long __this__nativeId);
        
        @io.qt.QtUninvokable
        public final void setFramesInFlight(int framesInFlight){
            setFramesInFlight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), framesInFlight);
        }
        
        @io.qt.QtUninvokable
        private native void setFramesInFlight_native_int(long __this__nativeId, int framesInFlight);
        
        @io.qt.QtUninvokable
        public final int framesInFlight(){
            return framesInFlight_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native int framesInFlight_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected GraphicsStateInfo(QPrivateConstructor p) { super(p); } 
        
        
        @Override
        public GraphicsStateInfo clone() {
            return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        private native GraphicsStateInfo clone_native(long __this_nativeId);
    }


    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#activeFocusItem-prop">QQuickWindow::activeFocusItemChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="activeFocusItem")
    public final Signal0 activeFocusItemChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#afterAnimating">QQuickWindow::afterAnimating()</a></p>
     */
    public final Signal0 afterAnimating = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#afterRenderPassRecording">QQuickWindow::afterRenderPassRecording()</a></p>
     */
    public final Signal0 afterRenderPassRecording = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#afterRendering">QQuickWindow::afterRendering()</a></p>
     */
    public final Signal0 afterRendering = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#afterSynchronizing">QQuickWindow::afterSynchronizing()</a></p>
     */
    public final Signal0 afterSynchronizing = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#beforeRenderPassRecording">QQuickWindow::beforeRenderPassRecording()</a></p>
     */
    public final Signal0 beforeRenderPassRecording = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#beforeRendering">QQuickWindow::beforeRendering()</a></p>
     */
    public final Signal0 beforeRendering = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#beforeSynchronizing">QQuickWindow::beforeSynchronizing()</a></p>
     */
    public final Signal0 beforeSynchronizing = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#color-prop">QQuickWindow::colorChanged(QColor)</a></p>
     */
    @io.qt.QtPropertyNotify(name="color")
    public final Signal1<io.qt.gui.QColor> colorChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#frameSwapped">QQuickWindow::frameSwapped()</a></p>
     */
    public final Signal0 frameSwapped = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#openglContextCreated">QQuickWindow::openglContextCreated(QOpenGLContext*)</a></p>
     */
    public final Signal1<io.qt.gui.QOpenGLContext> openglContextCreated = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#sceneGraphAboutToStop">QQuickWindow::sceneGraphAboutToStop()</a></p>
     */
    public final Signal0 sceneGraphAboutToStop = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#sceneGraphError">QQuickWindow::sceneGraphError(QQuickWindow::SceneGraphError,QString)</a></p>
     */
    public final Signal2<io.qt.quick.QQuickWindow.SceneGraphError, java.lang.String> sceneGraphError = new Signal2<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#sceneGraphInitialized">QQuickWindow::sceneGraphInitialized()</a></p>
     */
    public final Signal0 sceneGraphInitialized = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#sceneGraphInvalidated">QQuickWindow::sceneGraphInvalidated()</a></p>
     */
    public final Signal0 sceneGraphInvalidated = new Signal0();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#QQuickWindow">QQuickWindow::QQuickWindow(QQuickRenderControl*)</a></p>
     */
    public QQuickWindow(io.qt.quick.QQuickRenderControl renderControl){
        super((QPrivateConstructor)null);
        initialize_native(this, renderControl);
    }
    
    private native static void initialize_native(QQuickWindow instance, io.qt.quick.QQuickRenderControl renderControl);
    
    /**
     * <p>Overloaded constructor for {@link #QQuickWindow(io.qt.gui.QWindow)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickWindow() {
        this((io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#QQuickWindow">QQuickWindow::QQuickWindow(QWindow*)</a></p>
     */
    public QQuickWindow(io.qt.gui.QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuickWindow instance, io.qt.gui.QWindow parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#activeFocusItem-prop">QQuickWindow::activeFocusItem()const</a></p>
     */
    @io.qt.QtPropertyReader(name="activeFocusItem")
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickItem activeFocusItem(){
        return activeFocusItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickItem activeFocusItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#beginExternalCommands">QQuickWindow::beginExternalCommands()</a></p>
     */
    @io.qt.QtUninvokable
    public final void beginExternalCommands(){
        beginExternalCommands_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void beginExternalCommands_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#clearBeforeRendering">QQuickWindow::clearBeforeRendering()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean clearBeforeRendering(){
        return clearBeforeRendering_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean clearBeforeRendering_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#color-prop">QQuickWindow::color()const</a></p>
     */
    @io.qt.QtPropertyReader(name="color")
    @io.qt.QtUninvokable
    public final io.qt.gui.QColor color(){
        return color_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QColor color_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#contentItem-prop">QQuickWindow::contentItem()const</a></p>
     */
    @io.qt.QtPropertyReader(name="contentItem")
    @io.qt.QtPropertyConstant
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickItem contentItem(){
        return contentItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickItem contentItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#createImageNode">QQuickWindow::createImageNode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGImageNode createImageNode(){
        return createImageNode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGImageNode createImageNode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#createNinePatchNode">QQuickWindow::createNinePatchNode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGNinePatchNode createNinePatchNode(){
        return createNinePatchNode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGNinePatchNode createNinePatchNode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#createRectangleNode">QQuickWindow::createRectangleNode()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGRectangleNode createRectangleNode(){
        return createRectangleNode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGRectangleNode createRectangleNode_native_constfct(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #createTextureFromId(int, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}.</p>
     * 
     * @deprecated Use createTextureFromNativeObject() instead
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture createTextureFromId(int id, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOption ... options){
        return createTextureFromId(id, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(options));
    }
    
    /**
     * <p>Overloaded function for {@link #createTextureFromId(int, io.qt.core.QSize, io.qt.quick.QQuickWindow.CreateTextureOptions)}
     *  with <code>options = new io.qt.quick.QQuickWindow.CreateTextureOptions(0)</code>.</p>
     * 
     * @deprecated Use createTextureFromNativeObject() instead
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture createTextureFromId(int id, io.qt.core.QSize size) {
        return createTextureFromId(id, size, new io.qt.quick.QQuickWindow.CreateTextureOptions(0));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow-obsolete.html#createTextureFromId">QQuickWindow::createTextureFromId(uint,QSize,CreateTextureOptions)const</a></p>
     * 
     * @deprecated Use createTextureFromNativeObject() instead
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture createTextureFromId(int id, io.qt.core.QSize size, io.qt.quick.QQuickWindow.CreateTextureOptions options){
        return createTextureFromId_native_uint_cref_QSize_QFlags_QQuickWindow_CreateTextureOption__constfct(QtJambi_LibraryUtilities.internal.nativeId(this), id, QtJambi_LibraryUtilities.internal.checkedNativeId(size), options.value());
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGTexture createTextureFromId_native_uint_cref_QSize_QFlags_QQuickWindow_CreateTextureOption__constfct(long __this__nativeId, int id, long size, int options);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#createTextureFromImage-1">QQuickWindow::createTextureFromImage(QImage)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture createTextureFromImage(io.qt.gui.QImage image){
        return createTextureFromImage_native_cref_QImage_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(image));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGTexture createTextureFromImage_native_cref_QImage_constfct(long __this__nativeId, long image);
    
    /**
     * <p>Overloaded function for {@link #createTextureFromImage(io.qt.gui.QImage, io.qt.quick.QQuickWindow.CreateTextureOptions)}.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture createTextureFromImage(io.qt.gui.QImage image, io.qt.quick.QQuickWindow.CreateTextureOption ... options){
        return createTextureFromImage(image, new io.qt.quick.QQuickWindow.CreateTextureOptions(options));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#createTextureFromImage">QQuickWindow::createTextureFromImage(QImage,CreateTextureOptions)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGTexture createTextureFromImage(io.qt.gui.QImage image, io.qt.quick.QQuickWindow.CreateTextureOptions options){
        return createTextureFromImage_native_cref_QImage_QFlags_QQuickWindow_CreateTextureOption__constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(image), options.value());
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGTexture createTextureFromImage_native_cref_QImage_QFlags_QQuickWindow_CreateTextureOption__constfct(long __this__nativeId, long image, int options);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#effectiveDevicePixelRatio">QQuickWindow::effectiveDevicePixelRatio()const</a></p>
     */
    @io.qt.QtUninvokable
    public final double effectiveDevicePixelRatio(){
        return effectiveDevicePixelRatio_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double effectiveDevicePixelRatio_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#endExternalCommands">QQuickWindow::endExternalCommands()</a></p>
     */
    @io.qt.QtUninvokable
    public final void endExternalCommands(){
        endExternalCommands_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void endExternalCommands_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#grabWindow">QQuickWindow::grabWindow()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QImage grabWindow(){
        return grabWindow_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QImage grabWindow_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#graphicsStateInfo">QQuickWindow::graphicsStateInfo()</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickWindow.GraphicsStateInfo graphicsStateInfo(){
        return graphicsStateInfo_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickWindow.GraphicsStateInfo graphicsStateInfo_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#incubationController">QQuickWindow::incubationController()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlIncubationController incubationController(){
        return incubationController_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlIncubationController incubationController_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#isPersistentOpenGLContext">QQuickWindow::isPersistentOpenGLContext()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isPersistentOpenGLContext(){
        return isPersistentOpenGLContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isPersistentOpenGLContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#isPersistentSceneGraph">QQuickWindow::isPersistentSceneGraph()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isPersistentSceneGraph(){
        return isPersistentSceneGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isPersistentSceneGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#isSceneGraphInitialized">QQuickWindow::isSceneGraphInitialized()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isSceneGraphInitialized(){
        return isSceneGraphInitialized_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isSceneGraphInitialized_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#mouseGrabberItem">QQuickWindow::mouseGrabberItem()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickItem mouseGrabberItem(){
        return mouseGrabberItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickItem mouseGrabberItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#openglContext">QQuickWindow::openglContext()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QOpenGLContext openglContext(){
        return openglContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QOpenGLContext openglContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#releaseResources">QQuickWindow::releaseResources()</a></p>
     */
    public final void releaseResources(){
        releaseResources_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void releaseResources_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#renderTarget">QQuickWindow::renderTarget()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QOpenGLFramebufferObject renderTarget(){
        return renderTarget_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QOpenGLFramebufferObject renderTarget_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#renderTargetId">QQuickWindow::renderTargetId()const</a></p>
     */
    @io.qt.QtUninvokable
    public final int renderTargetId(){
        return renderTargetId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native int renderTargetId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#renderTargetSize">QQuickWindow::renderTargetSize()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QSize renderTargetSize(){
        return renderTargetSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize renderTargetSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#rendererInterface">QQuickWindow::rendererInterface()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QSGRendererInterface rendererInterface(){
        return rendererInterface_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGRendererInterface rendererInterface_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#resetOpenGLState">QQuickWindow::resetOpenGLState()</a></p>
     */
    @io.qt.QtUninvokable
    public final void resetOpenGLState(){
        resetOpenGLState_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void resetOpenGLState_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#scheduleRenderJob">QQuickWindow::scheduleRenderJob(QRunnable*,QQuickWindow::RenderStage)</a></p>
     */
    @io.qt.QtUninvokable
    public final void scheduleRenderJob(io.qt.core.QRunnable job, io.qt.quick.QQuickWindow.RenderStage schedule){
        java.util.Objects.requireNonNull(job, "Argument 'job': null not expected.");
        scheduleRenderJob_native_QRunnable_ptr_QQuickWindow_RenderStage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(job), schedule.value());
    }
    
    @io.qt.QtUninvokable
    private native void scheduleRenderJob_native_QRunnable_ptr_QQuickWindow_RenderStage(long __this__nativeId, long job, int schedule);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow-obsolete.html#sendEvent">QQuickWindow::sendEvent(QQuickItem*,QEvent*)</a></p>
     */
    @Deprecated
    @io.qt.QtUninvokable
    public final boolean sendEvent(io.qt.quick.QQuickItem arg__1, io.qt.core.QEvent arg__2){
        return sendEvent_native_QQuickItem_ptr_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
    }
    
    @Deprecated
    @io.qt.QtUninvokable
    private native boolean sendEvent_native_QQuickItem_ptr_QEvent_ptr(long __this__nativeId, long arg__1, long arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#setClearBeforeRendering">QQuickWindow::setClearBeforeRendering(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setClearBeforeRendering(boolean enabled){
        setClearBeforeRendering_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setClearBeforeRendering_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#color-prop">QQuickWindow::setColor(QColor)</a></p>
     */
    @io.qt.QtPropertyWriter(name="color")
    @io.qt.QtUninvokable
    public final void setColor(io.qt.gui.QColor color){
        setColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    @io.qt.QtUninvokable
    private native void setColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#setPersistentOpenGLContext">QQuickWindow::setPersistentOpenGLContext(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPersistentOpenGLContext(boolean persistent){
        setPersistentOpenGLContext_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), persistent);
    }
    
    @io.qt.QtUninvokable
    private native void setPersistentOpenGLContext_native_bool(long __this__nativeId, boolean persistent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#setPersistentSceneGraph">QQuickWindow::setPersistentSceneGraph(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setPersistentSceneGraph(boolean persistent){
        setPersistentSceneGraph_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), persistent);
    }
    
    @io.qt.QtUninvokable
    private native void setPersistentSceneGraph_native_bool(long __this__nativeId, boolean persistent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#setRenderTarget">QQuickWindow::setRenderTarget(QOpenGLFramebufferObject*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRenderTarget(io.qt.gui.QOpenGLFramebufferObject fbo){
        setRenderTarget_native_QOpenGLFramebufferObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(fbo));
    }
    
    @io.qt.QtUninvokable
    private native void setRenderTarget_native_QOpenGLFramebufferObject_ptr(long __this__nativeId, long fbo);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#setRenderTarget-1">QQuickWindow::setRenderTarget(uint,QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setRenderTarget(int fboId, io.qt.core.QSize size){
        setRenderTarget_native_uint_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), fboId, QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setRenderTarget_native_uint_cref_QSize(long __this__nativeId, int fboId, long size);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#update">QQuickWindow::update()</a></p>
     */
    public final void update(){
        update_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void update_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public io.qt.gui.QAccessibleInterface accessibleRoot(){
        return accessibleRoot_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QAccessibleInterface accessibleRoot_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean event(io.qt.core.QEvent arg__1){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#exposeEvent">QWindow::exposeEvent(QExposeEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void exposeEvent(io.qt.gui.QExposeEvent arg__1){
        exposeEvent_native_QExposeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void exposeEvent_native_QExposeEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#focusInEvent">QWindow::focusInEvent(QFocusEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void focusInEvent(io.qt.gui.QFocusEvent arg__1){
        focusInEvent_native_QFocusEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void focusInEvent_native_QFocusEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#focusObject">QWindow::focusObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.core.QObject focusObject(){
        return focusObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject focusObject_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#focusOutEvent">QWindow::focusOutEvent(QFocusEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void focusOutEvent(io.qt.gui.QFocusEvent arg__1){
        focusOutEvent_native_QFocusEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void focusOutEvent_native_QFocusEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#hideEvent">QWindow::hideEvent(QHideEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void hideEvent(io.qt.gui.QHideEvent arg__1){
        hideEvent_native_QHideEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void hideEvent_native_QHideEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#keyPressEvent">QWindow::keyPressEvent(QKeyEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void keyPressEvent(io.qt.gui.QKeyEvent arg__1){
        keyPressEvent_native_QKeyEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void keyPressEvent_native_QKeyEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#keyReleaseEvent">QWindow::keyReleaseEvent(QKeyEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void keyReleaseEvent(io.qt.gui.QKeyEvent arg__1){
        keyReleaseEvent_native_QKeyEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void keyReleaseEvent_native_QKeyEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#mouseDoubleClickEvent">QWindow::mouseDoubleClickEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mouseDoubleClickEvent(io.qt.gui.QMouseEvent arg__1){
        mouseDoubleClickEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void mouseDoubleClickEvent_native_QMouseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#mouseMoveEvent">QWindow::mouseMoveEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mouseMoveEvent(io.qt.gui.QMouseEvent arg__1){
        mouseMoveEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void mouseMoveEvent_native_QMouseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#mousePressEvent">QWindow::mousePressEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mousePressEvent(io.qt.gui.QMouseEvent arg__1){
        mousePressEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void mousePressEvent_native_QMouseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#mouseReleaseEvent">QWindow::mouseReleaseEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mouseReleaseEvent(io.qt.gui.QMouseEvent arg__1){
        mouseReleaseEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void mouseReleaseEvent_native_QMouseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#resizeEvent">QWindow::resizeEvent(QResizeEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void resizeEvent(io.qt.gui.QResizeEvent arg__1){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#showEvent">QWindow::showEvent(QShowEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void showEvent(io.qt.gui.QShowEvent arg__1){
        showEvent_native_QShowEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void showEvent_native_QShowEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#tabletEvent">QWindow::tabletEvent(QTabletEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void tabletEvent(io.qt.gui.QTabletEvent arg__1){
        tabletEvent_native_QTabletEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void tabletEvent_native_QTabletEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#wheelEvent">QWindow::wheelEvent(QWheelEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void wheelEvent(io.qt.gui.QWheelEvent arg__1){
        wheelEvent_native_QWheelEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void wheelEvent_native_QWheelEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>Returns whether to use alpha transparency on newly created windows</p>
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#hasDefaultAlphaBuffer">QQuickWindow::hasDefaultAlphaBuffer()</a></p>
     */
    public native static boolean hasDefaultAlphaBuffer();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#sceneGraphBackend">QQuickWindow::sceneGraphBackend()</a></p>
     */
    public native static java.lang.String sceneGraphBackend();
    
    /**
     * <p>UseAlpha specifies whether to use alpha transparency on newly created windows</p>
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#setDefaultAlphaBuffer">QQuickWindow::setDefaultAlphaBuffer(bool)</a></p>
     */
    public native static void setDefaultAlphaBuffer(boolean useAlpha);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#setSceneGraphBackend">QQuickWindow::setSceneGraphBackend(QSGRendererInterface::GraphicsApi)</a></p>
     */
    public static void setSceneGraphBackend(io.qt.quick.QSGRendererInterface.GraphicsApi api){
        setSceneGraphBackend_native_QSGRendererInterface_GraphicsApi(api.value());
    }
    
    private native static void setSceneGraphBackend_native_QSGRendererInterface_GraphicsApi(int api);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#setSceneGraphBackend-1">QQuickWindow::setSceneGraphBackend(QString)</a></p>
     */
    public native static void setSceneGraphBackend(java.lang.String backend);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#setTextRenderType">QQuickWindow::setTextRenderType(QQuickWindow::TextRenderType)</a></p>
     */
    public static void setTextRenderType(io.qt.quick.QQuickWindow.TextRenderType renderType){
        setTextRenderType_native_QQuickWindow_TextRenderType(renderType.value());
    }
    
    private native static void setTextRenderType_native_QQuickWindow_TextRenderType(int renderType);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickwindow.html#textRenderType">QQuickWindow::textRenderType()</a></p>
     */
    public static io.qt.quick.QQuickWindow.TextRenderType textRenderType(){
        return io.qt.quick.QQuickWindow.TextRenderType.resolve(textRenderType_native());
    }
    
    private native static int textRenderType_native();
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickWindow(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuickWindow(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuickWindow instance, QDeclarativeConstructor constructor);
    
    @io.qt.QtUninvokable
    public final void scheduleRenderJob(Runnable job, io.qt.quick.QQuickWindow.RenderStage schedule){
        scheduleRenderJob(io.qt.core.QRunnable.of(job), schedule);
    }

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
}
