package io.qt.quick;


/**
 * <p>Window for displaying a Qt Quick user interface</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qquickview.html">QQuickView</a></p>
 */
public class QQuickView extends io.qt.quick.QQuickWindow
{
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcQmlComponent = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickView.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickview.html#ResizeMode-enum">QQuickView::ResizeMode</a></p>
     */
    public enum ResizeMode implements io.qt.QtEnumerator {
        SizeViewToRootObject(0),
        SizeRootObjectToView(1);

        private ResizeMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ResizeMode resolve(int value) {
            switch (value) {
            case 0: return SizeViewToRootObject;
            case 1: return SizeRootObjectToView;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickview.html#Status-enum">QQuickView::Status</a></p>
     */
    public enum Status implements io.qt.QtEnumerator {
        Null(0),
        Ready(1),
        Loading(2),
        Error(3);

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Status resolve(int value) {
            switch (value) {
            case 0: return Null;
            case 1: return Ready;
            case 2: return Loading;
            case 3: return Error;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#statusChanged">QQuickView::statusChanged(QQuickView::Status)</a></p>
     */
    @io.qt.QtPropertyNotify(name="status")
    public final Signal1<io.qt.quick.QQuickView.Status> statusChanged = new Signal1<>();
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#QQuickView-1">QQuickView::QQuickView(QQmlEngine*,QWindow*)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QQuickView(io.qt.qml.QQmlEngine engine, io.qt.gui.QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, engine, parent);
    }
    
    private native static void initialize_native(QQuickView instance, io.qt.qml.QQmlEngine engine, io.qt.gui.QWindow parent);
    
    /**
     * <p>Overloaded constructor for {@link #QQuickView(io.qt.gui.QWindow)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickView() {
        this((io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#QQuickView">QQuickView::QQuickView(QWindow*)</a></p>
     */
    public QQuickView(io.qt.gui.QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuickView instance, io.qt.gui.QWindow parent);
    
    public QQuickView(io.qt.core.QUrl source, io.qt.quick.QQuickRenderControl renderControl){
        super((QPrivateConstructor)null);
        initialize_native(this, source, renderControl);
    }
    
    private native static void initialize_native(QQuickView instance, io.qt.core.QUrl source, io.qt.quick.QQuickRenderControl renderControl);
    
    /**
     * <p>Overloaded constructor for {@link #QQuickView(io.qt.core.QUrl, io.qt.gui.QWindow)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickView(io.qt.core.QUrl source) {
        this(source, (io.qt.gui.QWindow)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#QQuickView-2">QQuickView::QQuickView(QUrl,QWindow*)</a></p>
     */
    public QQuickView(io.qt.core.QUrl source, io.qt.gui.QWindow parent){
        super((QPrivateConstructor)null);
        initialize_native(this, source, parent);
    }
    
    private native static void initialize_native(QQuickView instance, io.qt.core.QUrl source, io.qt.gui.QWindow parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#engine">QQuickView::engine()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlEngine engine(){
        return engine_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlEngine engine_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#errors">QQuickView::errors()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.qml.QQmlError> errors(){
        return errors_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.qml.QQmlError> errors_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#initialSize">QQuickView::initialSize()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QSize initialSize(){
        return initialSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize initialSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#resizeMode-prop">QQuickView::resizeMode()const</a></p>
     */
    @io.qt.QtPropertyReader(name="resizeMode")
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickView.ResizeMode resizeMode(){
        return io.qt.quick.QQuickView.ResizeMode.resolve(resizeMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int resizeMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#rootContext">QQuickView::rootContext()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlContext rootContext(){
        return rootContext_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlContext rootContext_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#rootObject">QQuickView::rootObject()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickItem rootObject(){
        return rootObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickItem rootObject_native_constfct(long __this__nativeId);
    
    @SuppressWarnings({"exports"})
    public final void setContent(io.qt.core.QUrl url, io.qt.qml.QQmlComponent component, io.qt.core.QObject item){
        setContent_native_cref_QUrl_QQmlComponent_ptr_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(url), QtJambi_LibraryUtilities.internal.checkedNativeId(component), QtJambi_LibraryUtilities.internal.checkedNativeId(item));
        __rcQmlComponent = component;
    }
    
    private native void setContent_native_cref_QUrl_QQmlComponent_ptr_QObject_ptr(long __this__nativeId, long url, long component, long item);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#setInitialProperties">QQuickView::setInitialProperties(QVariantMap)</a></p>
     */
    public final void setInitialProperties(java.util.Map<java.lang.String, java.lang.Object> initialProperties){
        setInitialProperties_native_cref_QMap(QtJambi_LibraryUtilities.internal.nativeId(this), initialProperties);
    }
    
    private native void setInitialProperties_native_cref_QMap(long __this__nativeId, java.util.Map<java.lang.String, java.lang.Object> initialProperties);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#resizeMode-prop">QQuickView::setResizeMode(QQuickView::ResizeMode)</a></p>
     */
    @io.qt.QtPropertyWriter(name="resizeMode")
    @io.qt.QtUninvokable
    public final void setResizeMode(io.qt.quick.QQuickView.ResizeMode arg__1){
        setResizeMode_native_QQuickView_ResizeMode(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native void setResizeMode_native_QQuickView_ResizeMode(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#setSource">QQuickView::setSource(QUrl)</a></p>
     */
    @io.qt.QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.QUrl arg__1){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long arg__1);
    
    @io.qt.QtUninvokable
    public final io.qt.core.QSize sizeHint(){
        return sizeHint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize sizeHint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#source">QQuickView::source()const</a></p>
     */
    @io.qt.QtPropertyReader(name="source")
    @io.qt.QtPropertyDesignable
    @io.qt.QtUninvokable
    public final io.qt.core.QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickview.html#status-prop">QQuickView::status()const</a></p>
     */
    @io.qt.QtPropertyReader(name="status")
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickView.Status status(){
        return io.qt.quick.QQuickView.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#keyPressEvent">QWindow::keyPressEvent(QKeyEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void keyPressEvent(io.qt.gui.QKeyEvent arg__1){
        keyPressEvent_native_QKeyEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void keyPressEvent_native_QKeyEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#keyReleaseEvent">QWindow::keyReleaseEvent(QKeyEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void keyReleaseEvent(io.qt.gui.QKeyEvent arg__1){
        keyReleaseEvent_native_QKeyEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void keyReleaseEvent_native_QKeyEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#mouseMoveEvent">QWindow::mouseMoveEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mouseMoveEvent(io.qt.gui.QMouseEvent arg__1){
        mouseMoveEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void mouseMoveEvent_native_QMouseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#mousePressEvent">QWindow::mousePressEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mousePressEvent(io.qt.gui.QMouseEvent arg__1){
        mousePressEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void mousePressEvent_native_QMouseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#mouseReleaseEvent">QWindow::mouseReleaseEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mouseReleaseEvent(io.qt.gui.QMouseEvent arg__1){
        mouseReleaseEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void mouseReleaseEvent_native_QMouseEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qwindow.html#resizeEvent">QWindow::resizeEvent(QResizeEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void resizeEvent(io.qt.gui.QResizeEvent arg__1){
        resizeEvent_native_QResizeEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void resizeEvent_native_QResizeEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qobject.html#timerEvent">QObject::timerEvent(QTimerEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void timerEvent(io.qt.core.QTimerEvent arg__1){
        timerEvent_native_QTimerEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void timerEvent_native_QTimerEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickView(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuickView(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuickView instance, QDeclarativeConstructor constructor);
    
}
