package io.qt.quick;


/**
 * <p>Interface for loading custom textures from QML</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qquicktexturefactory.html">QQuickTextureFactory</a></p>
 */
public abstract class QQuickTextureFactory extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickTextureFactory.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QQuickTextureFactory {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.quick.QSGTexture createTexture(io.qt.quick.QQuickWindow window){
            return createTexture_native_QQuickWindow_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(window));
        }
        @io.qt.QtUninvokable
        private native io.qt.quick.QSGTexture createTexture_native_QQuickWindow_ptr_constfct(long __this__nativeId, long window);
        
        
        @Override
        @io.qt.QtUninvokable
        public int textureByteCount(){
            return textureByteCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native int textureByteCount_native_constfct(long __this__nativeId);
        
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.core.QSize textureSize(){
            return textureSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.core.QSize textureSize_native_constfct(long __this__nativeId);
        
    }
    
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquicktexturefactory.html#QQuickTextureFactory">QQuickTextureFactory::QQuickTextureFactory()</a></p>
     */
    public QQuickTextureFactory(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QQuickTextureFactory instance);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquicktexturefactory.html#createTexture">QQuickTextureFactory::createTexture(QQuickWindow*)const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.quick.QSGTexture createTexture(io.qt.quick.QQuickWindow window);
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGTexture createTexture_native_QQuickWindow_ptr_constfct(long __this__nativeId, long window);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquicktexturefactory.html#image">QQuickTextureFactory::image()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.gui.QImage image(){
        return image_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QImage image_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquicktexturefactory.html#textureByteCount">QQuickTextureFactory::textureByteCount()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract int textureByteCount();
    
    @io.qt.QtUninvokable
    private native int textureByteCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquicktexturefactory.html#textureSize">QQuickTextureFactory::textureSize()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.core.QSize textureSize();
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSize textureSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquicktexturefactory.html#textureFactoryForImage">QQuickTextureFactory::textureFactoryForImage(QImage)</a></p>
     */
    public static io.qt.quick.QQuickTextureFactory textureFactoryForImage(io.qt.gui.QImage image){
        return textureFactoryForImage_native_cref_QImage(QtJambi_LibraryUtilities.internal.checkedNativeId(image));
    }
    
    private native static io.qt.quick.QQuickTextureFactory textureFactoryForImage_native_cref_QImage(long image);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickTextureFactory(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuickTextureFactory(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuickTextureFactory instance, QDeclarativeConstructor constructor);
    
}
