package io.qt.quick;


/**
 * <p>The most basic of all visual items in Qt Quick</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qquickitem.html">QQuickItem</a></p>
 */
public class QQuickItem extends io.qt.core.QObject
    implements io.qt.qml.QQmlParserStatus
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    @io.qt.QtPropertyMember(enabled=false)
    private Object __rcContainmentMask = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickItem.class);
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickitem.html#Flag-enum">QQuickItem::Flag</a></p>
     * 
     * @see Flags
     */
    public enum Flag implements io.qt.QtFlagEnumerator {
        ItemClipsChildrenToShape(1),
        ItemAcceptsInputMethod(2),
        ItemIsFocusScope(4),
        ItemHasContents(8),
        ItemAcceptsDrops(16);

        private Flag(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public Flags asFlags() {
            return new Flags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public Flags combined(Flag e) {
            return new Flags(this, e);
        }

        /**
         * Creates a new {@link Flags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static Flags flags(Flag ... values) {
            return new Flags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static Flag resolve(int value) {
            switch (value) {
            case 1: return ItemClipsChildrenToShape;
            case 2: return ItemAcceptsInputMethod;
            case 4: return ItemIsFocusScope;
            case 8: return ItemHasContents;
            case 16: return ItemAcceptsDrops;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * QFlags type for enum {@link Flag}
     */
    public static final class Flags extends io.qt.QFlags<Flag> implements Comparable<Flags> {
        private static final long serialVersionUID = 0x92d9bce6c929c1c6L;

        /**
         * Creates a new Flags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Flags(Flag ... args){
            super(args);
        }

        /**
         * Creates a new Flags with given <code>value</code>.
         * @param value
         */
        public Flags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Flags
         */
        @Override
        public final Flags combined(Flag e){
            return new Flags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final Flags setFlag(Flag e){
            super.setFlag(e);
            return this;
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final Flags setFlag(Flag e, boolean on){
            super.setFlag(e, on);
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Flags.
         * @return array of enum entries
         */
        @Override
        public final Flag[] flags(){
            return super.flags(Flag.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final Flags clone(){
            return new Flags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(Flags other){
            return Integer.compare(value(), other.value());
        }
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickitem.html#ItemChange-enum">QQuickItem::ItemChange</a></p>
     */
    @io.qt.QtUnlistedEnum
    public enum ItemChange implements io.qt.QtEnumerator {
        ItemChildAddedChange(0),
        ItemChildRemovedChange(1),
        ItemSceneChange(2),
        ItemVisibleHasChanged(3),
        ItemParentHasChanged(4),
        ItemOpacityHasChanged(5),
        ItemActiveFocusHasChanged(6),
        ItemRotationHasChanged(7),
        ItemAntialiasingHasChanged(8),
        ItemDevicePixelRatioHasChanged(9),
        ItemEnabledHasChanged(10);

        private ItemChange(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static ItemChange resolve(int value) {
            switch (value) {
            case 0: return ItemChildAddedChange;
            case 1: return ItemChildRemovedChange;
            case 2: return ItemSceneChange;
            case 3: return ItemVisibleHasChanged;
            case 4: return ItemParentHasChanged;
            case 5: return ItemOpacityHasChanged;
            case 6: return ItemActiveFocusHasChanged;
            case 7: return ItemRotationHasChanged;
            case 8: return ItemAntialiasingHasChanged;
            case 9: return ItemDevicePixelRatioHasChanged;
            case 10: return ItemEnabledHasChanged;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <a href="http://doc.qt.io/qt-5/qquickitem.html#TransformOrigin-enum">QQuickItem::TransformOrigin</a></p>
     */
    public enum TransformOrigin implements io.qt.QtEnumerator {
        TopLeft(0),
        Top(1),
        TopRight(2),
        Left(3),
        Center(4),
        Right(5),
        BottomLeft(6),
        Bottom(7),
        BottomRight(8);

        private TransformOrigin(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static TransformOrigin resolve(int value) {
            switch (value) {
            case 0: return TopLeft;
            case 1: return Top;
            case 2: return TopRight;
            case 3: return Left;
            case 4: return Center;
            case 5: return Right;
            case 6: return BottomLeft;
            case 7: return Bottom;
            case 8: return BottomRight;
            default: throw new io.qt.QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>Java wrapper for Qt class QQuickItem::UpdatePaintNodeData</p>
     */
    public static final class UpdatePaintNodeData extends io.qt.QtObject
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        
        
        @io.qt.QtUninvokable
        public final void setTransformNode(io.qt.quick.QSGTransformNode transformNode){
            setTransformNode_native_QSGTransformNode_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(transformNode));
        }
        
        @io.qt.QtUninvokable
        private native void setTransformNode_native_QSGTransformNode_ptr(long __this__nativeId, long transformNode);
        
        @io.qt.QtUninvokable
        public final io.qt.quick.QSGTransformNode transformNode(){
            return transformNode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.quick.QSGTransformNode transformNode_native(long __this__nativeId);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected UpdatePaintNodeData(QPrivateConstructor p) { super(p); } 
        
    }


    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#activeFocus-prop">QQuickItem::activeFocusChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="activeFocus")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> activeFocusChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#activeFocusOnTab-prop">QQuickItem::activeFocusOnTabChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="activeFocusOnTab")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> activeFocusOnTabChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#antialiasing-prop">QQuickItem::antialiasingChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="antialiasing")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> antialiasingChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#baselineOffset-prop">QQuickItem::baselineOffsetChanged(qreal)</a></p>
     */
    @io.qt.QtPropertyNotify(name="baselineOffset")
    public final Signal1<@io.qt.QtPrimitiveType Double> baselineOffsetChanged = new Signal1<>();

    public final Signal0 childrenChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#childrenRect-prop">QQuickItem::childrenRectChanged(QRectF)</a></p>
     */
    @io.qt.QtPropertyNotify(name="childrenRect")
    public final Signal1<io.qt.core.QRectF> childrenRectChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#clip-prop">QQuickItem::clipChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="clip")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> clipChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#containmentMask-prop">QQuickItem::containmentMaskChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="containmentMask")
    public final Signal0 containmentMaskChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#enabled-prop">QQuickItem::enabledChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="enabled")
    public final Signal0 enabledChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#focus-prop">QQuickItem::focusChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="focus")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> focusChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#height-prop">QQuickItem::heightChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="height")
    public final Signal0 heightChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#implicitHeight-prop">QQuickItem::implicitHeightChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="implicitHeight")
    public final Signal0 implicitHeightChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#implicitWidth-prop">QQuickItem::implicitWidthChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="implicitWidth")
    public final Signal0 implicitWidthChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#opacity-prop">QQuickItem::opacityChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="opacity")
    public final Signal0 opacityChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#parent-prop">QQuickItem::parentChanged(QQuickItem*)</a></p>
     */
    @io.qt.QtPropertyNotify(name="parent")
    public final Signal1<io.qt.quick.QQuickItem> parentChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#rotation-prop">QQuickItem::rotationChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="rotation")
    public final Signal0 rotationChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#scale-prop">QQuickItem::scaleChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="scale")
    public final Signal0 scaleChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#smooth-prop">QQuickItem::smoothChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="smooth")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> smoothChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#state-prop">QQuickItem::stateChanged(QString)</a></p>
     */
    @io.qt.QtPropertyNotify(name="state")
    public final Signal1<java.lang.String> stateChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#transformOrigin-prop">QQuickItem::transformOriginChanged(QQuickItem::TransformOrigin)</a></p>
     */
    @io.qt.QtPropertyNotify(name="transformOrigin")
    public final Signal1<io.qt.quick.QQuickItem.TransformOrigin> transformOriginChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#visible-prop">QQuickItem::visibleChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="visible")
    public final Signal0 visibleChanged = new Signal0();

    public final Signal0 visibleChildrenChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#width-prop">QQuickItem::widthChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="width")
    public final Signal0 widthChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#windowChanged">QQuickItem::windowChanged(QQuickWindow*)</a></p>
     */
    public final Signal1<io.qt.quick.QQuickWindow> windowChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#x-prop">QQuickItem::xChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="x")
    public final Signal0 xChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#y-prop">QQuickItem::yChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="y")
    public final Signal0 yChanged = new Signal0();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#z-prop">QQuickItem::zChanged()</a></p>
     */
    @io.qt.QtPropertyNotify(name="z")
    public final Signal0 zChanged = new Signal0();
    
    /**
     * <p>Overloaded constructor for {@link #QQuickItem(io.qt.quick.QQuickItem)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickItem() {
        this((io.qt.quick.QQuickItem)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#QQuickItem">QQuickItem::QQuickItem(QQuickItem*)</a></p>
     */
    public QQuickItem(io.qt.quick.QQuickItem parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuickItem instance, io.qt.quick.QQuickItem parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#acceptHoverEvents">QQuickItem::acceptHoverEvents()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean acceptHoverEvents(){
        return acceptHoverEvents_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean acceptHoverEvents_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#acceptTouchEvents">QQuickItem::acceptTouchEvents()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean acceptTouchEvents(){
        return acceptTouchEvents_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean acceptTouchEvents_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#acceptedMouseButtons">QQuickItem::acceptedMouseButtons()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.Qt.MouseButtons acceptedMouseButtons(){
        return new io.qt.core.Qt.MouseButtons(acceptedMouseButtons_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int acceptedMouseButtons_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#activeFocusOnTab-prop">QQuickItem::activeFocusOnTab()const</a></p>
     */
    @io.qt.QtPropertyReader(name="activeFocusOnTab")
    @io.qt.QtUninvokable
    public final boolean activeFocusOnTab(){
        return activeFocusOnTab_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean activeFocusOnTab_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#antialiasing-prop">QQuickItem::antialiasing()const</a></p>
     */
    @io.qt.QtPropertyReader(name="antialiasing")
    @io.qt.QtUninvokable
    public final boolean antialiasing(){
        return antialiasing_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean antialiasing_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#baselineOffset-prop">QQuickItem::baselineOffset()const</a></p>
     */
    @io.qt.QtPropertyReader(name="baselineOffset")
    @io.qt.QtUninvokable
    public final double baselineOffset(){
        return baselineOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double baselineOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#childAt">QQuickItem::childAt(qreal,qreal)const</a></p>
     */
    public final io.qt.quick.QQuickItem childAt(double x, double y){
        return childAt_native_qtjambireal_qtjambireal_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), x, y);
    }
    
    private native io.qt.quick.QQuickItem childAt_native_qtjambireal_qtjambireal_constfct(long __this__nativeId, double x, double y);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#childItems">QQuickItem::childItems()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QList<io.qt.quick.QQuickItem> childItems(){
        return childItems_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QList<io.qt.quick.QQuickItem> childItems_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#childrenRect-prop">QQuickItem::childrenRect()</a></p>
     */
    @io.qt.QtPropertyReader(name="childrenRect")
    @io.qt.QtPropertyDesignable("false")
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF childrenRect(){
        return childrenRect_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF childrenRect_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#clip-prop">QQuickItem::clip()const</a></p>
     */
    @io.qt.QtPropertyReader(name="clip")
    @io.qt.QtUninvokable
    public final boolean clip(){
        return clip_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean clip_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#containmentMask-prop">QQuickItem::containmentMask()const</a></p>
     */
    @io.qt.QtPropertyReader(name="containmentMask")
    @io.qt.QtUninvokable
    public final io.qt.core.QObject containmentMask(){
        return containmentMask_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QObject containmentMask_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#cursor">QQuickItem::cursor()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.gui.QCursor cursor(){
        return cursor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QCursor cursor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#filtersChildMouseEvents">QQuickItem::filtersChildMouseEvents()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean filtersChildMouseEvents(){
        return filtersChildMouseEvents_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean filtersChildMouseEvents_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#flags">QQuickItem::flags()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickItem.Flags flags(){
        return new io.qt.quick.QQuickItem.Flags(flags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int flags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#forceActiveFocus">QQuickItem::forceActiveFocus()</a></p>
     */
    public final void forceActiveFocus(){
        forceActiveFocus_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void forceActiveFocus_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#forceActiveFocus-1">QQuickItem::forceActiveFocus(Qt::FocusReason)</a></p>
     */
    public final void forceActiveFocus(io.qt.core.Qt.FocusReason reason){
        forceActiveFocus_native_Qt_FocusReason(QtJambi_LibraryUtilities.internal.nativeId(this), reason.value());
    }
    
    private native void forceActiveFocus_native_Qt_FocusReason(long __this__nativeId, int reason);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#grabMouse">QQuickItem::grabMouse()</a></p>
     */
    @io.qt.QtUninvokable
    public final void grabMouse(){
        grabMouse_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void grabMouse_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #grabToImage(io.qt.qml.QJSValue, io.qt.core.QSize)}
     *  with <code>targetSize = new io.qt.core.QSize()</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public final boolean grabToImage(io.qt.qml.QJSValue callback) {
        return grabToImage(callback, new io.qt.core.QSize());
    }
    
    @SuppressWarnings({"exports"})
    public final boolean grabToImage(io.qt.qml.QJSValue callback, io.qt.core.QSize targetSize){
        return grabToImage_native_cref_QJSValue_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(callback), QtJambi_LibraryUtilities.internal.checkedNativeId(targetSize));
    }
    
    private native boolean grabToImage_native_cref_QJSValue_cref_QSize(long __this__nativeId, long callback, long targetSize);
    
    /**
     * <p>Overloaded function for {@link #grabToImage(io.qt.core.QSize)}
     *  with <code>targetSize = new io.qt.core.QSize()</code>.</p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickItemGrabResult grabToImage() {
        return grabToImage(new io.qt.core.QSize());
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#grabToImage-1">QQuickItem::grabToImage(QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickItemGrabResult grabToImage(io.qt.core.QSize targetSize){
        return grabToImage_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(targetSize));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickItemGrabResult grabToImage_native_cref_QSize(long __this__nativeId, long targetSize);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#grabTouchPoints">QQuickItem::grabTouchPoints(QVector&lt;int&gt;)</a></p>
     */
    @io.qt.QtUninvokable
    public final void grabTouchPoints(java.util.Collection<java.lang.Integer> ids){
        grabTouchPoints_native_cref_QVector(QtJambi_LibraryUtilities.internal.nativeId(this), ids);
    }
    
    @io.qt.QtUninvokable
    private native void grabTouchPoints_native_cref_QVector(long __this__nativeId, java.util.Collection<java.lang.Integer> ids);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#activeFocus-prop">QQuickItem::hasActiveFocus()const</a></p>
     */
    @io.qt.QtPropertyReader(name="activeFocus")
    @io.qt.QtUninvokable
    public final boolean hasActiveFocus(){
        return hasActiveFocus_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasActiveFocus_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#focus-prop">QQuickItem::hasFocus()const</a></p>
     */
    @io.qt.QtPropertyReader(name="focus")
    @io.qt.QtUninvokable
    public final boolean hasFocus(){
        return hasFocus_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean hasFocus_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#height-prop">QQuickItem::height()const</a></p>
     */
    @io.qt.QtPropertyReader(name="height")
    @io.qt.QtUninvokable
    public final double height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#heightValid">QQuickItem::heightValid()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final boolean heightValid(){
        return heightValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean heightValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#implicitHeight-prop">QQuickItem::implicitHeight()const</a></p>
     */
    @io.qt.QtPropertyReader(name="implicitHeight")
    @io.qt.QtUninvokable
    public final double implicitHeight(){
        return implicitHeight_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double implicitHeight_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#implicitWidth">QQuickItem::implicitWidth()const</a></p>
     */
    @io.qt.QtPropertyReader(name="implicitWidth")
    @io.qt.QtUninvokable
    public final double implicitWidth(){
        return implicitWidth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double implicitWidth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#isAncestorOf">QQuickItem::isAncestorOf(const QQuickItem*)const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isAncestorOf(io.qt.quick.QQuickItem child){
        return isAncestorOf_native_const_QQuickItem_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(child));
    }
    
    @io.qt.QtUninvokable
    private native boolean isAncestorOf_native_const_QQuickItem_ptr_constfct(long __this__nativeId, long child);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#isComponentComplete">QQuickItem::isComponentComplete()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final boolean isComponentComplete(){
        return isComponentComplete_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isComponentComplete_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#enabled-prop">QQuickItem::isEnabled()const</a></p>
     */
    @io.qt.QtPropertyReader(name="enabled")
    @io.qt.QtUninvokable
    public final boolean isEnabled(){
        return isEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#isFocusScope">QQuickItem::isFocusScope()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean isFocusScope(){
        return isFocusScope_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isFocusScope_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final boolean isUnderMouse(){
        return isUnderMouse_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isUnderMouse_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#visible-prop">QQuickItem::isVisible()const</a></p>
     */
    @io.qt.QtPropertyReader(name="visible")
    @io.qt.QtUninvokable
    public final boolean isVisible(){
        return isVisible_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isVisible_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.gui.QTransform itemTransform(io.qt.quick.QQuickItem arg__1){
        return itemTransform_native_QQuickItem_ptr_bool_ptr_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QTransform itemTransform_native_QQuickItem_ptr_bool_ptr_constfct(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#keepMouseGrab">QQuickItem::keepMouseGrab()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean keepMouseGrab(){
        return keepMouseGrab_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean keepMouseGrab_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#keepTouchGrab">QQuickItem::keepTouchGrab()const</a></p>
     */
    @io.qt.QtUninvokable
    public final boolean keepTouchGrab(){
        return keepTouchGrab_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean keepTouchGrab_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mapFromGlobal">QQuickItem::mapFromGlobal(QPointF)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QPointF mapFromGlobal(io.qt.core.QPointF point){
        return mapFromGlobal_native_cref_QPointF_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPointF mapFromGlobal_native_cref_QPointF_constfct(long __this__nativeId, long point);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mapFromItem">QQuickItem::mapFromItem(const QQuickItem*,QPointF)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QPointF mapFromItem(io.qt.quick.QQuickItem item, io.qt.core.QPointF point){
        return mapFromItem_native_const_QQuickItem_ptr_cref_QPointF_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPointF mapFromItem_native_const_QQuickItem_ptr_cref_QPointF_constfct(long __this__nativeId, long item, long point);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mapFromScene">QQuickItem::mapFromScene(QPointF)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QPointF mapFromScene(io.qt.core.QPointF point){
        return mapFromScene_native_cref_QPointF_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPointF mapFromScene_native_cref_QPointF_constfct(long __this__nativeId, long point);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mapRectFromItem">QQuickItem::mapRectFromItem(const QQuickItem*,QRectF)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF mapRectFromItem(io.qt.quick.QQuickItem item, io.qt.core.QRectF rect){
        return mapRectFromItem_native_const_QQuickItem_ptr_cref_QRectF_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF mapRectFromItem_native_const_QQuickItem_ptr_cref_QRectF_constfct(long __this__nativeId, long item, long rect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mapRectFromScene">QQuickItem::mapRectFromScene(QRectF)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF mapRectFromScene(io.qt.core.QRectF rect){
        return mapRectFromScene_native_cref_QRectF_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF mapRectFromScene_native_cref_QRectF_constfct(long __this__nativeId, long rect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mapRectToItem">QQuickItem::mapRectToItem(const QQuickItem*,QRectF)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF mapRectToItem(io.qt.quick.QQuickItem item, io.qt.core.QRectF rect){
        return mapRectToItem_native_const_QQuickItem_ptr_cref_QRectF_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF mapRectToItem_native_const_QQuickItem_ptr_cref_QRectF_constfct(long __this__nativeId, long item, long rect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mapRectToScene">QQuickItem::mapRectToScene(QRectF)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QRectF mapRectToScene(io.qt.core.QRectF rect){
        return mapRectToScene_native_cref_QRectF_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF mapRectToScene_native_cref_QRectF_constfct(long __this__nativeId, long rect);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mapToGlobal">QQuickItem::mapToGlobal(QPointF)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QPointF mapToGlobal(io.qt.core.QPointF point){
        return mapToGlobal_native_cref_QPointF_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPointF mapToGlobal_native_cref_QPointF_constfct(long __this__nativeId, long point);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mapToItem">QQuickItem::mapToItem(const QQuickItem*,QPointF)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QPointF mapToItem(io.qt.quick.QQuickItem item, io.qt.core.QPointF point){
        return mapToItem_native_const_QQuickItem_ptr_cref_QPointF_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(item), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPointF mapToItem_native_const_QQuickItem_ptr_cref_QPointF_constfct(long __this__nativeId, long item, long point);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mapToScene">QQuickItem::mapToScene(QPointF)const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QPointF mapToScene(io.qt.core.QPointF point){
        return mapToScene_native_cref_QPointF_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPointF mapToScene_native_cref_QPointF_constfct(long __this__nativeId, long point);
    
    /**
     * <p>Overloaded function for {@link #nextItemInFocusChain(boolean)}
     *  with <code>forward = true</code>.</p>
     */
    public final io.qt.quick.QQuickItem nextItemInFocusChain() {
        return nextItemInFocusChain((boolean)true);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#nextItemInFocusChain">QQuickItem::nextItemInFocusChain(bool)</a></p>
     */
    public final io.qt.quick.QQuickItem nextItemInFocusChain(boolean forward){
        return nextItemInFocusChain_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), forward);
    }
    
    private native io.qt.quick.QQuickItem nextItemInFocusChain_native_bool(long __this__nativeId, boolean forward);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#opacity-prop">QQuickItem::opacity()const</a></p>
     */
    @io.qt.QtPropertyReader(name="opacity")
    @io.qt.QtUninvokable
    public final double opacity(){
        return opacity_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double opacity_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#parent-prop">QQuickItem::parentItem()const</a></p>
     */
    @io.qt.QtPropertyReader(name="parent")
    @io.qt.QtPropertyDesignable("false")
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickItem parentItem(){
        return parentItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickItem parentItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#polish">QQuickItem::polish()</a></p>
     */
    @io.qt.QtUninvokable
    public final void polish(){
        polish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void polish_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public final io.qt.core.QPointF position(){
        return position_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPointF position_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#antialiasing-prop">QQuickItem::resetAntialiasing()</a></p>
     */
    @io.qt.QtPropertyResetter(name="antialiasing")
    @io.qt.QtUninvokable
    public final void resetAntialiasing(){
        resetAntialiasing_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void resetAntialiasing_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#height-prop">QQuickItem::resetHeight()</a></p>
     */
    @io.qt.QtPropertyResetter(name="height")
    @io.qt.QtUninvokable
    public final void resetHeight(){
        resetHeight_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void resetHeight_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#width-prop">QQuickItem::resetWidth()</a></p>
     */
    @io.qt.QtPropertyResetter(name="width")
    @io.qt.QtUninvokable
    public final void resetWidth(){
        resetWidth_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void resetWidth_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#rotation-prop">QQuickItem::rotation()const</a></p>
     */
    @io.qt.QtPropertyReader(name="rotation")
    @io.qt.QtUninvokable
    public final double rotation(){
        return rotation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double rotation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#scale-prop">QQuickItem::scale()const</a></p>
     */
    @io.qt.QtPropertyReader(name="scale")
    @io.qt.QtUninvokable
    public final double scale(){
        return scale_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double scale_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#scopedFocusItem">QQuickItem::scopedFocusItem()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickItem scopedFocusItem(){
        return scopedFocusItem_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickItem scopedFocusItem_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#setAcceptHoverEvents">QQuickItem::setAcceptHoverEvents(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAcceptHoverEvents(boolean enabled){
        setAcceptHoverEvents_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setAcceptHoverEvents_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#setAcceptTouchEvents">QQuickItem::setAcceptTouchEvents(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAcceptTouchEvents(boolean accept){
        setAcceptTouchEvents_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), accept);
    }
    
    @io.qt.QtUninvokable
    private native void setAcceptTouchEvents_native_bool(long __this__nativeId, boolean accept);
    
    /**
     * <p>Overloaded function for {@link #setAcceptedMouseButtons(io.qt.core.Qt.MouseButtons)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setAcceptedMouseButtons(io.qt.core.Qt.MouseButton ... buttons){
        setAcceptedMouseButtons(new io.qt.core.Qt.MouseButtons(buttons));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#setAcceptedMouseButtons">QQuickItem::setAcceptedMouseButtons(Qt::MouseButtons)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setAcceptedMouseButtons(io.qt.core.Qt.MouseButtons buttons){
        setAcceptedMouseButtons_native_QFlags_Qt_MouseButton_(QtJambi_LibraryUtilities.internal.nativeId(this), buttons.value());
    }
    
    @io.qt.QtUninvokable
    private native void setAcceptedMouseButtons_native_QFlags_Qt_MouseButton_(long __this__nativeId, int buttons);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#activeFocusOnTab-prop">QQuickItem::setActiveFocusOnTab(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="activeFocusOnTab")
    @io.qt.QtUninvokable
    public final void setActiveFocusOnTab(boolean arg__1){
        setActiveFocusOnTab_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setActiveFocusOnTab_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#antialiasing-prop">QQuickItem::setAntialiasing(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="antialiasing")
    @io.qt.QtUninvokable
    public final void setAntialiasing(boolean arg__1){
        setAntialiasing_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setAntialiasing_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#baselineOffset-prop">QQuickItem::setBaselineOffset(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="baselineOffset")
    @io.qt.QtUninvokable
    public final void setBaselineOffset(double arg__1){
        setBaselineOffset_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setBaselineOffset_native_qtjambireal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#clip-prop">QQuickItem::setClip(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="clip")
    @io.qt.QtUninvokable
    public final void setClip(boolean arg__1){
        setClip_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setClip_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#containmentMask-prop">QQuickItem::setContainmentMask(QObject*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="containmentMask")
    @io.qt.QtUninvokable
    public final void setContainmentMask(io.qt.core.QObject mask){
        boolean hasContainsMethod = true;
                        if(mask!=null){
                            hasContainsMethod = mask.metaObject().method("contains", io.qt.core.QPointF.class)!=null;
                        }
        setContainmentMask_native_QObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(mask));
        if (hasContainsMethod) {
            __rcContainmentMask = mask;
        }
    }
    
    @io.qt.QtUninvokable
    private native void setContainmentMask_native_QObject_ptr(long __this__nativeId, long mask);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#setCursor">QQuickItem::setCursor(QCursor)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setCursor(io.qt.gui.QCursor cursor){
        setCursor_native_cref_QCursor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(cursor));
    }
    
    @io.qt.QtUninvokable
    private native void setCursor_native_cref_QCursor(long __this__nativeId, long cursor);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#enabled-prop">QQuickItem::setEnabled(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="enabled")
    @io.qt.QtUninvokable
    public final void setEnabled(boolean arg__1){
        setEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setEnabled_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#setFiltersChildMouseEvents">QQuickItem::setFiltersChildMouseEvents(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFiltersChildMouseEvents(boolean filter){
        setFiltersChildMouseEvents_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), filter);
    }
    
    @io.qt.QtUninvokable
    private native void setFiltersChildMouseEvents_native_bool(long __this__nativeId, boolean filter);
    
    /**
     * <p>Overloaded function for {@link #setFlag(io.qt.quick.QQuickItem.Flag, boolean)}
     *  with <code>enabled = true</code>.</p>
     */
    @io.qt.QtUninvokable
    public final void setFlag(io.qt.quick.QQuickItem.Flag flag) {
        setFlag(flag, (boolean)true);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#setFlag">QQuickItem::setFlag(QQuickItem::Flag,bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFlag(io.qt.quick.QQuickItem.Flag flag, boolean enabled){
        setFlag_native_QQuickItem_Flag_bool(QtJambi_LibraryUtilities.internal.nativeId(this), flag.value(), enabled);
    }
    
    @io.qt.QtUninvokable
    private native void setFlag_native_QQuickItem_Flag_bool(long __this__nativeId, int flag, boolean enabled);
    
    /**
     * <p>Overloaded function for {@link #setFlags(io.qt.quick.QQuickItem.Flags)}.</p>
     */
    @io.qt.QtUninvokable
    public final void setFlags(io.qt.quick.QQuickItem.Flag ... flags){
        setFlags(new io.qt.quick.QQuickItem.Flags(flags));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#setFlags">QQuickItem::setFlags(Flags)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setFlags(io.qt.quick.QQuickItem.Flags flags){
        setFlags_native_QFlags_QQuickItem_Flag_(QtJambi_LibraryUtilities.internal.nativeId(this), flags.value());
    }
    
    @io.qt.QtUninvokable
    private native void setFlags_native_QFlags_QQuickItem_Flag_(long __this__nativeId, int flags);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#focus-prop">QQuickItem::setFocus(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="focus")
    @io.qt.QtUninvokable
    public final void setFocus(boolean arg__1){
        setFocus_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setFocus_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#focus-prop">QQuickItem::setFocus(bool,Qt::FocusReason)</a></p>
     */
    @io.qt.QtPropertyWriter(name="focus")
    @io.qt.QtUninvokable
    public final void setFocus(boolean focus, io.qt.core.Qt.FocusReason reason){
        setFocus_native_bool_Qt_FocusReason(QtJambi_LibraryUtilities.internal.nativeId(this), focus, reason.value());
    }
    
    @io.qt.QtUninvokable
    private native void setFocus_native_bool_Qt_FocusReason(long __this__nativeId, boolean focus, int reason);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#height-prop">QQuickItem::setHeight(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="height")
    @io.qt.QtUninvokable
    public final void setHeight(double arg__1){
        setHeight_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setHeight_native_qtjambireal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#implicitHeight-prop">QQuickItem::setImplicitHeight(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="implicitHeight")
    @io.qt.QtUninvokable
    public final void setImplicitHeight(double arg__1){
        setImplicitHeight_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setImplicitHeight_native_qtjambireal(long __this__nativeId, double arg__1);
    
    @io.qt.QtUninvokable
    protected final void setImplicitSize(double arg__1, double arg__2){
        setImplicitSize_native_qtjambireal_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1, arg__2);
    }
    
    @io.qt.QtUninvokable
    private native void setImplicitSize_native_qtjambireal_qtjambireal(long __this__nativeId, double arg__1, double arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#implicitWidth-prop">QQuickItem::setImplicitWidth(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="implicitWidth")
    @io.qt.QtUninvokable
    public final void setImplicitWidth(double arg__1){
        setImplicitWidth_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setImplicitWidth_native_qtjambireal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#setKeepMouseGrab">QQuickItem::setKeepMouseGrab(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setKeepMouseGrab(boolean arg__1){
        setKeepMouseGrab_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setKeepMouseGrab_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#setKeepTouchGrab">QQuickItem::setKeepTouchGrab(bool)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setKeepTouchGrab(boolean arg__1){
        setKeepTouchGrab_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setKeepTouchGrab_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#opacity-prop">QQuickItem::setOpacity(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="opacity")
    @io.qt.QtUninvokable
    public final void setOpacity(double arg__1){
        setOpacity_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setOpacity_native_qtjambireal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#parent-prop">QQuickItem::setParentItem(QQuickItem*)</a></p>
     */
    @io.qt.QtPropertyWriter(name="parent")
    @io.qt.QtUninvokable
    public final void setParentItem(io.qt.quick.QQuickItem parent){
        setParentItem_native_QQuickItem_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(parent));
    }
    
    @io.qt.QtUninvokable
    private native void setParentItem_native_QQuickItem_ptr(long __this__nativeId, long parent);
    
    @io.qt.QtUninvokable
    public final void setPosition(io.qt.core.QPointF arg__1){
        setPosition_native_cref_QPointF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void setPosition_native_cref_QPointF(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#rotation-prop">QQuickItem::setRotation(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="rotation")
    @io.qt.QtUninvokable
    public final void setRotation(double arg__1){
        setRotation_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setRotation_native_qtjambireal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#scale-prop">QQuickItem::setScale(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="scale")
    @io.qt.QtUninvokable
    public final void setScale(double arg__1){
        setScale_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setScale_native_qtjambireal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#setSize">QQuickItem::setSize(QSizeF)</a></p>
     */
    @io.qt.QtUninvokable
    public final void setSize(io.qt.core.QSizeF size){
        setSize_native_cref_QSizeF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    @io.qt.QtUninvokable
    private native void setSize_native_cref_QSizeF(long __this__nativeId, long size);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#smooth-prop">QQuickItem::setSmooth(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="smooth")
    @io.qt.QtUninvokable
    public final void setSmooth(boolean arg__1){
        setSmooth_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setSmooth_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#state-prop">QQuickItem::setState(QString)</a></p>
     */
    @io.qt.QtPropertyWriter(name="state")
    @io.qt.QtUninvokable
    public final void setState(java.lang.String arg__1){
        setState_native_cref_QString(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setState_native_cref_QString(long __this__nativeId, java.lang.String arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#transformOrigin-prop">QQuickItem::setTransformOrigin(QQuickItem::TransformOrigin)</a></p>
     */
    @io.qt.QtPropertyWriter(name="transformOrigin")
    @io.qt.QtUninvokable
    public final void setTransformOrigin(io.qt.quick.QQuickItem.TransformOrigin arg__1){
        setTransformOrigin_native_QQuickItem_TransformOrigin(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @io.qt.QtUninvokable
    private native void setTransformOrigin_native_QQuickItem_TransformOrigin(long __this__nativeId, int arg__1);
    
    @io.qt.QtUninvokable
    public final void setTransformOriginPoint(io.qt.core.QPointF arg__1){
        setTransformOriginPoint_native_cref_QPointF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void setTransformOriginPoint_native_cref_QPointF(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#visible-prop">QQuickItem::setVisible(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="visible")
    @io.qt.QtUninvokable
    public final void setVisible(boolean arg__1){
        setVisible_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setVisible_native_bool(long __this__nativeId, boolean arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#width-prop">QQuickItem::setWidth(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="width")
    @io.qt.QtUninvokable
    public final void setWidth(double arg__1){
        setWidth_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setWidth_native_qtjambireal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#x-prop">QQuickItem::setX(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="x")
    @io.qt.QtUninvokable
    public final void setX(double arg__1){
        setX_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setX_native_qtjambireal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#y-prop">QQuickItem::setY(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="y")
    @io.qt.QtUninvokable
    public final void setY(double arg__1){
        setY_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setY_native_qtjambireal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#z-prop">QQuickItem::setZ(qreal)</a></p>
     */
    @io.qt.QtPropertyWriter(name="z")
    @io.qt.QtUninvokable
    public final void setZ(double arg__1){
        setZ_native_qtjambireal(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1);
    }
    
    @io.qt.QtUninvokable
    private native void setZ_native_qtjambireal(long __this__nativeId, double arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#size">QQuickItem::size()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.core.QSizeF size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QSizeF size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#smooth-prop">QQuickItem::smooth()const</a></p>
     */
    @io.qt.QtPropertyReader(name="smooth")
    @io.qt.QtUninvokable
    public final boolean smooth(){
        return smooth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean smooth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#stackAfter">QQuickItem::stackAfter(const QQuickItem*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void stackAfter(io.qt.quick.QQuickItem arg__1){
        stackAfter_native_const_QQuickItem_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void stackAfter_native_const_QQuickItem_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#stackBefore">QQuickItem::stackBefore(const QQuickItem*)</a></p>
     */
    @io.qt.QtUninvokable
    public final void stackBefore(io.qt.quick.QQuickItem arg__1){
        stackBefore_native_const_QQuickItem_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void stackBefore_native_const_QQuickItem_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#state-prop">QQuickItem::state()const</a></p>
     */
    @io.qt.QtPropertyReader(name="state")
    @io.qt.QtUninvokable
    public final java.lang.String state(){
        return state_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native java.lang.String state_native_constfct(long __this__nativeId);
    
    @io.qt.QtPropertyReader(name="transform")
    @io.qt.QtPropertyDesignable("false")
    @io.qt.QtUninvokable
    public final io.qt.qml.QQmlListProperty<io.qt.quick.QQuickTransform> transform(){
        return transform_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.qml.QQmlListProperty<io.qt.quick.QQuickTransform> transform_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#transformOrigin-prop">QQuickItem::transformOrigin()const</a></p>
     */
    @io.qt.QtPropertyReader(name="transformOrigin")
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickItem.TransformOrigin transformOrigin(){
        return io.qt.quick.QQuickItem.TransformOrigin.resolve(transformOrigin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @io.qt.QtUninvokable
    private native int transformOrigin_native_constfct(long __this__nativeId);
    
    @io.qt.QtPropertyReader(name="transformOriginPoint")
    @io.qt.QtUninvokable
    public final io.qt.core.QPointF transformOriginPoint(){
        return transformOriginPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QPointF transformOriginPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#ungrabMouse">QQuickItem::ungrabMouse()</a></p>
     */
    @io.qt.QtUninvokable
    public final void ungrabMouse(){
        ungrabMouse_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void ungrabMouse_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#ungrabTouchPoints">QQuickItem::ungrabTouchPoints()</a></p>
     */
    @io.qt.QtUninvokable
    public final void ungrabTouchPoints(){
        ungrabTouchPoints_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void ungrabTouchPoints_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#unsetCursor">QQuickItem::unsetCursor()</a></p>
     */
    @io.qt.QtUninvokable
    public final void unsetCursor(){
        unsetCursor_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void unsetCursor_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#update">QQuickItem::update()</a></p>
     */
    public final void update(){
        update_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void update_native(long __this__nativeId);
    
    /**
     * <p>Overloaded function for {@link #updateInputMethod(io.qt.core.Qt.InputMethodQueries)}.</p>
     */
    @io.qt.QtUninvokable
    protected final void updateInputMethod(io.qt.core.Qt.InputMethodQuery ... queries){
        updateInputMethod(new io.qt.core.Qt.InputMethodQueries(queries));
    }
    
    /**
     * <p>Overloaded function for {@link #updateInputMethod(io.qt.core.Qt.InputMethodQueries)}
     *  with <code>queries = new io.qt.core.Qt.InputMethodQueries(16570)</code>.</p>
     */
    @io.qt.QtUninvokable
    protected final void updateInputMethod() {
        updateInputMethod(new io.qt.core.Qt.InputMethodQueries(16570));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#updateInputMethod">QQuickItem::updateInputMethod(Qt::InputMethodQueries)</a></p>
     */
    @io.qt.QtUninvokable
    protected final void updateInputMethod(io.qt.core.Qt.InputMethodQueries queries){
        updateInputMethod_native_QFlags_Qt_InputMethodQuery_(QtJambi_LibraryUtilities.internal.nativeId(this), queries.value());
    }
    
    @io.qt.QtUninvokable
    private native void updateInputMethod_native_QFlags_Qt_InputMethodQuery_(long __this__nativeId, int queries);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#width-prop">QQuickItem::width()const</a></p>
     */
    @io.qt.QtPropertyReader(name="width")
    @io.qt.QtUninvokable
    public final double width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#widthValid">QQuickItem::widthValid()const</a></p>
     */
    @io.qt.QtUninvokable
    protected final boolean widthValid(){
        return widthValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean widthValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#window">QQuickItem::window()const</a></p>
     */
    @io.qt.QtUninvokable
    public final io.qt.quick.QQuickWindow window(){
        return window_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickWindow window_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#x-prop">QQuickItem::x()const</a></p>
     */
    @io.qt.QtPropertyReader(name="x")
    @io.qt.QtUninvokable
    public final double x(){
        return x_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double x_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#y-prop">QQuickItem::y()const</a></p>
     */
    @io.qt.QtPropertyReader(name="y")
    @io.qt.QtUninvokable
    public final double y(){
        return y_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double y_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#z-prop">QQuickItem::z()const</a></p>
     */
    @io.qt.QtPropertyReader(name="z")
    @io.qt.QtUninvokable
    public final double z(){
        return z_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native double z_native_constfct(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public io.qt.core.QRectF boundingRect(){
        return boundingRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF boundingRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#childMouseEventFilter">QQuickItem::childMouseEventFilter(QQuickItem*,QEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected boolean childMouseEventFilter(io.qt.quick.QQuickItem arg__1, io.qt.core.QEvent arg__2){
        return childMouseEventFilter_native_QQuickItem_ptr_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
    }
    
    @io.qt.QtUninvokable
    private native boolean childMouseEventFilter_native_QQuickItem_ptr_QEvent_ptr(long __this__nativeId, long arg__1, long arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlparserstatus.html#classBegin">QQmlParserStatus::classBegin()</a></p>
     */
    @io.qt.QtUninvokable
    public void classBegin(){
        classBegin_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void classBegin_native(long __this__nativeId);
    
    @io.qt.QtUninvokable
    public io.qt.core.QRectF clipRect(){
        return clipRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.core.QRectF clipRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlparserstatus.html#componentComplete">QQmlParserStatus::componentComplete()</a></p>
     */
    @io.qt.QtUninvokable
    public void componentComplete(){
        componentComplete_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native static void componentComplete_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#contains">QQuickItem::contains(QPointF)const</a></p>
     */
    public boolean contains(io.qt.core.QPointF point){
        return contains_native_cref_QPointF_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(point));
    }
    
    private native boolean contains_native_cref_QPointF_constfct(long __this__nativeId, long point);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#dragEnterEvent">QQuickItem::dragEnterEvent(QDragEnterEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void dragEnterEvent(io.qt.gui.QDragEnterEvent arg__1){
        dragEnterEvent_native_QDragEnterEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void dragEnterEvent_native_QDragEnterEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#dragLeaveEvent">QQuickItem::dragLeaveEvent(QDragLeaveEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void dragLeaveEvent(io.qt.gui.QDragLeaveEvent arg__1){
        dragLeaveEvent_native_QDragLeaveEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void dragLeaveEvent_native_QDragLeaveEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#dragMoveEvent">QQuickItem::dragMoveEvent(QDragMoveEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void dragMoveEvent(io.qt.gui.QDragMoveEvent arg__1){
        dragMoveEvent_native_QDragMoveEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void dragMoveEvent_native_QDragMoveEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#dropEvent">QQuickItem::dropEvent(QDropEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void dropEvent(io.qt.gui.QDropEvent arg__1){
        dropEvent_native_QDropEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void dropEvent_native_QDropEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qobject.html#event">QObject::event(QEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    public boolean event(io.qt.core.QEvent arg__1){
        return event_native_QEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native boolean event_native_QEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#focusInEvent">QQuickItem::focusInEvent(QFocusEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void focusInEvent(io.qt.gui.QFocusEvent arg__1){
        focusInEvent_native_QFocusEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void focusInEvent_native_QFocusEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#focusOutEvent">QQuickItem::focusOutEvent(QFocusEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void focusOutEvent(io.qt.gui.QFocusEvent arg__1){
        focusOutEvent_native_QFocusEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void focusOutEvent_native_QFocusEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#geometryChanged">QQuickItem::geometryChanged(QRectF,QRectF)</a></p>
     */
    @io.qt.QtUninvokable
    protected void geometryChanged(io.qt.core.QRectF newGeometry, io.qt.core.QRectF oldGeometry){
        geometryChanged_native_cref_QRectF_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newGeometry), QtJambi_LibraryUtilities.internal.checkedNativeId(oldGeometry));
    }
    
    @io.qt.QtUninvokable
    private native void geometryChanged_native_cref_QRectF_cref_QRectF(long __this__nativeId, long newGeometry, long oldGeometry);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#hoverEnterEvent">QQuickItem::hoverEnterEvent(QHoverEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void hoverEnterEvent(io.qt.gui.QHoverEvent event){
        hoverEnterEvent_native_QHoverEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void hoverEnterEvent_native_QHoverEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#hoverLeaveEvent">QQuickItem::hoverLeaveEvent(QHoverEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void hoverLeaveEvent(io.qt.gui.QHoverEvent event){
        hoverLeaveEvent_native_QHoverEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void hoverLeaveEvent_native_QHoverEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#hoverMoveEvent">QQuickItem::hoverMoveEvent(QHoverEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void hoverMoveEvent(io.qt.gui.QHoverEvent event){
        hoverMoveEvent_native_QHoverEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void hoverMoveEvent_native_QHoverEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#inputMethodEvent">QQuickItem::inputMethodEvent(QInputMethodEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void inputMethodEvent(io.qt.gui.QInputMethodEvent arg__1){
        inputMethodEvent_native_QInputMethodEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @io.qt.QtUninvokable
    private native void inputMethodEvent_native_QInputMethodEvent_ptr(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#inputMethodQuery">QQuickItem::inputMethodQuery(Qt::InputMethodQuery)const</a></p>
     */
    @io.qt.QtUninvokable
    public java.lang.Object inputMethodQuery(io.qt.core.Qt.InputMethodQuery query){
        return inputMethodQuery_native_Qt_InputMethodQuery_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), query.value());
    }
    
    @io.qt.QtUninvokable
    private native java.lang.Object inputMethodQuery_native_Qt_InputMethodQuery_constfct(long __this__nativeId, int query);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#isTextureProvider">QQuickItem::isTextureProvider()const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isTextureProvider(){
        return isTextureProvider_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isTextureProvider_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#itemChange">QQuickItem::itemChange(QQuickItem::ItemChange,QQuickItem::ItemChangeData)</a></p>
     */
    @io.qt.QtUninvokable
    protected void itemChange(io.qt.quick.QQuickItem.ItemChange arg__1, java.lang.Object arg__2){
        itemChange_native_QQuickItem_ItemChange_cref_QQuickItem_ItemChangeData(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value(), arg__2);
    }
    
    @io.qt.QtUninvokable
    private native void itemChange_native_QQuickItem_ItemChange_cref_QQuickItem_ItemChangeData(long __this__nativeId, int arg__1, java.lang.Object arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#keyPressEvent">QQuickItem::keyPressEvent(QKeyEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void keyPressEvent(io.qt.gui.QKeyEvent event){
        keyPressEvent_native_QKeyEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void keyPressEvent_native_QKeyEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#keyReleaseEvent">QQuickItem::keyReleaseEvent(QKeyEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void keyReleaseEvent(io.qt.gui.QKeyEvent event){
        keyReleaseEvent_native_QKeyEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void keyReleaseEvent_native_QKeyEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mouseDoubleClickEvent">QQuickItem::mouseDoubleClickEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mouseDoubleClickEvent(io.qt.gui.QMouseEvent event){
        mouseDoubleClickEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void mouseDoubleClickEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mouseMoveEvent">QQuickItem::mouseMoveEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mouseMoveEvent(io.qt.gui.QMouseEvent event){
        mouseMoveEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void mouseMoveEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mousePressEvent">QQuickItem::mousePressEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mousePressEvent(io.qt.gui.QMouseEvent event){
        mousePressEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void mousePressEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mouseReleaseEvent">QQuickItem::mouseReleaseEvent(QMouseEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void mouseReleaseEvent(io.qt.gui.QMouseEvent event){
        mouseReleaseEvent_native_QMouseEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void mouseReleaseEvent_native_QMouseEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#mouseUngrabEvent">QQuickItem::mouseUngrabEvent()</a></p>
     */
    @io.qt.QtUninvokable
    protected void mouseUngrabEvent(){
        mouseUngrabEvent_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void mouseUngrabEvent_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#releaseResources">QQuickItem::releaseResources()</a></p>
     */
    @io.qt.QtUninvokable
    protected void releaseResources(){
        releaseResources_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void releaseResources_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#textureProvider">QQuickItem::textureProvider()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGTextureProvider textureProvider(){
        return textureProvider_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGTextureProvider textureProvider_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#touchEvent">QQuickItem::touchEvent(QTouchEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void touchEvent(io.qt.gui.QTouchEvent event){
        touchEvent_native_QTouchEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void touchEvent_native_QTouchEvent_ptr(long __this__nativeId, long event);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#touchUngrabEvent">QQuickItem::touchUngrabEvent()</a></p>
     */
    @io.qt.QtUninvokable
    protected void touchUngrabEvent(){
        touchUngrabEvent_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void touchUngrabEvent_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#updatePaintNode">QQuickItem::updatePaintNode(QSGNode*,QQuickItem::UpdatePaintNodeData*)</a></p>
     */
    @io.qt.QtUninvokable
    protected io.qt.quick.QSGNode updatePaintNode(io.qt.quick.QSGNode arg__1, io.qt.quick.QQuickItem.UpdatePaintNodeData arg__2){
        io.qt.quick.QSGNode __qt_return_value = updatePaintNode_native_QSGNode_ptr_QQuickItem_UpdatePaintNodeData_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
        QtJambi_LibraryUtilities.internal.invalidateObject(arg__1);
        return __qt_return_value;
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGNode updatePaintNode_native_QSGNode_ptr_QQuickItem_UpdatePaintNodeData_ptr(long __this__nativeId, long arg__1, long arg__2);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#updatePolish">QQuickItem::updatePolish()</a></p>
     */
    @io.qt.QtUninvokable
    protected void updatePolish(){
        updatePolish_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void updatePolish_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#wheelEvent">QQuickItem::wheelEvent(QWheelEvent*)</a></p>
     */
    @io.qt.QtUninvokable
    protected void wheelEvent(io.qt.gui.QWheelEvent event){
        wheelEvent_native_QWheelEvent_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(event));
    }
    
    @io.qt.QtUninvokable
    private native void wheelEvent_native_QWheelEvent_ptr(long __this__nativeId, long event);
    
    @io.qt.QtUninvokable
    protected void windowDeactivateEvent(){
        windowDeactivateEvent_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void windowDeactivateEvent_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickItem(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuickItem(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuickItem instance, QDeclarativeConstructor constructor);
    

    @Override
    @io.qt.QtUninvokable
    public String toString() {
        return toString_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @io.qt.QtUninvokable
    private static native String toString_native(long __this_nativeId);
}
