package io.qt.quick;


/**
 * <p>Interface for supporting pixmaps and threaded image requests in QML</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qquickimageprovider.html">QQuickImageProvider</a></p>
 */
public class QQuickImageProvider extends io.qt.QtObject
    implements io.qt.qml.QQmlImageProviderBase
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>Overloaded constructor for {@link #QQuickImageProvider(io.qt.qml.QQmlImageProviderBase.ImageType, io.qt.qml.QQmlImageProviderBase.Flags)}.</p>
     */
    @SuppressWarnings({"exports"})
    public QQuickImageProvider(io.qt.qml.QQmlImageProviderBase.ImageType type, io.qt.qml.QQmlImageProviderBase.Flag ... flags){
        this(type, new io.qt.qml.QQmlImageProviderBase.Flags(flags));
    }
    
    /**
     * <p>Overloaded constructor for {@link #QQuickImageProvider(io.qt.qml.QQmlImageProviderBase.ImageType, io.qt.qml.QQmlImageProviderBase.Flags)}
     *  with <code>flags = new io.qt.qml.QQmlImageProviderBase.Flags(0)</code>.</p>
     */
    @SuppressWarnings({"exports"})
    public QQuickImageProvider(io.qt.qml.QQmlImageProviderBase.ImageType type) {
        this(type, new io.qt.qml.QQmlImageProviderBase.Flags(0));
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickimageprovider.html#QQuickImageProvider">QQuickImageProvider::QQuickImageProvider(QQmlImageProviderBase::ImageType,Flags)</a></p>
     */
    @SuppressWarnings({"exports"})
    public QQuickImageProvider(io.qt.qml.QQmlImageProviderBase.ImageType type, io.qt.qml.QQmlImageProviderBase.Flags flags){
        super((QPrivateConstructor)null);
        initialize_native(this, type, flags);
    }
    
    private native static void initialize_native(QQuickImageProvider instance, io.qt.qml.QQmlImageProviderBase.ImageType type, io.qt.qml.QQmlImageProviderBase.Flags flags);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlimageproviderbase.html#flags">QQmlImageProviderBase::flags()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public io.qt.qml.QQmlImageProviderBase.Flags flags(){
        return new io.qt.qml.QQmlImageProviderBase.Flags(flags_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    private native static int flags_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qqmlimageproviderbase.html#imageType">QQmlImageProviderBase::imageType()const</a></p>
     */
    @SuppressWarnings({"exports"})
    @io.qt.QtUninvokable
    public io.qt.qml.QQmlImageProviderBase.ImageType imageType(){
        return io.qt.qml.QQmlImageProviderBase.ImageType.resolve(imageType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    private native static int imageType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickimageprovider.html#requestImage">QQuickImageProvider::requestImage(QString,QSize*,QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.gui.QImage requestImage(java.lang.String id, io.qt.core.QSize size, io.qt.core.QSize requestedSize){
        return requestImage_native_cref_QString_QSize_ptr_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), id, size, QtJambi_LibraryUtilities.internal.checkedNativeId(requestedSize));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QImage requestImage_native_cref_QString_QSize_ptr_cref_QSize(long __this__nativeId, java.lang.String id, io.qt.core.QSize size, long requestedSize);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickimageprovider.html#requestPixmap">QQuickImageProvider::requestPixmap(QString,QSize*,QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.gui.QPixmap requestPixmap(java.lang.String id, io.qt.core.QSize size, io.qt.core.QSize requestedSize){
        return requestPixmap_native_cref_QString_QSize_ptr_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), id, size, QtJambi_LibraryUtilities.internal.checkedNativeId(requestedSize));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.gui.QPixmap requestPixmap_native_cref_QString_QSize_ptr_cref_QSize(long __this__nativeId, java.lang.String id, io.qt.core.QSize size, long requestedSize);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickimageprovider.html#requestTexture">QQuickImageProvider::requestTexture(QString,QSize*,QSize)</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QQuickTextureFactory requestTexture(java.lang.String id, io.qt.core.QSize size, io.qt.core.QSize requestedSize){
        return requestTexture_native_cref_QString_QSize_ptr_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), id, size, QtJambi_LibraryUtilities.internal.checkedNativeId(requestedSize));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickTextureFactory requestTexture_native_cref_QString_QSize_ptr_cref_QSize(long __this__nativeId, java.lang.String id, io.qt.core.QSize size, long requestedSize);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickImageProvider(QPrivateConstructor p) { super(p); } 
    
}
