package io.qt.quick;


/**
 * <p>Convenience class for integrating OpenGL rendering using a framebuffer object (FBO) with Qt Quick</p>
 * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qquickframebufferobject.html">QQuickFramebufferObject</a></p>
 */
public abstract class QQuickFramebufferObject extends io.qt.quick.QQuickItem
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QQuickFramebufferObject.class);
    
    @io.qt.NativeAccess
    private static final class ConcreteWrapper extends QQuickFramebufferObject {
        
        @io.qt.NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @io.qt.QtUninvokable
        public io.qt.quick.QQuickFramebufferObject.Renderer createRenderer(){
            return createRenderer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @io.qt.QtUninvokable
        private native io.qt.quick.QQuickFramebufferObject.Renderer createRenderer_native_constfct(long __this__nativeId);
        
    }
    
    /**
     * <p>Java wrapper for Qt class <a href="http://doc.qt.io/qt-5/qquickframebufferobject-renderer.html">QQuickFramebufferObject::Renderer</a></p>
     */
    public static abstract class Renderer extends io.qt.QtObject
    {
        static {
            QtJambi_LibraryUtilities.initialize();
        }
        
        @io.qt.NativeAccess
        private static final class ConcreteWrapper extends QQuickFramebufferObject.Renderer {
            
            @io.qt.NativeAccess
            private ConcreteWrapper(QPrivateConstructor p) { super(p); }
            
            @Override
            @io.qt.QtUninvokable
            protected void render(){
                render_native(QtJambi_LibraryUtilities.internal.nativeId(this));
            }
            @io.qt.QtUninvokable
            private native void render_native(long __this__nativeId);
            
        }
        
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject-renderer.html#Renderer">QQuickFramebufferObject::Renderer::Renderer()</a></p>
         */
        protected Renderer(){
            super((QPrivateConstructor)null);
            initialize_native(this);
        }
        
        private native static void initialize_native(Renderer instance);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject-renderer.html#framebufferObject">QQuickFramebufferObject::Renderer::framebufferObject()const</a></p>
         */
        @io.qt.QtUninvokable
        protected final io.qt.gui.QOpenGLFramebufferObject framebufferObject(){
            return framebufferObject_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QOpenGLFramebufferObject framebufferObject_native_constfct(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject-renderer.html#invalidateFramebufferObject">QQuickFramebufferObject::Renderer::invalidateFramebufferObject()</a></p>
         */
        @io.qt.QtUninvokable
        protected final void invalidateFramebufferObject(){
            invalidateFramebufferObject_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native void invalidateFramebufferObject_native(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject-renderer.html#update">QQuickFramebufferObject::Renderer::update()</a></p>
         */
        @io.qt.QtUninvokable
        protected final void update(){
            update_native(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        
        @io.qt.QtUninvokable
        private native void update_native(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject-renderer.html#createFramebufferObject">QQuickFramebufferObject::Renderer::createFramebufferObject(QSize)</a></p>
         */
        @io.qt.QtUninvokable
        protected io.qt.gui.QOpenGLFramebufferObject createFramebufferObject(io.qt.core.QSize size){
            return createFramebufferObject_native_cref_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
        }
        
        @io.qt.QtUninvokable
        private native io.qt.gui.QOpenGLFramebufferObject createFramebufferObject_native_cref_QSize(long __this__nativeId, long size);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject-renderer.html#render">QQuickFramebufferObject::Renderer::render()</a></p>
         */
        @io.qt.QtUninvokable
        protected abstract void render();
        
        @io.qt.QtUninvokable
        private native void render_native(long __this__nativeId);
        
        /**
         * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject-renderer.html#synchronize">QQuickFramebufferObject::Renderer::synchronize(QQuickFramebufferObject*)</a></p>
         */
        @io.qt.QtUninvokable
        protected void synchronize(io.qt.quick.QQuickFramebufferObject arg__1){
            synchronize_native_QQuickFramebufferObject_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
        }
        
        @io.qt.QtUninvokable
        private native void synchronize_native_QQuickFramebufferObject_ptr(long __this__nativeId, long arg__1);
        
        /**
         * Constructor for internal use only.
         * @param p expected to be <code>null</code>.
         */
        @io.qt.NativeAccess
        protected Renderer(QPrivateConstructor p) { super(p); } 
        
    }


    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject.html#mirrorVertically-prop">QQuickFramebufferObject::mirrorVerticallyChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="mirrorVertically")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> mirrorVerticallyChanged = new Signal1<>();

    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject.html#textureFollowsItemSize-prop">QQuickFramebufferObject::textureFollowsItemSizeChanged(bool)</a></p>
     */
    @io.qt.QtPropertyNotify(name="textureFollowsItemSize")
    public final Signal1<@io.qt.QtPrimitiveType Boolean> textureFollowsItemSizeChanged = new Signal1<>();
    
    /**
     * <p>Overloaded constructor for {@link #QQuickFramebufferObject(io.qt.quick.QQuickItem)}
     *  with <code>parent = null</code>.</p>
     */
    public QQuickFramebufferObject() {
        this((io.qt.quick.QQuickItem)null);
    }
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject.html#QQuickFramebufferObject">QQuickFramebufferObject::QQuickFramebufferObject(QQuickItem*)</a></p>
     */
    public QQuickFramebufferObject(io.qt.quick.QQuickItem parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QQuickFramebufferObject instance, io.qt.quick.QQuickItem parent);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject.html#mirrorVertically-prop">QQuickFramebufferObject::mirrorVertically()const</a></p>
     */
    @io.qt.QtPropertyReader(name="mirrorVertically")
    @io.qt.QtUninvokable
    public final boolean mirrorVertically(){
        return mirrorVertically_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean mirrorVertically_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject.html#mirrorVertically-prop">QQuickFramebufferObject::setMirrorVertically(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="mirrorVertically")
    @io.qt.QtUninvokable
    public final void setMirrorVertically(boolean enable){
        setMirrorVertically_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enable);
    }
    
    @io.qt.QtUninvokable
    private native void setMirrorVertically_native_bool(long __this__nativeId, boolean enable);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject.html#textureFollowsItemSize-prop">QQuickFramebufferObject::setTextureFollowsItemSize(bool)</a></p>
     */
    @io.qt.QtPropertyWriter(name="textureFollowsItemSize")
    @io.qt.QtUninvokable
    public final void setTextureFollowsItemSize(boolean follows){
        setTextureFollowsItemSize_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), follows);
    }
    
    @io.qt.QtUninvokable
    private native void setTextureFollowsItemSize_native_bool(long __this__nativeId, boolean follows);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject.html#textureFollowsItemSize-prop">QQuickFramebufferObject::textureFollowsItemSize()const</a></p>
     */
    @io.qt.QtPropertyReader(name="textureFollowsItemSize")
    @io.qt.QtUninvokable
    public final boolean textureFollowsItemSize(){
        return textureFollowsItemSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean textureFollowsItemSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickframebufferobject.html#createRenderer">QQuickFramebufferObject::createRenderer()const</a></p>
     */
    @io.qt.QtUninvokable
    public abstract io.qt.quick.QQuickFramebufferObject.Renderer createRenderer();
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QQuickFramebufferObject.Renderer createRenderer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#geometryChanged">QQuickItem::geometryChanged(QRectF,QRectF)</a></p>
     */
    @io.qt.QtUninvokable
    protected void geometryChanged(io.qt.core.QRectF newGeometry, io.qt.core.QRectF oldGeometry){
        geometryChanged_native_cref_QRectF_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(newGeometry), QtJambi_LibraryUtilities.internal.checkedNativeId(oldGeometry));
    }
    
    @io.qt.QtUninvokable
    private native void geometryChanged_native_cref_QRectF_cref_QRectF(long __this__nativeId, long newGeometry, long oldGeometry);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#isTextureProvider">QQuickItem::isTextureProvider()const</a></p>
     */
    @io.qt.QtUninvokable
    public boolean isTextureProvider(){
        return isTextureProvider_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native boolean isTextureProvider_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#releaseResources">QQuickItem::releaseResources()</a></p>
     */
    @io.qt.QtUninvokable
    protected void releaseResources(){
        releaseResources_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native void releaseResources_native(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#textureProvider">QQuickItem::textureProvider()const</a></p>
     */
    @io.qt.QtUninvokable
    public io.qt.quick.QSGTextureProvider textureProvider(){
        return textureProvider_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGTextureProvider textureProvider_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <a href="http://doc.qt.io/qt-5/qquickitem.html#updatePaintNode">QQuickItem::updatePaintNode(QSGNode*,QQuickItem::UpdatePaintNodeData*)</a></p>
     */
    @io.qt.QtUninvokable
    protected io.qt.quick.QSGNode updatePaintNode(io.qt.quick.QSGNode arg__1, io.qt.quick.QQuickItem.UpdatePaintNodeData arg__2){
        io.qt.quick.QSGNode __qt_return_value = updatePaintNode_native_QSGNode_ptr_QQuickItem_UpdatePaintNodeData_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__2));
        QtJambi_LibraryUtilities.internal.invalidateObject(arg__1);
        return __qt_return_value;
    }
    
    @io.qt.QtUninvokable
    private native io.qt.quick.QSGNode updatePaintNode_native_QSGNode_ptr_QQuickItem_UpdatePaintNodeData_ptr(long __this__nativeId, long arg__1, long arg__2);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     */
    @io.qt.NativeAccess
    protected QQuickFramebufferObject(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @io.qt.NativeAccess
    protected QQuickFramebufferObject(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @io.qt.QtUninvokable
    private static native void initialize_native(QQuickFramebufferObject instance, QDeclarativeConstructor constructor);
    
}
