#ifndef QQUICKRHIITEMRENDERER_SHELL_H
#define QQUICKRHIITEMRENDERER_SHELL_H

#include <QtCore/QtGlobal>
#include <QtQuick/qquickrhiitem.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtGui/rhi/qrhi.h>
#include <QtJambi/RegistryAPI>


class QQuickRhiItemRenderer_shell : public QQuickRhiItemRenderer, public QtJambiShellInterface
{
public:
    QQuickRhiItemRenderer_shell();
    ~QQuickRhiItemRenderer_shell() override;

    void initialize(QRhiCommandBuffer* cb0) override;
    void render(QRhiCommandBuffer* cb0) override;
    void synchronize(QQuickRhiItem* item0) override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QQuickRhiItemRenderer_access : public QQuickRhiItemRenderer
{
    jobject __qt_colorTexture_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_depthStencilBuffer_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_msaaColorBuffer_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_renderTarget_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_resolveTexture_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_rhi_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_update(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    void __qt_initialize_QRhiCommandBuffer_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID cb0);
    void __qt_render_QRhiCommandBuffer_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID cb0);
    void __qt_synchronize_QQuickRhiItem_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID item0);
};

#endif // QQUICKRHIITEMRENDERER_SHELL_H
