#ifndef QSGIMAGENODE_SHELL_H
#define QSGIMAGENODE_SHELL_H

#include <QtCore/QtGlobal>
#include <QtCore/qcompilerdetection.h>

QT_WARNING_DISABLE_DEPRECATED
QT_WARNING_DISABLE_GCC("-Wdeprecated-declarations")

#include <QtQuick/qsgimagenode.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qrect.h>
#include <QtGui/qmatrix4x4.h>
#include <QtQuick/qsggeometry.h>
#include <QtQuick/qsgmaterial.h>
#include <QtQuick/qsgnode.h>
#include <QtQuick/qsgtexture.h>
#include <QtJambi/RegistryAPI>


class QSGImageNode_shell : public QSGImageNode, public QtJambiShellInterface
{
public:
    QSGImageNode_shell();
    ~QSGImageNode_shell() override;

    QSGTexture::AnisotropyLevel anisotropyLevel() const override;
    QSGTexture::Filtering filtering() const override;
    bool isSubtreeBlocked() const override;
    QSGTexture::Filtering mipmapFiltering() const override;
    bool ownsTexture() const override;
    void preprocess() override;
    QRectF rect() const override;
    void setAnisotropyLevel(QSGTexture::AnisotropyLevel level0) override;
    void setFiltering(QSGTexture::Filtering filtering0) override;
    void setMipmapFiltering(QSGTexture::Filtering filtering0) override;
    void setOwnsTexture(bool owns0) override;
    void setRect(const QRectF& rect0) override;
    void setSourceRect(const QRectF& r0) override;
    void setTexture(QSGTexture* texture0) override;
    void setTextureCoordinatesTransform(QSGImageNode::TextureCoordinatesTransformMode mode0) override;
    QRectF sourceRect() const override;
    QSGTexture* texture() const override;
    QSGImageNode::TextureCoordinatesTransformMode textureCoordinatesTransform() const override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QSGImageNode_access : public QSGImageNode
{
    jint __qt_anisotropyLevel(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_filtering(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_mipmapFiltering(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_ownsTexture(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_rect(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_setAnisotropyLevel_QSGTexture_AnisotropyLevel(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint level0);
    void __qt_setFiltering_QSGTexture_Filtering(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint filtering0);
    void __qt_setMipmapFiltering_QSGTexture_Filtering(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint filtering0);
    void __qt_setOwnsTexture_bool(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jboolean owns0);
    void __qt_setRect_cref_QRectF(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID rect0);
    void __qt_setSourceRect_cref_QRectF(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID r0);
    void __qt_setTexture_QSGTexture_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID texture0);
    void __qt_setTextureCoordinatesTransform_QSGImageNode_TextureCoordinatesTransformMode(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint mode0);
    jobject __qt_sourceRect(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_texture(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_textureCoordinatesTransform(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QSGIMAGENODE_SHELL_H
