#include <QtCore/QtGlobal>
#include <QtQuick/qquickrendertarget.h>
#include <QtCore/QVariant>
#include <QtCore/qsize.h>
#include <QtGui/qpaintdevice.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiQuick/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

// emitting (writeClassCodeInjections)
QQuickRenderTarget qtjambi_QQuickRenderTarget_fromVulkanImage(JNIEnv *env, jlong image, jint layout, const QSize& pixelSize, int sampleCount);
QQuickRenderTarget qtjambi_QQuickRenderTarget_fromVulkanImage(JNIEnv *env, jlong image, jint layout, jint format, const QSize& pixelSize, int sampleCount);

void deleter_QQuickRenderTarget(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QQuickRenderTarget")
    QQuickRenderTarget *_ptr = reinterpret_cast<QQuickRenderTarget *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QQuickRenderTarget()
void __qt_construct_QQuickRenderTarget_0(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QQuickRenderTarget()")
    Q_UNUSED(__java_arguments)
    QQuickRenderTarget *__qt_this = new(__qtjambi_ptr) QQuickRenderTarget();
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
    Q_UNUSED(__qt_this)
}

// new QQuickRenderTarget(QQuickRenderTarget)
void __qt_construct_QQuickRenderTarget_1(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QQuickRenderTarget(QQuickRenderTarget)")
    jobject other0 = __java_arguments[0].l;
    const QQuickRenderTarget& __qt_other0 = qtjambi_cast<const QQuickRenderTarget& >(__jni_env, other0);
    QQuickRenderTarget *__qt_this = new(__qtjambi_ptr) QQuickRenderTarget(__qt_other0);
    Q_UNUSED(__jni_object)
    Q_UNUSED(__qt_this)
}

// destruct QQuickRenderTarget
void __qt_destruct_QQuickRenderTarget(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QQuickRenderTarget")
    reinterpret_cast<QQuickRenderTarget*>(ptr)->~QQuickRenderTarget();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QQuickRenderTarget::QQuickRenderTarget()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_initialize_1native__Lio_qt_quick_QQuickRenderTarget_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickRenderTarget::QQuickRenderTarget()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QQuickRenderTarget_0, sizeof(QQuickRenderTarget), typeid(QQuickRenderTarget), false, &deleter_QQuickRenderTarget, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickRenderTarget::QQuickRenderTarget(QQuickRenderTarget)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_initialize_1native__Lio_qt_quick_QQuickRenderTarget_2Lio_qt_quick_QQuickRenderTarget_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickRenderTarget::QQuickRenderTarget(QQuickRenderTarget)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QQuickRenderTarget_1, sizeof(QQuickRenderTarget), typeid(QQuickRenderTarget), false, &deleter_QQuickRenderTarget, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickRenderTarget::devicePixelRatio()const
extern "C" Q_DECL_EXPORT jdouble JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_devicePixelRatio_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jdouble __java_return_value{0};
    QTJAMBI_TRY {
        const QQuickRenderTarget *__qt_this = QtJambiAPI::objectFromNativeId<QQuickRenderTarget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickRenderTarget::devicePixelRatio()const", __qt_this)
        qreal __qt_return_value = __qt_this->devicePixelRatio();
        __java_return_value = jdouble(__qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QQuickRenderTarget *__qt_this = QtJambiAPI::objectFromNativeId<QQuickRenderTarget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickRenderTarget::isNull()const", __qt_this)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::mirrorVertically()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_mirrorVertically_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QQuickRenderTarget *__qt_this = QtJambiAPI::objectFromNativeId<QQuickRenderTarget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickRenderTarget::mirrorVertically()const", __qt_this)
        __java_return_value = __qt_this->mirrorVertically();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::operator=(QQuickRenderTarget)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_assign_1native_1cref_1QQuickRenderTarget__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickRenderTarget *__qt_this = QtJambiAPI::objectFromNativeId<QQuickRenderTarget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickRenderTarget::operator=(QQuickRenderTarget)", __qt_this)
        const QQuickRenderTarget& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QQuickRenderTarget>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickRenderTarget::operator==(QQuickRenderTarget,QQuickRenderTarget)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_operator_1equal_1native_1cref_1QQuickRenderTarget__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID rhs1)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QQuickRenderTarget *__qt_this = QtJambiAPI::objectFromNativeId<QQuickRenderTarget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickRenderTarget::operator==(QQuickRenderTarget,QQuickRenderTarget)", __qt_this)
        const QQuickRenderTarget& __qt_rhs1 = QtJambiAPI::valueReferenceFromNativeId<QQuickRenderTarget>(rhs1);
        __java_return_value = (*__qt_this) == __qt_rhs1;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::setDevicePixelRatio(qreal)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_setDevicePixelRatio_1native_1qreal__JD)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jdouble ratio0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickRenderTarget *__qt_this = QtJambiAPI::objectFromNativeId<QQuickRenderTarget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickRenderTarget::setDevicePixelRatio(qreal)", __qt_this)
        __qt_this->setDevicePixelRatio(static_cast<qreal>(ratio0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickRenderTarget::setMirrorVertically(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_setMirrorVertically_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickRenderTarget *__qt_this = QtJambiAPI::objectFromNativeId<QQuickRenderTarget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickRenderTarget::setMirrorVertically(bool)", __qt_this)
        __qt_this->setMirrorVertically(static_cast<bool>(enable0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickRenderTarget::fromD3D11Texture(void*,QSize,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_fromD3D11Texture_1native_1void_1ptr_1cref_1QSize_1int__Lio_qt_QNativePointer_2JI)
(JNIEnv *__jni_env,
 jclass,
 jobject texture0,
 QtJambiNativeID pixelSize1,
 jint sampleCount2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickRenderTarget::fromD3D11Texture(void*,QSize,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if defined(Q_OS_WIN)
        void* __qt_texture0 = reinterpret_cast<void* >(QtJambiAPI::convertQNativePointerToNative(__jni_env, texture0, 1));
        const QSize& __qt_pixelSize1 = QtJambiAPI::valueReferenceFromNativeId<QSize>(pixelSize1);
        QQuickRenderTarget __qt_return_value = QQuickRenderTarget::fromD3D11Texture(__qt_texture0, __qt_pixelSize1, static_cast<int>(sampleCount2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(texture0)
        Q_UNUSED(pixelSize1)
        Q_UNUSED(sampleCount2)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // defined(Q_OS_WIN)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::fromD3D11Texture(void*,uint,QSize,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_fromD3D11Texture_1native_1void_1ptr_1uint_1cref_1QSize_1int__Lio_qt_QNativePointer_2IJI)
(JNIEnv *__jni_env,
 jclass,
 jobject texture0,
 jint format1,
 QtJambiNativeID pixelSize2,
 jint sampleCount3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickRenderTarget::fromD3D11Texture(void*,uint,QSize,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if defined(Q_OS_WIN)
        void* __qt_texture0 = reinterpret_cast<void* >(QtJambiAPI::convertQNativePointerToNative(__jni_env, texture0, 1));
        const QSize& __qt_pixelSize2 = QtJambiAPI::valueReferenceFromNativeId<QSize>(pixelSize2);
        QQuickRenderTarget __qt_return_value = QQuickRenderTarget::fromD3D11Texture(__qt_texture0, static_cast<uint>(format1), __qt_pixelSize2, static_cast<int>(sampleCount3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(texture0)
        Q_UNUSED(format1)
        Q_UNUSED(pixelSize2)
        Q_UNUSED(sampleCount3)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // defined(Q_OS_WIN)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::fromMetalTexture(MTLTexture*,QSize,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_fromMetalTexture_1native_1MTLTexture_1ptr_1cref_1QSize_1int__Lio_qt_QNativePointer_2JI)
(JNIEnv *__jni_env,
 jclass,
 jobject texture0,
 QtJambiNativeID pixelSize1,
 jint sampleCount2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickRenderTarget::fromMetalTexture(MTLTexture*,QSize,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if (defined(Q_OS_MACOS) || defined(Q_OS_IOS))
        MTLTexture* __qt_texture0 = reinterpret_cast<MTLTexture* >(QtJambiAPI::convertQNativePointerToNative(__jni_env, texture0, 1));
        const QSize& __qt_pixelSize1 = QtJambiAPI::valueReferenceFromNativeId<QSize>(pixelSize1);
        QQuickRenderTarget __qt_return_value = QQuickRenderTarget::fromMetalTexture(__qt_texture0, __qt_pixelSize1, static_cast<int>(sampleCount2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(texture0)
        Q_UNUSED(pixelSize1)
        Q_UNUSED(sampleCount2)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // (defined(Q_OS_MACOS) || defined(Q_OS_IOS))
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::fromMetalTexture(MTLTexture*,uint,QSize,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_fromMetalTexture_1native_1MTLTexture_1ptr_1uint_1cref_1QSize_1int__Lio_qt_QNativePointer_2IJI)
(JNIEnv *__jni_env,
 jclass,
 jobject texture0,
 jint format1,
 QtJambiNativeID pixelSize2,
 jint sampleCount3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickRenderTarget::fromMetalTexture(MTLTexture*,uint,QSize,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if (defined(Q_OS_MACOS) || defined(Q_OS_IOS))
        MTLTexture* __qt_texture0 = reinterpret_cast<MTLTexture* >(QtJambiAPI::convertQNativePointerToNative(__jni_env, texture0, 1));
        const QSize& __qt_pixelSize2 = QtJambiAPI::valueReferenceFromNativeId<QSize>(pixelSize2);
        QQuickRenderTarget __qt_return_value = QQuickRenderTarget::fromMetalTexture(__qt_texture0, static_cast<uint>(format1), __qt_pixelSize2, static_cast<int>(sampleCount3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(texture0)
        Q_UNUSED(format1)
        Q_UNUSED(pixelSize2)
        Q_UNUSED(sampleCount3)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // (defined(Q_OS_MACOS) || defined(Q_OS_IOS))
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::fromOpenGLRenderBuffer(uint,QSize,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_fromOpenGLRenderBuffer_1native_1uint_1cref_1QSize_1int__IJI)
(JNIEnv *__jni_env,
 jclass,
 jint renderbufferId0,
 QtJambiNativeID pixelSize1,
 jint sampleCount2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickRenderTarget::fromOpenGLRenderBuffer(uint,QSize,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSize& __qt_pixelSize1 = QtJambiAPI::valueReferenceFromNativeId<QSize>(pixelSize1);
        QQuickRenderTarget __qt_return_value = QQuickRenderTarget::fromOpenGLRenderBuffer(static_cast<uint>(renderbufferId0), __qt_pixelSize1, static_cast<int>(sampleCount2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::fromOpenGLTexture(uint,QSize,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_fromOpenGLTexture_1native_1uint_1cref_1QSize_1int__IJI)
(JNIEnv *__jni_env,
 jclass,
 jint textureId0,
 QtJambiNativeID pixelSize1,
 jint sampleCount2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickRenderTarget::fromOpenGLTexture(uint,QSize,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSize& __qt_pixelSize1 = QtJambiAPI::valueReferenceFromNativeId<QSize>(pixelSize1);
        QQuickRenderTarget __qt_return_value = QQuickRenderTarget::fromOpenGLTexture(static_cast<uint>(textureId0), __qt_pixelSize1, static_cast<int>(sampleCount2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::fromOpenGLTexture(uint,uint,QSize,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_fromOpenGLTexture_1native_1uint_1uint_1cref_1QSize_1int__IIJI)
(JNIEnv *__jni_env,
 jclass,
 jint textureId0,
 jint format1,
 QtJambiNativeID pixelSize2,
 jint sampleCount3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickRenderTarget::fromOpenGLTexture(uint,uint,QSize,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QSize& __qt_pixelSize2 = QtJambiAPI::valueReferenceFromNativeId<QSize>(pixelSize2);
        QQuickRenderTarget __qt_return_value = QQuickRenderTarget::fromOpenGLTexture(static_cast<uint>(textureId0), static_cast<uint>(format1), __qt_pixelSize2, static_cast<int>(sampleCount3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::fromPaintDevice(QPaintDevice*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_fromPaintDevice_1native_1QPaintDevice_1ptr__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID device0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickRenderTarget::fromPaintDevice(QPaintDevice*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QPaintDevice* __qt_device0 = QtJambiAPI::interfaceFromNativeId<QPaintDevice>(device0);
        QQuickRenderTarget __qt_return_value = QQuickRenderTarget::fromPaintDevice(__qt_device0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::fromVulkanImage(VkImage,VkImageLayout,VkFormat,QSize,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_fromVulkanImage_1native_1VkImage_1VkImageLayout_1VkFormat_1cref_1QSize_1int__JIIJI)
(JNIEnv *__jni_env,
 jclass,
 jlong image0,
 jint layout1,
 jint format2,
 QtJambiNativeID pixelSize3,
 jint sampleCount4)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickRenderTarget::fromVulkanImage(VkImage,VkImageLayout,VkFormat,QSize,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(vulkan)
#ifdef __qt_image0
#undef __qt_image0
#endif
#define __qt_image0 image0
#ifdef __qt_layout1
#undef __qt_layout1
#endif
#define __qt_layout1 layout1
#ifdef __qt_format2
#undef __qt_format2
#endif
#define __qt_format2 format2
        const QSize& __qt_pixelSize3 = QtJambiAPI::valueReferenceFromNativeId<QSize>(pixelSize3);
        auto __qt_return_value = qtjambi_QQuickRenderTarget_fromVulkanImage(__jni_env, __qt_image0, __qt_layout1, VkFormat(__qt_format2), __qt_pixelSize3, static_cast<int>(sampleCount4));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(image0)
        Q_UNUSED(layout1)
        Q_UNUSED(format2)
        Q_UNUSED(pixelSize3)
        Q_UNUSED(sampleCount4)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(vulkan)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickRenderTarget::fromVulkanImage(VkImage,VkImageLayout,QSize,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_fromVulkanImage_1native_1VkImage_1VkImageLayout_1cref_1QSize_1int__JIJI)
(JNIEnv *__jni_env,
 jclass,
 jlong image0,
 jint layout1,
 QtJambiNativeID pixelSize2,
 jint sampleCount3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickRenderTarget::fromVulkanImage(VkImage,VkImageLayout,QSize,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(vulkan)
#ifdef __qt_image0
#undef __qt_image0
#endif
#define __qt_image0 image0
#ifdef __qt_layout1
#undef __qt_layout1
#endif
#define __qt_layout1 layout1
        const QSize& __qt_pixelSize2 = QtJambiAPI::valueReferenceFromNativeId<QSize>(pixelSize2);
        auto __qt_return_value = qtjambi_QQuickRenderTarget_fromVulkanImage(__jni_env, __qt_image0, __qt_layout1, __qt_pixelSize2, static_cast<int>(sampleCount3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(image0)
        Q_UNUSED(layout1)
        Q_UNUSED(pixelSize2)
        Q_UNUSED(sampleCount3)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(vulkan)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QQuickRenderTarget *__qt_this = QtJambiAPI::objectFromNativeId<QQuickRenderTarget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickRenderTarget_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QQuickRenderTarget *__qt_this = QtJambiAPI::objectFromNativeId<QQuickRenderTarget>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QQuickRenderTarget(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QQuickRenderTarget>("QQuickRenderTarget", "io/qt/quick/QQuickRenderTarget");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, &__qt_destruct_QQuickRenderTarget, {
        ConstructorInfo(&__qt_construct_QQuickRenderTarget_0, nullptr)
       ,ConstructorInfo(&__qt_construct_QQuickRenderTarget_1, "Lio/qt/quick/QQuickRenderTarget;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QQuickRenderTarget);
    registerMetaType<QQuickRenderTarget>("QQuickRenderTarget");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
