#ifndef QQUICKIMAGEPROVIDER_SHELL_H
#define QQUICKIMAGEPROVIDER_SHELL_H

#include <QtCore/QtGlobal>
#include <QtQuick/qquickimageprovider.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qsize.h>
#include <QtGui/qimage.h>
#include <QtGui/qpixmap.h>
#include <QtQml/qqmlengine.h>
#include <QtJambi/RegistryAPI>


class QQuickImageProvider_shell : public QQuickImageProvider, public QtJambiShellInterface
{
public:
    QQuickImageProvider_shell(QQmlImageProviderBase::ImageType type0, QQmlImageProviderBase::Flags flags1 = QQmlImageProviderBase::Flags());
    ~QQuickImageProvider_shell() override;

    QQmlImageProviderBase::Flags flags() const override;
    QQmlImageProviderBase::ImageType imageType() const override;
    QImage requestImage(const QString& id0, QSize* size1, const QSize& requestedSize2) override;
    QPixmap requestPixmap(const QString& id0, QSize* size1, const QSize& requestedSize2) override;
    QQuickTextureFactory* requestTexture(const QString& id0, QSize* size1, const QSize& requestedSize2) override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QQuickImageProvider_access : public QQuickImageProvider
{
    jint __qt_flags_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_imageType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_requestImage_cref_QString_QSize_ptr_cref_QSize(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring id0, QtJambiNativeID size1, QtJambiNativeID requestedSize2);
    jobject __qt_requestPixmap_cref_QString_QSize_ptr_cref_QSize(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring id0, QtJambiNativeID size1, QtJambiNativeID requestedSize2);
    jobject __qt_requestTexture_cref_QString_QSize_ptr_cref_QSize(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jstring id0, QtJambiNativeID size1, QtJambiNativeID requestedSize2);
};

#endif // QQUICKIMAGEPROVIDER_SHELL_H
