#ifndef QSGRENDERNODE_RENDERSTATE_SHELL_H
#define QSGRENDERNODE_RENDERSTATE_SHELL_H

#include <QtCore/QtGlobal>
#include <QtQuick/qsgrendernode.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qrect.h>
#include <QtGui/qmatrix4x4.h>
#include <QtGui/qregion.h>
#include <QtJambi/RegistryAPI>


class QSGRenderNode$RenderState_shell : public QSGRenderNode::RenderState, public QtJambiShellInterface
{
public:
    QSGRenderNode$RenderState_shell();
    ~QSGRenderNode$RenderState_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QSGRenderNode$RenderState_oshell;
};


class QSGRenderNode$RenderState_oshell : public QSGRenderNode$RenderState_shell
{
public:
    using QSGRenderNode$RenderState_shell::QSGRenderNode$RenderState_shell;
    const QRegion* clipRegion() const override;
    void* get(const char* state0) const override;
    const QMatrix4x4* projectionMatrix() const override;
    bool scissorEnabled() const override;
    QRect scissorRect() const override;
    bool stencilEnabled() const override;
    int stencilValue() const override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QSGRenderNode$RenderState_access : public QSGRenderNode::RenderState
{
    jobject __qt_clipRegion_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_projectionMatrix_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_scissorEnabled_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_scissorRect_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jboolean __qt_stencilEnabled_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_stencilValue_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QSGRENDERNODE_RENDERSTATE_SHELL_H
