#ifndef QSGMATERIALSHADER_SHELL_H
#define QSGMATERIALSHADER_SHELL_H

#include <QtCore/QtGlobal>
#include <QtQuick/qsgmaterialshader.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QByteArray>
#include <QtCore/QScopedArrayPointer>
#include <QtCore/QScopedPointer>
#include <QtCore/QVariant>
#include <QtJambi/JavaAPI>
#include <QtQuick/qsgmaterial.h>
#include <QtQuick/qsgtexture.h>
#include <QtJambi/RegistryAPI>


class QSGMaterialShader_shell : public QSGMaterialShader, public QtJambiShellInterface
{
public:
    QSGMaterialShader_shell();
    ~QSGMaterialShader_shell() override;
    static void operator delete(void * ptr) noexcept;
private:
    QtJambiShell* __shell() const override final;
    friend class QSGMaterialShader_oshell;
    mutable QByteArray __qt_vertexShader;
    mutable QByteArray __qt_fragmentShader;
    mutable QByteArray __qt_attributeNameByteArrays;
    mutable QVector<const char *> __qt_attributeNames;
};


class QSGMaterialShader_oshell : public QSGMaterialShader_shell
{
public:
    using QSGMaterialShader_shell::QSGMaterialShader_shell;
    bool updateGraphicsPipelineState(QSGMaterialShader::RenderState& state0, QSGMaterialShader::GraphicsPipelineState* ps1, QSGMaterial* newMaterial2, QSGMaterial* oldMaterial3) override;
    void updateSampledImage(QSGMaterialShader::RenderState& state0, int binding1, QSGTexture** texture2, QSGMaterial* newMaterial3, QSGMaterial* oldMaterial4) override;
    bool updateUniformData(QSGMaterialShader::RenderState& state0, QSGMaterial* newMaterial1, QSGMaterial* oldMaterial2) override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QSGMaterialShader_access : public QSGMaterialShader
{
    void __qt_setShaderFileName_QSGMaterialShader_Stage_cref_QString(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint stage0, jstring filename1);
    jboolean __qt_updateGraphicsPipelineState_ref_QSGMaterialShader_RenderState_QSGMaterialShader_GraphicsPipelineState_ptr_QSGMaterial_ptr_QSGMaterial_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID state0, QtJambiNativeID ps1, QtJambiNativeID newMaterial2, QtJambiNativeID oldMaterial3);
    void __qt_updateSampledImage_ref_QSGMaterialShader_RenderState_int_QSGTexture_ptr_ptr_QSGMaterial_ptr_QSGMaterial_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID state0, jint binding1, jobjectArray texture2, QtJambiNativeID newMaterial3, QtJambiNativeID oldMaterial4);
    jboolean __qt_updateUniformData_ref_QSGMaterialShader_RenderState_QSGMaterial_ptr_QSGMaterial_ptr(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID state0, QtJambiNativeID newMaterial1, QtJambiNativeID oldMaterial2);
};

#endif // QSGMATERIALSHADER_SHELL_H
