#ifndef QSGTEXTNODE_SHELL_H
#define QSGTEXTNODE_SHELL_H

#include <QtCore/QtGlobal>
#include <QtCore/qcompilerdetection.h>

QT_WARNING_DISABLE_DEPRECATED
QT_WARNING_DISABLE_GCC("-Wdeprecated-declarations")

#include <QtQuick/qsgtextnode.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtCore/qpoint.h>
#include <QtCore/qrect.h>
#include <QtGui/qcolor.h>
#include <QtGui/qmatrix4x4.h>
#include <QtGui/qtextdocument.h>
#include <QtGui/qtextlayout.h>
#include <QtQuick/qsgnode.h>
#include <QtQuick/qsgtexture.h>
#include <QtJambi/RegistryAPI>


class QSGTextNode_shell : public QSGTextNode, public QtJambiShellInterface
{
public:
    QSGTextNode_shell();
    ~QSGTextNode_shell() override;

    void clear() override;
    QColor color() const override;
    QSGTexture::Filtering filtering() const override;
    bool isSubtreeBlocked() const override;
    QColor linkColor() const override;
    void preprocess() override;
    QSGTextNode::RenderType renderType() const override;
    int renderTypeQuality() const override;
    QColor selectionColor() const override;
    QColor selectionTextColor() const override;
    void setColor(QColor color0) override;
    void setFiltering(QSGTexture::Filtering arg__1) override;
    void setLinkColor(QColor linkColor0) override;
    void setRenderType(QSGTextNode::RenderType renderType0) override;
    void setRenderTypeQuality(int renderTypeQuality0) override;
    void setSelectionColor(QColor selectionColor0) override;
    void setSelectionTextColor(QColor selectionTextColor0) override;
    void setStyleColor(QColor styleColor0) override;
    void setTextStyle(QSGTextNode::TextStyle textStyle0) override;
    void setViewport(const QRectF& viewport0) override;
    QColor styleColor() const override;
    QSGTextNode::TextStyle textStyle() override;
    QRectF viewport() const override;
    static void operator delete(void * ptr) noexcept;
private:
    void doAddTextDocument(QPointF position0, QTextDocument* document1, int selectionStart2, int selectionCount3) override;
    void doAddTextLayout(QPointF position0, QTextLayout* layout1, int selectionStart2, int selectionCount3, int lineStart4, int lineCount5) override;
    QtJambiShell* __shell() const override final;
    jmethodID __shell_javaMethod(int pos) const;
};

struct QSGTextNode_access : public QSGTextNode
{
    void __qt_clear(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_color_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_filtering_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_linkColor_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jbyte __qt_renderType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_renderTypeQuality_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_selectionColor_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jobject __qt_selectionTextColor_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    void __qt_setColor_QColor(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID color0);
    void __qt_setFiltering_QSGTexture_Filtering(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint arg__1);
    void __qt_setLinkColor_QColor(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID linkColor0);
    void __qt_setRenderType_QSGTextNode_RenderType(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jbyte renderType0);
    void __qt_setRenderTypeQuality_int(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jint renderTypeQuality0);
    void __qt_setSelectionColor_QColor(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID selectionColor0);
    void __qt_setSelectionTextColor_QColor(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID selectionTextColor0);
    void __qt_setStyleColor_QColor(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID styleColor0);
    void __qt_setTextStyle_QSGTextNode_TextStyle(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, jbyte textStyle0);
    void __qt_setViewport_cref_QRectF(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId, QtJambiNativeID viewport0);
    jobject __qt_styleColor_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jbyte __qt_textStyle(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId);
    jobject __qt_viewport_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QSGTEXTNODE_SHELL_H
