#include <QtCore/QtGlobal>
#include <QtQuick/qquickgraphicsdevice.h>
#include <QtCore/QVariant>
#include <QtGui/qopenglcontext.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiQuick/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

// emitting (writeClassCodeInjections)
QQuickGraphicsDevice qtjambi_QQuickGraphicsDevice_fromPhysicalDevice(JNIEnv *, jlong);
QQuickGraphicsDevice qtjambi_QQuickGraphicsDevice_fromDeviceObjects(JNIEnv *, jlong, jlong, int, int);

void deleter_QQuickGraphicsDevice(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QQuickGraphicsDevice")
    QQuickGraphicsDevice *_ptr = reinterpret_cast<QQuickGraphicsDevice *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QQuickGraphicsDevice()
void __qt_construct_QQuickGraphicsDevice(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QQuickGraphicsDevice()")
    Q_UNUSED(__java_arguments)
    QQuickGraphicsDevice *__qt_this = new(__qtjambi_ptr) QQuickGraphicsDevice();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QQuickGraphicsDevice::QQuickGraphicsDevice()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_initialize_1native__Lio_qt_quick_QQuickGraphicsDevice_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickGraphicsDevice::QQuickGraphicsDevice()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QQuickGraphicsDevice, sizeof(QQuickGraphicsDevice), typeid(QQuickGraphicsDevice), 0, false, &deleter_QQuickGraphicsDevice, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QQuickGraphicsDevice(QQuickGraphicsDevice)
void __qt_construct_QQuickGraphicsDevice_cref_QQuickGraphicsDevice(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QQuickGraphicsDevice(QQuickGraphicsDevice)")
    jobject other0 = __java_arguments[0].l;
    const QQuickGraphicsDevice& __qt_other0 = qtjambi_cast<const QQuickGraphicsDevice&>(__jni_env, other0);
    QQuickGraphicsDevice *__qt_this = new(__qtjambi_ptr) QQuickGraphicsDevice(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QQuickGraphicsDevice::QQuickGraphicsDevice(QQuickGraphicsDevice)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_initialize_1native__Lio_qt_quick_QQuickGraphicsDevice_2Lio_qt_quick_QQuickGraphicsDevice_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickGraphicsDevice::QQuickGraphicsDevice(QQuickGraphicsDevice)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QQuickGraphicsDevice_cref_QQuickGraphicsDevice, sizeof(QQuickGraphicsDevice), typeid(QQuickGraphicsDevice), 0, false, &deleter_QQuickGraphicsDevice, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QQuickGraphicsDevice
void __qt_destruct_QQuickGraphicsDevice(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QQuickGraphicsDevice")
    reinterpret_cast<QQuickGraphicsDevice*>(ptr)->~QQuickGraphicsDevice();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QQuickGraphicsDevice::isNull()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_isNull_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QQuickGraphicsDevice *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsDevice::isNull()const", __this_nativeId)
        __java_return_value = __qt_this->isNull();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsDevice::operator=(QQuickGraphicsDevice)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_assign_1native_1cref_1QQuickGraphicsDevice__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickGraphicsDevice *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsDevice::operator=(QQuickGraphicsDevice)", __this_nativeId)
        const QQuickGraphicsDevice& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QQuickGraphicsDevice>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickGraphicsDevice::operator==(QQuickGraphicsDevice,QQuickGraphicsDevice)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_equals_1native_1cref_1QQuickGraphicsDevice__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID value21)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QQuickGraphicsDevice *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsDevice::operator==(QQuickGraphicsDevice,QQuickGraphicsDevice)", __this_nativeId)
        const QQuickGraphicsDevice& __qt_value21 = QtJambiAPI::valueReferenceFromNativeId<QQuickGraphicsDevice>(value21);
        __java_return_value = (*__qt_this) == __qt_value21;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsDevice::fromAdapter(quint32,qint32,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_fromAdapter__III)
(JNIEnv *__jni_env,
 jclass,
 jint adapterLuidLow0,
 jint adapterLuidHigh1,
 jint featureLevel2)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickGraphicsDevice::fromAdapter(quint32,qint32,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if defined(Q_OS_WIN)
        QQuickGraphicsDevice __qt_return_value = QQuickGraphicsDevice::fromAdapter(static_cast<quint32>(adapterLuidLow0), static_cast<qint32>(adapterLuidHigh1), static_cast<int>(featureLevel2));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(adapterLuidLow0)
        Q_UNUSED(adapterLuidHigh1)
        Q_UNUSED(featureLevel2)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // defined(Q_OS_WIN)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsDevice::fromDeviceAndCommandQueue(MTLDevice*,MTLCommandQueue*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_fromDeviceAndCommandQueue__Lio_qt_QNativePointer_2Lio_qt_QNativePointer_2)
(JNIEnv *__jni_env,
 jclass,
 jobject device0,
 jobject commandQueue1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickGraphicsDevice::fromDeviceAndCommandQueue(MTLDevice*,MTLCommandQueue*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if (defined(Q_OS_MACOS) || defined(Q_OS_IOS))
        MTLDevice* __qt_device0 = reinterpret_cast<MTLDevice*>(QtJambiAPI::convertQNativePointerToNative(__jni_env, device0));
        MTLCommandQueue* __qt_commandQueue1 = reinterpret_cast<MTLCommandQueue*>(QtJambiAPI::convertQNativePointerToNative(__jni_env, commandQueue1));
        QQuickGraphicsDevice __qt_return_value = QQuickGraphicsDevice::fromDeviceAndCommandQueue(__qt_device0, __qt_commandQueue1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(device0)
        Q_UNUSED(commandQueue1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // (defined(Q_OS_MACOS) || defined(Q_OS_IOS))
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsDevice::fromDeviceAndContext(void*,void*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_fromDeviceAndContext__Lio_qt_QNativePointer_2Lio_qt_QNativePointer_2)
(JNIEnv *__jni_env,
 jclass,
 jobject device0,
 jobject context1)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickGraphicsDevice::fromDeviceAndContext(void*,void*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if defined(Q_OS_WIN)
        void* __qt_device0 = reinterpret_cast<void*>(QtJambiAPI::convertQNativePointerToNative(__jni_env, device0));
        void* __qt_context1 = reinterpret_cast<void*>(QtJambiAPI::convertQNativePointerToNative(__jni_env, context1));
        QQuickGraphicsDevice __qt_return_value = QQuickGraphicsDevice::fromDeviceAndContext(__qt_device0, __qt_context1);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(device0)
        Q_UNUSED(context1)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // defined(Q_OS_WIN)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsDevice::fromDeviceObjects(VkPhysicalDevice,VkDevice,int,int)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_fromDeviceObjects__JJII)
(JNIEnv *__jni_env,
 jclass,
 jlong physicalDevice0,
 jlong device1,
 jint queueFamilyIndex2,
 jint queueIndex3)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickGraphicsDevice::fromDeviceObjects(VkPhysicalDevice,VkDevice,int,int)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(vulkan)
#ifdef __qt_physicalDevice0
#undef __qt_physicalDevice0
#endif
#define __qt_physicalDevice0 physicalDevice0
#ifdef __qt_device1
#undef __qt_device1
#endif
#define __qt_device1 device1
        auto __qt_return_value = qtjambi_QQuickGraphicsDevice_fromDeviceObjects(__jni_env, __qt_physicalDevice0, __qt_device1, static_cast<int>(queueFamilyIndex2), static_cast<int>(queueIndex3));
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(physicalDevice0)
        Q_UNUSED(device1)
        Q_UNUSED(queueFamilyIndex2)
        Q_UNUSED(queueIndex3)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(vulkan)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsDevice::fromOpenGLContext(QOpenGLContext*)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_fromOpenGLContext_1native_1QOpenGLContext_1ptr__J)
(JNIEnv *__jni_env,
 jclass,
 QtJambiNativeID context0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickGraphicsDevice::fromOpenGLContext(QOpenGLContext*)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(opengl)
        QOpenGLContext* __qt_context0 = QtJambiAPI::objectFromNativeId<QOpenGLContext>(context0);
        QQuickGraphicsDevice __qt_return_value = QQuickGraphicsDevice::fromOpenGLContext(__qt_context0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(context0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(opengl)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsDevice::fromPhysicalDevice(VkPhysicalDevice)
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_fromPhysicalDevice__J)
(JNIEnv *__jni_env,
 jclass,
 jlong physicalDevice0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickGraphicsDevice::fromPhysicalDevice(VkPhysicalDevice)")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
#if QT_CONFIG(vulkan)
#ifdef __qt_physicalDevice0
#undef __qt_physicalDevice0
#endif
#define __qt_physicalDevice0 physicalDevice0
        auto __qt_return_value = qtjambi_QQuickGraphicsDevice_fromPhysicalDevice(__jni_env, __qt_physicalDevice0);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
#else
        Q_UNUSED(physicalDevice0)
        JavaException::raiseQNoImplementationException(__jni_env, "The method has no implementation on this platform." QTJAMBI_STACKTRACEINFO );
#endif // QT_CONFIG(vulkan)
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QQuickGraphicsDevice *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}
// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsDevice_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QQuickGraphicsDevice *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsDevice>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QQuickGraphicsDevice(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QQuickGraphicsDevice>("QQuickGraphicsDevice", "io/qt/quick/QQuickGraphicsDevice");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QQuickGraphicsDevice, {
        ConstructorInfo(&__qt_construct_QQuickGraphicsDevice, nullptr)
       ,ConstructorInfo(&__qt_construct_QQuickGraphicsDevice_cref_QQuickGraphicsDevice, "Lio/qt/quick/QQuickGraphicsDevice;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QQuickGraphicsDevice);
    registerMetaType<QQuickGraphicsDevice>("QQuickGraphicsDevice");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
