#ifndef QSGRENDERERINTERFACE_IMPL_SHELL_H
#define QSGRENDERERINTERFACE_IMPL_SHELL_H

#include <QtCore/QtGlobal>
#include <QtQuick/qsgrendererinterface.h>
#include <QtJambi/QtJambiAPI>
#include <QtCore/QVariant>
#include <QtQuick/qquickwindow.h>
#include <QtJambi/RegistryAPI>


class QSGRendererInterface_shell : public QSGRendererInterface, public QtJambiShellInterface
{
public:
    QSGRendererInterface_shell();
    ~QSGRendererInterface_shell() override;
private:
    QtJambiShell* __shell() const override final;
    friend class QSGRendererInterface_oshell;
};


class QSGRendererInterface_oshell : public QSGRendererInterface_shell
{
public:
    using QSGRendererInterface_shell::QSGRendererInterface_shell;
    void* getResource(QQuickWindow* window0, QSGRendererInterface::Resource resource1) const override;
    void* getResource(QQuickWindow* window0, const char* resource1) const override;
    QSGRendererInterface::GraphicsApi graphicsApi() const override;
    QSGRendererInterface::ShaderCompilationTypes shaderCompilationType() const override;
    QSGRendererInterface::ShaderSourceTypes shaderSourceType() const override;
    QSGRendererInterface::ShaderType shaderType() const override;
    static void operator delete(void * ptr) noexcept;
private:
    jmethodID __shell_javaMethod(int pos) const;
};

struct QSGRendererInterface_access : public QSGRendererInterface
{
    jint __qt_graphicsApi_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_shaderCompilationType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_shaderSourceType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
    jint __qt_shaderType_constfct(JNIEnv *__jni_env, QtJambiNativeID __this_nativeId) const;
};

#endif // QSGRENDERERINTERFACE_IMPL_SHELL_H
