#include <QtCore/QtGlobal>
#include <QtQuick/qquickgraphicsconfiguration.h>
#include <QtCore/QList>
#include <QtCore/QVariant>
#include <QtCore/qbytearray.h>

#include <QtJambi/QtJambiAPI>
#include <QtJambiQuick/hashes.h>

#include <QtJambi/RegistryAPI>
#include <QtJambi/Cast>

void deleter_QQuickGraphicsConfiguration(void *ptr, bool isShell)
{
    QTJAMBI_NATIVE_METHOD_CALL("qtjambi_deleter for QQuickGraphicsConfiguration")
    QQuickGraphicsConfiguration *_ptr = reinterpret_cast<QQuickGraphicsConfiguration *>(ptr);
    if(!isShell){
        QtJambiAPI::registerNonShellDeletion(ptr);
    }
    delete _ptr;
}

// emitting (writeConstructors)
// new QQuickGraphicsConfiguration()
void __qt_construct_QQuickGraphicsConfiguration(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QQuickGraphicsConfiguration()")
    Q_UNUSED(__java_arguments)
    QQuickGraphicsConfiguration *__qt_this = new(__qtjambi_ptr) QQuickGraphicsConfiguration();
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
    Q_UNUSED(__jni_env)
}

// QQuickGraphicsConfiguration::QQuickGraphicsConfiguration()
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_initialize_1native__Lio_qt_quick_QQuickGraphicsConfiguration_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickGraphicsConfiguration::QQuickGraphicsConfiguration()")
    QTJAMBI_TRY {
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QQuickGraphicsConfiguration, sizeof(QQuickGraphicsConfiguration), typeid(QQuickGraphicsConfiguration), 0, false, &deleter_QQuickGraphicsConfiguration, nullptr);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// new QQuickGraphicsConfiguration(QQuickGraphicsConfiguration)
void __qt_construct_QQuickGraphicsConfiguration_cref_QQuickGraphicsConfiguration(void* __qtjambi_ptr, JNIEnv* __jni_env, jobject __jni_object, jvalue* __java_arguments, bool, bool, bool __qtjambi_is_generic)
{
    QTJAMBI_NATIVE_METHOD_CALL("construct QQuickGraphicsConfiguration(QQuickGraphicsConfiguration)")
    jobject other0 = __java_arguments[0].l;
    const QQuickGraphicsConfiguration& __qt_other0 = qtjambi_cast<const QQuickGraphicsConfiguration&>(__jni_env, other0);
    QQuickGraphicsConfiguration *__qt_this = new(__qtjambi_ptr) QQuickGraphicsConfiguration(__qt_other0);
    Q_UNUSED(__qt_this)
    Q_UNUSED(__qtjambi_is_generic)
    Q_UNUSED(__jni_object)
}

// QQuickGraphicsConfiguration::QQuickGraphicsConfiguration(QQuickGraphicsConfiguration)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_initialize_1native__Lio_qt_quick_QQuickGraphicsConfiguration_2Lio_qt_quick_QQuickGraphicsConfiguration_2)
(JNIEnv *__jni_env,
 jclass __jni_class,
 jobject __jni_object,
 jobject other0)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickGraphicsConfiguration::QQuickGraphicsConfiguration(QQuickGraphicsConfiguration)")
    QTJAMBI_TRY {
        jvalue arguments;
        arguments.l = other0;
        QtJambiShell::initialize(__jni_env, __jni_class, __jni_object, &__qt_construct_QQuickGraphicsConfiguration_cref_QQuickGraphicsConfiguration, sizeof(QQuickGraphicsConfiguration), typeid(QQuickGraphicsConfiguration), 0, false, &deleter_QQuickGraphicsConfiguration, &arguments);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// destruct QQuickGraphicsConfiguration
void __qt_destruct_QQuickGraphicsConfiguration(void* ptr)
{
    QTJAMBI_NATIVE_METHOD_CALL("destruct QQuickGraphicsConfiguration")
    reinterpret_cast<QQuickGraphicsConfiguration*>(ptr)->~QQuickGraphicsConfiguration();
}

// emitting  (functionsInTargetLang writeFinalFunction)
// QQuickGraphicsConfiguration::deviceExtensions()const
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_deviceExtensions_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        const QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::deviceExtensions()const", __this_nativeId)
        QList<QByteArray> __qt_return_value = __qt_this->deviceExtensions();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsConfiguration::isAutomaticPipelineCacheEnabled()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_isAutomaticPipelineCacheEnabled_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::isAutomaticPipelineCacheEnabled()const", __this_nativeId)
        __java_return_value = __qt_this->isAutomaticPipelineCacheEnabled();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsConfiguration::isDebugLayerEnabled()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_isDebugLayerEnabled_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::isDebugLayerEnabled()const", __this_nativeId)
        __java_return_value = __qt_this->isDebugLayerEnabled();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsConfiguration::isDebugMarkersEnabled()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_isDebugMarkersEnabled_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::isDebugMarkersEnabled()const", __this_nativeId)
        __java_return_value = __qt_this->isDebugMarkersEnabled();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsConfiguration::isDepthBufferEnabledFor2D()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_isDepthBufferEnabledFor2D_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::isDepthBufferEnabledFor2D()const", __this_nativeId)
        __java_return_value = __qt_this->isDepthBufferEnabledFor2D();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsConfiguration::operator=(QQuickGraphicsConfiguration)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_assign_1native_1cref_1QQuickGraphicsConfiguration__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID other0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::operator=(QQuickGraphicsConfiguration)", __this_nativeId)
        const QQuickGraphicsConfiguration& __qt_other0 = QtJambiAPI::valueReferenceFromNativeId<QQuickGraphicsConfiguration>(other0);
        (*__qt_this) = __qt_other0;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickGraphicsConfiguration::operator==(QQuickGraphicsConfiguration,QQuickGraphicsConfiguration)
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_equals_1native_1cref_1QQuickGraphicsConfiguration__JJ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 QtJambiNativeID value21)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::operator==(QQuickGraphicsConfiguration,QQuickGraphicsConfiguration)", __this_nativeId)
        const QQuickGraphicsConfiguration& __qt_value21 = QtJambiAPI::valueReferenceFromNativeId<QQuickGraphicsConfiguration>(value21);
        __java_return_value = (*__qt_this) == __qt_value21;
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsConfiguration::pipelineCacheLoadFile()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_pipelineCacheLoadFile_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::pipelineCacheLoadFile()const", __this_nativeId)
        QString __qt_return_value = __qt_this->pipelineCacheLoadFile();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsConfiguration::pipelineCacheSaveFile()const
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_pipelineCacheSaveFile_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jstring __java_return_value{0};
    QTJAMBI_TRY {
        const QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::pipelineCacheSaveFile()const", __this_nativeId)
        QString __qt_return_value = __qt_this->pipelineCacheSaveFile();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsConfiguration::prefersSoftwareDevice()const
extern "C" Q_DECL_EXPORT jboolean JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_prefersSoftwareDevice_1native_1constfct__J)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId)
{
    Q_UNUSED(__this)
    jboolean __java_return_value{0};
    QTJAMBI_TRY {
        const QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::prefersSoftwareDevice()const", __this_nativeId)
        __java_return_value = __qt_this->prefersSoftwareDevice();
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// QQuickGraphicsConfiguration::setAutomaticPipelineCache(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_setAutomaticPipelineCache_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::setAutomaticPipelineCache(bool)", __this_nativeId)
        __qt_this->setAutomaticPipelineCache(static_cast<bool>(enable0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickGraphicsConfiguration::setDebugLayer(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_setDebugLayer_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::setDebugLayer(bool)", __this_nativeId)
        __qt_this->setDebugLayer(static_cast<bool>(enable0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickGraphicsConfiguration::setDebugMarkers(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_setDebugMarkers_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::setDebugMarkers(bool)", __this_nativeId)
        __qt_this->setDebugMarkers(static_cast<bool>(enable0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickGraphicsConfiguration::setDepthBufferFor2D(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_setDepthBufferFor2D_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::setDepthBufferFor2D(bool)", __this_nativeId)
        __qt_this->setDepthBufferFor2D(static_cast<bool>(enable0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickGraphicsConfiguration::setDeviceExtensions(QByteArrayList)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_setDeviceExtensions_1native_1cref_1QList__JLjava_util_Collection_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jobject extensions0)
{
    QtJambiScope __qtjambi_scope(__this_nativeId);
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::setDeviceExtensions(QByteArrayList)", __this_nativeId)
        const QList<QByteArray>&  __qt_extensions0 = qtjambi_cast<const QList<QByteArray>& >(__jni_env, __qtjambi_scope, extensions0);
        __qt_this->setDeviceExtensions(__qt_extensions0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickGraphicsConfiguration::setPipelineCacheLoadFile(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_setPipelineCacheLoadFile_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring filename0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::setPipelineCacheLoadFile(QString)", __this_nativeId)
        QString  __qt_filename0 = qtjambi_cast<QString>(__jni_env, filename0);
        __qt_this->setPipelineCacheLoadFile(__qt_filename0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickGraphicsConfiguration::setPipelineCacheSaveFile(QString)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_setPipelineCacheSaveFile_1native_1cref_1QString__JLjava_lang_String_2)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jstring filename0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::setPipelineCacheSaveFile(QString)", __this_nativeId)
        QString  __qt_filename0 = qtjambi_cast<QString>(__jni_env, filename0);
        __qt_this->setPipelineCacheSaveFile(__qt_filename0);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickGraphicsConfiguration::setPreferSoftwareDevice(bool)
extern "C" Q_DECL_EXPORT void JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_setPreferSoftwareDevice_1native_1bool__JZ)
(JNIEnv *__jni_env,
 jobject __this,
 QtJambiNativeID __this_nativeId,
 jboolean enable0)
{
    Q_UNUSED(__this)
    QTJAMBI_TRY {
        QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QTJAMBI_NATIVE_INSTANCE_METHOD_CALL("QQuickGraphicsConfiguration::setPreferSoftwareDevice(bool)", __this_nativeId)
        __qt_this->setPreferSoftwareDevice(static_cast<bool>(enable0));
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END

}

// QQuickGraphicsConfiguration::preferredInstanceExtensions()
extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_preferredInstanceExtensions__)
(JNIEnv *__jni_env,
 jclass)
{
    QTJAMBI_NATIVE_METHOD_CALL("QQuickGraphicsConfiguration::preferredInstanceExtensions()")
    jobject __java_return_value{0};
    QTJAMBI_TRY {
        QList<QByteArray> __qt_return_value = QQuickGraphicsConfiguration::preferredInstanceExtensions();
        __java_return_value = qtjambi_cast<jobject>(__jni_env, __qt_return_value);
    }QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    }QTJAMBI_TRY_END
    return __java_return_value;

}

// emitting (writeJavaLangObjectOverrideFunctions)

extern "C" Q_DECL_EXPORT jint JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_hashCode_1native)
(JNIEnv * __jni_env, jclass, QtJambiNativeID __this_nativeId)
{
    jint __java_return_value = 0;
    QTJAMBI_TRY {
        QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        hash_type hashValue = qHash(*__qt_this);
        __java_return_value = jint(quint64(hashValue) ^ quint64(hashValue) >> 32);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

#include <QtCore/QDebug>
extern "C" Q_DECL_EXPORT jstring JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_toString_1native)(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jstring __java_return_value = nullptr;
    QTJAMBI_TRY {
        QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        QString res;
        QDebug(&res).noquote() << *__qt_this;
        if(!res.isEmpty() && res.back().isSpace())
            res = res.trimmed();
        __java_return_value = qtjambi_cast<jstring>(__jni_env, res);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}

// emitting (writeCloneFunction)

extern "C" Q_DECL_EXPORT jobject JNICALL QTJAMBI_FUNCTION_PREFIX(Java_io_qt_quick_QQuickGraphicsConfiguration_clone_1native)
(JNIEnv *__jni_env, jobject, QtJambiNativeID __this_nativeId)
{
    jobject __java_return_value = nullptr;
    QTJAMBI_TRY {
        const QQuickGraphicsConfiguration *__qt_this = QtJambiAPI::objectFromNativeId<QQuickGraphicsConfiguration>(__this_nativeId);
        QtJambiAPI::checkNullPointer(__jni_env, __qt_this);
        __java_return_value = qtjambi_cast<jobject>(__jni_env, *__qt_this);
    } QTJAMBI_CATCH(const JavaException& exn){
        exn.raiseInJava(__jni_env);
    } QTJAMBI_TRY_END
    return __java_return_value;
}


void initialize_meta_info_QQuickGraphicsConfiguration(){
    using namespace RegistryAPI;
    const std::type_info& typeId = registerValueTypeInfo<QQuickGraphicsConfiguration>("QQuickGraphicsConfiguration", "io/qt/quick/QQuickGraphicsConfiguration");
    Q_UNUSED(typeId)
// BEGIN: function table
    registerConstructorInfos(typeId, 0, &__qt_destruct_QQuickGraphicsConfiguration, {
        ConstructorInfo(&__qt_construct_QQuickGraphicsConfiguration, nullptr)
       ,ConstructorInfo(&__qt_construct_QQuickGraphicsConfiguration_cref_QQuickGraphicsConfiguration, "Lio/qt/quick/QQuickGraphicsConfiguration;")
    });
// END: function table

// BEGIN: type registration
    registerDeleter(typeId, &deleter_QQuickGraphicsConfiguration);
    registerMetaType<QQuickGraphicsConfiguration>("QQuickGraphicsConfiguration");
// END: type registration

// BEGIN: polymorphic ids
// END: polymorphic ids


// BEGIN: enums and flags
// END: enums and flags
}
