package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Contains classes that enable 2D and 3D rendering</p>
 * <p>Java wrapper for Qt header file <code><a href="https://doc.qt.io/qt/qt3drender.html">Qt3DRender</a></code></p>
 */
public final class Qt3DRender
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    private Qt3DRender() throws java.lang.InstantiationError { throw new java.lang.InstantiationError("Cannot instantiate namespace Qt3DRender."); }
    
    /**
     * <p>Java wrapper for Qt enum <code>Qt3DRender::API</code></p>
     */
    public enum API implements QtEnumerator {
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>API::<wbr/>OpenGL</code></p>
         */
        OpenGL(0),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>API::<wbr/>Vulkan</code></p>
         */
        Vulkan(1),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>API::<wbr/>DirectX</code></p>
         */
        DirectX(2),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>API::<wbr/>Metal</code></p>
         */
        Metal(3),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>API::<wbr/>RHI</code></p>
         */
        RHI(4),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>API::<wbr/>Null</code></p>
         */
        Null(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private API(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull API resolve(int value) {
            switch (value) {
            case 0: return OpenGL;
            case 1: return Vulkan;
            case 2: return DirectX;
            case 3: return Metal;
            case 4: return RHI;
            case 5: return Null;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    
}
