package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Provides Image access to shader programs</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html">Qt3DRender::QShaderImage</a></code></p>
 */
public class QShaderImage extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QShaderImage.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#Access-enum">Qt3DRender::QShaderImage::Access</a></code></p>
     */
    public enum Access implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#Access-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>ReadOnly</a></code></p>
         */
        ReadOnly(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#Access-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>WriteOnly</a></code></p>
         */
        WriteOnly(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#Access-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>ReadWrite</a></code></p>
         */
        ReadWrite(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Access(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Access resolve(int value) {
            switch (value) {
            case 0: return ReadOnly;
            case 1: return WriteOnly;
            case 2: return ReadWrite;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::QShaderImage::ImageFormat</a></code></p>
     */
    public enum ImageFormat implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>NoFormat</a></code></p>
         */
        NoFormat(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>Automatic</a></code></p>
         */
        Automatic(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>R8_UNorm</a></code></p>
         */
        R8_UNorm(33321),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG8_UNorm</a></code></p>
         */
        RG8_UNorm(33323),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGBA8_UNorm</a></code></p>
         */
        RGBA8_UNorm(32856),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>R16_UNorm</a></code></p>
         */
        R16_UNorm(33322),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG16_UNorm</a></code></p>
         */
        RG16_UNorm(33324),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGBA16_UNorm</a></code></p>
         */
        RGBA16_UNorm(32859),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>R8_SNorm</a></code></p>
         */
        R8_SNorm(36756),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG8_SNorm</a></code></p>
         */
        RG8_SNorm(36757),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGBA8_SNorm</a></code></p>
         */
        RGBA8_SNorm(36759),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>R16_SNorm</a></code></p>
         */
        R16_SNorm(36760),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG16_SNorm</a></code></p>
         */
        RG16_SNorm(36761),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGBA16_SNorm</a></code></p>
         */
        RGBA16_SNorm(36763),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>R8U</a></code></p>
         */
        R8U(33330),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG8U</a></code></p>
         */
        RG8U(33336),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGBA8U</a></code></p>
         */
        RGBA8U(36220),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>R16U</a></code></p>
         */
        R16U(33332),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG16U</a></code></p>
         */
        RG16U(33338),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGBA16U</a></code></p>
         */
        RGBA16U(36214),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>R32U</a></code></p>
         */
        R32U(33334),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG32U</a></code></p>
         */
        RG32U(33340),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGBA32U</a></code></p>
         */
        RGBA32U(36208),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>R8I</a></code></p>
         */
        R8I(33329),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG8I</a></code></p>
         */
        RG8I(33335),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGBA8I</a></code></p>
         */
        RGBA8I(36238),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>R16I</a></code></p>
         */
        R16I(33331),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG16I</a></code></p>
         */
        RG16I(33337),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGBA16I</a></code></p>
         */
        RGBA16I(36232),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>R32I</a></code></p>
         */
        R32I(33333),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG32I</a></code></p>
         */
        RG32I(33339),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGBA32I</a></code></p>
         */
        RGBA32I(36226),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>R16F</a></code></p>
         */
        R16F(33325),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG16F</a></code></p>
         */
        RG16F(33327),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGBA16F</a></code></p>
         */
        RGBA16F(34842),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>R32F</a></code></p>
         */
        R32F(33326),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG32F</a></code></p>
         */
        RG32F(33328),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGBA32F</a></code></p>
         */
        RGBA32F(34836),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RG11B10F</a></code></p>
         */
        RG11B10F(35898),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGB10A2</a></code></p>
         */
        RGB10A2(32857),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#ImageFormat-enum">Qt3DRender::<wbr/>QShaderImage::<wbr/>RGB10A2U</a></code></p>
         */
        RGB10A2U(36975);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ImageFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ImageFormat resolve(int value) {
            switch (value) {
            case 0: return NoFormat;
            case 1: return Automatic;
            case 33321: return R8_UNorm;
            case 33323: return RG8_UNorm;
            case 32856: return RGBA8_UNorm;
            case 33322: return R16_UNorm;
            case 33324: return RG16_UNorm;
            case 32859: return RGBA16_UNorm;
            case 36756: return R8_SNorm;
            case 36757: return RG8_SNorm;
            case 36759: return RGBA8_SNorm;
            case 36760: return R16_SNorm;
            case 36761: return RG16_SNorm;
            case 36763: return RGBA16_SNorm;
            case 33330: return R8U;
            case 33336: return RG8U;
            case 36220: return RGBA8U;
            case 33332: return R16U;
            case 33338: return RG16U;
            case 36214: return RGBA16U;
            case 33334: return R32U;
            case 33340: return RG32U;
            case 36208: return RGBA32U;
            case 33329: return R8I;
            case 33335: return RG8I;
            case 36238: return RGBA8I;
            case 33331: return R16I;
            case 33337: return RG16I;
            case 36232: return RGBA16I;
            case 33333: return R32I;
            case 33339: return RG32I;
            case 36226: return RGBA32I;
            case 33325: return R16F;
            case 33327: return RG16F;
            case 34842: return RGBA16F;
            case 33326: return R32F;
            case 33328: return RG32F;
            case 34836: return RGBA32F;
            case 35898: return RG11B10F;
            case 32857: return RGB10A2;
            case 36975: return RGB10A2U;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#access-prop">Qt3DRender::QShaderImage::<wbr/>accessChanged(Qt3DRender::QShaderImage::Access)</a></code></p>
     */
    @QtPropertyNotify(name="access")
    public final @NonNull Signal1<io.qt.qt3d.render.QShaderImage.@NonNull Access> accessChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#format-prop">Qt3DRender::QShaderImage::<wbr/>formatChanged(Qt3DRender::QShaderImage::ImageFormat)</a></code></p>
     */
    @QtPropertyNotify(name="format")
    public final @NonNull Signal1<io.qt.qt3d.render.QShaderImage.@NonNull ImageFormat> formatChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#layer-prop">Qt3DRender::QShaderImage::<wbr/>layerChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="layer")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> layerChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#layered-prop">Qt3DRender::QShaderImage::<wbr/>layeredChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="layered")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> layeredChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#mipLevel-prop">Qt3DRender::QShaderImage::<wbr/>mipLevelChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="mipLevel")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> mipLevelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#texture-prop">Qt3DRender::QShaderImage::<wbr/>textureChanged(Qt3DRender::QAbstractTexture*)</a></code></p>
     */
    @QtPropertyNotify(name="texture")
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QAbstractTexture> textureChanged = new Signal1<>();
    
    /**
     * <p>See <code>Qt3DRender::QShaderImage::<wbr/>QShaderImage(Qt3DCore::QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QShaderImage(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QShaderImage instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#access-prop">Qt3DRender::QShaderImage::<wbr/>access()const</a></code></p>
     */
    @QtPropertyReader(name="access")
    @QtUninvokable
    public final io.qt.qt3d.render.QShaderImage.@NonNull Access access(){
        return io.qt.qt3d.render.QShaderImage.Access.resolve(access_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int access_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#format-prop">Qt3DRender::QShaderImage::<wbr/>format()const</a></code></p>
     */
    @QtPropertyReader(name="format")
    @QtUninvokable
    public final io.qt.qt3d.render.QShaderImage.@NonNull ImageFormat format(){
        return io.qt.qt3d.render.QShaderImage.ImageFormat.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#layer-prop">Qt3DRender::QShaderImage::<wbr/>layer()const</a></code></p>
     */
    @QtPropertyReader(name="layer")
    @QtUninvokable
    public final int layer(){
        return layer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int layer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#layered-prop">Qt3DRender::QShaderImage::<wbr/>layered()const</a></code></p>
     */
    @QtPropertyReader(name="layered")
    @QtUninvokable
    public final boolean layered(){
        return layered_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean layered_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#mipLevel-prop">Qt3DRender::QShaderImage::<wbr/>mipLevel()const</a></code></p>
     */
    @QtPropertyReader(name="mipLevel")
    @QtUninvokable
    public final int mipLevel(){
        return mipLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int mipLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#access-prop">Qt3DRender::QShaderImage::<wbr/>setAccess(Qt3DRender::QShaderImage::Access)</a></code></p>
     */
    @QtPropertyWriter(name="access")
    public final void setAccess(io.qt.qt3d.render.QShaderImage.@NonNull Access access){
        setAccess_native_Qt3DRender_QShaderImage_Access(QtJambi_LibraryUtilities.internal.nativeId(this), access.value());
    }
    
    private native void setAccess_native_Qt3DRender_QShaderImage_Access(long __this__nativeId, int access);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#format-prop">Qt3DRender::QShaderImage::<wbr/>setFormat(Qt3DRender::QShaderImage::ImageFormat)</a></code></p>
     */
    @QtPropertyWriter(name="format")
    public final void setFormat(io.qt.qt3d.render.QShaderImage.@NonNull ImageFormat format){
        setFormat_native_Qt3DRender_QShaderImage_ImageFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    private native void setFormat_native_Qt3DRender_QShaderImage_ImageFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#layer-prop">Qt3DRender::QShaderImage::<wbr/>setLayer(int)</a></code></p>
     */
    @QtPropertyWriter(name="layer")
    public final void setLayer(int layer){
        setLayer_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layer);
    }
    
    private native void setLayer_native_int(long __this__nativeId, int layer);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#layered-prop">Qt3DRender::QShaderImage::<wbr/>setLayered(bool)</a></code></p>
     */
    @QtPropertyWriter(name="layered")
    public final void setLayered(boolean layered){
        setLayered_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), layered);
    }
    
    private native void setLayered_native_bool(long __this__nativeId, boolean layered);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#mipLevel-prop">Qt3DRender::QShaderImage::<wbr/>setMipLevel(int)</a></code></p>
     */
    @QtPropertyWriter(name="mipLevel")
    public final void setMipLevel(int mipLevel){
        setMipLevel_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevel);
    }
    
    private native void setMipLevel_native_int(long __this__nativeId, int mipLevel);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#texture-prop">Qt3DRender::QShaderImage::<wbr/>setTexture(Qt3DRender::QAbstractTexture*)</a></code></p>
     */
    @QtPropertyWriter(name="texture")
    public final void setTexture(io.qt.qt3d.render.@Nullable QAbstractTexture texture){
        setTexture_native_Qt3DRender_QAbstractTexture_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(texture));
    }
    
    private native void setTexture_native_Qt3DRender_QAbstractTexture_ptr(long __this__nativeId, long texture);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderimage.html#texture-prop">Qt3DRender::QShaderImage::<wbr/>texture()const</a></code></p>
     */
    @QtPropertyReader(name="texture")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QAbstractTexture texture(){
        return texture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QAbstractTexture texture_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QShaderImage(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QShaderImage(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QShaderImage instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QShaderImage(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QShaderImage() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #access()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QShaderImage.@NonNull Access getAccess() {
        return access();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #format()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QShaderImage.@NonNull ImageFormat getFormat() {
        return format();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #layer()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLayer() {
        return layer();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #layered()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getLayered() {
        return layered();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #mipLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMipLevel() {
        return mipLevel();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #texture()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QAbstractTexture getTexture() {
        return texture();
    }
}
