package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Encapsulates geometry rendering</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html">Qt3DRender::QGeometryRenderer</a></code></p>
 */
public class QGeometryRenderer extends io.qt.qt3d.core.QBoundingVolume
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QGeometryRenderer.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::QGeometryRenderer::PrimitiveType</a></code></p>
     */
    public enum PrimitiveType implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::<wbr/>QGeometryRenderer::<wbr/>Points</a></code></p>
         */
        Points(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::<wbr/>QGeometryRenderer::<wbr/>Lines</a></code></p>
         */
        Lines(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::<wbr/>QGeometryRenderer::<wbr/>LineLoop</a></code></p>
         */
        LineLoop(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::<wbr/>QGeometryRenderer::<wbr/>LineStrip</a></code></p>
         */
        LineStrip(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::<wbr/>QGeometryRenderer::<wbr/>Triangles</a></code></p>
         */
        Triangles(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::<wbr/>QGeometryRenderer::<wbr/>TriangleStrip</a></code></p>
         */
        TriangleStrip(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::<wbr/>QGeometryRenderer::<wbr/>TriangleFan</a></code></p>
         */
        TriangleFan(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::<wbr/>QGeometryRenderer::<wbr/>LinesAdjacency</a></code></p>
         */
        LinesAdjacency(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::<wbr/>QGeometryRenderer::<wbr/>TrianglesAdjacency</a></code></p>
         */
        TrianglesAdjacency(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::<wbr/>QGeometryRenderer::<wbr/>LineStripAdjacency</a></code></p>
         */
        LineStripAdjacency(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::<wbr/>QGeometryRenderer::<wbr/>TriangleStripAdjacency</a></code></p>
         */
        TriangleStripAdjacency(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#PrimitiveType-enum">Qt3DRender::<wbr/>QGeometryRenderer::<wbr/>Patches</a></code></p>
         */
        Patches(14);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private PrimitiveType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull PrimitiveType resolve(int value) {
            switch (value) {
            case 0: return Points;
            case 1: return Lines;
            case 2: return LineLoop;
            case 3: return LineStrip;
            case 4: return Triangles;
            case 5: return TriangleStrip;
            case 6: return TriangleFan;
            case 10: return LinesAdjacency;
            case 12: return TrianglesAdjacency;
            case 11: return LineStripAdjacency;
            case 13: return TriangleStripAdjacency;
            case 14: return Patches;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#firstInstance-prop">Qt3DRender::QGeometryRenderer::<wbr/>firstInstanceChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="firstInstance")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> firstInstanceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#firstVertex-prop">Qt3DRender::QGeometryRenderer::<wbr/>firstVertexChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="firstVertex")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> firstVertexChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#geometry-prop">Qt3DRender::QGeometryRenderer::<wbr/>geometryChanged(Qt3DCore::QGeometry*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtPropertyNotify(name="geometry")
    public final @NonNull Signal1<io.qt.qt3d.core.@Nullable QGeometry> geometryChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#indexBufferByteOffset-prop">Qt3DRender::QGeometryRenderer::<wbr/>indexBufferByteOffsetChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="indexBufferByteOffset")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> indexBufferByteOffsetChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#indexOffset-prop">Qt3DRender::QGeometryRenderer::<wbr/>indexOffsetChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="indexOffset")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> indexOffsetChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#instanceCount-prop">Qt3DRender::QGeometryRenderer::<wbr/>instanceCountChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="instanceCount")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> instanceCountChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#primitiveRestartEnabled-prop">Qt3DRender::QGeometryRenderer::<wbr/>primitiveRestartEnabledChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="primitiveRestartEnabled")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> primitiveRestartEnabledChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#primitiveType-prop">Qt3DRender::QGeometryRenderer::<wbr/>primitiveTypeChanged(Qt3DRender::QGeometryRenderer::PrimitiveType)</a></code></p>
     */
    @QtPropertyNotify(name="primitiveType")
    public final @NonNull Signal1<io.qt.qt3d.render.QGeometryRenderer.@NonNull PrimitiveType> primitiveTypeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#restartIndexValue-prop">Qt3DRender::QGeometryRenderer::<wbr/>restartIndexValueChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="restartIndexValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> restartIndexValueChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#sortIndex-prop">Qt3DRender::QGeometryRenderer::<wbr/>sortIndexChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="sortIndex")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> sortIndexChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#vertexCount-prop">Qt3DRender::QGeometryRenderer::<wbr/>vertexCountChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="vertexCount")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> vertexCountChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#verticesPerPatch-prop">Qt3DRender::QGeometryRenderer::<wbr/>verticesPerPatchChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="verticesPerPatch")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> verticesPerPatchChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#QGeometryRenderer">Qt3DRender::QGeometryRenderer::<wbr/>QGeometryRenderer(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QGeometryRenderer(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QGeometryRenderer instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#firstInstance-prop">Qt3DRender::QGeometryRenderer::<wbr/>firstInstance()const</a></code></p>
     */
    @QtPropertyReader(name="firstInstance")
    @QtUninvokable
    public final int firstInstance(){
        return firstInstance_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int firstInstance_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#firstVertex-prop">Qt3DRender::QGeometryRenderer::<wbr/>firstVertex()const</a></code></p>
     */
    @QtPropertyReader(name="firstVertex")
    @QtUninvokable
    public final int firstVertex(){
        return firstVertex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int firstVertex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#geometry-prop">Qt3DRender::QGeometryRenderer::<wbr/>geometry()const</a></code></p>
     */
    @QtPropertyReader(name="geometry")
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QGeometry geometry(){
        return geometry_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.core.QGeometry geometry_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#indexBufferByteOffset-prop">Qt3DRender::QGeometryRenderer::<wbr/>indexBufferByteOffset()const</a></code></p>
     */
    @QtPropertyReader(name="indexBufferByteOffset")
    @QtUninvokable
    public final int indexBufferByteOffset(){
        return indexBufferByteOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int indexBufferByteOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#indexOffset-prop">Qt3DRender::QGeometryRenderer::<wbr/>indexOffset()const</a></code></p>
     */
    @QtPropertyReader(name="indexOffset")
    @QtUninvokable
    public final int indexOffset(){
        return indexOffset_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int indexOffset_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#instanceCount-prop">Qt3DRender::QGeometryRenderer::<wbr/>instanceCount()const</a></code></p>
     */
    @QtPropertyReader(name="instanceCount")
    @QtUninvokable
    public final int instanceCount(){
        return instanceCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int instanceCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#primitiveRestartEnabled-prop">Qt3DRender::QGeometryRenderer::<wbr/>primitiveRestartEnabled()const</a></code></p>
     */
    @QtPropertyReader(name="primitiveRestartEnabled")
    @QtUninvokable
    public final boolean primitiveRestartEnabled(){
        return primitiveRestartEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean primitiveRestartEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#primitiveType-prop">Qt3DRender::QGeometryRenderer::<wbr/>primitiveType()const</a></code></p>
     */
    @QtPropertyReader(name="primitiveType")
    @QtUninvokable
    public final io.qt.qt3d.render.QGeometryRenderer.@NonNull PrimitiveType primitiveType(){
        return io.qt.qt3d.render.QGeometryRenderer.PrimitiveType.resolve(primitiveType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int primitiveType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#restartIndexValue-prop">Qt3DRender::QGeometryRenderer::<wbr/>restartIndexValue()const</a></code></p>
     */
    @QtPropertyReader(name="restartIndexValue")
    @QtUninvokable
    public final int restartIndexValue(){
        return restartIndexValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int restartIndexValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#firstInstance-prop">Qt3DRender::QGeometryRenderer::<wbr/>setFirstInstance(int)</a></code></p>
     */
    @QtPropertyWriter(name="firstInstance")
    public final void setFirstInstance(int firstInstance){
        setFirstInstance_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), firstInstance);
    }
    
    private native void setFirstInstance_native_int(long __this__nativeId, int firstInstance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#firstVertex-prop">Qt3DRender::QGeometryRenderer::<wbr/>setFirstVertex(int)</a></code></p>
     */
    @QtPropertyWriter(name="firstVertex")
    public final void setFirstVertex(int firstVertex){
        setFirstVertex_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), firstVertex);
    }
    
    private native void setFirstVertex_native_int(long __this__nativeId, int firstVertex);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#geometry-prop">Qt3DRender::QGeometryRenderer::<wbr/>setGeometry(Qt3DCore::QGeometry*)</a></code></p>
     */
    @QtPropertyWriter(name="geometry")
    @SuppressWarnings({"exports"})
    public final void setGeometry(io.qt.qt3d.core.@Nullable QGeometry geometry){
        setGeometry_native_Qt3DCore_QGeometry_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(geometry));
    }
    
    private native void setGeometry_native_Qt3DCore_QGeometry_ptr(long __this__nativeId, long geometry);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#indexBufferByteOffset-prop">Qt3DRender::QGeometryRenderer::<wbr/>setIndexBufferByteOffset(int)</a></code></p>
     */
    @QtPropertyWriter(name="indexBufferByteOffset")
    public final void setIndexBufferByteOffset(int offset){
        setIndexBufferByteOffset_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), offset);
    }
    
    private native void setIndexBufferByteOffset_native_int(long __this__nativeId, int offset);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#indexOffset-prop">Qt3DRender::QGeometryRenderer::<wbr/>setIndexOffset(int)</a></code></p>
     */
    @QtPropertyWriter(name="indexOffset")
    public final void setIndexOffset(int indexOffset){
        setIndexOffset_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), indexOffset);
    }
    
    private native void setIndexOffset_native_int(long __this__nativeId, int indexOffset);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#instanceCount-prop">Qt3DRender::QGeometryRenderer::<wbr/>setInstanceCount(int)</a></code></p>
     */
    @QtPropertyWriter(name="instanceCount")
    public final void setInstanceCount(int instanceCount){
        setInstanceCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), instanceCount);
    }
    
    private native void setInstanceCount_native_int(long __this__nativeId, int instanceCount);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#primitiveRestartEnabled-prop">Qt3DRender::QGeometryRenderer::<wbr/>setPrimitiveRestartEnabled(bool)</a></code></p>
     */
    @QtPropertyWriter(name="primitiveRestartEnabled")
    public final void setPrimitiveRestartEnabled(boolean enabled){
        setPrimitiveRestartEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), enabled);
    }
    
    private native void setPrimitiveRestartEnabled_native_bool(long __this__nativeId, boolean enabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#primitiveType-prop">Qt3DRender::QGeometryRenderer::<wbr/>setPrimitiveType(Qt3DRender::QGeometryRenderer::PrimitiveType)</a></code></p>
     */
    @QtPropertyWriter(name="primitiveType")
    public final void setPrimitiveType(io.qt.qt3d.render.QGeometryRenderer.@NonNull PrimitiveType primitiveType){
        setPrimitiveType_native_Qt3DRender_QGeometryRenderer_PrimitiveType(QtJambi_LibraryUtilities.internal.nativeId(this), primitiveType.value());
    }
    
    private native void setPrimitiveType_native_Qt3DRender_QGeometryRenderer_PrimitiveType(long __this__nativeId, int primitiveType);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#restartIndexValue-prop">Qt3DRender::QGeometryRenderer::<wbr/>setRestartIndexValue(int)</a></code></p>
     */
    @QtPropertyWriter(name="restartIndexValue")
    public final void setRestartIndexValue(int index){
        setRestartIndexValue_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), index);
    }
    
    private native void setRestartIndexValue_native_int(long __this__nativeId, int index);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#sortIndex-prop">Qt3DRender::QGeometryRenderer::<wbr/>setSortIndex(float)</a></code></p>
     */
    @QtPropertyWriter(name="sortIndex")
    public final void setSortIndex(float sortIndex){
        setSortIndex_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), sortIndex);
    }
    
    private native void setSortIndex_native_float(long __this__nativeId, float sortIndex);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#vertexCount-prop">Qt3DRender::QGeometryRenderer::<wbr/>setVertexCount(int)</a></code></p>
     */
    @QtPropertyWriter(name="vertexCount")
    public final void setVertexCount(int vertexCount){
        setVertexCount_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), vertexCount);
    }
    
    private native void setVertexCount_native_int(long __this__nativeId, int vertexCount);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#verticesPerPatch-prop">Qt3DRender::QGeometryRenderer::<wbr/>setVerticesPerPatch(int)</a></code></p>
     */
    @QtPropertyWriter(name="verticesPerPatch")
    public final void setVerticesPerPatch(int verticesPerPatch){
        setVerticesPerPatch_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), verticesPerPatch);
    }
    
    private native void setVerticesPerPatch_native_int(long __this__nativeId, int verticesPerPatch);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#sortIndex-prop">Qt3DRender::QGeometryRenderer::<wbr/>sortIndex()const</a></code></p>
     */
    @QtPropertyReader(name="sortIndex")
    @QtUninvokable
    public final float sortIndex(){
        return sortIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float sortIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#vertexCount-prop">Qt3DRender::QGeometryRenderer::<wbr/>vertexCount()const</a></code></p>
     */
    @QtPropertyReader(name="vertexCount")
    @QtUninvokable
    public final int vertexCount(){
        return vertexCount_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int vertexCount_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qgeometryrenderer.html#verticesPerPatch-prop">Qt3DRender::QGeometryRenderer::<wbr/>verticesPerPatch()const</a></code></p>
     */
    @QtPropertyReader(name="verticesPerPatch")
    @QtUninvokable
    public final int verticesPerPatch(){
        return verticesPerPatch_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int verticesPerPatch_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QGeometryRenderer(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QGeometryRenderer(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QGeometryRenderer instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QGeometryRenderer(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QGeometryRenderer() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #firstInstance()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getFirstInstance() {
        return firstInstance();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #firstVertex()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getFirstVertex() {
        return firstVertex();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #geometry()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.qt3d.core.@Nullable QGeometry getGeometry() {
        return geometry();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #indexBufferByteOffset()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getIndexBufferByteOffset() {
        return indexBufferByteOffset();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #indexOffset()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getIndexOffset() {
        return indexOffset();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #instanceCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getInstanceCount() {
        return instanceCount();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #primitiveRestartEnabled()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getPrimitiveRestartEnabled() {
        return primitiveRestartEnabled();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #primitiveType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QGeometryRenderer.@NonNull PrimitiveType getPrimitiveType() {
        return primitiveType();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #restartIndexValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getRestartIndexValue() {
        return restartIndexValue();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #sortIndex()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getSortIndex() {
        return sortIndex();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #vertexCount()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVertexCount() {
        return vertexCount();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #verticesPerPatch()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVerticesPerPatch() {
        return verticesPerPatch();
    }
}
