package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>A base class to be used to provide textures</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html">Qt3DRender::QAbstractTexture</a></code></p>
 */
public class QAbstractTexture extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractTexture.class);
    
    /**
     * <p>Java wrapper for Qt enum <code>Qt3DRender::QAbstractTexture::ComparisonFunction</code></p>
     */
    public enum ComparisonFunction implements QtEnumerator {
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CompareLessEqual</code></p>
         */
        CompareLessEqual(515),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CompareGreaterEqual</code></p>
         */
        CompareGreaterEqual(518),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CompareLess</code></p>
         */
        CompareLess(513),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CompareGreater</code></p>
         */
        CompareGreater(516),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CompareEqual</code></p>
         */
        CompareEqual(514),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CommpareNotEqual</code></p>
         */
        CommpareNotEqual(517),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CompareAlways</code></p>
         */
        CompareAlways(519),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CompareNever</code></p>
         */
        CompareNever(512);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ComparisonFunction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ComparisonFunction resolve(int value) {
            switch (value) {
            case 515: return CompareLessEqual;
            case 518: return CompareGreaterEqual;
            case 513: return CompareLess;
            case 516: return CompareGreater;
            case 514: return CompareEqual;
            case 517: return CommpareNotEqual;
            case 519: return CompareAlways;
            case 512: return CompareNever;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>Qt3DRender::QAbstractTexture::ComparisonMode</code></p>
     */
    public enum ComparisonMode implements QtEnumerator {
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CompareRefToTexture</code></p>
         */
        CompareRefToTexture(34894),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CompareNone</code></p>
         */
        CompareNone(0);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private ComparisonMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull ComparisonMode resolve(int value) {
            switch (value) {
            case 34894: return CompareRefToTexture;
            case 0: return CompareNone;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::QAbstractTexture::CubeMapFace</a></code></p>
     */
    public enum CubeMapFace implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CubeMapPositiveX</a></code></p>
         */
        CubeMapPositiveX(34069),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CubeMapNegativeX</a></code></p>
         */
        CubeMapNegativeX(34070),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CubeMapPositiveY</a></code></p>
         */
        CubeMapPositiveY(34071),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CubeMapNegativeY</a></code></p>
         */
        CubeMapNegativeY(34072),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CubeMapPositiveZ</a></code></p>
         */
        CubeMapPositiveZ(34073),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>CubeMapNegativeZ</a></code></p>
         */
        CubeMapNegativeZ(34074),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#CubeMapFace-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>AllFaces</a></code></p>
         */
        AllFaces(34075);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CubeMapFace(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull CubeMapFace resolve(int value) {
            switch (value) {
            case 34069: return CubeMapPositiveX;
            case 34070: return CubeMapNegativeX;
            case 34071: return CubeMapPositiveY;
            case 34072: return CubeMapNegativeY;
            case 34073: return CubeMapPositiveZ;
            case 34074: return CubeMapNegativeZ;
            case 34075: return AllFaces;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::QAbstractTexture::Filter</a></code></p>
     */
    public enum Filter implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Nearest</a></code></p>
         */
        Nearest(9728),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Linear</a></code></p>
         */
        Linear(9729),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>NearestMipMapNearest</a></code></p>
         */
        NearestMipMapNearest(9984),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>NearestMipMapLinear</a></code></p>
         */
        NearestMipMapLinear(9986),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>LinearMipMapNearest</a></code></p>
         */
        LinearMipMapNearest(9985),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Filter-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>LinearMipMapLinear</a></code></p>
         */
        LinearMipMapLinear(9987);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Filter(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Filter resolve(int value) {
            switch (value) {
            case 9728: return Nearest;
            case 9729: return Linear;
            case 9984: return NearestMipMapNearest;
            case 9986: return NearestMipMapLinear;
            case 9985: return LinearMipMapNearest;
            case 9987: return LinearMipMapLinear;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>Qt3DRender::QAbstractTexture::HandleType</code></p>
     */
    public enum HandleType implements QtEnumerator {
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>NoHandle</code></p>
         */
        NoHandle(0),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>OpenGLTextureId</code></p>
         */
        OpenGLTextureId(1),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RHITextureId</code></p>
         */
        RHITextureId(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private HandleType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull HandleType resolve(int value) {
            switch (value) {
            case 0: return NoHandle;
            case 1: return OpenGLTextureId;
            case 2: return RHITextureId;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Status-enum">Qt3DRender::QAbstractTexture::Status</a></code></p>
     */
    public enum Status implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Status-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>None</a></code></p>
         */
        None(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Status-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Loading</a></code></p>
         */
        Loading(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Status-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Ready</a></code></p>
         */
        Ready(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Status-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Error</a></code></p>
         */
        Error(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Status resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return Loading;
            case 2: return Ready;
            case 3: return Error;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::QAbstractTexture::Target</a></code></p>
     */
    public enum Target implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>TargetAutomatic</a></code></p>
         */
        TargetAutomatic(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Target1D</a></code></p>
         */
        Target1D(3552),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Target1DArray</a></code></p>
         */
        Target1DArray(35864),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Target2D</a></code></p>
         */
        Target2D(3553),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Target2DArray</a></code></p>
         */
        Target2DArray(35866),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Target3D</a></code></p>
         */
        Target3D(32879),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>TargetCubeMap</a></code></p>
         */
        TargetCubeMap(34067),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>TargetCubeMapArray</a></code></p>
         */
        TargetCubeMapArray(36873),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Target2DMultisample</a></code></p>
         */
        Target2DMultisample(37120),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Target2DMultisampleArray</a></code></p>
         */
        Target2DMultisampleArray(37122),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>TargetRectangle</a></code></p>
         */
        TargetRectangle(34037),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#Target-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>TargetBuffer</a></code></p>
         */
        TargetBuffer(35882);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Target(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Target resolve(int value) {
            switch (value) {
            case 0: return TargetAutomatic;
            case 3552: return Target1D;
            case 35864: return Target1DArray;
            case 3553: return Target2D;
            case 35866: return Target2DArray;
            case 32879: return Target3D;
            case 34067: return TargetCubeMap;
            case 36873: return TargetCubeMapArray;
            case 37120: return Target2DMultisample;
            case 37122: return Target2DMultisampleArray;
            case 34037: return TargetRectangle;
            case 35882: return TargetBuffer;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::QAbstractTexture::TextureFormat</a></code></p>
     */
    public enum TextureFormat implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>NoFormat</a></code></p>
         */
        NoFormat(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>Automatic</a></code></p>
         */
        Automatic(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R8_UNorm</a></code></p>
         */
        R8_UNorm(33321),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG8_UNorm</a></code></p>
         */
        RG8_UNorm(33323),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB8_UNorm</a></code></p>
         */
        RGB8_UNorm(32849),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA8_UNorm</a></code></p>
         */
        RGBA8_UNorm(32856),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R16_UNorm</a></code></p>
         */
        R16_UNorm(33322),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG16_UNorm</a></code></p>
         */
        RG16_UNorm(33324),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB16_UNorm</a></code></p>
         */
        RGB16_UNorm(32852),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA16_UNorm</a></code></p>
         */
        RGBA16_UNorm(32859),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R8_SNorm</a></code></p>
         */
        R8_SNorm(36756),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG8_SNorm</a></code></p>
         */
        RG8_SNorm(36757),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB8_SNorm</a></code></p>
         */
        RGB8_SNorm(36758),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA8_SNorm</a></code></p>
         */
        RGBA8_SNorm(36759),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R16_SNorm</a></code></p>
         */
        R16_SNorm(36760),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG16_SNorm</a></code></p>
         */
        RG16_SNorm(36761),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB16_SNorm</a></code></p>
         */
        RGB16_SNorm(36762),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA16_SNorm</a></code></p>
         */
        RGBA16_SNorm(36763),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R8U</a></code></p>
         */
        R8U(33330),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG8U</a></code></p>
         */
        RG8U(33336),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB8U</a></code></p>
         */
        RGB8U(36221),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA8U</a></code></p>
         */
        RGBA8U(36220),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R16U</a></code></p>
         */
        R16U(33332),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG16U</a></code></p>
         */
        RG16U(33338),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB16U</a></code></p>
         */
        RGB16U(36215),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA16U</a></code></p>
         */
        RGBA16U(36214),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R32U</a></code></p>
         */
        R32U(33334),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG32U</a></code></p>
         */
        RG32U(33340),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB32U</a></code></p>
         */
        RGB32U(36209),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA32U</a></code></p>
         */
        RGBA32U(36208),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R8I</a></code></p>
         */
        R8I(33329),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG8I</a></code></p>
         */
        RG8I(33335),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB8I</a></code></p>
         */
        RGB8I(36239),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA8I</a></code></p>
         */
        RGBA8I(36238),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R16I</a></code></p>
         */
        R16I(33331),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG16I</a></code></p>
         */
        RG16I(33337),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB16I</a></code></p>
         */
        RGB16I(36233),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA16I</a></code></p>
         */
        RGBA16I(36232),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R32I</a></code></p>
         */
        R32I(33333),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG32I</a></code></p>
         */
        RG32I(33339),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB32I</a></code></p>
         */
        RGB32I(36227),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA32I</a></code></p>
         */
        RGBA32I(36226),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R16F</a></code></p>
         */
        R16F(33325),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG16F</a></code></p>
         */
        RG16F(33327),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB16F</a></code></p>
         */
        RGB16F(34843),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA16F</a></code></p>
         */
        RGBA16F(34842),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R32F</a></code></p>
         */
        R32F(33326),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG32F</a></code></p>
         */
        RG32F(33328),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB32F</a></code></p>
         */
        RGB32F(34837),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA32F</a></code></p>
         */
        RGBA32F(34836),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB9E5</a></code></p>
         */
        RGB9E5(35901),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG11B10F</a></code></p>
         */
        RG11B10F(35898),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG3B2</a></code></p>
         */
        RG3B2(10768),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R5G6B5</a></code></p>
         */
        R5G6B5(36194),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB5A1</a></code></p>
         */
        RGB5A1(32855),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA4</a></code></p>
         */
        RGBA4(32854),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB10A2</a></code></p>
         */
        RGB10A2(32857),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB10A2U</a></code></p>
         */
        RGB10A2U(36975),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>D16</a></code></p>
         */
        D16(33189),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>D24</a></code></p>
         */
        D24(33190),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>D24S8</a></code></p>
         */
        D24S8(35056),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>D32</a></code></p>
         */
        D32(33191),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>D32F</a></code></p>
         */
        D32F(36012),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>D32FS8X24</a></code></p>
         */
        D32FS8X24(36013),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB_DXT1</a></code></p>
         */
        RGB_DXT1(33776),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA_DXT1</a></code></p>
         */
        RGBA_DXT1(33777),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA_DXT3</a></code></p>
         */
        RGBA_DXT3(33778),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA_DXT5</a></code></p>
         */
        RGBA_DXT5(33779),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R_ATI1N_UNorm</a></code></p>
         */
        R_ATI1N_UNorm(36283),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R_ATI1N_SNorm</a></code></p>
         */
        R_ATI1N_SNorm(36284),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG_ATI2N_UNorm</a></code></p>
         */
        RG_ATI2N_UNorm(36285),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG_ATI2N_SNorm</a></code></p>
         */
        RG_ATI2N_SNorm(36286),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB_BP_UNSIGNED_FLOAT</a></code></p>
         */
        RGB_BP_UNSIGNED_FLOAT(36495),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB_BP_SIGNED_FLOAT</a></code></p>
         */
        RGB_BP_SIGNED_FLOAT(36494),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB_BP_UNorm</a></code></p>
         */
        RGB_BP_UNorm(36492),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R11_EAC_UNorm</a></code></p>
         */
        R11_EAC_UNorm(37488),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>R11_EAC_SNorm</a></code></p>
         */
        R11_EAC_SNorm(37489),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG11_EAC_UNorm</a></code></p>
         */
        RG11_EAC_UNorm(37490),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RG11_EAC_SNorm</a></code></p>
         */
        RG11_EAC_SNorm(37491),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB8_ETC2</a></code></p>
         */
        RGB8_ETC2(37492),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>SRGB8_ETC2</a></code></p>
         */
        SRGB8_ETC2(37493),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB8_PunchThrough_Alpha1_ETC2</a></code></p>
         */
        RGB8_PunchThrough_Alpha1_ETC2(37494),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>SRGB8_PunchThrough_Alpha1_ETC2</a></code></p>
         */
        SRGB8_PunchThrough_Alpha1_ETC2(37495),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBA8_ETC2_EAC</a></code></p>
         */
        RGBA8_ETC2_EAC(37496),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>SRGB8_Alpha8_ETC2_EAC</a></code></p>
         */
        SRGB8_Alpha8_ETC2_EAC(37497),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGB8_ETC1</a></code></p>
         */
        RGB8_ETC1(36196),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>SRGB8</a></code></p>
         */
        SRGB8(35905),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>SRGB8_Alpha8</a></code></p>
         */
        SRGB8_Alpha8(35907),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>SRGB_DXT1</a></code></p>
         */
        SRGB_DXT1(35916),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>SRGB_Alpha_DXT1</a></code></p>
         */
        SRGB_Alpha_DXT1(35917),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>SRGB_Alpha_DXT3</a></code></p>
         */
        SRGB_Alpha_DXT3(35918),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>SRGB_Alpha_DXT5</a></code></p>
         */
        SRGB_Alpha_DXT5(35919),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>SRGB_BP_UNorm</a></code></p>
         */
        SRGB_BP_UNorm(36493),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>DepthFormat</a></code></p>
         */
        DepthFormat(6402),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>AlphaFormat</a></code></p>
         */
        AlphaFormat(6406),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBFormat</a></code></p>
         */
        RGBFormat(6407),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>RGBAFormat</a></code></p>
         */
        RGBAFormat(6408),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>LuminanceFormat</a></code></p>
         */
        LuminanceFormat(6409),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#TextureFormat-enum">Qt3DRender::<wbr/>QAbstractTexture::<wbr/>LuminanceAlphaFormat</a></code></p>
         */
        LuminanceAlphaFormat(6410);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private TextureFormat(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull TextureFormat resolve(int value) {
            switch (value) {
            case 0: return NoFormat;
            case 1: return Automatic;
            case 33321: return R8_UNorm;
            case 33323: return RG8_UNorm;
            case 32849: return RGB8_UNorm;
            case 32856: return RGBA8_UNorm;
            case 33322: return R16_UNorm;
            case 33324: return RG16_UNorm;
            case 32852: return RGB16_UNorm;
            case 32859: return RGBA16_UNorm;
            case 36756: return R8_SNorm;
            case 36757: return RG8_SNorm;
            case 36758: return RGB8_SNorm;
            case 36759: return RGBA8_SNorm;
            case 36760: return R16_SNorm;
            case 36761: return RG16_SNorm;
            case 36762: return RGB16_SNorm;
            case 36763: return RGBA16_SNorm;
            case 33330: return R8U;
            case 33336: return RG8U;
            case 36221: return RGB8U;
            case 36220: return RGBA8U;
            case 33332: return R16U;
            case 33338: return RG16U;
            case 36215: return RGB16U;
            case 36214: return RGBA16U;
            case 33334: return R32U;
            case 33340: return RG32U;
            case 36209: return RGB32U;
            case 36208: return RGBA32U;
            case 33329: return R8I;
            case 33335: return RG8I;
            case 36239: return RGB8I;
            case 36238: return RGBA8I;
            case 33331: return R16I;
            case 33337: return RG16I;
            case 36233: return RGB16I;
            case 36232: return RGBA16I;
            case 33333: return R32I;
            case 33339: return RG32I;
            case 36227: return RGB32I;
            case 36226: return RGBA32I;
            case 33325: return R16F;
            case 33327: return RG16F;
            case 34843: return RGB16F;
            case 34842: return RGBA16F;
            case 33326: return R32F;
            case 33328: return RG32F;
            case 34837: return RGB32F;
            case 34836: return RGBA32F;
            case 35901: return RGB9E5;
            case 35898: return RG11B10F;
            case 10768: return RG3B2;
            case 36194: return R5G6B5;
            case 32855: return RGB5A1;
            case 32854: return RGBA4;
            case 32857: return RGB10A2;
            case 36975: return RGB10A2U;
            case 33189: return D16;
            case 33190: return D24;
            case 35056: return D24S8;
            case 33191: return D32;
            case 36012: return D32F;
            case 36013: return D32FS8X24;
            case 33776: return RGB_DXT1;
            case 33777: return RGBA_DXT1;
            case 33778: return RGBA_DXT3;
            case 33779: return RGBA_DXT5;
            case 36283: return R_ATI1N_UNorm;
            case 36284: return R_ATI1N_SNorm;
            case 36285: return RG_ATI2N_UNorm;
            case 36286: return RG_ATI2N_SNorm;
            case 36495: return RGB_BP_UNSIGNED_FLOAT;
            case 36494: return RGB_BP_SIGNED_FLOAT;
            case 36492: return RGB_BP_UNorm;
            case 37488: return R11_EAC_UNorm;
            case 37489: return R11_EAC_SNorm;
            case 37490: return RG11_EAC_UNorm;
            case 37491: return RG11_EAC_SNorm;
            case 37492: return RGB8_ETC2;
            case 37493: return SRGB8_ETC2;
            case 37494: return RGB8_PunchThrough_Alpha1_ETC2;
            case 37495: return SRGB8_PunchThrough_Alpha1_ETC2;
            case 37496: return RGBA8_ETC2_EAC;
            case 37497: return SRGB8_Alpha8_ETC2_EAC;
            case 36196: return RGB8_ETC1;
            case 35905: return SRGB8;
            case 35907: return SRGB8_Alpha8;
            case 35916: return SRGB_DXT1;
            case 35917: return SRGB_Alpha_DXT1;
            case 35918: return SRGB_Alpha_DXT3;
            case 35919: return SRGB_Alpha_DXT5;
            case 36493: return SRGB_BP_UNorm;
            case 6402: return DepthFormat;
            case 6406: return AlphaFormat;
            case 6407: return RGBFormat;
            case 6408: return RGBAFormat;
            case 6409: return LuminanceFormat;
            case 6410: return LuminanceAlphaFormat;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#comparisonFunction-prop">Qt3DRender::QAbstractTexture::<wbr/>comparisonFunctionChanged(Qt3DRender::QAbstractTexture::ComparisonFunction)</a></code></p>
     */
    @QtPropertyNotify(name="comparisonFunction")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonFunction> comparisonFunctionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#comparisonMode-prop">Qt3DRender::QAbstractTexture::<wbr/>comparisonModeChanged(Qt3DRender::QAbstractTexture::ComparisonMode)</a></code></p>
     */
    @QtPropertyNotify(name="comparisonMode")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonMode> comparisonModeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#depth-prop">Qt3DRender::QAbstractTexture::<wbr/>depthChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="depth")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> depthChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#format-prop">Qt3DRender::QAbstractTexture::<wbr/>formatChanged(Qt3DRender::QAbstractTexture::TextureFormat)</a></code></p>
     */
    @QtPropertyNotify(name="format")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull TextureFormat> formatChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#generateMipMaps-prop">Qt3DRender::QAbstractTexture::<wbr/>generateMipMapsChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="generateMipMaps")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> generateMipMapsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#handle-prop">Qt3DRender::QAbstractTexture::<wbr/>handleChanged(QVariant)</a></code></p>
     */
    @QtPropertyNotify(name="handle")
    public final @NonNull Signal1<java.lang.Object> handleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#handleType-prop">Qt3DRender::QAbstractTexture::<wbr/>handleTypeChanged(Qt3DRender::QAbstractTexture::HandleType)</a></code></p>
     */
    @QtPropertyNotify(name="handleType")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull HandleType> handleTypeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#height-prop">Qt3DRender::QAbstractTexture::<wbr/>heightChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="height")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> heightChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#layers-prop">Qt3DRender::QAbstractTexture::<wbr/>layersChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="layers")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> layersChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#magnificationFilter-prop">Qt3DRender::QAbstractTexture::<wbr/>magnificationFilterChanged(Qt3DRender::QAbstractTexture::Filter)</a></code></p>
     */
    @QtPropertyNotify(name="magnificationFilter")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull Filter> magnificationFilterChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#maximumAnisotropy-prop">Qt3DRender::QAbstractTexture::<wbr/>maximumAnisotropyChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="maximumAnisotropy")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> maximumAnisotropyChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#minificationFilter-prop">Qt3DRender::QAbstractTexture::<wbr/>minificationFilterChanged(Qt3DRender::QAbstractTexture::Filter)</a></code></p>
     */
    @QtPropertyNotify(name="minificationFilter")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull Filter> minificationFilterChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#mipLevels-prop">Qt3DRender::QAbstractTexture::<wbr/>mipLevelsChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="mipLevels")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> mipLevelsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#samples-prop">Qt3DRender::QAbstractTexture::<wbr/>samplesChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="samples")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> samplesChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#status-prop">Qt3DRender::QAbstractTexture::<wbr/>statusChanged(Qt3DRender::QAbstractTexture::Status)</a></code></p>
     */
    @QtPropertyNotify(name="status")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull Status> statusChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#width-prop">Qt3DRender::QAbstractTexture::<wbr/>widthChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="width")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> widthChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#QAbstractTexture">Qt3DRender::QAbstractTexture::<wbr/>QAbstractTexture(Qt3DCore::QNode*)</a></code></p>
     */
    protected QAbstractTexture(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractTexture instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#QAbstractTexture-1">Qt3DRender::QAbstractTexture::<wbr/>QAbstractTexture(Qt3DRender::QAbstractTexture::Target,<wbr/>Qt3DCore::QNode*)</a></code></p>
     */
    protected QAbstractTexture(io.qt.qt3d.render.QAbstractTexture.@NonNull Target target, io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, target, parent);
    }
    
    private native static void initialize_native(QAbstractTexture instance, io.qt.qt3d.render.QAbstractTexture.Target target, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#addTextureImage">Qt3DRender::QAbstractTexture::<wbr/>addTextureImage(Qt3DRender::QAbstractTextureImage*)</a></code></p>
     */
    @QtUninvokable
    public final void addTextureImage(io.qt.qt3d.render.@Nullable QAbstractTextureImage textureImage){
        addTextureImage_native_Qt3DRender_QAbstractTextureImage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(textureImage));
    }
    
    @QtUninvokable
    private native void addTextureImage_native_Qt3DRender_QAbstractTextureImage_ptr(long __this__nativeId, long textureImage);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#comparisonFunction">Qt3DRender::QAbstractTexture::<wbr/>comparisonFunction()const</a></code></p>
     */
    @QtPropertyReader(name="comparisonFunction")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonFunction comparisonFunction(){
        return io.qt.qt3d.render.QAbstractTexture.ComparisonFunction.resolve(comparisonFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int comparisonFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#comparisonMode">Qt3DRender::QAbstractTexture::<wbr/>comparisonMode()const</a></code></p>
     */
    @QtPropertyReader(name="comparisonMode")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonMode comparisonMode(){
        return io.qt.qt3d.render.QAbstractTexture.ComparisonMode.resolve(comparisonMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int comparisonMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#depth">Qt3DRender::QAbstractTexture::<wbr/>depth()const</a></code></p>
     */
    @QtPropertyReader(name="depth")
    @QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#format">Qt3DRender::QAbstractTexture::<wbr/>format()const</a></code></p>
     */
    @QtPropertyReader(name="format")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull TextureFormat format(){
        return io.qt.qt3d.render.QAbstractTexture.TextureFormat.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#generateMipMaps-prop">Qt3DRender::QAbstractTexture::<wbr/>generateMipMaps()const</a></code></p>
     */
    @QtPropertyReader(name="generateMipMaps")
    @QtUninvokable
    public final boolean generateMipMaps(){
        return generateMipMaps_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean generateMipMaps_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#handle">Qt3DRender::QAbstractTexture::<wbr/>handle()const</a></code></p>
     */
    @QtPropertyReader(name="handle")
    @QtUninvokable
    public final java.lang.Object handle(){
        return handle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object handle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#handleType">Qt3DRender::QAbstractTexture::<wbr/>handleType()const</a></code></p>
     */
    @QtPropertyReader(name="handleType")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull HandleType handleType(){
        return io.qt.qt3d.render.QAbstractTexture.HandleType.resolve(handleType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int handleType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#height">Qt3DRender::QAbstractTexture::<wbr/>height()const</a></code></p>
     */
    @QtPropertyReader(name="height")
    @QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#layers">Qt3DRender::QAbstractTexture::<wbr/>layers()const</a></code></p>
     */
    @QtPropertyReader(name="layers")
    @QtUninvokable
    public final int layers(){
        return layers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int layers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#magnificationFilter-prop">Qt3DRender::QAbstractTexture::<wbr/>magnificationFilter()const</a></code></p>
     */
    @QtPropertyReader(name="magnificationFilter")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Filter magnificationFilter(){
        return io.qt.qt3d.render.QAbstractTexture.Filter.resolve(magnificationFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int magnificationFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#maximumAnisotropy">Qt3DRender::QAbstractTexture::<wbr/>maximumAnisotropy()const</a></code></p>
     */
    @QtPropertyReader(name="maximumAnisotropy")
    @QtUninvokable
    public final float maximumAnisotropy(){
        return maximumAnisotropy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maximumAnisotropy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#minificationFilter-prop">Qt3DRender::QAbstractTexture::<wbr/>minificationFilter()const</a></code></p>
     */
    @QtPropertyReader(name="minificationFilter")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Filter minificationFilter(){
        return io.qt.qt3d.render.QAbstractTexture.Filter.resolve(minificationFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int minificationFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#mipLevels-prop">Qt3DRender::QAbstractTexture::<wbr/>mipLevels()const</a></code></p>
     */
    @QtPropertyReader(name="mipLevels")
    @QtUninvokable
    public final int mipLevels(){
        return mipLevels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int mipLevels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#removeTextureImage">Qt3DRender::QAbstractTexture::<wbr/>removeTextureImage(Qt3DRender::QAbstractTextureImage*)</a></code></p>
     */
    @QtUninvokable
    public final void removeTextureImage(io.qt.qt3d.render.@Nullable QAbstractTextureImage textureImage){
        removeTextureImage_native_Qt3DRender_QAbstractTextureImage_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(textureImage));
    }
    
    @QtUninvokable
    private native void removeTextureImage_native_Qt3DRender_QAbstractTextureImage_ptr(long __this__nativeId, long textureImage);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#samples">Qt3DRender::QAbstractTexture::<wbr/>samples()const</a></code></p>
     */
    @QtPropertyReader(name="samples")
    @QtUninvokable
    public final int samples(){
        return samples_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int samples_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setComparisonFunction">Qt3DRender::QAbstractTexture::<wbr/>setComparisonFunction(Qt3DRender::QAbstractTexture::ComparisonFunction)</a></code></p>
     */
    @QtPropertyWriter(name="comparisonFunction")
    public final void setComparisonFunction(io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonFunction function){
        setComparisonFunction_native_Qt3DRender_QAbstractTexture_ComparisonFunction(QtJambi_LibraryUtilities.internal.nativeId(this), function.value());
    }
    
    private native void setComparisonFunction_native_Qt3DRender_QAbstractTexture_ComparisonFunction(long __this__nativeId, int function);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setComparisonMode">Qt3DRender::QAbstractTexture::<wbr/>setComparisonMode(Qt3DRender::QAbstractTexture::ComparisonMode)</a></code></p>
     */
    @QtPropertyWriter(name="comparisonMode")
    public final void setComparisonMode(io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonMode mode){
        setComparisonMode_native_Qt3DRender_QAbstractTexture_ComparisonMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setComparisonMode_native_Qt3DRender_QAbstractTexture_ComparisonMode(long __this__nativeId, int mode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setDepth">Qt3DRender::QAbstractTexture::<wbr/>setDepth(int)</a></code></p>
     */
    @QtPropertyWriter(name="depth")
    public final void setDepth(int depth){
        setDepth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    private native void setDepth_native_int(long __this__nativeId, int depth);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setFormat">Qt3DRender::QAbstractTexture::<wbr/>setFormat(Qt3DRender::QAbstractTexture::TextureFormat)</a></code></p>
     */
    @QtPropertyWriter(name="format")
    public final void setFormat(io.qt.qt3d.render.QAbstractTexture.@NonNull TextureFormat format){
        setFormat_native_Qt3DRender_QAbstractTexture_TextureFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    private native void setFormat_native_Qt3DRender_QAbstractTexture_TextureFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setGenerateMipMaps">Qt3DRender::QAbstractTexture::<wbr/>setGenerateMipMaps(bool)</a></code></p>
     */
    @QtPropertyWriter(name="generateMipMaps")
    public final void setGenerateMipMaps(boolean gen){
        setGenerateMipMaps_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), gen);
    }
    
    private native void setGenerateMipMaps_native_bool(long __this__nativeId, boolean gen);
    
    /**
     * <p>See <code>Qt3DRender::QAbstractTexture::<wbr/>setHandle(QVariant)</code></p>
     */
    @QtUninvokable
    protected final void setHandle(java.lang.Object handle){
        setHandle_native_cref_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), handle);
    }
    
    @QtUninvokable
    private native void setHandle_native_cref_QVariant(long __this__nativeId, java.lang.Object handle);
    
    /**
     * <p>See <code>Qt3DRender::QAbstractTexture::<wbr/>setHandleType(Qt3DRender::QAbstractTexture::HandleType)</code></p>
     */
    @QtUninvokable
    protected final void setHandleType(io.qt.qt3d.render.QAbstractTexture.@NonNull HandleType type){
        setHandleType_native_Qt3DRender_QAbstractTexture_HandleType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native void setHandleType_native_Qt3DRender_QAbstractTexture_HandleType(long __this__nativeId, int type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setHeight">Qt3DRender::QAbstractTexture::<wbr/>setHeight(int)</a></code></p>
     */
    @QtPropertyWriter(name="height")
    public final void setHeight(int height){
        setHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), height);
    }
    
    private native void setHeight_native_int(long __this__nativeId, int height);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setLayers">Qt3DRender::QAbstractTexture::<wbr/>setLayers(int)</a></code></p>
     */
    @QtPropertyWriter(name="layers")
    public final void setLayers(int layers){
        setLayers_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layers);
    }
    
    private native void setLayers_native_int(long __this__nativeId, int layers);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setMagnificationFilter">Qt3DRender::QAbstractTexture::<wbr/>setMagnificationFilter(Qt3DRender::QAbstractTexture::Filter)</a></code></p>
     */
    @QtPropertyWriter(name="magnificationFilter")
    public final void setMagnificationFilter(io.qt.qt3d.render.QAbstractTexture.@NonNull Filter f){
        setMagnificationFilter_native_Qt3DRender_QAbstractTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), f.value());
    }
    
    private native void setMagnificationFilter_native_Qt3DRender_QAbstractTexture_Filter(long __this__nativeId, int f);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setMaximumAnisotropy">Qt3DRender::QAbstractTexture::<wbr/>setMaximumAnisotropy(float)</a></code></p>
     */
    @QtPropertyWriter(name="maximumAnisotropy")
    public final void setMaximumAnisotropy(float anisotropy){
        setMaximumAnisotropy_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), anisotropy);
    }
    
    private native void setMaximumAnisotropy_native_float(long __this__nativeId, float anisotropy);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setMinificationFilter">Qt3DRender::QAbstractTexture::<wbr/>setMinificationFilter(Qt3DRender::QAbstractTexture::Filter)</a></code></p>
     */
    @QtPropertyWriter(name="minificationFilter")
    public final void setMinificationFilter(io.qt.qt3d.render.QAbstractTexture.@NonNull Filter f){
        setMinificationFilter_native_Qt3DRender_QAbstractTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), f.value());
    }
    
    private native void setMinificationFilter_native_Qt3DRender_QAbstractTexture_Filter(long __this__nativeId, int f);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#mipLevels-prop">Qt3DRender::QAbstractTexture::<wbr/>setMipLevels(int)</a></code></p>
     */
    @QtPropertyWriter(name="mipLevels")
    public final void setMipLevels(int mipLevels){
        setMipLevels_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevels);
    }
    
    private native void setMipLevels_native_int(long __this__nativeId, int mipLevels);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setSamples">Qt3DRender::QAbstractTexture::<wbr/>setSamples(int)</a></code></p>
     */
    @QtPropertyWriter(name="samples")
    public final void setSamples(int samples){
        setSamples_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), samples);
    }
    
    private native void setSamples_native_int(long __this__nativeId, int samples);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setSize">Qt3DRender::QAbstractTexture::<wbr/>setSize(int,<wbr/>int,<wbr/>int)</a></code></p>
     */
    @QtUninvokable
    public final void setSize(int width, int height, int depth){
        setSize_native_int_int_int(QtJambi_LibraryUtilities.internal.nativeId(this), width, height, depth);
    }
    
    @QtUninvokable
    private native void setSize_native_int_int_int(long __this__nativeId, int width, int height, int depth);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setStatus">Qt3DRender::QAbstractTexture::<wbr/>setStatus(Qt3DRender::QAbstractTexture::Status)</a></code></p>
     */
    @QtUninvokable
    protected final void setStatus(io.qt.qt3d.render.QAbstractTexture.@NonNull Status status){
        setStatus_native_Qt3DRender_QAbstractTexture_Status(QtJambi_LibraryUtilities.internal.nativeId(this), status.value());
    }
    
    @QtUninvokable
    private native void setStatus_native_Qt3DRender_QAbstractTexture_Status(long __this__nativeId, int status);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setWidth">Qt3DRender::QAbstractTexture::<wbr/>setWidth(int)</a></code></p>
     */
    @QtPropertyWriter(name="width")
    public final void setWidth(int width){
        setWidth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    private native void setWidth_native_int(long __this__nativeId, int width);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#setWrapMode">Qt3DRender::QAbstractTexture::<wbr/>setWrapMode(Qt3DRender::QTextureWrapMode)</a></code></p>
     */
    @QtUninvokable
    public final void setWrapMode(io.qt.qt3d.render.@StrictNonNull QTextureWrapMode wrapMode){
        java.util.Objects.requireNonNull(wrapMode, "Argument 'wrapMode': null not expected.");
        setWrapMode_native_cref_Qt3DRender_QTextureWrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(wrapMode));
    }
    
    @QtUninvokable
    private native void setWrapMode_native_cref_Qt3DRender_QTextureWrapMode(long __this__nativeId, long wrapMode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#status">Qt3DRender::QAbstractTexture::<wbr/>status()const</a></code></p>
     */
    @QtPropertyReader(name="status")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Status status(){
        return io.qt.qt3d.render.QAbstractTexture.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#target">Qt3DRender::QAbstractTexture::<wbr/>target()const</a></code></p>
     */
    @QtPropertyReader(name="target")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Target target(){
        return io.qt.qt3d.render.QAbstractTexture.Target.resolve(target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#textureImages">Qt3DRender::QAbstractTexture::<wbr/>textureImages()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QAbstractTextureImage> textureImages(){
        return textureImages_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QAbstractTextureImage> textureImages_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#updateData">Qt3DRender::QAbstractTexture::<wbr/>updateData(Qt3DRender::QTextureDataUpdate)</a></code></p>
     */
    public final void updateData(io.qt.qt3d.render.@NonNull QTextureDataUpdate update){
        updateData_native_cref_Qt3DRender_QTextureDataUpdate(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(update));
    }
    
    private native void updateData_native_cref_Qt3DRender_QTextureDataUpdate(long __this__nativeId, long update);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#width">Qt3DRender::QAbstractTexture::<wbr/>width()const</a></code></p>
     */
    @QtPropertyReader(name="width")
    @QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttexture.html#wrapMode-prop">Qt3DRender::QAbstractTexture::<wbr/>wrapMode()</a></code></p>
     */
    @QtPropertyReader(name="wrapMode")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QTextureWrapMode wrapMode(){
        return wrapMode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QTextureWrapMode wrapMode_native(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractTexture(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAbstractTexture(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractTexture instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractTexture(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    protected QAbstractTexture() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractTexture(io.qt.qt3d.render.QAbstractTexture.Target, io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    protected QAbstractTexture(io.qt.qt3d.render.QAbstractTexture.@NonNull Target target) {
        this(target, (io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #comparisonFunction()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonFunction getComparisonFunction() {
        return comparisonFunction();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #comparisonMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonMode getComparisonMode() {
        return comparisonMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #depth()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getDepth() {
        return depth();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #format()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull TextureFormat getFormat() {
        return format();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #generateMipMaps()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getGenerateMipMaps() {
        return generateMipMaps();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #handle()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.Object getHandle() {
        return handle();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #handleType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull HandleType getHandleType() {
        return handleType();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #height()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getHeight() {
        return height();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #layers()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLayers() {
        return layers();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #magnificationFilter()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Filter getMagnificationFilter() {
        return magnificationFilter();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #maximumAnisotropy()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getMaximumAnisotropy() {
        return maximumAnisotropy();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #minificationFilter()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Filter getMinificationFilter() {
        return minificationFilter();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #mipLevels()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMipLevels() {
        return mipLevels();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #samples()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getSamples() {
        return samples();
    }
    
    /**
     * <p>Overloaded function for {@link #setSize(int, int, int)}
     *  with <code>depth = 1</code>.</p>
     */
    @QtUninvokable
    public final void setSize(int width, int height) {
        setSize(width, height, (int)1);
    }
    
    /**
     * <p>Overloaded function for {@link #setSize(int, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>height = 1</code></li>
     * <li><code>depth = 1</code></li>
     * </ul>
     */
    @QtUninvokable
    public final void setSize(int width) {
        setSize(width, (int)1, (int)1);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Status getStatus() {
        return status();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #target()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Target getTarget() {
        return target();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #width()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWidth() {
        return width();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #wrapMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QTextureWrapMode getWrapMode() {
        return wrapMode();
    }
}
