package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Generates a Shader Program content from loaded graphs</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html">Qt3DRender::QShaderProgramBuilder</a></code></p>
 */
public class QShaderProgramBuilder extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QShaderProgramBuilder.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#computeShaderCode-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>computeShaderCodeChanged(QByteArray)</a></code></p>
     */
    @QtPropertyNotify(name="computeShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> computeShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#computeShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>computeShaderGraphChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="computeShaderGraph")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> computeShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#enabledLayers-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>enabledLayersChanged(QStringList)</a></code></p>
     */
    @QtPropertyNotify(name="enabledLayers")
    public final @NonNull Signal1<java.util.@NonNull List<java.lang.@NonNull String>> enabledLayersChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#fragmentShaderCode-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>fragmentShaderCodeChanged(QByteArray)</a></code></p>
     */
    @QtPropertyNotify(name="fragmentShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> fragmentShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#fragmentShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>fragmentShaderGraphChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="fragmentShaderGraph")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> fragmentShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#geometryShaderCode-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>geometryShaderCodeChanged(QByteArray)</a></code></p>
     */
    @QtPropertyNotify(name="geometryShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> geometryShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#geometryShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>geometryShaderGraphChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="geometryShaderGraph")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> geometryShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#shaderProgram-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>shaderProgramChanged(Qt3DRender::QShaderProgram*)</a></code></p>
     */
    @QtPropertyNotify(name="shaderProgram")
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QShaderProgram> shaderProgramChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderCode-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>tessellationControlShaderCodeChanged(QByteArray)</a></code></p>
     */
    @QtPropertyNotify(name="tessellationControlShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> tessellationControlShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>tessellationControlShaderGraphChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="tessellationControlShaderGraph")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> tessellationControlShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderCode-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>tessellationEvaluationShaderCodeChanged(QByteArray)</a></code></p>
     */
    @QtPropertyNotify(name="tessellationEvaluationShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> tessellationEvaluationShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>tessellationEvaluationShaderGraphChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="tessellationEvaluationShaderGraph")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> tessellationEvaluationShaderGraphChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#vertexShaderCode-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>vertexShaderCodeChanged(QByteArray)</a></code></p>
     */
    @QtPropertyNotify(name="vertexShaderCode")
    public final @NonNull Signal1<io.qt.core.@NonNull QByteArray> vertexShaderCodeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#vertexShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>vertexShaderGraphChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="vertexShaderGraph")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> vertexShaderGraphChanged = new Signal1<>();
    
    /**
     * <p>See <code>Qt3DRender::QShaderProgramBuilder::<wbr/>QShaderProgramBuilder(Qt3DCore::QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QShaderProgramBuilder(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QShaderProgramBuilder instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#computeShaderCode-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>computeShaderCode()const</a></code></p>
     */
    @QtPropertyReader(name="computeShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray computeShaderCode(){
        return computeShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray computeShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#computeShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>computeShaderGraph()const</a></code></p>
     */
    @QtPropertyReader(name="computeShaderGraph")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl computeShaderGraph(){
        return computeShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl computeShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#enabledLayers-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>enabledLayers()const</a></code></p>
     */
    @QtPropertyReader(name="enabledLayers")
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList enabledLayers(){
        return enabledLayers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList enabledLayers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#fragmentShaderCode-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>fragmentShaderCode()const</a></code></p>
     */
    @QtPropertyReader(name="fragmentShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray fragmentShaderCode(){
        return fragmentShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray fragmentShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#fragmentShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>fragmentShaderGraph()const</a></code></p>
     */
    @QtPropertyReader(name="fragmentShaderGraph")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl fragmentShaderGraph(){
        return fragmentShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl fragmentShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#geometryShaderCode-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>geometryShaderCode()const</a></code></p>
     */
    @QtPropertyReader(name="geometryShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray geometryShaderCode(){
        return geometryShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray geometryShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#geometryShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>geometryShaderGraph()const</a></code></p>
     */
    @QtPropertyReader(name="geometryShaderGraph")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl geometryShaderGraph(){
        return geometryShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl geometryShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#computeShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>setComputeShaderGraph(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="computeShaderGraph")
    public final void setComputeShaderGraph(io.qt.core.@NonNull QUrl computeShaderGraph){
        setComputeShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(computeShaderGraph));
    }
    
    private native void setComputeShaderGraph_native_cref_QUrl(long __this__nativeId, long computeShaderGraph);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#enabledLayers-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>setEnabledLayers(QStringList)</a></code></p>
     */
    @QtPropertyWriter(name="enabledLayers")
    public final void setEnabledLayers(java.util.@NonNull Collection<java.lang.@NonNull String> layers){
        setEnabledLayers_native_cref_QStringList(QtJambi_LibraryUtilities.internal.nativeId(this), layers);
    }
    
    private native void setEnabledLayers_native_cref_QStringList(long __this__nativeId, java.util.Collection<java.lang.String> layers);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#fragmentShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>setFragmentShaderGraph(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="fragmentShaderGraph")
    public final void setFragmentShaderGraph(io.qt.core.@NonNull QUrl fragmentShaderGraph){
        setFragmentShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(fragmentShaderGraph));
    }
    
    private native void setFragmentShaderGraph_native_cref_QUrl(long __this__nativeId, long fragmentShaderGraph);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#geometryShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>setGeometryShaderGraph(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="geometryShaderGraph")
    public final void setGeometryShaderGraph(io.qt.core.@NonNull QUrl geometryShaderGraph){
        setGeometryShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(geometryShaderGraph));
    }
    
    private native void setGeometryShaderGraph_native_cref_QUrl(long __this__nativeId, long geometryShaderGraph);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#shaderProgram-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>setShaderProgram(Qt3DRender::QShaderProgram*)</a></code></p>
     */
    @QtPropertyWriter(name="shaderProgram")
    public final void setShaderProgram(io.qt.qt3d.render.@Nullable QShaderProgram program){
        setShaderProgram_native_Qt3DRender_QShaderProgram_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(program));
    }
    
    private native void setShaderProgram_native_Qt3DRender_QShaderProgram_ptr(long __this__nativeId, long program);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>setTessellationControlShaderGraph(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="tessellationControlShaderGraph")
    public final void setTessellationControlShaderGraph(io.qt.core.@NonNull QUrl tessellationControlShaderGraph){
        setTessellationControlShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tessellationControlShaderGraph));
    }
    
    private native void setTessellationControlShaderGraph_native_cref_QUrl(long __this__nativeId, long tessellationControlShaderGraph);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>setTessellationEvaluationShaderGraph(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="tessellationEvaluationShaderGraph")
    public final void setTessellationEvaluationShaderGraph(io.qt.core.@NonNull QUrl tessellationEvaluationShaderGraph){
        setTessellationEvaluationShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(tessellationEvaluationShaderGraph));
    }
    
    private native void setTessellationEvaluationShaderGraph_native_cref_QUrl(long __this__nativeId, long tessellationEvaluationShaderGraph);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#vertexShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>setVertexShaderGraph(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="vertexShaderGraph")
    public final void setVertexShaderGraph(io.qt.core.@NonNull QUrl vertexShaderGraph){
        setVertexShaderGraph_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(vertexShaderGraph));
    }
    
    private native void setVertexShaderGraph_native_cref_QUrl(long __this__nativeId, long vertexShaderGraph);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#shaderProgram-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>shaderProgram()const</a></code></p>
     */
    @QtPropertyReader(name="shaderProgram")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QShaderProgram shaderProgram(){
        return shaderProgram_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QShaderProgram shaderProgram_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderCode-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>tessellationControlShaderCode()const</a></code></p>
     */
    @QtPropertyReader(name="tessellationControlShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray tessellationControlShaderCode(){
        return tessellationControlShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray tessellationControlShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationControlShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>tessellationControlShaderGraph()const</a></code></p>
     */
    @QtPropertyReader(name="tessellationControlShaderGraph")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl tessellationControlShaderGraph(){
        return tessellationControlShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl tessellationControlShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderCode-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>tessellationEvaluationShaderCode()const</a></code></p>
     */
    @QtPropertyReader(name="tessellationEvaluationShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray tessellationEvaluationShaderCode(){
        return tessellationEvaluationShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray tessellationEvaluationShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#tessellationEvaluationShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>tessellationEvaluationShaderGraph()const</a></code></p>
     */
    @QtPropertyReader(name="tessellationEvaluationShaderGraph")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl tessellationEvaluationShaderGraph(){
        return tessellationEvaluationShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl tessellationEvaluationShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#vertexShaderCode-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>vertexShaderCode()const</a></code></p>
     */
    @QtPropertyReader(name="vertexShaderCode")
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray vertexShaderCode(){
        return vertexShaderCode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray vertexShaderCode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qshaderprogrambuilder.html#vertexShaderGraph-prop">Qt3DRender::QShaderProgramBuilder::<wbr/>vertexShaderGraph()const</a></code></p>
     */
    @QtPropertyReader(name="vertexShaderGraph")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl vertexShaderGraph(){
        return vertexShaderGraph_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl vertexShaderGraph_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QShaderProgramBuilder(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QShaderProgramBuilder(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QShaderProgramBuilder instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QShaderProgramBuilder(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QShaderProgramBuilder() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #computeShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getComputeShaderCode() {
        return computeShaderCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #computeShaderGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getComputeShaderGraph() {
        return computeShaderGraph();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #enabledLayers()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getEnabledLayers() {
        return enabledLayers();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #fragmentShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getFragmentShaderCode() {
        return fragmentShaderCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #fragmentShaderGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getFragmentShaderGraph() {
        return fragmentShaderGraph();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #geometryShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getGeometryShaderCode() {
        return geometryShaderCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #geometryShaderGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getGeometryShaderGraph() {
        return geometryShaderGraph();
    }
    
    /**
     * <p>Overloaded function for {@link #setComputeShaderGraph(io.qt.core.QUrl)}.</p>
     */
    public final void setComputeShaderGraph(java.lang.@NonNull String computeShaderGraph) {
        setComputeShaderGraph(new io.qt.core.QUrl(computeShaderGraph));
    }
    
    /**
     * <p>Overloaded function for {@link #setFragmentShaderGraph(io.qt.core.QUrl)}.</p>
     */
    public final void setFragmentShaderGraph(java.lang.@NonNull String fragmentShaderGraph) {
        setFragmentShaderGraph(new io.qt.core.QUrl(fragmentShaderGraph));
    }
    
    /**
     * <p>Overloaded function for {@link #setGeometryShaderGraph(io.qt.core.QUrl)}.</p>
     */
    public final void setGeometryShaderGraph(java.lang.@NonNull String geometryShaderGraph) {
        setGeometryShaderGraph(new io.qt.core.QUrl(geometryShaderGraph));
    }
    
    /**
     * <p>Overloaded function for {@link #setTessellationControlShaderGraph(io.qt.core.QUrl)}.</p>
     */
    public final void setTessellationControlShaderGraph(java.lang.@NonNull String tessellationControlShaderGraph) {
        setTessellationControlShaderGraph(new io.qt.core.QUrl(tessellationControlShaderGraph));
    }
    
    /**
     * <p>Overloaded function for {@link #setTessellationEvaluationShaderGraph(io.qt.core.QUrl)}.</p>
     */
    public final void setTessellationEvaluationShaderGraph(java.lang.@NonNull String tessellationEvaluationShaderGraph) {
        setTessellationEvaluationShaderGraph(new io.qt.core.QUrl(tessellationEvaluationShaderGraph));
    }
    
    /**
     * <p>Overloaded function for {@link #setVertexShaderGraph(io.qt.core.QUrl)}.</p>
     */
    public final void setVertexShaderGraph(java.lang.@NonNull String vertexShaderGraph) {
        setVertexShaderGraph(new io.qt.core.QUrl(vertexShaderGraph));
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #shaderProgram()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QShaderProgram getShaderProgram() {
        return shaderProgram();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #tessellationControlShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getTessellationControlShaderCode() {
        return tessellationControlShaderCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #tessellationControlShaderGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getTessellationControlShaderGraph() {
        return tessellationControlShaderGraph();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #tessellationEvaluationShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getTessellationEvaluationShaderCode() {
        return tessellationEvaluationShaderCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #tessellationEvaluationShaderGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getTessellationEvaluationShaderGraph() {
        return tessellationEvaluationShaderGraph();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #vertexShaderCode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray getVertexShaderCode() {
        return vertexShaderCode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #vertexShaderGraph()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getVertexShaderGraph() {
        return vertexShaderGraph();
    }
}
