package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Allows the specification of an attachment of a render target (whether it is a color texture, a depth texture, etc... )</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html">Qt3DRender::QRenderTargetOutput</a></code></p>
 */
public class QRenderTargetOutput extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderTargetOutput.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::QRenderTargetOutput::AttachmentPoint</a></code></p>
     */
    public enum AttachmentPoint implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color0</a></code></p>
         */
        Color0(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color1</a></code></p>
         */
        Color1(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color2</a></code></p>
         */
        Color2(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color3</a></code></p>
         */
        Color3(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color4</a></code></p>
         */
        Color4(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color5</a></code></p>
         */
        Color5(5),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color6</a></code></p>
         */
        Color6(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color7</a></code></p>
         */
        Color7(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color8</a></code></p>
         */
        Color8(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color9</a></code></p>
         */
        Color9(9),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color10</a></code></p>
         */
        Color10(10),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color11</a></code></p>
         */
        Color11(11),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color12</a></code></p>
         */
        Color12(12),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color13</a></code></p>
         */
        Color13(13),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color14</a></code></p>
         */
        Color14(14),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Color15</a></code></p>
         */
        Color15(15),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Depth</a></code></p>
         */
        Depth(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Stencil</a></code></p>
         */
        Stencil(17),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>DepthStencil</a></code></p>
         */
        DepthStencil(18),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Left</a></code></p>
         */
        Left(19),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#AttachmentPoint-enum">Qt3DRender::<wbr/>QRenderTargetOutput::<wbr/>Right</a></code></p>
         */
        Right(20);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private AttachmentPoint(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull AttachmentPoint resolve(int value) {
            switch (value) {
            case 0: return Color0;
            case 1: return Color1;
            case 2: return Color2;
            case 3: return Color3;
            case 4: return Color4;
            case 5: return Color5;
            case 6: return Color6;
            case 7: return Color7;
            case 8: return Color8;
            case 9: return Color9;
            case 10: return Color10;
            case 11: return Color11;
            case 12: return Color12;
            case 13: return Color13;
            case 14: return Color14;
            case 15: return Color15;
            case 16: return Depth;
            case 17: return Stencil;
            case 18: return DepthStencil;
            case 19: return Left;
            case 20: return Right;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#attachmentPoint-prop">Qt3DRender::QRenderTargetOutput::<wbr/>attachmentPointChanged(Qt3DRender::QRenderTargetOutput::AttachmentPoint)</a></code></p>
     */
    @QtPropertyNotify(name="attachmentPoint")
    public final @NonNull Signal1<io.qt.qt3d.render.QRenderTargetOutput.@NonNull AttachmentPoint> attachmentPointChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#face-prop">Qt3DRender::QRenderTargetOutput::<wbr/>faceChanged(Qt3DRender::QAbstractTexture::CubeMapFace)</a></code></p>
     */
    @QtPropertyNotify(name="face")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull CubeMapFace> faceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#layer-prop">Qt3DRender::QRenderTargetOutput::<wbr/>layerChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="layer")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> layerChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#mipLevel-prop">Qt3DRender::QRenderTargetOutput::<wbr/>mipLevelChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="mipLevel")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> mipLevelChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#texture-prop">Qt3DRender::QRenderTargetOutput::<wbr/>textureChanged(Qt3DRender::QAbstractTexture*)</a></code></p>
     */
    @QtPropertyNotify(name="texture")
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QAbstractTexture> textureChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#QRenderTargetOutput">Qt3DRender::QRenderTargetOutput::<wbr/>QRenderTargetOutput(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QRenderTargetOutput(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderTargetOutput instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#attachmentPoint-prop">Qt3DRender::QRenderTargetOutput::<wbr/>attachmentPoint()const</a></code></p>
     */
    @QtPropertyReader(name="attachmentPoint")
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderTargetOutput.@NonNull AttachmentPoint attachmentPoint(){
        return io.qt.qt3d.render.QRenderTargetOutput.AttachmentPoint.resolve(attachmentPoint_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int attachmentPoint_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#face-prop">Qt3DRender::QRenderTargetOutput::<wbr/>face()const</a></code></p>
     */
    @QtPropertyReader(name="face")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull CubeMapFace face(){
        return io.qt.qt3d.render.QAbstractTexture.CubeMapFace.resolve(face_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int face_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#layer-prop">Qt3DRender::QRenderTargetOutput::<wbr/>layer()const</a></code></p>
     */
    @QtPropertyReader(name="layer")
    @QtUninvokable
    public final int layer(){
        return layer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int layer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#mipLevel-prop">Qt3DRender::QRenderTargetOutput::<wbr/>mipLevel()const</a></code></p>
     */
    @QtPropertyReader(name="mipLevel")
    @QtUninvokable
    public final int mipLevel(){
        return mipLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int mipLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#attachmentPoint-prop">Qt3DRender::QRenderTargetOutput::<wbr/>setAttachmentPoint(Qt3DRender::QRenderTargetOutput::AttachmentPoint)</a></code></p>
     */
    @QtPropertyWriter(name="attachmentPoint")
    public final void setAttachmentPoint(io.qt.qt3d.render.QRenderTargetOutput.@NonNull AttachmentPoint attachmentPoint){
        setAttachmentPoint_native_Qt3DRender_QRenderTargetOutput_AttachmentPoint(QtJambi_LibraryUtilities.internal.nativeId(this), attachmentPoint.value());
    }
    
    private native void setAttachmentPoint_native_Qt3DRender_QRenderTargetOutput_AttachmentPoint(long __this__nativeId, int attachmentPoint);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#face-prop">Qt3DRender::QRenderTargetOutput::<wbr/>setFace(Qt3DRender::QAbstractTexture::CubeMapFace)</a></code></p>
     */
    @QtPropertyWriter(name="face")
    public final void setFace(io.qt.qt3d.render.QAbstractTexture.@NonNull CubeMapFace face){
        setFace_native_Qt3DRender_QAbstractTexture_CubeMapFace(QtJambi_LibraryUtilities.internal.nativeId(this), face.value());
    }
    
    private native void setFace_native_Qt3DRender_QAbstractTexture_CubeMapFace(long __this__nativeId, int face);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#layer-prop">Qt3DRender::QRenderTargetOutput::<wbr/>setLayer(int)</a></code></p>
     */
    @QtPropertyWriter(name="layer")
    public final void setLayer(int layer){
        setLayer_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layer);
    }
    
    private native void setLayer_native_int(long __this__nativeId, int layer);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#mipLevel-prop">Qt3DRender::QRenderTargetOutput::<wbr/>setMipLevel(int)</a></code></p>
     */
    @QtPropertyWriter(name="mipLevel")
    public final void setMipLevel(int level){
        setMipLevel_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), level);
    }
    
    private native void setMipLevel_native_int(long __this__nativeId, int level);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#texture-prop">Qt3DRender::QRenderTargetOutput::<wbr/>setTexture(Qt3DRender::QAbstractTexture*)</a></code></p>
     */
    @QtPropertyWriter(name="texture")
    public final void setTexture(io.qt.qt3d.render.@Nullable QAbstractTexture texture){
        setTexture_native_Qt3DRender_QAbstractTexture_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(texture));
    }
    
    private native void setTexture_native_Qt3DRender_QAbstractTexture_ptr(long __this__nativeId, long texture);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertargetoutput.html#texture-prop">Qt3DRender::QRenderTargetOutput::<wbr/>texture()const</a></code></p>
     */
    @QtPropertyReader(name="texture")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QAbstractTexture texture(){
        return texture_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QAbstractTexture texture_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRenderTargetOutput(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QRenderTargetOutput(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRenderTargetOutput instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRenderTargetOutput(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderTargetOutput() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #attachmentPoint()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderTargetOutput.@NonNull AttachmentPoint getAttachmentPoint() {
        return attachmentPoint();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #face()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull CubeMapFace getFace() {
        return face();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #layer()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLayer() {
        return layer();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #mipLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMipLevel() {
        return mipLevel();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #texture()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QAbstractTexture getTexture() {
        return texture();
    }
}
