package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Qt3DRender::QRayCaster is used to perform ray casting tests in 3d world coordinates</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qraycaster.html">Qt3DRender::QRayCaster</a></code></p>
 */
public class QRayCaster extends io.qt.qt3d.render.QAbstractRayCaster
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRayCaster.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qraycaster.html#direction-prop">Qt3DRender::QRayCaster::<wbr/>directionChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="direction")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> directionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qraycaster.html#length-prop">Qt3DRender::QRayCaster::<wbr/>lengthChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="length")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> lengthChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qraycaster.html#origin-prop">Qt3DRender::QRayCaster::<wbr/>originChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="origin")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> originChanged = new Signal1<>();
    
    /**
     * <p>See <code>Qt3DRender::QRayCaster::<wbr/>QRayCaster(QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QRayCaster(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRayCaster instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qraycaster.html#direction-prop">Qt3DRender::QRayCaster::<wbr/>direction()const</a></code></p>
     */
    @QtPropertyReader(name="direction")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D direction(){
        return direction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D direction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qraycaster.html#length-prop">Qt3DRender::QRayCaster::<wbr/>length()const</a></code></p>
     */
    @QtPropertyReader(name="length")
    @QtUninvokable
    public final float length(){
        return length_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float length_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qraycaster.html#origin-prop">Qt3DRender::QRayCaster::<wbr/>origin()const</a></code></p>
     */
    @QtPropertyReader(name="origin")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D origin(){
        return origin_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D origin_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>Qt3DRender::QRayCaster::<wbr/>pick(QVector3D,<wbr/>QVector3D,<wbr/>float)</code></p>
     */
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@NonNull QRayCasterHit> pick(io.qt.gui.@NonNull QVector3D origin, io.qt.gui.@NonNull QVector3D direction, float length){
        return pick_native_cref_QVector3D_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(origin), QtJambi_LibraryUtilities.internal.checkedNativeId(direction), length);
    }
    
    private native io.qt.core.QList<io.qt.qt3d.render.QRayCasterHit> pick_native_cref_QVector3D_cref_QVector3D_float(long __this__nativeId, long origin, long direction, float length);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qraycaster.html#direction-prop">Qt3DRender::QRayCaster::<wbr/>setDirection(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="direction")
    public final void setDirection(io.qt.gui.@NonNull QVector3D direction){
        setDirection_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(direction));
    }
    
    private native void setDirection_native_cref_QVector3D(long __this__nativeId, long direction);
    
    /**
     * <p>Sets the length of the ray to length</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qraycaster.html#setLength">Qt3DRender::QRayCaster::<wbr/>setLength(float)</a></code></p>
     */
    @QtPropertyWriter(name="length")
    public final void setLength(float length){
        setLength_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), length);
    }
    
    private native void setLength_native_float(long __this__nativeId, float length);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qraycaster.html#origin-prop">Qt3DRender::QRayCaster::<wbr/>setOrigin(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="origin")
    public final void setOrigin(io.qt.gui.@NonNull QVector3D origin){
        setOrigin_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(origin));
    }
    
    private native void setOrigin_native_cref_QVector3D(long __this__nativeId, long origin);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qraycaster.html#trigger">Qt3DRender::QRayCaster::<wbr/>trigger()</a></code></p>
     */
    public final void trigger(){
        trigger_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    private native void trigger_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qraycaster.html#trigger-1">Qt3DRender::QRayCaster::<wbr/>trigger(QVector3D,<wbr/>QVector3D,<wbr/>float)</a></code></p>
     */
    public final void trigger(io.qt.gui.@NonNull QVector3D origin, io.qt.gui.@NonNull QVector3D direction, float length){
        trigger_native_cref_QVector3D_cref_QVector3D_float(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(origin), QtJambi_LibraryUtilities.internal.checkedNativeId(direction), length);
    }
    
    private native void trigger_native_cref_QVector3D_cref_QVector3D_float(long __this__nativeId, long origin, long direction, float length);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRayCaster(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QRayCaster(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRayCaster instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRayCaster(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRayCaster() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #direction()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getDirection() {
        return direction();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #length()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getLength() {
        return length();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #origin()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getOrigin() {
        return origin();
    }
}
