package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Holds information when a segment of a line is picked</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qpicklineevent.html">Qt3DRender::QPickLineEvent</a></code></p>
 */
public class QPickLineEvent extends io.qt.qt3d.render.QPickEvent
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPickLineEvent.class);
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpicklineevent.html#QPickLineEvent">Qt3DRender::QPickLineEvent::<wbr/>QPickLineEvent()</a></code></p>
     */
    public QPickLineEvent(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QPickLineEvent instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpicklineevent.html#QPickLineEvent">Qt3DRender::QPickLineEvent::<wbr/>QPickLineEvent(QPointF,<wbr/>QVector3D,<wbr/>QVector3D,<wbr/>float,<wbr/>uint,<wbr/>uint,<wbr/>uint,<wbr/>Buttons,<wbr/>int,<wbr/>int)</a></code></p>
     */
    public QPickLineEvent(io.qt.core.@NonNull QPointF position, io.qt.gui.@NonNull QVector3D worldIntersection, io.qt.gui.@NonNull QVector3D localIntersection, float distance, int edgeIndex, int vertex1Index, int vertex2Index, io.qt.qt3d.render.QPickEvent.@NonNull Buttons button, int buttons, int modifiers){
        super((QPrivateConstructor)null);
        initialize_native(this, position, worldIntersection, localIntersection, distance, edgeIndex, vertex1Index, vertex2Index, button, buttons, modifiers);
    }
    
    private native static void initialize_native(QPickLineEvent instance, io.qt.core.QPointF position, io.qt.gui.QVector3D worldIntersection, io.qt.gui.QVector3D localIntersection, float distance, int edgeIndex, int vertex1Index, int vertex2Index, io.qt.qt3d.render.QPickEvent.Buttons button, int buttons, int modifiers);
    
    /**
     * <p>QPickLineEvent::edgeIndex Returns the index of the picked edge</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpicklineevent.html#edgeIndex">Qt3DRender::QPickLineEvent::<wbr/>edgeIndex()const</a></code></p>
     */
    @QtPropertyReader(name="edgeIndex")
    @QtPropertyConstant
    @QtUninvokable
    public final int edgeIndex(){
        return edgeIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int edgeIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickLineEvent::vertex1Index Returns the index of the first point of the picked edge</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpicklineevent.html#vertex1Index">Qt3DRender::QPickLineEvent::<wbr/>vertex1Index()const</a></code></p>
     */
    @QtPropertyReader(name="vertex1Index")
    @QtPropertyConstant
    @QtUninvokable
    public final int vertex1Index(){
        return vertex1Index_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int vertex1Index_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickLineEvent::vertex2Index Returns the index of the second point of the picked triangle</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpicklineevent.html#vertex2Index">Qt3DRender::QPickLineEvent::<wbr/>vertex2Index()const</a></code></p>
     */
    @QtPropertyReader(name="vertex2Index")
    @QtPropertyConstant
    @QtUninvokable
    public final int vertex2Index(){
        return vertex2Index_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int vertex2Index_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPickLineEvent(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QPickLineEvent(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPickLineEvent instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QPickLineEvent(io.qt.core.QPointF, io.qt.gui.QVector3D, io.qt.gui.QVector3D, float, int, int, int, io.qt.qt3d.render.QPickEvent.Buttons, int, int)}.</p>
     */
    public QPickLineEvent(io.qt.core.@NonNull QPoint position, io.qt.gui.@NonNull QVector3D worldIntersection, io.qt.gui.@NonNull QVector3D localIntersection, float distance, int edgeIndex, int vertex1Index, int vertex2Index, io.qt.qt3d.render.QPickEvent.@NonNull Buttons button, int buttons, int modifiers) {
        this(new io.qt.core.QPointF(position), worldIntersection, localIntersection, distance, edgeIndex, vertex1Index, vertex2Index, button, buttons, modifiers);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #edgeIndex()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getEdgeIndex() {
        return edgeIndex();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #vertex1Index()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVertex1Index() {
        return vertex1Index();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #vertex2Index()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVertex2Index() {
        return vertex2Index();
    }
}
