package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>A QAbstractTextureImage that can be written through a QPainter</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html">Qt3DRender::QPaintedTextureImage</a></code></p>
 */
public abstract class QPaintedTextureImage extends io.qt.qt3d.render.QAbstractTextureImage
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPaintedTextureImage.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QPaintedTextureImage {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        protected void paint(io.qt.gui.@Nullable QPainter painter){
            paint_native_QPainter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(painter));
        }
        @QtUninvokable
        private native void paint_native_QPainter_ptr(long __this__nativeId, long painter);
        
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#height-prop">Qt3DRender::QPaintedTextureImage::<wbr/>heightChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="height")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> heightChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#size-prop">Qt3DRender::QPaintedTextureImage::<wbr/>sizeChanged(QSize)</a></code></p>
     */
    @QtPropertyNotify(name="size")
    public final @NonNull Signal1<io.qt.core.@NonNull QSize> sizeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#width-prop">Qt3DRender::QPaintedTextureImage::<wbr/>widthChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="width")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> widthChanged = new Signal1<>();
    
    /**
     * <p>See <code>Qt3DRender::QPaintedTextureImage::<wbr/>QPaintedTextureImage(Qt3DCore::QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QPaintedTextureImage(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPaintedTextureImage instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * Function has no implementation because its native counterpart is private.
     */
    @Deprecated
    @QtUninvokable
    @Override
    protected final io.qt.qt3d.render.@Nullable QTextureImageDataGenerator dataGenerator() throws QNoImplementationException {
        throw new QNoImplementationException();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#height-prop">Qt3DRender::QPaintedTextureImage::<wbr/>height()const</a></code></p>
     */
    @QtPropertyReader(name="height")
    @QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#setHeight">Qt3DRender::QPaintedTextureImage::<wbr/>setHeight(int)</a></code></p>
     */
    @QtPropertyWriter(name="height")
    public final void setHeight(int h){
        setHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), h);
    }
    
    private native void setHeight_native_int(long __this__nativeId, int h);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#setSize">Qt3DRender::QPaintedTextureImage::<wbr/>setSize(QSize)</a></code></p>
     */
    @QtPropertyWriter(name="size")
    public final void setSize(io.qt.core.@NonNull QSize size){
        setSize_native_QSize(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(size));
    }
    
    private native void setSize_native_QSize(long __this__nativeId, long size);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#setWidth">Qt3DRender::QPaintedTextureImage::<wbr/>setWidth(int)</a></code></p>
     */
    @QtPropertyWriter(name="width")
    public final void setWidth(int w){
        setWidth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), w);
    }
    
    private native void setWidth_native_int(long __this__nativeId, int w);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#size-prop">Qt3DRender::QPaintedTextureImage::<wbr/>size()const</a></code></p>
     */
    @QtPropertyReader(name="size")
    @QtUninvokable
    public final io.qt.core.@NonNull QSize size(){
        return size_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QSize size_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#update">Qt3DRender::QPaintedTextureImage::<wbr/>update(QRect)</a></code></p>
     */
    @QtUninvokable
    public final void update(io.qt.core.@NonNull QRect rect){
        update_native_cref_QRect(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(rect));
    }
    
    @QtUninvokable
    private native void update_native_cref_QRect(long __this__nativeId, long rect);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#width-prop">Qt3DRender::QPaintedTextureImage::<wbr/>width()const</a></code></p>
     */
    @QtPropertyReader(name="width")
    @QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpaintedtextureimage.html#paint">Qt3DRender::QPaintedTextureImage::<wbr/>paint(QPainter*)</a></code></p>
     */
    @QtUninvokable
    protected abstract void paint(io.qt.gui.@Nullable QPainter painter);
    
    @QtUninvokable
    private native void paint_native_QPainter_ptr(long __this__nativeId, long painter);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPaintedTextureImage(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QPaintedTextureImage(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPaintedTextureImage instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QPaintedTextureImage(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QPaintedTextureImage() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #height()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getHeight() {
        return height();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #size()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QSize getSize() {
        return size();
    }
    
    /**
     * <p>Overloaded function for {@link #update(io.qt.core.QRect)}
     *  with <code>rect = new io.qt.core.QRect()</code>.</p>
     */
    @QtUninvokable
    public final void update() {
        update(new io.qt.core.QRect());
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #width()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getWidth() {
        return width();
    }
}
