package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Receives the result of render capture request</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapturereply.html">Qt3DRender::QRenderCaptureReply</a></code></p>
 */
public final class QRenderCaptureReply extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderCaptureReply.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapturereply.html#complete-prop">Qt3DRender::QRenderCaptureReply::<wbr/>completed()</a></code></p>
     */
    @QtPropertyNotify(name="complete")
    public final @NonNull Signal0 completed = new Signal0();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapturereply.html#captureId-prop">Qt3DRender::QRenderCaptureReply::<wbr/>captureId()const</a></code></p>
     */
    @QtPropertyReader(name="captureId")
    @QtPropertyConstant
    @QtUninvokable
    public final int captureId(){
        return captureId_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int captureId_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapturereply.html#image-prop">Qt3DRender::QRenderCaptureReply::<wbr/>image()const</a></code></p>
     */
    @QtPropertyReader(name="image")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage image(){
        return image_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QImage image_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapturereply.html#complete-prop">Qt3DRender::QRenderCaptureReply::<wbr/>isComplete()const</a></code></p>
     */
    @QtPropertyReader(name="complete")
    @QtUninvokable
    public final boolean isComplete(){
        return isComplete_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isComplete_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapturereply.html#saveImage">Qt3DRender::QRenderCaptureReply::<wbr/>saveImage(QString)const</a></code></p>
     */
    public final boolean saveImage(java.lang.@NonNull String fileName){
        return saveImage_native_cref_QString_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), fileName);
    }
    
    private native boolean saveImage_native_cref_QString_constfct(long __this__nativeId, java.lang.String fileName);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRenderCaptureReply(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #captureId()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getCaptureId() {
        return captureId();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #image()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QImage getImage() {
        return image();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #isComplete()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getComplete() {
        return isComplete();
    }
}
