package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Specifies whether front or back face culling is enabled</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qcullface.html">Qt3DRender::QCullFace</a></code></p>
 */
public class QCullFace extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QCullFace.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qcullface.html#CullingMode-enum">Qt3DRender::QCullFace::CullingMode</a></code></p>
     */
    public enum CullingMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qcullface.html#CullingMode-enum">Qt3DRender::<wbr/>QCullFace::<wbr/>NoCulling</a></code></p>
         */
        NoCulling(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qcullface.html#CullingMode-enum">Qt3DRender::<wbr/>QCullFace::<wbr/>Front</a></code></p>
         */
        Front(1028),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qcullface.html#CullingMode-enum">Qt3DRender::<wbr/>QCullFace::<wbr/>Back</a></code></p>
         */
        Back(1029),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qcullface.html#CullingMode-enum">Qt3DRender::<wbr/>QCullFace::<wbr/>FrontAndBack</a></code></p>
         */
        FrontAndBack(1032);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private CullingMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull CullingMode resolve(int value) {
            switch (value) {
            case 0: return NoCulling;
            case 1028: return Front;
            case 1029: return Back;
            case 1032: return FrontAndBack;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcullface.html#mode-prop">Qt3DRender::QCullFace::<wbr/>modeChanged(Qt3DRender::QCullFace::CullingMode)</a></code></p>
     */
    @QtPropertyNotify(name="mode")
    public final @NonNull Signal1<io.qt.qt3d.render.QCullFace.@NonNull CullingMode> modeChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcullface.html#QCullFace">Qt3DRender::QCullFace::<wbr/>QCullFace(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QCullFace(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QCullFace instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcullface.html#mode-prop">Qt3DRender::QCullFace::<wbr/>mode()const</a></code></p>
     */
    @QtPropertyReader(name="mode")
    @QtUninvokable
    public final io.qt.qt3d.render.QCullFace.@NonNull CullingMode mode(){
        return io.qt.qt3d.render.QCullFace.CullingMode.resolve(mode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int mode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qcullface.html#mode-prop">Qt3DRender::QCullFace::<wbr/>setMode(Qt3DRender::QCullFace::CullingMode)</a></code></p>
     */
    @QtPropertyWriter(name="mode")
    public final void setMode(io.qt.qt3d.render.QCullFace.@NonNull CullingMode mode){
        setMode_native_Qt3DRender_QCullFace_CullingMode(QtJambi_LibraryUtilities.internal.nativeId(this), mode.value());
    }
    
    private native void setMode_native_Qt3DRender_QCullFace_CullingMode(long __this__nativeId, int mode);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QCullFace(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QCullFace(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QCullFace instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QCullFace(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QCullFace() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #mode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QCullFace.@NonNull CullingMode getMode() {
        return mode();
    }
}
