package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>FrameGraphNode used to wait for a fence in the graphics command stream to become signaled</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html">Qt3DRender::QWaitFence</a></code></p>
 */
public class QWaitFence extends io.qt.qt3d.render.QFrameGraphNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QWaitFence.class);
    
    /**
     * <p>Java wrapper for Qt enum <code>Qt3DRender::QWaitFence::HandleType</code></p>
     */
    public enum HandleType implements QtEnumerator {
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QWaitFence::<wbr/>NoHandle</code></p>
         */
        NoHandle(0),
        /**
         * <p>Representing <code>Qt3DRender::<wbr/>QWaitFence::<wbr/>OpenGLFenceId</code></p>
         */
        OpenGLFenceId(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private HandleType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull HandleType resolve(int value) {
            switch (value) {
            case 0: return NoHandle;
            case 1: return OpenGLFenceId;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#handle-prop">Qt3DRender::QWaitFence::<wbr/>handleChanged(QVariant)</a></code></p>
     */
    @QtPropertyNotify(name="handle")
    public final @NonNull Signal1<java.lang.Object> handleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#handleType-prop">Qt3DRender::QWaitFence::<wbr/>handleTypeChanged(Qt3DRender::QWaitFence::HandleType)</a></code></p>
     */
    @QtPropertyNotify(name="handleType")
    public final @NonNull Signal1<io.qt.qt3d.render.QWaitFence.@NonNull HandleType> handleTypeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#timeout-prop">Qt3DRender::QWaitFence::<wbr/>timeoutChanged(quint64)</a></code></p>
     */
    @QtPropertyNotify(name="timeout")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Long> timeoutChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#waitOnCPU-prop">Qt3DRender::QWaitFence::<wbr/>waitOnCPUChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="waitOnCPU")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> waitOnCPUChanged = new Signal1<>();
    
    /**
     * <p>See <code>Qt3DRender::QWaitFence::<wbr/>QWaitFence(Qt3DCore::QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QWaitFence(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QWaitFence instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#handle-prop">Qt3DRender::QWaitFence::<wbr/>handle()const</a></code></p>
     */
    @QtPropertyReader(name="handle")
    @QtUninvokable
    public final java.lang.Object handle(){
        return handle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.Object handle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#handleType-prop">Qt3DRender::QWaitFence::<wbr/>handleType()const</a></code></p>
     */
    @QtPropertyReader(name="handleType")
    @QtUninvokable
    public final io.qt.qt3d.render.QWaitFence.@NonNull HandleType handleType(){
        return io.qt.qt3d.render.QWaitFence.HandleType.resolve(handleType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int handleType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#handle-prop">Qt3DRender::QWaitFence::<wbr/>setHandle(QVariant)</a></code></p>
     */
    @QtPropertyWriter(name="handle")
    @QtUninvokable
    public final void setHandle(java.lang.Object handle){
        setHandle_native_QVariant(QtJambi_LibraryUtilities.internal.nativeId(this), handle);
    }
    
    @QtUninvokable
    private native void setHandle_native_QVariant(long __this__nativeId, java.lang.Object handle);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#handleType-prop">Qt3DRender::QWaitFence::<wbr/>setHandleType(Qt3DRender::QWaitFence::HandleType)</a></code></p>
     */
    @QtPropertyWriter(name="handleType")
    @QtUninvokable
    public final void setHandleType(io.qt.qt3d.render.QWaitFence.@NonNull HandleType type){
        setHandleType_native_Qt3DRender_QWaitFence_HandleType(QtJambi_LibraryUtilities.internal.nativeId(this), type.value());
    }
    
    @QtUninvokable
    private native void setHandleType_native_Qt3DRender_QWaitFence_HandleType(long __this__nativeId, int type);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#timeout-prop">Qt3DRender::QWaitFence::<wbr/>setTimeout(quint64)</a></code></p>
     */
    @QtPropertyWriter(name="timeout")
    @QtUninvokable
    public final void setTimeout(long timeout){
        setTimeout_native_quint64(QtJambi_LibraryUtilities.internal.nativeId(this), timeout);
    }
    
    @QtUninvokable
    private native void setTimeout_native_quint64(long __this__nativeId, long timeout);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#waitOnCPU-prop">Qt3DRender::QWaitFence::<wbr/>setWaitOnCPU(bool)</a></code></p>
     */
    @QtPropertyWriter(name="waitOnCPU")
    @QtUninvokable
    public final void setWaitOnCPU(boolean waitOnCPU){
        setWaitOnCPU_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), waitOnCPU);
    }
    
    @QtUninvokable
    private native void setWaitOnCPU_native_bool(long __this__nativeId, boolean waitOnCPU);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#timeout-prop">Qt3DRender::QWaitFence::<wbr/>timeout()const</a></code></p>
     */
    @QtPropertyReader(name="timeout")
    @QtUninvokable
    public final long timeout(){
        return timeout_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native long timeout_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qwaitfence.html#waitOnCPU-prop">Qt3DRender::QWaitFence::<wbr/>waitOnCPU()const</a></code></p>
     */
    @QtPropertyReader(name="waitOnCPU")
    @QtUninvokable
    public final boolean waitOnCPU(){
        return waitOnCPU_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean waitOnCPU_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QWaitFence(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QWaitFence(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QWaitFence instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QWaitFence(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QWaitFence() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #handle()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.Object getHandle() {
        return handle();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #handleType()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QWaitFence.@NonNull HandleType getHandleType() {
        return handleType();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #timeout()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final long getTimeout() {
        return timeout();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #waitOnCPU()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getWaitOnCPU() {
        return waitOnCPU();
    }
}
