package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Stores data representing a texture</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html">Qt3DRender::QTextureImageData</a></code></p>
 */
public class QTextureImageData extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    

    /**
     * <p>Java wrapper for Qt callable <code>std::function&lt;QByteArray(QByteArray,int,int,int)&gt;</code></p>
     */
    @FunctionalInterface
    public interface DataConverter extends QtObjectInterface {

        public io.qt.core.@NonNull QByteArray apply(io.qt.core.@NonNull QByteArray arg__1, int arg__2, int arg__3, int arg__4);

        /**
         * @hidden
         * <p>Implementor class for interface {@link DataConverter}</p>
         */
        public static abstract class Impl extends QtObject implements DataConverter{
            static {
                QtJambi_LibraryUtilities.initialize();
            }

            public Impl(){
                super((QPrivateConstructor)null);
                initialize_native(this);
            }

            protected Impl(QPrivateConstructor p){
                super(p);
            }

            private static native void initialize_native(DataConverter instance);

            @NativeAccess
            private final static class ConcreteWrapper extends Impl {
                private ConcreteWrapper(QPrivateConstructor c){
                    super(c);
                }

                @Override
                public io.qt.core.@NonNull QByteArray apply(io.qt.core.@NonNull QByteArray arg__1, int arg__2, int arg__3, int arg__4){
                    return apply_native(QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1), arg__2, arg__3, arg__4);
                }

                private native io.qt.core.QByteArray apply_native(long arg__1, int arg__2, int arg__3, int arg__4);
            }

        }
    }

    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#QTextureImageData">Qt3DRender::QTextureImageData::<wbr/>QTextureImageData()</a></code></p>
     */
    public QTextureImageData(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QTextureImageData instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#alignment">Qt3DRender::QTextureImageData::<wbr/>alignment()const</a></code></p>
     */
    @QtUninvokable
    public final int alignment(){
        return alignment_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int alignment_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#cleanup">Qt3DRender::QTextureImageData::<wbr/>cleanup()</a></code></p>
     */
    @QtUninvokable
    public final void cleanup(){
        cleanup_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void cleanup_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#data">Qt3DRender::QTextureImageData::<wbr/>data(int,<wbr/>int,<wbr/>int)const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray data(int layer, int face, int mipmapLevel){
        return data_native_int_int_int_constfct(QtJambi_LibraryUtilities.internal.nativeId(this), layer, face, mipmapLevel);
    }
    
    @QtUninvokable
    private native io.qt.core.QByteArray data_native_int_int_int_constfct(long __this__nativeId, int layer, int face, int mipmapLevel);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#depth">Qt3DRender::QTextureImageData::<wbr/>depth()const</a></code></p>
     */
    @QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#faces">Qt3DRender::QTextureImageData::<wbr/>faces()const</a></code></p>
     */
    @QtUninvokable
    public final int faces(){
        return faces_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int faces_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#format">Qt3DRender::QTextureImageData::<wbr/>format()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull TextureFormat format(){
        return io.qt.opengl.QOpenGLTexture.TextureFormat.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#height">Qt3DRender::QTextureImageData::<wbr/>height()const</a></code></p>
     */
    @QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#isCompressed">Qt3DRender::QTextureImageData::<wbr/>isCompressed()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isCompressed(){
        return isCompressed_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isCompressed_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#layers">Qt3DRender::QTextureImageData::<wbr/>layers()const</a></code></p>
     */
    @QtUninvokable
    public final int layers(){
        return layers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int layers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#mipLevels">Qt3DRender::QTextureImageData::<wbr/>mipLevels()const</a></code></p>
     */
    @QtUninvokable
    public final int mipLevels(){
        return mipLevels_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int mipLevels_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code>Qt3DRender::QTextureImageData::<wbr/>operator=(Qt3DRender::QTextureImageData)</code></p>
     */
    @QtUninvokable
    public final void assign(io.qt.qt3d.render.@NonNull QTextureImageData other){
        assign_native_cref_Qt3DRender_QTextureImageData(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(other));
    }
    
    @QtUninvokable
    private native void assign_native_cref_Qt3DRender_QTextureImageData(long __this__nativeId, long other);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#pixelFormat">Qt3DRender::QTextureImageData::<wbr/>pixelFormat()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat pixelFormat(){
        return io.qt.opengl.QOpenGLTexture.PixelFormat.resolve(pixelFormat_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int pixelFormat_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#pixelType">Qt3DRender::QTextureImageData::<wbr/>pixelType()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull PixelType pixelType(){
        return io.qt.opengl.QOpenGLTexture.PixelType.resolve(pixelType_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int pixelType_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setAlignment">Qt3DRender::QTextureImageData::<wbr/>setAlignment(int)</a></code></p>
     */
    @QtUninvokable
    public final void setAlignment(int alignment){
        setAlignment_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), alignment);
    }
    
    @QtUninvokable
    private native void setAlignment_native_int(long __this__nativeId, int alignment);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setData">Qt3DRender::QTextureImageData::<wbr/>setData(QByteArray,<wbr/>int,<wbr/>bool)</a></code></p>
     */
    @QtUninvokable
    public final void setData(io.qt.core.@NonNull QByteArray data, int blockSize, boolean isCompressed){
        setData_native_cref_QByteArray_int_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), blockSize, isCompressed);
    }
    
    @QtUninvokable
    private native void setData_native_cref_QByteArray_int_bool(long __this__nativeId, long data, int blockSize, boolean isCompressed);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setData">Qt3DRender::QTextureImageData::<wbr/>setData(const QByteArray&amp;,<wbr/>std::function&lt;QByteArray(QByteArray,<wbr/>int,<wbr/>int,<wbr/>int)&gt;,<wbr/>bool)</a></code></p>
     */
    @QtUninvokable
    public final void setData(io.qt.core.@NonNull QByteArray data, io.qt.qt3d.render.QTextureImageData.@Nullable DataConverter arg__2, boolean isCompressed){
        setData_native_cref_QByteArray_Qt3DRender_QTextureImageData_DataConverter_bool(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(data), arg__2, isCompressed);
    }
    
    @QtUninvokable
    private native void setData_native_cref_QByteArray_Qt3DRender_QTextureImageData_DataConverter_bool(long __this__nativeId, long data, io.qt.qt3d.render.QTextureImageData.DataConverter arg__2, boolean isCompressed);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setDepth">Qt3DRender::QTextureImageData::<wbr/>setDepth(int)</a></code></p>
     */
    @QtUninvokable
    public final void setDepth(int depth){
        setDepth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @QtUninvokable
    private native void setDepth_native_int(long __this__nativeId, int depth);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setFaces">Qt3DRender::QTextureImageData::<wbr/>setFaces(int)</a></code></p>
     */
    @QtUninvokable
    public final void setFaces(int faces){
        setFaces_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), faces);
    }
    
    @QtUninvokable
    private native void setFaces_native_int(long __this__nativeId, int faces);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setFormat">Qt3DRender::QTextureImageData::<wbr/>setFormat(QOpenGLTexture::TextureFormat)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setFormat(io.qt.opengl.QOpenGLTexture.@NonNull TextureFormat format){
        setFormat_native_QOpenGLTexture_TextureFormat(QtJambi_LibraryUtilities.internal.nativeId(this), format.value());
    }
    
    @QtUninvokable
    private native void setFormat_native_QOpenGLTexture_TextureFormat(long __this__nativeId, int format);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setHeight">Qt3DRender::QTextureImageData::<wbr/>setHeight(int)</a></code></p>
     */
    @QtUninvokable
    public final void setHeight(int height){
        setHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), height);
    }
    
    @QtUninvokable
    private native void setHeight_native_int(long __this__nativeId, int height);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setImage">Qt3DRender::QTextureImageData::<wbr/>setImage(QImage)</a></code></p>
     */
    @QtUninvokable
    public final void setImage(io.qt.gui.@NonNull QImage arg__1){
        setImage_native_cref_QImage(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(arg__1));
    }
    
    @QtUninvokable
    private native void setImage_native_cref_QImage(long __this__nativeId, long arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setLayers">Qt3DRender::QTextureImageData::<wbr/>setLayers(int)</a></code></p>
     */
    @QtUninvokable
    public final void setLayers(int layers){
        setLayers_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layers);
    }
    
    @QtUninvokable
    private native void setLayers_native_int(long __this__nativeId, int layers);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setMipLevels">Qt3DRender::QTextureImageData::<wbr/>setMipLevels(int)</a></code></p>
     */
    @QtUninvokable
    public final void setMipLevels(int mipLevels){
        setMipLevels_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), mipLevels);
    }
    
    @QtUninvokable
    private native void setMipLevels_native_int(long __this__nativeId, int mipLevels);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setPixelFormat">Qt3DRender::QTextureImageData::<wbr/>setPixelFormat(QOpenGLTexture::PixelFormat)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setPixelFormat(io.qt.opengl.QOpenGLTexture.@NonNull PixelFormat pixelFormat){
        setPixelFormat_native_QOpenGLTexture_PixelFormat(QtJambi_LibraryUtilities.internal.nativeId(this), pixelFormat.value());
    }
    
    @QtUninvokable
    private native void setPixelFormat_native_QOpenGLTexture_PixelFormat(long __this__nativeId, int pixelFormat);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setPixelType">Qt3DRender::QTextureImageData::<wbr/>setPixelType(QOpenGLTexture::PixelType)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setPixelType(io.qt.opengl.QOpenGLTexture.@NonNull PixelType pixelType){
        setPixelType_native_QOpenGLTexture_PixelType(QtJambi_LibraryUtilities.internal.nativeId(this), pixelType.value());
    }
    
    @QtUninvokable
    private native void setPixelType_native_QOpenGLTexture_PixelType(long __this__nativeId, int pixelType);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setTarget">Qt3DRender::QTextureImageData::<wbr/>setTarget(QOpenGLTexture::Target)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final void setTarget(io.qt.opengl.QOpenGLTexture.@NonNull Target target){
        setTarget_native_QOpenGLTexture_Target(QtJambi_LibraryUtilities.internal.nativeId(this), target.value());
    }
    
    @QtUninvokable
    private native void setTarget_native_QOpenGLTexture_Target(long __this__nativeId, int target);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#setWidth">Qt3DRender::QTextureImageData::<wbr/>setWidth(int)</a></code></p>
     */
    @QtUninvokable
    public final void setWidth(int width){
        setWidth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @QtUninvokable
    private native void setWidth_native_int(long __this__nativeId, int width);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#target">Qt3DRender::QTextureImageData::<wbr/>target()const</a></code></p>
     */
    @SuppressWarnings({"exports"})
    @QtUninvokable
    public final io.qt.opengl.QOpenGLTexture.@NonNull Target target(){
        return io.qt.opengl.QOpenGLTexture.Target.resolve(target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimagedata.html#width">Qt3DRender::QTextureImageData::<wbr/>width()const</a></code></p>
     */
    @QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int width_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QTextureImageData(QPrivateConstructor p) { super(p); } 
    

    /**
     * Checks for equality by checking object's hash code.
     */
    @Override
    @QtUninvokable
    public boolean equals(Object other) {
        if(other instanceof io.qt.qt3d.render.QTextureImageData)
            return hashCode()==other.hashCode();
        else return super.equals(other);    }


    /**
     * Returns the objects's hash code computed by <code>qHash(Qt3DRender::QTextureImageData)</code>.
     */
    @QtUninvokable
    @Override
    public int hashCode() {
        return hashCode_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    @QtUninvokable
    private native static int hashCode_native(long __this_nativeId);
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QTextureImageData clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QTextureImageData clone_native(long __this_nativeId);
    
    /**
     * <p>Overloaded function for {@link #data(int, int, int)}
     *  with <code>mipmapLevel = 0</code>.</p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray data(int layer, int face) {
        return data(layer, face, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #data(int, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>face = 0</code></li>
     * <li><code>mipmapLevel = 0</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray data(int layer) {
        return data(layer, (int)0, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #data(int, int, int)}</p>
     * <p>with: </p><ul>
     * <li><code>layer = 0</code></li>
     * <li><code>face = 0</code></li>
     * <li><code>mipmapLevel = 0</code></li>
     * </ul>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QByteArray data() {
        return data((int)0, (int)0, (int)0);
    }
    
    /**
     * <p>Overloaded function for {@link #setData(io.qt.core.QByteArray, int, boolean)}
     *  with <code>isCompressed = false</code>.</p>
     */
    @QtUninvokable
    public final void setData(io.qt.core.@NonNull QByteArray data, int blockSize) {
        setData(data, blockSize, (boolean)false);
    }
    
    /**
     * <p>Overloaded function for {@link #setData(byte[], int, boolean)}
     *  with <code>isCompressed = false</code>.</p>
     */
    @QtUninvokable
    public final void setData(byte @NonNull[] data, int blockSize) {
        setData(data, blockSize, (boolean)false);
    }
    
    /**
     * <p>Overloaded function for {@link #setData(io.qt.core.QByteArray, int, boolean)}.</p>
     */
    @QtUninvokable
    public final void setData(byte @NonNull[] data, int blockSize, boolean isCompressed) {
        setData(new io.qt.core.QByteArray(data), blockSize, isCompressed);
    }
    
    /**
     * <p>Overloaded function for {@link #setData(io.qt.core.QByteArray, io.qt.qt3d.render.QTextureImageData.DataConverter, boolean)}
     *  with <code>isCompressed = false</code>.</p>
     */
    @QtUninvokable
    public final void setData(io.qt.core.@NonNull QByteArray data, io.qt.qt3d.render.QTextureImageData.@Nullable DataConverter arg__2) {
        setData(data, arg__2, (boolean)false);
    }
    
    /**
     * <p>Overloaded function for {@link #setData(byte[], io.qt.qt3d.render.QTextureImageData.DataConverter, boolean)}
     *  with <code>isCompressed = false</code>.</p>
     */
    @QtUninvokable
    public final void setData(byte @NonNull[] data, io.qt.qt3d.render.QTextureImageData.@Nullable DataConverter arg__2) {
        setData(data, arg__2, (boolean)false);
    }
    
    /**
     * <p>Overloaded function for {@link #setData(io.qt.core.QByteArray, io.qt.qt3d.render.QTextureImageData.DataConverter, boolean)}.</p>
     */
    @QtUninvokable
    public final void setData(byte @NonNull[] data, io.qt.qt3d.render.QTextureImageData.@Nullable DataConverter arg__2, boolean isCompressed) {
        setData(new io.qt.core.QByteArray(data), arg__2, isCompressed);
    }
}
