package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Encapsulates the necessary information to create an OpenGL texture image</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html">Qt3DRender::QAbstractTextureImage</a></code></p>
 */
public abstract class QAbstractTextureImage extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractTextureImage.class);
    
    @NativeAccess
    private static final class ConcreteWrapper extends QAbstractTextureImage {
        
        @NativeAccess
        private ConcreteWrapper(QPrivateConstructor p) { super(p); }
        
        @Override
        @QtUninvokable
        protected io.qt.qt3d.render.@Nullable QTextureImageDataGenerator dataGenerator(){
            return dataGenerator_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
        }
        @QtUninvokable
        private native io.qt.qt3d.render.QTextureImageDataGenerator dataGenerator_native_constfct(long __this__nativeId);
        
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#face-prop">Qt3DRender::QAbstractTextureImage::<wbr/>faceChanged(Qt3DRender::QAbstractTexture::CubeMapFace)</a></code></p>
     */
    @QtPropertyNotify(name="face")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractTexture.@NonNull CubeMapFace> faceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#layer-prop">Qt3DRender::QAbstractTextureImage::<wbr/>layerChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="layer")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> layerChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#mipLevel-prop">Qt3DRender::QAbstractTextureImage::<wbr/>mipLevelChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="mipLevel")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> mipLevelChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#QAbstractTextureImage">Qt3DRender::QAbstractTextureImage::<wbr/>QAbstractTextureImage(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QAbstractTextureImage(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractTextureImage instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#face-prop">Qt3DRender::QAbstractTextureImage::<wbr/>face()const</a></code></p>
     */
    @QtPropertyReader(name="face")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull CubeMapFace face(){
        return io.qt.qt3d.render.QAbstractTexture.CubeMapFace.resolve(face_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int face_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#layer-prop">Qt3DRender::QAbstractTextureImage::<wbr/>layer()const</a></code></p>
     */
    @QtPropertyReader(name="layer")
    @QtUninvokable
    public final int layer(){
        return layer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int layer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#mipLevel-prop">Qt3DRender::QAbstractTextureImage::<wbr/>mipLevel()const</a></code></p>
     */
    @QtPropertyReader(name="mipLevel")
    @QtUninvokable
    public final int mipLevel(){
        return mipLevel_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int mipLevel_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#notifyDataGeneratorChanged">Qt3DRender::QAbstractTextureImage::<wbr/>notifyDataGeneratorChanged()</a></code></p>
     */
    @QtUninvokable
    protected final void notifyDataGeneratorChanged(){
        notifyDataGeneratorChanged_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native void notifyDataGeneratorChanged_native(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#setFace">Qt3DRender::QAbstractTextureImage::<wbr/>setFace(Qt3DRender::QAbstractTexture::CubeMapFace)</a></code></p>
     */
    @QtPropertyWriter(name="face")
    public final void setFace(io.qt.qt3d.render.QAbstractTexture.@NonNull CubeMapFace face){
        setFace_native_Qt3DRender_QAbstractTexture_CubeMapFace(QtJambi_LibraryUtilities.internal.nativeId(this), face.value());
    }
    
    private native void setFace_native_Qt3DRender_QAbstractTexture_CubeMapFace(long __this__nativeId, int face);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#setLayer">Qt3DRender::QAbstractTextureImage::<wbr/>setLayer(int)</a></code></p>
     */
    @QtPropertyWriter(name="layer")
    public final void setLayer(int layer){
        setLayer_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layer);
    }
    
    private native void setLayer_native_int(long __this__nativeId, int layer);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#setMipLevel">Qt3DRender::QAbstractTextureImage::<wbr/>setMipLevel(int)</a></code></p>
     */
    @QtPropertyWriter(name="mipLevel")
    public final void setMipLevel(int level){
        setMipLevel_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), level);
    }
    
    private native void setMipLevel_native_int(long __this__nativeId, int level);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstracttextureimage.html#dataGenerator">Qt3DRender::QAbstractTextureImage::<wbr/>dataGenerator()const</a></code></p>
     */
    @QtUninvokable
    protected abstract io.qt.qt3d.render.@Nullable QTextureImageDataGenerator dataGenerator();
    
    @QtUninvokable
    private native io.qt.qt3d.render.QTextureImageDataGenerator dataGenerator_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractTextureImage(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAbstractTextureImage(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractTextureImage instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractTextureImage(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractTextureImage() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #face()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull CubeMapFace getFace() {
        return face();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #layer()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getLayer() {
        return layer();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #mipLevel()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMipLevel() {
        return mipLevel();
    }
}
