package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>A viewport on the Qt3D Scene</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qviewport.html">Qt3DRender::QViewport</a></code></p>
 */
public class QViewport extends io.qt.qt3d.render.QFrameGraphNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QViewport.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qviewport.html#gamma-prop">Qt3DRender::QViewport::<wbr>gammaChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="gamma")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> gammaChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qviewport.html#normalizedRect-prop">Qt3DRender::QViewport::<wbr>normalizedRectChanged(QRectF)</a></code></p>
     */
    @QtPropertyNotify(name="normalizedRect")
    public final @NonNull Signal1<io.qt.core.@NonNull QRectF> normalizedRectChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qviewport.html#QViewport">Qt3DRender::QViewport::<wbr>QViewport(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QViewport(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QViewport instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qviewport.html#gamma-prop">Qt3DRender::QViewport::<wbr>gamma()const</a></code></p>
     */
    @QtPropertyReader(name="gamma")
    @QtUninvokable
    public final float gamma(){
        return gamma_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float gamma_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qviewport.html#normalizedRect-prop">Qt3DRender::QViewport::<wbr>normalizedRect()const</a></code></p>
     */
    @QtPropertyReader(name="normalizedRect")
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF normalizedRect(){
        return normalizedRect_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QRectF normalizedRect_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qviewport.html#gamma-prop">Qt3DRender::QViewport::<wbr>setGamma(float)</a></code></p>
     */
    @QtPropertyWriter(name="gamma")
    public final void setGamma(float gamma){
        setGamma_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), gamma);
    }
    
    private native void setGamma_native_float(long __this__nativeId, float gamma);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qviewport.html#normalizedRect-prop">Qt3DRender::QViewport::<wbr>setNormalizedRect(QRectF)</a></code></p>
     */
    @QtPropertyWriter(name="normalizedRect")
    public final void setNormalizedRect(io.qt.core.@NonNull QRectF normalizedRect){
        setNormalizedRect_native_cref_QRectF(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(normalizedRect));
    }
    
    private native void setNormalizedRect_native_cref_QRectF(long __this__nativeId, long normalizedRect);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QViewport(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QViewport(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QViewport instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QViewport(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QViewport() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #gamma()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getGamma() {
        return gamma();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #normalizedRect()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QRectF getNormalizedRect() {
        return normalizedRect();
    }
}
