package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Encapsulates the necessary information to create an OpenGL texture image from an image source</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html">Qt3DRender::QTextureImage</a></code></p>
 */
public class QTextureImage extends io.qt.qt3d.render.QAbstractTextureImage
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QTextureImage.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#Status-enum">Qt3DRender::QTextureImage::Status</a></code></p>
     */
    public enum Status implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#Status-enum">Qt3DRender::<wbr>QTextureImage::<wbr>None</a></code></p>
         */
        None(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#Status-enum">Qt3DRender::<wbr>QTextureImage::<wbr>Loading</a></code></p>
         */
        Loading(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#Status-enum">Qt3DRender::<wbr>QTextureImage::<wbr>Ready</a></code></p>
         */
        Ready(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#Status-enum">Qt3DRender::<wbr>QTextureImage::<wbr>Error</a></code></p>
         */
        Error(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Status(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Status resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return Loading;
            case 2: return Ready;
            case 3: return Error;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#mirrored-prop">Qt3DRender::QTextureImage::<wbr>mirroredChanged(bool)</a></code></p>
     */
    @QtPropertyNotify(name="mirrored")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Boolean> mirroredChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#source-prop">Qt3DRender::QTextureImage::<wbr>sourceChanged(QUrl)</a></code></p>
     */
    @QtPropertyNotify(name="source")
    public final @NonNull Signal1<io.qt.core.@NonNull QUrl> sourceChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#status-prop">Qt3DRender::QTextureImage::<wbr>statusChanged(Qt3DRender::QTextureImage::Status)</a></code></p>
     */
    @QtPropertyNotify(name="status")
    public final @NonNull Signal1<io.qt.qt3d.render.QTextureImage.@NonNull Status> statusChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#QTextureImage">Qt3DRender::QTextureImage::<wbr>QTextureImage(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QTextureImage(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QTextureImage instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * Function has no implementation because its native counterpart is private.
     */
    @Deprecated
    @QtUninvokable
    @Override
    protected final io.qt.qt3d.render.@Nullable QTextureImageDataGenerator dataGenerator() throws QNoImplementationException {
        throw new QNoImplementationException();
    }
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#isMirrored">Qt3DRender::QTextureImage::<wbr>isMirrored()const</a></code></p>
     */
    @QtPropertyReader(name="mirrored")
    @QtUninvokable
    public final boolean isMirrored(){
        return isMirrored_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isMirrored_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#setMirrored">Qt3DRender::QTextureImage::<wbr>setMirrored(bool)</a></code></p>
     */
    @QtPropertyWriter(name="mirrored")
    public final void setMirrored(boolean mirrored){
        setMirrored_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), mirrored);
    }
    
    private native void setMirrored_native_bool(long __this__nativeId, boolean mirrored);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#setSource">Qt3DRender::QTextureImage::<wbr>setSource(QUrl)</a></code></p>
     */
    @QtPropertyWriter(name="source")
    public final void setSource(io.qt.core.@NonNull QUrl source){
        setSource_native_cref_QUrl(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(source));
    }
    
    private native void setSource_native_cref_QUrl(long __this__nativeId, long source);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#setStatus">Qt3DRender::QTextureImage::<wbr>setStatus(Qt3DRender::QTextureImage::Status)</a></code></p>
     */
    @QtUninvokable
    protected final void setStatus(io.qt.qt3d.render.QTextureImage.@NonNull Status status){
        setStatus_native_Qt3DRender_QTextureImage_Status(QtJambi_LibraryUtilities.internal.nativeId(this), status.value());
    }
    
    @QtUninvokable
    private native void setStatus_native_Qt3DRender_QTextureImage_Status(long __this__nativeId, int status);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#source">Qt3DRender::QTextureImage::<wbr>source()const</a></code></p>
     */
    @QtPropertyReader(name="source")
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl source(){
        return source_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QUrl source_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtextureimage.html#status">Qt3DRender::QTextureImage::<wbr>status()const</a></code></p>
     */
    @QtPropertyReader(name="status")
    @QtUninvokable
    public final io.qt.qt3d.render.QTextureImage.@NonNull Status status(){
        return io.qt.qt3d.render.QTextureImage.Status.resolve(status_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int status_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QTextureImage(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QTextureImage(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QTextureImage instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QTextureImage(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QTextureImage() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isMirrored()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getMirrored() {
        return isMirrored();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #source()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QUrl getSource() {
        return source();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #status()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QTextureImage.@NonNull Status getStatus() {
        return status();
    }
}
