package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Stores texture information such as the target, height, width, depth, layers, wrap, and if mipmaps are enabled</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html">Qt3DRender::QTextureData</a></code></p>
 */
public class QTextureData extends QtObject
    implements java.lang.Cloneable
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#QTextureData">Qt3DRender::QTextureData::<wbr>QTextureData()</a></code></p>
     */
    public QTextureData(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QTextureData instance);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#addImageData">Qt3DRender::QTextureData::<wbr>addImageData(Qt3DRender::QTextureImageDataPtr)</a></code></p>
     */
    @QtUninvokable
    public final void addImageData(io.qt.qt3d.render.@Nullable QTextureImageData imageData){
        addImageData_native_cref_QSharedPointer(QtJambi_LibraryUtilities.internal.nativeId(this), imageData);
    }
    
    @QtUninvokable
    private native void addImageData_native_cref_QSharedPointer(long __this__nativeId, io.qt.qt3d.render.QTextureImageData imageData);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#comparisonFunction">Qt3DRender::QTextureData::<wbr>comparisonFunction()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonFunction comparisonFunction(){
        return io.qt.qt3d.render.QAbstractTexture.ComparisonFunction.resolve(comparisonFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int comparisonFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#comparisonMode">Qt3DRender::QTextureData::<wbr>comparisonMode()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonMode comparisonMode(){
        return io.qt.qt3d.render.QAbstractTexture.ComparisonMode.resolve(comparisonMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int comparisonMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#depth">Qt3DRender::QTextureData::<wbr>depth()const</a></code></p>
     */
    @QtUninvokable
    public final int depth(){
        return depth_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int depth_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#format">Qt3DRender::QTextureData::<wbr>format()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull TextureFormat format(){
        return io.qt.qt3d.render.QAbstractTexture.TextureFormat.resolve(format_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int format_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#height">Qt3DRender::QTextureData::<wbr>height()const</a></code></p>
     */
    @QtUninvokable
    public final int height(){
        return height_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int height_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#imageData">Qt3DRender::QTextureData::<wbr>imageData()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QTextureImageData> imageData(){
        return imageData_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QTextureImageData> imageData_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#isAutoMipMapGenerationEnabled">Qt3DRender::QTextureData::<wbr>isAutoMipMapGenerationEnabled()const</a></code></p>
     */
    @QtUninvokable
    public final boolean isAutoMipMapGenerationEnabled(){
        return isAutoMipMapGenerationEnabled_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isAutoMipMapGenerationEnabled_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#layers">Qt3DRender::QTextureData::<wbr>layers()const</a></code></p>
     */
    @QtUninvokable
    public final int layers(){
        return layers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int layers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#magnificationFilter">Qt3DRender::QTextureData::<wbr>magnificationFilter()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Filter magnificationFilter(){
        return io.qt.qt3d.render.QAbstractTexture.Filter.resolve(magnificationFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int magnificationFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#maximumAnisotropy">Qt3DRender::QTextureData::<wbr>maximumAnisotropy()const</a></code></p>
     */
    @QtUninvokable
    public final float maximumAnisotropy(){
        return maximumAnisotropy_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float maximumAnisotropy_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#minificationFilter">Qt3DRender::QTextureData::<wbr>minificationFilter()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Filter minificationFilter(){
        return io.qt.qt3d.render.QAbstractTexture.Filter.resolve(minificationFilter_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int minificationFilter_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setAutoMipMapGenerationEnabled">Qt3DRender::QTextureData::<wbr>setAutoMipMapGenerationEnabled(bool)</a></code></p>
     */
    @QtUninvokable
    public final void setAutoMipMapGenerationEnabled(boolean isAutoMipMapGenerationEnabled){
        setAutoMipMapGenerationEnabled_native_bool(QtJambi_LibraryUtilities.internal.nativeId(this), isAutoMipMapGenerationEnabled);
    }
    
    @QtUninvokable
    private native void setAutoMipMapGenerationEnabled_native_bool(long __this__nativeId, boolean isAutoMipMapGenerationEnabled);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setComparisonFunction">Qt3DRender::QTextureData::<wbr>setComparisonFunction(Qt3DRender::QAbstractTexture::ComparisonFunction)</a></code></p>
     */
    @QtUninvokable
    public final void setComparisonFunction(io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonFunction comparisonFunction){
        setComparisonFunction_native_Qt3DRender_QAbstractTexture_ComparisonFunction(QtJambi_LibraryUtilities.internal.nativeId(this), comparisonFunction.value());
    }
    
    @QtUninvokable
    private native void setComparisonFunction_native_Qt3DRender_QAbstractTexture_ComparisonFunction(long __this__nativeId, int comparisonFunction);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setComparisonMode">Qt3DRender::QTextureData::<wbr>setComparisonMode(Qt3DRender::QAbstractTexture::ComparisonMode)</a></code></p>
     */
    @QtUninvokable
    public final void setComparisonMode(io.qt.qt3d.render.QAbstractTexture.@NonNull ComparisonMode comparisonMode){
        setComparisonMode_native_Qt3DRender_QAbstractTexture_ComparisonMode(QtJambi_LibraryUtilities.internal.nativeId(this), comparisonMode.value());
    }
    
    @QtUninvokable
    private native void setComparisonMode_native_Qt3DRender_QAbstractTexture_ComparisonMode(long __this__nativeId, int comparisonMode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setDepth">Qt3DRender::QTextureData::<wbr>setDepth(int)</a></code></p>
     */
    @QtUninvokable
    public final void setDepth(int depth){
        setDepth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), depth);
    }
    
    @QtUninvokable
    private native void setDepth_native_int(long __this__nativeId, int depth);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setFormat">Qt3DRender::QTextureData::<wbr>setFormat(Qt3DRender::QAbstractTexture::TextureFormat)</a></code></p>
     */
    @QtUninvokable
    public final void setFormat(io.qt.qt3d.render.QAbstractTexture.@NonNull TextureFormat arg__1){
        setFormat_native_Qt3DRender_QAbstractTexture_TextureFormat(QtJambi_LibraryUtilities.internal.nativeId(this), arg__1.value());
    }
    
    @QtUninvokable
    private native void setFormat_native_Qt3DRender_QAbstractTexture_TextureFormat(long __this__nativeId, int arg__1);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setHeight">Qt3DRender::QTextureData::<wbr>setHeight(int)</a></code></p>
     */
    @QtUninvokable
    public final void setHeight(int height){
        setHeight_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), height);
    }
    
    @QtUninvokable
    private native void setHeight_native_int(long __this__nativeId, int height);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setLayers">Qt3DRender::QTextureData::<wbr>setLayers(int)</a></code></p>
     */
    @QtUninvokable
    public final void setLayers(int layers){
        setLayers_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), layers);
    }
    
    @QtUninvokable
    private native void setLayers_native_int(long __this__nativeId, int layers);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setMagnificationFilter">Qt3DRender::QTextureData::<wbr>setMagnificationFilter(Qt3DRender::QAbstractTexture::Filter)</a></code></p>
     */
    @QtUninvokable
    public final void setMagnificationFilter(io.qt.qt3d.render.QAbstractTexture.@NonNull Filter filter){
        setMagnificationFilter_native_Qt3DRender_QAbstractTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), filter.value());
    }
    
    @QtUninvokable
    private native void setMagnificationFilter_native_Qt3DRender_QAbstractTexture_Filter(long __this__nativeId, int filter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setMaximumAnisotropy">Qt3DRender::QTextureData::<wbr>setMaximumAnisotropy(float)</a></code></p>
     */
    @QtUninvokable
    public final void setMaximumAnisotropy(float maximumAnisotropy){
        setMaximumAnisotropy_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), maximumAnisotropy);
    }
    
    @QtUninvokable
    private native void setMaximumAnisotropy_native_float(long __this__nativeId, float maximumAnisotropy);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setMinificationFilter">Qt3DRender::QTextureData::<wbr>setMinificationFilter(Qt3DRender::QAbstractTexture::Filter)</a></code></p>
     */
    @QtUninvokable
    public final void setMinificationFilter(io.qt.qt3d.render.QAbstractTexture.@NonNull Filter filter){
        setMinificationFilter_native_Qt3DRender_QAbstractTexture_Filter(QtJambi_LibraryUtilities.internal.nativeId(this), filter.value());
    }
    
    @QtUninvokable
    private native void setMinificationFilter_native_Qt3DRender_QAbstractTexture_Filter(long __this__nativeId, int filter);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setTarget">Qt3DRender::QTextureData::<wbr>setTarget(Qt3DRender::QAbstractTexture::Target)</a></code></p>
     */
    @QtUninvokable
    public final void setTarget(io.qt.qt3d.render.QAbstractTexture.@NonNull Target target){
        setTarget_native_Qt3DRender_QAbstractTexture_Target(QtJambi_LibraryUtilities.internal.nativeId(this), target.value());
    }
    
    @QtUninvokable
    private native void setTarget_native_Qt3DRender_QAbstractTexture_Target(long __this__nativeId, int target);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setWidth">Qt3DRender::QTextureData::<wbr>setWidth(int)</a></code></p>
     */
    @QtUninvokable
    public final void setWidth(int width){
        setWidth_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), width);
    }
    
    @QtUninvokable
    private native void setWidth_native_int(long __this__nativeId, int width);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setWrapModeX">Qt3DRender::QTextureData::<wbr>setWrapModeX(Qt3DRender::QTextureWrapMode::WrapMode)</a></code></p>
     */
    @QtUninvokable
    public final void setWrapModeX(io.qt.qt3d.render.QTextureWrapMode.@NonNull WrapMode wrapModeX){
        setWrapModeX_native_Qt3DRender_QTextureWrapMode_WrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), wrapModeX.value());
    }
    
    @QtUninvokable
    private native void setWrapModeX_native_Qt3DRender_QTextureWrapMode_WrapMode(long __this__nativeId, int wrapModeX);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setWrapModeY">Qt3DRender::QTextureData::<wbr>setWrapModeY(Qt3DRender::QTextureWrapMode::WrapMode)</a></code></p>
     */
    @QtUninvokable
    public final void setWrapModeY(io.qt.qt3d.render.QTextureWrapMode.@NonNull WrapMode wrapModeY){
        setWrapModeY_native_Qt3DRender_QTextureWrapMode_WrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), wrapModeY.value());
    }
    
    @QtUninvokable
    private native void setWrapModeY_native_Qt3DRender_QTextureWrapMode_WrapMode(long __this__nativeId, int wrapModeY);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#setWrapModeZ">Qt3DRender::QTextureData::<wbr>setWrapModeZ(Qt3DRender::QTextureWrapMode::WrapMode)</a></code></p>
     */
    @QtUninvokable
    public final void setWrapModeZ(io.qt.qt3d.render.QTextureWrapMode.@NonNull WrapMode wrapModeZ){
        setWrapModeZ_native_Qt3DRender_QTextureWrapMode_WrapMode(QtJambi_LibraryUtilities.internal.nativeId(this), wrapModeZ.value());
    }
    
    @QtUninvokable
    private native void setWrapModeZ_native_Qt3DRender_QTextureWrapMode_WrapMode(long __this__nativeId, int wrapModeZ);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#target">Qt3DRender::QTextureData::<wbr>target()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractTexture.@NonNull Target target(){
        return io.qt.qt3d.render.QAbstractTexture.Target.resolve(target_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int target_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#width">Qt3DRender::QTextureData::<wbr>width()const</a></code></p>
     */
    @QtUninvokable
    public final int width(){
        return width_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int width_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#wrapModeX">Qt3DRender::QTextureData::<wbr>wrapModeX()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.QTextureWrapMode.@NonNull WrapMode wrapModeX(){
        return io.qt.qt3d.render.QTextureWrapMode.WrapMode.resolve(wrapModeX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int wrapModeX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#wrapModeY">Qt3DRender::QTextureData::<wbr>wrapModeY()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.QTextureWrapMode.@NonNull WrapMode wrapModeY(){
        return io.qt.qt3d.render.QTextureWrapMode.WrapMode.resolve(wrapModeY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int wrapModeY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qtexturedata.html#wrapModeZ">Qt3DRender::QTextureData::<wbr>wrapModeZ()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.QTextureWrapMode.@NonNull WrapMode wrapModeZ(){
        return io.qt.qt3d.render.QTextureWrapMode.WrapMode.resolve(wrapModeZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int wrapModeZ_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QTextureData(QPrivateConstructor p) { super(p); } 
    
    
    /**
     * <p>Creates and returns a copy of this object.</p>
     */
    @QtUninvokable
    @Override
    public QTextureData clone() {
        return clone_native(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    private static native QTextureData clone_native(long __this_nativeId);
}
