package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Encapsulate a Spot Light object in a Qt 3D scene</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html">Qt3DRender::QSpotLight</a></code></p>
 */
public class QSpotLight extends io.qt.qt3d.render.QAbstractLight
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QSpotLight.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#constantAttenuation-prop">Qt3DRender::QSpotLight::<wbr>constantAttenuationChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="constantAttenuation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> constantAttenuationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#cutOffAngle-prop">Qt3DRender::QSpotLight::<wbr>cutOffAngleChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="cutOffAngle")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> cutOffAngleChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#linearAttenuation-prop">Qt3DRender::QSpotLight::<wbr>linearAttenuationChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="linearAttenuation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> linearAttenuationChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#localDirection-prop">Qt3DRender::QSpotLight::<wbr>localDirectionChanged(QVector3D)</a></code></p>
     */
    @QtPropertyNotify(name="localDirection")
    public final @NonNull Signal1<io.qt.gui.@NonNull QVector3D> localDirectionChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#quadraticAttenuation-prop">Qt3DRender::QSpotLight::<wbr>quadraticAttenuationChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="quadraticAttenuation")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> quadraticAttenuationChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#QSpotLight">Qt3DRender::QSpotLight::<wbr>QSpotLight(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QSpotLight(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QSpotLight instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#constantAttenuation-prop">Qt3DRender::QSpotLight::<wbr>constantAttenuation()const</a></code></p>
     */
    @QtPropertyReader(name="constantAttenuation")
    @QtUninvokable
    public final float constantAttenuation(){
        return constantAttenuation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float constantAttenuation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#cutOffAngle-prop">Qt3DRender::QSpotLight::<wbr>cutOffAngle()const</a></code></p>
     */
    @QtPropertyReader(name="cutOffAngle")
    @QtUninvokable
    public final float cutOffAngle(){
        return cutOffAngle_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float cutOffAngle_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#linearAttenuation-prop">Qt3DRender::QSpotLight::<wbr>linearAttenuation()const</a></code></p>
     */
    @QtPropertyReader(name="linearAttenuation")
    @QtUninvokable
    public final float linearAttenuation(){
        return linearAttenuation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float linearAttenuation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#localDirection-prop">Qt3DRender::QSpotLight::<wbr>localDirection()const</a></code></p>
     */
    @QtPropertyReader(name="localDirection")
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D localDirection(){
        return localDirection_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D localDirection_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#quadraticAttenuation-prop">Qt3DRender::QSpotLight::<wbr>quadraticAttenuation()const</a></code></p>
     */
    @QtPropertyReader(name="quadraticAttenuation")
    @QtUninvokable
    public final float quadraticAttenuation(){
        return quadraticAttenuation_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float quadraticAttenuation_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#constantAttenuation-prop">Qt3DRender::QSpotLight::<wbr>setConstantAttenuation(float)</a></code></p>
     */
    @QtPropertyWriter(name="constantAttenuation")
    public final void setConstantAttenuation(float value){
        setConstantAttenuation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setConstantAttenuation_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#cutOffAngle-prop">Qt3DRender::QSpotLight::<wbr>setCutOffAngle(float)</a></code></p>
     */
    @QtPropertyWriter(name="cutOffAngle")
    public final void setCutOffAngle(float cutOffAngle){
        setCutOffAngle_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), cutOffAngle);
    }
    
    private native void setCutOffAngle_native_float(long __this__nativeId, float cutOffAngle);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#linearAttenuation-prop">Qt3DRender::QSpotLight::<wbr>setLinearAttenuation(float)</a></code></p>
     */
    @QtPropertyWriter(name="linearAttenuation")
    public final void setLinearAttenuation(float value){
        setLinearAttenuation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setLinearAttenuation_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#localDirection-prop">Qt3DRender::QSpotLight::<wbr>setLocalDirection(QVector3D)</a></code></p>
     */
    @QtPropertyWriter(name="localDirection")
    public final void setLocalDirection(io.qt.gui.@NonNull QVector3D localDirection){
        setLocalDirection_native_cref_QVector3D(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(localDirection));
    }
    
    private native void setLocalDirection_native_cref_QVector3D(long __this__nativeId, long localDirection);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qspotlight.html#quadraticAttenuation-prop">Qt3DRender::QSpotLight::<wbr>setQuadraticAttenuation(float)</a></code></p>
     */
    @QtPropertyWriter(name="quadraticAttenuation")
    public final void setQuadraticAttenuation(float value){
        setQuadraticAttenuation_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setQuadraticAttenuation_native_float(long __this__nativeId, float value);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QSpotLight(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QSpotLight(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QSpotLight instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QSpotLight(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QSpotLight() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #constantAttenuation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getConstantAttenuation() {
        return constantAttenuation();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #cutOffAngle()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getCutOffAngle() {
        return cutOffAngle();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #linearAttenuation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getLinearAttenuation() {
        return linearAttenuation();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #localDirection()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getLocalDirection() {
        return localDirection();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #quadraticAttenuation()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getQuadraticAttenuation() {
        return quadraticAttenuation();
    }
}
