package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Encapsulates a target (usually a frame buffer object) which the renderer can render into</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qrendertarget.html">Qt3DRender::QRenderTarget</a></code></p>
 */
public class QRenderTarget extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderTarget.class);
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertarget.html#QRenderTarget">Qt3DRender::QRenderTarget::<wbr>QRenderTarget(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QRenderTarget(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderTarget instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertarget.html#addOutput">Qt3DRender::QRenderTarget::<wbr>addOutput(Qt3DRender::QRenderTargetOutput*)</a></code></p>
     */
    @QtUninvokable
    public final void addOutput(io.qt.qt3d.render.@Nullable QRenderTargetOutput output){
        addOutput_native_Qt3DRender_QRenderTargetOutput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(output));
    }
    
    @QtUninvokable
    private native void addOutput_native_Qt3DRender_QRenderTargetOutput_ptr(long __this__nativeId, long output);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertarget.html#outputs">Qt3DRender::QRenderTarget::<wbr>outputs()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QRenderTargetOutput> outputs(){
        return outputs_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QRenderTargetOutput> outputs_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendertarget.html#removeOutput">Qt3DRender::QRenderTarget::<wbr>removeOutput(Qt3DRender::QRenderTargetOutput*)</a></code></p>
     */
    @QtUninvokable
    public final void removeOutput(io.qt.qt3d.render.@Nullable QRenderTargetOutput output){
        removeOutput_native_Qt3DRender_QRenderTargetOutput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(output));
    }
    
    @QtUninvokable
    private native void removeOutput_native_Qt3DRender_QRenderTargetOutput_ptr(long __this__nativeId, long output);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRenderTarget(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRenderTarget(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRenderTarget instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRenderTarget(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderTarget() {
        this((io.qt.qt3d.core.QNode)null);
    }
}
