package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>FrameGraph node offers a way of specifying a set of QRenderState objects to be applied during the execution of a framegraph branch</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qrenderstateset.html">Qt3DRender::QRenderStateSet</a></code></p>
 */
public class QRenderStateSet extends io.qt.qt3d.render.QFrameGraphNode
{
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderStateSet.class);
    
    
    /**
     * <p>See <code>Qt3DRender::QRenderStateSet::<wbr>QRenderStateSet(Qt3DCore::QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QRenderStateSet(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderStateSet instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderstateset.html#addRenderState">Qt3DRender::QRenderStateSet::<wbr>addRenderState(Qt3DRender::QRenderState*)</a></code></p>
     */
    @QtUninvokable
    public final void addRenderState(io.qt.qt3d.render.@Nullable QRenderState state){
        addRenderState_native_Qt3DRender_QRenderState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state));
    }
    
    @QtUninvokable
    private native void addRenderState_native_Qt3DRender_QRenderState_ptr(long __this__nativeId, long state);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderstateset.html#removeRenderState">Qt3DRender::QRenderStateSet::<wbr>removeRenderState(Qt3DRender::QRenderState*)</a></code></p>
     */
    @QtUninvokable
    public final void removeRenderState(io.qt.qt3d.render.@Nullable QRenderState state){
        removeRenderState_native_Qt3DRender_QRenderState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state));
    }
    
    @QtUninvokable
    private native void removeRenderState_native_Qt3DRender_QRenderState_ptr(long __this__nativeId, long state);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderstateset.html#renderStates">Qt3DRender::QRenderStateSet::<wbr>renderStates()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QRenderState> renderStates(){
        return renderStates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QRenderState> renderStates_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRenderStateSet(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRenderStateSet(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRenderStateSet instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRenderStateSet(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderStateSet() {
        this((io.qt.qt3d.core.QNode)null);
    }
}
