package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Encapsulates a Render Pass</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html">Qt3DRender::QRenderPass</a></code></p>
 */
public class QRenderPass extends io.qt.qt3d.core.QNode
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderPass.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#shaderProgram-prop">Qt3DRender::QRenderPass::<wbr>shaderProgramChanged(Qt3DRender::QShaderProgram*)</a></code></p>
     */
    @QtPropertyNotify(name="shaderProgram")
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QShaderProgram> shaderProgramChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#QRenderPass">Qt3DRender::QRenderPass::<wbr>QRenderPass(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QRenderPass(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderPass instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#addFilterKey">Qt3DRender::QRenderPass::<wbr>addFilterKey(Qt3DRender::QFilterKey*)</a></code></p>
     */
    @QtUninvokable
    public final void addFilterKey(io.qt.qt3d.render.@Nullable QFilterKey filterKey){
        addFilterKey_native_Qt3DRender_QFilterKey_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(filterKey));
    }
    
    @QtUninvokable
    private native void addFilterKey_native_Qt3DRender_QFilterKey_ptr(long __this__nativeId, long filterKey);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#addParameter">Qt3DRender::QRenderPass::<wbr>addParameter(Qt3DRender::QParameter*)</a></code></p>
     */
    @QtUninvokable
    public final void addParameter(io.qt.qt3d.render.@Nullable QParameter p){
        addParameter_native_Qt3DRender_QParameter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(p));
    }
    
    @QtUninvokable
    private native void addParameter_native_Qt3DRender_QParameter_ptr(long __this__nativeId, long p);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#addRenderState">Qt3DRender::QRenderPass::<wbr>addRenderState(Qt3DRender::QRenderState*)</a></code></p>
     */
    @QtUninvokable
    public final void addRenderState(io.qt.qt3d.render.@Nullable QRenderState state){
        addRenderState_native_Qt3DRender_QRenderState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state));
    }
    
    @QtUninvokable
    private native void addRenderState_native_Qt3DRender_QRenderState_ptr(long __this__nativeId, long state);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#filterKeys">Qt3DRender::QRenderPass::<wbr>filterKeys()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QFilterKey> filterKeys(){
        return filterKeys_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QFilterKey> filterKeys_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#parameters">Qt3DRender::QRenderPass::<wbr>parameters()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QParameter> parameters(){
        return parameters_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QParameter> parameters_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#removeFilterKey">Qt3DRender::QRenderPass::<wbr>removeFilterKey(Qt3DRender::QFilterKey*)</a></code></p>
     */
    @QtUninvokable
    public final void removeFilterKey(io.qt.qt3d.render.@Nullable QFilterKey filterKey){
        removeFilterKey_native_Qt3DRender_QFilterKey_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(filterKey));
    }
    
    @QtUninvokable
    private native void removeFilterKey_native_Qt3DRender_QFilterKey_ptr(long __this__nativeId, long filterKey);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#removeParameter">Qt3DRender::QRenderPass::<wbr>removeParameter(Qt3DRender::QParameter*)</a></code></p>
     */
    @QtUninvokable
    public final void removeParameter(io.qt.qt3d.render.@Nullable QParameter p){
        removeParameter_native_Qt3DRender_QParameter_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(p));
    }
    
    @QtUninvokable
    private native void removeParameter_native_Qt3DRender_QParameter_ptr(long __this__nativeId, long p);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#removeRenderState">Qt3DRender::QRenderPass::<wbr>removeRenderState(Qt3DRender::QRenderState*)</a></code></p>
     */
    @QtUninvokable
    public final void removeRenderState(io.qt.qt3d.render.@Nullable QRenderState state){
        removeRenderState_native_Qt3DRender_QRenderState_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(state));
    }
    
    @QtUninvokable
    private native void removeRenderState_native_Qt3DRender_QRenderState_ptr(long __this__nativeId, long state);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#renderStates">Qt3DRender::QRenderPass::<wbr>renderStates()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QRenderState> renderStates(){
        return renderStates_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QRenderState> renderStates_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#shaderProgram-prop">Qt3DRender::QRenderPass::<wbr>setShaderProgram(Qt3DRender::QShaderProgram*)</a></code></p>
     */
    @QtPropertyWriter(name="shaderProgram")
    public final void setShaderProgram(io.qt.qt3d.render.@Nullable QShaderProgram shaderProgram){
        setShaderProgram_native_Qt3DRender_QShaderProgram_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(shaderProgram));
    }
    
    private native void setShaderProgram_native_Qt3DRender_QShaderProgram_ptr(long __this__nativeId, long shaderProgram);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrenderpass.html#shaderProgram-prop">Qt3DRender::QRenderPass::<wbr>shaderProgram()const</a></code></p>
     */
    @QtPropertyReader(name="shaderProgram")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QShaderProgram shaderProgram(){
        return shaderProgram_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QShaderProgram shaderProgram_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRenderPass(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRenderPass(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRenderPass instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRenderPass(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderPass() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #shaderProgram()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QShaderProgram getShaderProgram() {
        return shaderProgram();
    }
}
