package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Holds settings related to available rendering engines</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html">Qt3DRender::QRenderCapabilities</a></code></p>
 */
public class QRenderCapabilities extends io.qt.core.QObject
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRenderCapabilities.class);
    
    /**
     * <p>Java wrapper for Qt enum <code>Qt3DRender::QRenderCapabilities::API</code></p>
     */
    public enum API implements QtEnumerator {
        /**
         * <p>Representing <code>Qt3DRender::<wbr>QRenderCapabilities::<wbr>OpenGL</code></p>
         */
        OpenGL(1),
        /**
         * <p>Representing <code>Qt3DRender::<wbr>QRenderCapabilities::<wbr>OpenGLES</code></p>
         */
        OpenGLES(2),
        /**
         * <p>Representing <code>Qt3DRender::<wbr>QRenderCapabilities::<wbr>Vulkan</code></p>
         */
        Vulkan(3),
        /**
         * <p>Representing <code>Qt3DRender::<wbr>QRenderCapabilities::<wbr>DirectX</code></p>
         */
        DirectX(4),
        /**
         * <p>Representing <code>Qt3DRender::<wbr>QRenderCapabilities::<wbr>RHI</code></p>
         */
        RHI(5);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private API(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull API resolve(int value) {
            switch (value) {
            case 1: return OpenGL;
            case 2: return OpenGLES;
            case 3: return Vulkan;
            case 4: return DirectX;
            case 5: return RHI;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code>Qt3DRender::QRenderCapabilities::Profile</code></p>
     */
    public enum Profile implements QtEnumerator {
        /**
         * <p>Representing <code>Qt3DRender::<wbr>QRenderCapabilities::<wbr>NoProfile</code></p>
         */
        NoProfile(0),
        /**
         * <p>Representing <code>Qt3DRender::<wbr>QRenderCapabilities::<wbr>CoreProfile</code></p>
         */
        CoreProfile(1),
        /**
         * <p>Representing <code>Qt3DRender::<wbr>QRenderCapabilities::<wbr>CompatibilityProfile</code></p>
         */
        CompatibilityProfile(2);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Profile(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Profile resolve(int value) {
            switch (value) {
            case 0: return NoProfile;
            case 1: return CoreProfile;
            case 2: return CompatibilityProfile;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    
    /**
     * <p>See <code>Qt3DRender::QRenderCapabilities::<wbr>QRenderCapabilities(QObject*)</code></p>
     */
    public QRenderCapabilities(io.qt.core.@Nullable QObject parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRenderCapabilities instance, io.qt.core.QObject parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#api-prop">Qt3DRender::QRenderCapabilities::<wbr>api()const</a></code></p>
     */
    @QtPropertyReader(name="api")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderCapabilities.@NonNull API api(){
        return io.qt.qt3d.render.QRenderCapabilities.API.resolve(api_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int api_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#driverVersion-prop">Qt3DRender::QRenderCapabilities::<wbr>driverVersion()const</a></code></p>
     */
    @QtPropertyReader(name="driverVersion")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String driverVersion(){
        return driverVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String driverVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#extensions-prop">Qt3DRender::QRenderCapabilities::<wbr>extensions()const</a></code></p>
     */
    @QtPropertyReader(name="extensions")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList extensions(){
        return extensions_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QStringList extensions_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#glslVersion-prop">Qt3DRender::QRenderCapabilities::<wbr>glslVersion()const</a></code></p>
     */
    @QtPropertyReader(name="glslVersion")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String glslVersion(){
        return glslVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String glslVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#valid-prop">Qt3DRender::QRenderCapabilities::<wbr>isValid()const</a></code></p>
     */
    @QtPropertyReader(name="valid")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean isValid(){
        return isValid_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean isValid_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#majorVersion-prop">Qt3DRender::QRenderCapabilities::<wbr>majorVersion()const</a></code></p>
     */
    @QtPropertyReader(name="majorVersion")
    @QtPropertyConstant
    @QtUninvokable
    public final int majorVersion(){
        return majorVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int majorVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxComputeInvocations-prop">Qt3DRender::QRenderCapabilities::<wbr>maxComputeInvocations()const</a></code></p>
     */
    @QtPropertyReader(name="maxComputeInvocations")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxComputeInvocations(){
        return maxComputeInvocations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxComputeInvocations_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxComputeSharedMemorySize-prop">Qt3DRender::QRenderCapabilities::<wbr>maxComputeSharedMemorySize()const</a></code></p>
     */
    @QtPropertyReader(name="maxComputeSharedMemorySize")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxComputeSharedMemorySize(){
        return maxComputeSharedMemorySize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxComputeSharedMemorySize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxImageUnits-prop">Qt3DRender::QRenderCapabilities::<wbr>maxImageUnits()const</a></code></p>
     */
    @QtPropertyReader(name="maxImageUnits")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxImageUnits(){
        return maxImageUnits_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxImageUnits_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxSSBOBindings-prop">Qt3DRender::QRenderCapabilities::<wbr>maxSSBOBindings()const</a></code></p>
     */
    @QtPropertyReader(name="maxSSBOBindings")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxSSBOBindings(){
        return maxSSBOBindings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxSSBOBindings_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxSSBOSize-prop">Qt3DRender::QRenderCapabilities::<wbr>maxSSBOSize()const</a></code></p>
     */
    @QtPropertyReader(name="maxSSBOSize")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxSSBOSize(){
        return maxSSBOSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxSSBOSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxSamples-prop">Qt3DRender::QRenderCapabilities::<wbr>maxSamples()const</a></code></p>
     */
    @QtPropertyReader(name="maxSamples")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxSamples(){
        return maxSamples_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxSamples_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxTextureLayers-prop">Qt3DRender::QRenderCapabilities::<wbr>maxTextureLayers()const</a></code></p>
     */
    @QtPropertyReader(name="maxTextureLayers")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxTextureLayers(){
        return maxTextureLayers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxTextureLayers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxTextureSize-prop">Qt3DRender::QRenderCapabilities::<wbr>maxTextureSize()const</a></code></p>
     */
    @QtPropertyReader(name="maxTextureSize")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxTextureSize(){
        return maxTextureSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxTextureSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxTextureUnits-prop">Qt3DRender::QRenderCapabilities::<wbr>maxTextureUnits()const</a></code></p>
     */
    @QtPropertyReader(name="maxTextureUnits")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxTextureUnits(){
        return maxTextureUnits_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxTextureUnits_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxUBOBindings-prop">Qt3DRender::QRenderCapabilities::<wbr>maxUBOBindings()const</a></code></p>
     */
    @QtPropertyReader(name="maxUBOBindings")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxUBOBindings(){
        return maxUBOBindings_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxUBOBindings_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxUBOSize-prop">Qt3DRender::QRenderCapabilities::<wbr>maxUBOSize()const</a></code></p>
     */
    @QtPropertyReader(name="maxUBOSize")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxUBOSize(){
        return maxUBOSize_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxUBOSize_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxWorkGroupCountX-prop">Qt3DRender::QRenderCapabilities::<wbr>maxWorkGroupCountX()const</a></code></p>
     */
    @QtPropertyReader(name="maxWorkGroupCountX")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxWorkGroupCountX(){
        return maxWorkGroupCountX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxWorkGroupCountX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxWorkGroupCountY-prop">Qt3DRender::QRenderCapabilities::<wbr>maxWorkGroupCountY()const</a></code></p>
     */
    @QtPropertyReader(name="maxWorkGroupCountY")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxWorkGroupCountY(){
        return maxWorkGroupCountY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxWorkGroupCountY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxWorkGroupCountZ-prop">Qt3DRender::QRenderCapabilities::<wbr>maxWorkGroupCountZ()const</a></code></p>
     */
    @QtPropertyReader(name="maxWorkGroupCountZ")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxWorkGroupCountZ(){
        return maxWorkGroupCountZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxWorkGroupCountZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxWorkGroupSizeX-prop">Qt3DRender::QRenderCapabilities::<wbr>maxWorkGroupSizeX()const</a></code></p>
     */
    @QtPropertyReader(name="maxWorkGroupSizeX")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxWorkGroupSizeX(){
        return maxWorkGroupSizeX_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxWorkGroupSizeX_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxWorkGroupSizeY-prop">Qt3DRender::QRenderCapabilities::<wbr>maxWorkGroupSizeY()const</a></code></p>
     */
    @QtPropertyReader(name="maxWorkGroupSizeY")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxWorkGroupSizeY(){
        return maxWorkGroupSizeY_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxWorkGroupSizeY_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#maxWorkGroupSizeZ-prop">Qt3DRender::QRenderCapabilities::<wbr>maxWorkGroupSizeZ()const</a></code></p>
     */
    @QtPropertyReader(name="maxWorkGroupSizeZ")
    @QtPropertyConstant
    @QtUninvokable
    public final int maxWorkGroupSizeZ(){
        return maxWorkGroupSizeZ_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int maxWorkGroupSizeZ_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#minorVersion-prop">Qt3DRender::QRenderCapabilities::<wbr>minorVersion()const</a></code></p>
     */
    @QtPropertyReader(name="minorVersion")
    @QtPropertyConstant
    @QtUninvokable
    public final int minorVersion(){
        return minorVersion_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int minorVersion_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#profile-prop">Qt3DRender::QRenderCapabilities::<wbr>profile()const</a></code></p>
     */
    @QtPropertyReader(name="profile")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderCapabilities.@NonNull Profile profile(){
        return io.qt.qt3d.render.QRenderCapabilities.Profile.resolve(profile_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int profile_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#renderer-prop">Qt3DRender::QRenderCapabilities::<wbr>renderer()const</a></code></p>
     */
    @QtPropertyReader(name="renderer")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String renderer(){
        return renderer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String renderer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#supportsCompute-prop">Qt3DRender::QRenderCapabilities::<wbr>supportsCompute()const</a></code></p>
     */
    @QtPropertyReader(name="supportsCompute")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean supportsCompute(){
        return supportsCompute_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean supportsCompute_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#supportsImageStore-prop">Qt3DRender::QRenderCapabilities::<wbr>supportsImageStore()const</a></code></p>
     */
    @QtPropertyReader(name="supportsImageStore")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean supportsImageStore(){
        return supportsImageStore_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean supportsImageStore_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#supportsSSBO-prop">Qt3DRender::QRenderCapabilities::<wbr>supportsSSBO()const</a></code></p>
     */
    @QtPropertyReader(name="supportsSSBO")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean supportsSSBO(){
        return supportsSSBO_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean supportsSSBO_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#supportsUBO-prop">Qt3DRender::QRenderCapabilities::<wbr>supportsUBO()const</a></code></p>
     */
    @QtPropertyReader(name="supportsUBO")
    @QtPropertyConstant
    @QtUninvokable
    public final boolean supportsUBO(){
        return supportsUBO_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native boolean supportsUBO_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrendercapabilities.html#vendor-prop">Qt3DRender::QRenderCapabilities::<wbr>vendor()const</a></code></p>
     */
    @QtPropertyReader(name="vendor")
    @QtPropertyConstant
    @QtUninvokable
    public final java.lang.@NonNull String vendor(){
        return vendor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native java.lang.String vendor_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRenderCapabilities(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRenderCapabilities(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRenderCapabilities instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRenderCapabilities(io.qt.core.QObject)}
     *  with <code>parent = null</code>.</p>
     */
    public QRenderCapabilities() {
        this((io.qt.core.QObject)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #api()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderCapabilities.@NonNull API getApi() {
        return api();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #driverVersion()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getDriverVersion() {
        return driverVersion();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #extensions()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QStringList getExtensions() {
        return extensions();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #glslVersion()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getGlslVersion() {
        return glslVersion();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #isValid()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getValid() {
        return isValid();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #majorVersion()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMajorVersion() {
        return majorVersion();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxComputeInvocations()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxComputeInvocations() {
        return maxComputeInvocations();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxComputeSharedMemorySize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxComputeSharedMemorySize() {
        return maxComputeSharedMemorySize();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxImageUnits()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxImageUnits() {
        return maxImageUnits();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxSSBOBindings()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxSSBOBindings() {
        return maxSSBOBindings();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxSSBOSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxSSBOSize() {
        return maxSSBOSize();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxSamples()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxSamples() {
        return maxSamples();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxTextureLayers()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxTextureLayers() {
        return maxTextureLayers();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxTextureSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxTextureSize() {
        return maxTextureSize();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxTextureUnits()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxTextureUnits() {
        return maxTextureUnits();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxUBOBindings()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxUBOBindings() {
        return maxUBOBindings();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxUBOSize()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxUBOSize() {
        return maxUBOSize();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxWorkGroupCountX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxWorkGroupCountX() {
        return maxWorkGroupCountX();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxWorkGroupCountY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxWorkGroupCountY() {
        return maxWorkGroupCountY();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxWorkGroupCountZ()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxWorkGroupCountZ() {
        return maxWorkGroupCountZ();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxWorkGroupSizeX()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxWorkGroupSizeX() {
        return maxWorkGroupSizeX();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxWorkGroupSizeY()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxWorkGroupSizeY() {
        return maxWorkGroupSizeY();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #maxWorkGroupSizeZ()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMaxWorkGroupSizeZ() {
        return maxWorkGroupSizeZ();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #minorVersion()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getMinorVersion() {
        return minorVersion();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #profile()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QRenderCapabilities.@NonNull Profile getProfile() {
        return profile();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #renderer()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getRenderer() {
        return renderer();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #supportsCompute()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSupportsCompute() {
        return supportsCompute();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #supportsImageStore()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSupportsImageStore() {
        return supportsImageStore();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #supportsSSBO()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSupportsSSBO() {
        return supportsSSBO();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #supportsUBO()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final boolean getSupportsUBO() {
        return supportsUBO();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vendor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final java.lang.@NonNull String getVendor() {
        return vendor();
    }
}
