package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Render state allows to control the type of rasterization to be performed</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html">Qt3DRender::QRasterMode</a></code></p>
 */
public class QRasterMode extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QRasterMode.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#FaceMode-enum">Qt3DRender::QRasterMode::FaceMode</a></code></p>
     */
    public enum FaceMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#FaceMode-enum">Qt3DRender::<wbr>QRasterMode::<wbr>Front</a></code></p>
         */
        Front(1028),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#FaceMode-enum">Qt3DRender::<wbr>QRasterMode::<wbr>Back</a></code></p>
         */
        Back(1029),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#FaceMode-enum">Qt3DRender::<wbr>QRasterMode::<wbr>FrontAndBack</a></code></p>
         */
        FrontAndBack(1032);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FaceMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FaceMode resolve(int value) {
            switch (value) {
            case 1028: return Front;
            case 1029: return Back;
            case 1032: return FrontAndBack;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#RasterMode-enum">Qt3DRender::QRasterMode::RasterMode</a></code></p>
     */
    public enum RasterMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#RasterMode-enum">Qt3DRender::<wbr>QRasterMode::<wbr>Points</a></code></p>
         */
        Points(6912),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#RasterMode-enum">Qt3DRender::<wbr>QRasterMode::<wbr>Lines</a></code></p>
         */
        Lines(6913),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#RasterMode-enum">Qt3DRender::<wbr>QRasterMode::<wbr>Fill</a></code></p>
         */
        Fill(6914);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RasterMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RasterMode resolve(int value) {
            switch (value) {
            case 6912: return Points;
            case 6913: return Lines;
            case 6914: return Fill;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#faceMode-prop">Qt3DRender::QRasterMode::<wbr>faceModeChanged(Qt3DRender::QRasterMode::FaceMode)</a></code></p>
     */
    @QtPropertyNotify(name="faceMode")
    public final @NonNull Signal1<io.qt.qt3d.render.QRasterMode.@NonNull FaceMode> faceModeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#rasterMode-prop">Qt3DRender::QRasterMode::<wbr>rasterModeChanged(Qt3DRender::QRasterMode::RasterMode)</a></code></p>
     */
    @QtPropertyNotify(name="rasterMode")
    public final @NonNull Signal1<io.qt.qt3d.render.QRasterMode.@NonNull RasterMode> rasterModeChanged = new Signal1<>();
    
    /**
     * <p>See <code>Qt3DRender::QRasterMode::<wbr>QRasterMode(Qt3DCore::QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QRasterMode(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QRasterMode instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#faceMode-prop">Qt3DRender::QRasterMode::<wbr>faceMode()const</a></code></p>
     */
    @QtPropertyReader(name="faceMode")
    @QtUninvokable
    public final io.qt.qt3d.render.QRasterMode.@NonNull FaceMode faceMode(){
        return io.qt.qt3d.render.QRasterMode.FaceMode.resolve(faceMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int faceMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#rasterMode-prop">Qt3DRender::QRasterMode::<wbr>rasterMode()const</a></code></p>
     */
    @QtPropertyReader(name="rasterMode")
    @QtUninvokable
    public final io.qt.qt3d.render.QRasterMode.@NonNull RasterMode rasterMode(){
        return io.qt.qt3d.render.QRasterMode.RasterMode.resolve(rasterMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int rasterMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#faceMode-prop">Qt3DRender::QRasterMode::<wbr>setFaceMode(Qt3DRender::QRasterMode::FaceMode)</a></code></p>
     */
    @QtPropertyWriter(name="faceMode")
    public final void setFaceMode(io.qt.qt3d.render.QRasterMode.@NonNull FaceMode faceMode){
        setFaceMode_native_Qt3DRender_QRasterMode_FaceMode(QtJambi_LibraryUtilities.internal.nativeId(this), faceMode.value());
    }
    
    private native void setFaceMode_native_Qt3DRender_QRasterMode_FaceMode(long __this__nativeId, int faceMode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qrastermode.html#rasterMode-prop">Qt3DRender::QRasterMode::<wbr>setRasterMode(Qt3DRender::QRasterMode::RasterMode)</a></code></p>
     */
    @QtPropertyWriter(name="rasterMode")
    public final void setRasterMode(io.qt.qt3d.render.QRasterMode.@NonNull RasterMode rasterMode){
        setRasterMode_native_Qt3DRender_QRasterMode_RasterMode(QtJambi_LibraryUtilities.internal.nativeId(this), rasterMode.value());
    }
    
    private native void setRasterMode_native_Qt3DRender_QRasterMode_RasterMode(long __this__nativeId, int rasterMode);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QRasterMode(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QRasterMode(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QRasterMode instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QRasterMode(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QRasterMode() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #faceMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QRasterMode.@NonNull FaceMode getFaceMode() {
        return faceMode();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #rasterMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QRasterMode.@NonNull RasterMode getRasterMode() {
        return rasterMode();
    }
}
