package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Sets the scale and steps to calculate depth values for polygon offsets</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qpolygonoffset.html">Qt3DRender::QPolygonOffset</a></code></p>
 */
public class QPolygonOffset extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPolygonOffset.class);
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpolygonoffset.html#depthSteps-prop">Qt3DRender::QPolygonOffset::<wbr>depthStepsChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="depthSteps")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> depthStepsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpolygonoffset.html#scaleFactor-prop">Qt3DRender::QPolygonOffset::<wbr>scaleFactorChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="scaleFactor")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> scaleFactorChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpolygonoffset.html#QPolygonOffset">Qt3DRender::QPolygonOffset::<wbr>QPolygonOffset(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QPolygonOffset(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPolygonOffset instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpolygonoffset.html#depthSteps-prop">Qt3DRender::QPolygonOffset::<wbr>depthSteps()const</a></code></p>
     */
    @QtPropertyReader(name="depthSteps")
    @QtUninvokable
    public final float depthSteps(){
        return depthSteps_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float depthSteps_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpolygonoffset.html#scaleFactor-prop">Qt3DRender::QPolygonOffset::<wbr>scaleFactor()const</a></code></p>
     */
    @QtPropertyReader(name="scaleFactor")
    @QtUninvokable
    public final float scaleFactor(){
        return scaleFactor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float scaleFactor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpolygonoffset.html#depthSteps-prop">Qt3DRender::QPolygonOffset::<wbr>setDepthSteps(float)</a></code></p>
     */
    @QtPropertyWriter(name="depthSteps")
    public final void setDepthSteps(float depthSteps){
        setDepthSteps_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), depthSteps);
    }
    
    private native void setDepthSteps_native_float(long __this__nativeId, float depthSteps);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpolygonoffset.html#scaleFactor-prop">Qt3DRender::QPolygonOffset::<wbr>setScaleFactor(float)</a></code></p>
     */
    @QtPropertyWriter(name="scaleFactor")
    public final void setScaleFactor(float scaleFactor){
        setScaleFactor_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), scaleFactor);
    }
    
    private native void setScaleFactor_native_float(long __this__nativeId, float scaleFactor);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPolygonOffset(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QPolygonOffset(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPolygonOffset instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QPolygonOffset(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QPolygonOffset() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #depthSteps()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getDepthSteps() {
        return depthSteps();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #scaleFactor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getScaleFactor() {
        return scaleFactor();
    }
}
