package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Specifies the size of rasterized points. May either be set statically or by shader programs</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qpointsize.html">Qt3DRender::QPointSize</a></code></p>
 */
public class QPointSize extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPointSize.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#SizeMode-enum">Qt3DRender::QPointSize::SizeMode</a></code></p>
     */
    public enum SizeMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#SizeMode-enum">Qt3DRender::<wbr>QPointSize::<wbr>Fixed</a></code></p>
         */
        Fixed(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#SizeMode-enum">Qt3DRender::<wbr>QPointSize::<wbr>Programmable</a></code></p>
         */
        Programmable(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private SizeMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull SizeMode resolve(int value) {
            switch (value) {
            case 0: return Fixed;
            case 1: return Programmable;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#sizeMode-prop">Qt3DRender::QPointSize::<wbr>sizeModeChanged(Qt3DRender::QPointSize::SizeMode)</a></code></p>
     */
    @QtPropertyNotify(name="sizeMode")
    public final @NonNull Signal1<io.qt.qt3d.render.QPointSize.@NonNull SizeMode> sizeModeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#value-prop">Qt3DRender::QPointSize::<wbr>valueChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="value")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> valueChanged = new Signal1<>();
    
    /**
     * <p>See <code>Qt3DRender::QPointSize::<wbr>QPointSize(Qt3DCore::QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QPointSize(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QPointSize instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#sizeMode-prop">Qt3DRender::QPointSize::<wbr>setSizeMode(Qt3DRender::QPointSize::SizeMode)</a></code></p>
     */
    @QtPropertyWriter(name="sizeMode")
    public final void setSizeMode(io.qt.qt3d.render.QPointSize.@NonNull SizeMode sizeMode){
        setSizeMode_native_Qt3DRender_QPointSize_SizeMode(QtJambi_LibraryUtilities.internal.nativeId(this), sizeMode.value());
    }
    
    private native void setSizeMode_native_Qt3DRender_QPointSize_SizeMode(long __this__nativeId, int sizeMode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#value-prop">Qt3DRender::QPointSize::<wbr>setValue(float)</a></code></p>
     */
    @QtPropertyWriter(name="value")
    public final void setValue(float value){
        setValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), value);
    }
    
    private native void setValue_native_float(long __this__nativeId, float value);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#sizeMode-prop">Qt3DRender::QPointSize::<wbr>sizeMode()const</a></code></p>
     */
    @QtPropertyReader(name="sizeMode")
    @QtUninvokable
    public final io.qt.qt3d.render.QPointSize.@NonNull SizeMode sizeMode(){
        return io.qt.qt3d.render.QPointSize.SizeMode.resolve(sizeMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int sizeMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpointsize.html#value-prop">Qt3DRender::QPointSize::<wbr>value()const</a></code></p>
     */
    @QtPropertyReader(name="value")
    @QtUninvokable
    public final float value(){
        return value_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float value_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPointSize(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QPointSize(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPointSize instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QPointSize(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QPointSize() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #sizeMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QPointSize.@NonNull SizeMode getSizeMode() {
        return sizeMode();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #value()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getValue() {
        return value();
    }
}
