package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Holds information when a triangle is picked</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qpicktriangleevent.html">Qt3DRender::QPickTriangleEvent</a></code></p>
 */
public class QPickTriangleEvent extends io.qt.qt3d.render.QPickEvent
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QPickTriangleEvent.class);
    
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpicktriangleevent.html#QPickTriangleEvent">Qt3DRender::QPickTriangleEvent::<wbr>QPickTriangleEvent()</a></code></p>
     */
    public QPickTriangleEvent(){
        super((QPrivateConstructor)null);
        initialize_native(this);
    }
    
    private native static void initialize_native(QPickTriangleEvent instance);
    
    /**
     * <p>QPickTriangleEvent::QPickTriangleEvent Constructs a new QPickEvent with the given parameters * position, * worldIntersection, * localIntersection, * distance, * triangleIndex, * vertex1Index, * vertex2Index and * vertex3Index</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpicktriangleevent.html#QPickTriangleEvent-1">Qt3DRender::QPickTriangleEvent::<wbr>QPickTriangleEvent(QPointF,<wbr>QVector3D,<wbr>QVector3D,<wbr>float,<wbr>uint,<wbr>uint,<wbr>uint,<wbr>uint)</a></code></p>
     */
    public QPickTriangleEvent(io.qt.core.@NonNull QPointF position, io.qt.gui.@NonNull QVector3D worldIntersection, io.qt.gui.@NonNull QVector3D localIntersection, float distance, int triangleIndex, int vertex1Index, int vertex2Index, int vertex3Index){
        super((QPrivateConstructor)null);
        initialize_native(this, position, worldIntersection, localIntersection, distance, triangleIndex, vertex1Index, vertex2Index, vertex3Index);
    }
    
    private native static void initialize_native(QPickTriangleEvent instance, io.qt.core.QPointF position, io.qt.gui.QVector3D worldIntersection, io.qt.gui.QVector3D localIntersection, float distance, int triangleIndex, int vertex1Index, int vertex2Index, int vertex3Index);
    
    /**
     * <p>See <code>Qt3DRender::QPickTriangleEvent::<wbr>QPickTriangleEvent(QPointF,<wbr>QVector3D,<wbr>QVector3D,<wbr>float,<wbr>uint,<wbr>uint,<wbr>uint,<wbr>uint,<wbr>Buttons,<wbr>int,<wbr>int,<wbr>QVector3D)</code></p>
     */
    public QPickTriangleEvent(io.qt.core.@NonNull QPointF position, io.qt.gui.@NonNull QVector3D worldIntersection, io.qt.gui.@NonNull QVector3D localIntersection, float distance, int triangleIndex, int vertex1Index, int vertex2Index, int vertex3Index, io.qt.qt3d.render.QPickEvent.@NonNull Buttons button, int buttons, int modifiers, io.qt.gui.@NonNull QVector3D uvw){
        super((QPrivateConstructor)null);
        initialize_native(this, position, worldIntersection, localIntersection, distance, triangleIndex, vertex1Index, vertex2Index, vertex3Index, button, buttons, modifiers, uvw);
    }
    
    private native static void initialize_native(QPickTriangleEvent instance, io.qt.core.QPointF position, io.qt.gui.QVector3D worldIntersection, io.qt.gui.QVector3D localIntersection, float distance, int triangleIndex, int vertex1Index, int vertex2Index, int vertex3Index, io.qt.qt3d.render.QPickEvent.Buttons button, int buttons, int modifiers, io.qt.gui.QVector3D uvw);
    
    /**
     * <p>QPickTriangleEvent::triangleIndex Returns the index of the picked triangle</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpicktriangleevent.html#triangleIndex">Qt3DRender::QPickTriangleEvent::<wbr>triangleIndex()const</a></code></p>
     */
    @QtPropertyReader(name="triangleIndex")
    @QtPropertyConstant
    @QtUninvokable
    public final int triangleIndex(){
        return triangleIndex_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int triangleIndex_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpicktriangleevent.html#uvw">Qt3DRender::QPickTriangleEvent::<wbr>uvw()const</a></code></p>
     */
    @QtPropertyReader(name="uvw")
    @QtPropertyConstant
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D uvw(){
        return uvw_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QVector3D uvw_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickTriangleEvent::vertex1Index Returns the index of the first point of the picked triangle</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpicktriangleevent.html#vertex1Index">Qt3DRender::QPickTriangleEvent::<wbr>vertex1Index()const</a></code></p>
     */
    @QtPropertyReader(name="vertex1Index")
    @QtPropertyConstant
    @QtUninvokable
    public final int vertex1Index(){
        return vertex1Index_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int vertex1Index_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickTriangleEvent::vertex2Index Returns the index of the second point of the picked triangle</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpicktriangleevent.html#vertex2Index">Qt3DRender::QPickTriangleEvent::<wbr>vertex2Index()const</a></code></p>
     */
    @QtPropertyReader(name="vertex2Index")
    @QtPropertyConstant
    @QtUninvokable
    public final int vertex2Index(){
        return vertex2Index_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int vertex2Index_native_constfct(long __this__nativeId);
    
    /**
     * <p>QPickTriangleEvent::vertex3Index Returns index of third point of picked triangle</p>
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qpicktriangleevent.html#vertex3Index">Qt3DRender::QPickTriangleEvent::<wbr>vertex3Index()const</a></code></p>
     */
    @QtPropertyReader(name="vertex3Index")
    @QtPropertyConstant
    @QtUninvokable
    public final int vertex3Index(){
        return vertex3Index_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int vertex3Index_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QPickTriangleEvent(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QPickTriangleEvent(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QPickTriangleEvent instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Kotlin property getter. In Java use {@link #triangleIndex()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getTriangleIndex() {
        return triangleIndex();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #uvw()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QVector3D getUvw() {
        return uvw();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertex1Index()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVertex1Index() {
        return vertex1Index();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertex2Index()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVertex2Index() {
        return vertex2Index();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #vertex3Index()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getVertex3Index() {
        return vertex3Index();
    }
}
