package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Tests the fragment shader's depth value against the depth of a sample being written to</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html">Qt3DRender::QDepthTest</a></code></p>
 */
public class QDepthTest extends io.qt.qt3d.render.QRenderState
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QDepthTest.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#DepthFunction-enum">Qt3DRender::QDepthTest::DepthFunction</a></code></p>
     */
    public enum DepthFunction implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#DepthFunction-enum">Qt3DRender::<wbr>QDepthTest::<wbr>Never</a></code></p>
         */
        Never(512),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#DepthFunction-enum">Qt3DRender::<wbr>QDepthTest::<wbr>Always</a></code></p>
         */
        Always(519),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#DepthFunction-enum">Qt3DRender::<wbr>QDepthTest::<wbr>Less</a></code></p>
         */
        Less(513),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#DepthFunction-enum">Qt3DRender::<wbr>QDepthTest::<wbr>LessOrEqual</a></code></p>
         */
        LessOrEqual(515),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#DepthFunction-enum">Qt3DRender::<wbr>QDepthTest::<wbr>Equal</a></code></p>
         */
        Equal(514),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#DepthFunction-enum">Qt3DRender::<wbr>QDepthTest::<wbr>GreaterOrEqual</a></code></p>
         */
        GreaterOrEqual(518),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#DepthFunction-enum">Qt3DRender::<wbr>QDepthTest::<wbr>Greater</a></code></p>
         */
        Greater(516),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#DepthFunction-enum">Qt3DRender::<wbr>QDepthTest::<wbr>NotEqual</a></code></p>
         */
        NotEqual(517);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private DepthFunction(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull DepthFunction resolve(int value) {
            switch (value) {
            case 512: return Never;
            case 519: return Always;
            case 513: return Less;
            case 515: return LessOrEqual;
            case 514: return Equal;
            case 518: return GreaterOrEqual;
            case 516: return Greater;
            case 517: return NotEqual;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#depthFunction-prop">Qt3DRender::QDepthTest::<wbr>depthFunctionChanged(Qt3DRender::QDepthTest::DepthFunction)</a></code></p>
     */
    @QtPropertyNotify(name="depthFunction")
    public final @NonNull Signal1<io.qt.qt3d.render.QDepthTest.@NonNull DepthFunction> depthFunctionChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#QDepthTest">Qt3DRender::QDepthTest::<wbr>QDepthTest(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QDepthTest(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QDepthTest instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#depthFunction-prop">Qt3DRender::QDepthTest::<wbr>depthFunction()const</a></code></p>
     */
    @QtPropertyReader(name="depthFunction")
    @QtUninvokable
    public final io.qt.qt3d.render.QDepthTest.@NonNull DepthFunction depthFunction(){
        return io.qt.qt3d.render.QDepthTest.DepthFunction.resolve(depthFunction_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int depthFunction_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qdepthtest.html#depthFunction-prop">Qt3DRender::QDepthTest::<wbr>setDepthFunction(Qt3DRender::QDepthTest::DepthFunction)</a></code></p>
     */
    @QtPropertyWriter(name="depthFunction")
    public final void setDepthFunction(io.qt.qt3d.render.QDepthTest.@NonNull DepthFunction depthFunction){
        setDepthFunction_native_Qt3DRender_QDepthTest_DepthFunction(QtJambi_LibraryUtilities.internal.nativeId(this), depthFunction.value());
    }
    
    private native void setDepthFunction_native_Qt3DRender_QDepthTest_DepthFunction(long __this__nativeId, int depthFunction);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QDepthTest(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QDepthTest(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QDepthTest instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QDepthTest(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QDepthTest() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #depthFunction()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QDepthTest.@NonNull DepthFunction getDepthFunction() {
        return depthFunction();
    }
}
