package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Class to clear buffers</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html">Qt3DRender::QClearBuffers</a></code></p>
 */
public class QClearBuffers extends io.qt.qt3d.render.QFrameGraphNode
{
    @QtPropertyMember(enabled=false)
    private Object __rcColorBuffer = null;
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QClearBuffers.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#BufferType-enum">Qt3DRender::QClearBuffers::BufferType</a></code></p>
     * 
     * @see BufferTypeFlags
     */
    public enum BufferType implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#BufferType-enum">Qt3DRender::<wbr>QClearBuffers::<wbr>None</a></code></p>
         */
        None(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#BufferType-enum">Qt3DRender::<wbr>QClearBuffers::<wbr>ColorBuffer</a></code></p>
         */
        ColorBuffer(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#BufferType-enum">Qt3DRender::<wbr>QClearBuffers::<wbr>DepthBuffer</a></code></p>
         */
        DepthBuffer(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#BufferType-enum">Qt3DRender::<wbr>QClearBuffers::<wbr>StencilBuffer</a></code></p>
         */
        StencilBuffer(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#BufferType-enum">Qt3DRender::<wbr>QClearBuffers::<wbr>DepthStencilBuffer</a></code></p>
         */
        DepthStencilBuffer(6),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#BufferType-enum">Qt3DRender::<wbr>QClearBuffers::<wbr>ColorDepthBuffer</a></code></p>
         */
        ColorDepthBuffer(3),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#BufferType-enum">Qt3DRender::<wbr>QClearBuffers::<wbr>ColorDepthStencilBuffer</a></code></p>
         */
        ColorDepthStencilBuffer(7),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#BufferType-enum">Qt3DRender::<wbr>QClearBuffers::<wbr>AllBuffers</a></code></p>
         */
        AllBuffers(-1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private BufferType(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        public @NonNull BufferTypeFlags asFlags() {
            return new BufferTypeFlags(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull BufferTypeFlags combined(@NonNull BufferType e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull BufferTypeFlags cleared(@NonNull BufferType e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link BufferTypeFlags} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull BufferTypeFlags flags(@Nullable BufferType @NonNull... values) {
            return new BufferTypeFlags(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull BufferType resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return ColorBuffer;
            case 2: return DepthBuffer;
            case 4: return StencilBuffer;
            case 6: return DepthStencilBuffer;
            case 3: return ColorDepthBuffer;
            case 7: return ColorDepthStencilBuffer;
            case -1: return AllBuffers;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link BufferType}
     */
    public static final class BufferTypeFlags extends QFlags<BufferType> implements Comparable<BufferTypeFlags> {
        private static final long serialVersionUID = 0xde4c54fa10606669L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new BufferTypeFlags where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public BufferTypeFlags(@Nullable BufferType @NonNull... args){
            super(args);
        }

        /**
         * Creates a new BufferTypeFlags with given <code>value</code>.
         * @param value
         */
        public BufferTypeFlags(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new BufferTypeFlags
         */
        @Override
        public final @NonNull BufferTypeFlags combined(@StrictNonNull BufferType e){
            return new BufferTypeFlags(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        public final @NonNull BufferTypeFlags setFlag(@Nullable BufferType e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        public final @NonNull BufferTypeFlags setFlag(@Nullable BufferType e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this BufferTypeFlags.
         * @return array of enum entries
         */
        @Override
        public final @NonNull BufferType @NonNull[] flags(){
            return super.flags(BufferType.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull BufferTypeFlags clone(){
            return new BufferTypeFlags(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull BufferTypeFlags other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#buffers-prop">Qt3DRender::QClearBuffers::<wbr>buffersChanged(Qt3DRender::QClearBuffers::BufferType)</a></code></p>
     */
    @QtPropertyNotify(name="buffers")
    public final @NonNull Signal1<io.qt.qt3d.render.QClearBuffers.@NonNull BufferType> buffersChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#clearColor-prop">Qt3DRender::QClearBuffers::<wbr>clearColorChanged(QColor)</a></code></p>
     */
    @QtPropertyNotify(name="clearColor")
    public final @NonNull Signal1<io.qt.gui.@NonNull QColor> clearColorChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#clearDepthValue-prop">Qt3DRender::QClearBuffers::<wbr>clearDepthValueChanged(float)</a></code></p>
     */
    @QtPropertyNotify(name="clearDepthValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Float> clearDepthValueChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#clearStencilValue-prop">Qt3DRender::QClearBuffers::<wbr>clearStencilValueChanged(int)</a></code></p>
     */
    @QtPropertyNotify(name="clearStencilValue")
    public final @NonNull Signal1<java.lang.@QtPrimitiveType@NonNull Integer> clearStencilValueChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#colorBuffer-prop">Qt3DRender::QClearBuffers::<wbr>colorBufferChanged(Qt3DRender::QRenderTargetOutput*)</a></code></p>
     */
    @QtPropertyNotify(name="colorBuffer")
    public final @NonNull Signal1<io.qt.qt3d.render.@Nullable QRenderTargetOutput> colorBufferChanged = new Signal1<>();
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#QClearBuffers">Qt3DRender::QClearBuffers::<wbr>QClearBuffers(Qt3DCore::QNode*)</a></code></p>
     */
    @SuppressWarnings({"exports"})
    public QClearBuffers(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QClearBuffers instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#buffers-prop">Qt3DRender::QClearBuffers::<wbr>buffers()const</a></code></p>
     */
    @QtPropertyReader(name="buffers")
    @QtUninvokable
    public final io.qt.qt3d.render.QClearBuffers.@NonNull BufferType buffers(){
        return io.qt.qt3d.render.QClearBuffers.BufferType.resolve(buffers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int buffers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#clearColor-prop">Qt3DRender::QClearBuffers::<wbr>clearColor()const</a></code></p>
     */
    @QtPropertyReader(name="clearColor")
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor clearColor(){
        return clearColor_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.gui.QColor clearColor_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#clearDepthValue-prop">Qt3DRender::QClearBuffers::<wbr>clearDepthValue()const</a></code></p>
     */
    @QtPropertyReader(name="clearDepthValue")
    @QtUninvokable
    public final float clearDepthValue(){
        return clearDepthValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native float clearDepthValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#clearStencilValue-prop">Qt3DRender::QClearBuffers::<wbr>clearStencilValue()const</a></code></p>
     */
    @QtPropertyReader(name="clearStencilValue")
    @QtUninvokable
    public final int clearStencilValue(){
        return clearStencilValue_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native int clearStencilValue_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#colorBuffer-prop">Qt3DRender::QClearBuffers::<wbr>colorBuffer()const</a></code></p>
     */
    @QtPropertyReader(name="colorBuffer")
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderTargetOutput colorBuffer(){
        return colorBuffer_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.qt3d.render.QRenderTargetOutput colorBuffer_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#buffers-prop">Qt3DRender::QClearBuffers::<wbr>setBuffers(Qt3DRender::QClearBuffers::BufferType)</a></code></p>
     */
    @QtPropertyWriter(name="buffers")
    public final void setBuffers(io.qt.qt3d.render.QClearBuffers.@NonNull BufferType buffers){
        setBuffers_native_Qt3DRender_QClearBuffers_BufferType(QtJambi_LibraryUtilities.internal.nativeId(this), buffers.value());
    }
    
    private native void setBuffers_native_Qt3DRender_QClearBuffers_BufferType(long __this__nativeId, int buffers);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#clearColor-prop">Qt3DRender::QClearBuffers::<wbr>setClearColor(QColor)</a></code></p>
     */
    @QtPropertyWriter(name="clearColor")
    public final void setClearColor(io.qt.gui.@NonNull QColor color){
        setClearColor_native_cref_QColor(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(color));
    }
    
    private native void setClearColor_native_cref_QColor(long __this__nativeId, long color);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#clearDepthValue-prop">Qt3DRender::QClearBuffers::<wbr>setClearDepthValue(float)</a></code></p>
     */
    @QtPropertyWriter(name="clearDepthValue")
    public final void setClearDepthValue(float clearDepthValue){
        setClearDepthValue_native_float(QtJambi_LibraryUtilities.internal.nativeId(this), clearDepthValue);
    }
    
    private native void setClearDepthValue_native_float(long __this__nativeId, float clearDepthValue);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#clearStencilValue-prop">Qt3DRender::QClearBuffers::<wbr>setClearStencilValue(int)</a></code></p>
     */
    @QtPropertyWriter(name="clearStencilValue")
    public final void setClearStencilValue(int clearStencilValue){
        setClearStencilValue_native_int(QtJambi_LibraryUtilities.internal.nativeId(this), clearStencilValue);
    }
    
    private native void setClearStencilValue_native_int(long __this__nativeId, int clearStencilValue);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qclearbuffers.html#colorBuffer-prop">Qt3DRender::QClearBuffers::<wbr>setColorBuffer(Qt3DRender::QRenderTargetOutput*)</a></code></p>
     */
    @QtPropertyWriter(name="colorBuffer")
    public final void setColorBuffer(io.qt.qt3d.render.@Nullable QRenderTargetOutput buffer){
        setColorBuffer_native_Qt3DRender_QRenderTargetOutput_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(buffer));
        __rcColorBuffer = buffer;
    }
    
    private native void setColorBuffer_native_Qt3DRender_QRenderTargetOutput_ptr(long __this__nativeId, long buffer);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QClearBuffers(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * @hidden
     * It is not allowed to call the declarative constructor from inside Java.
     */
    @NativeAccess
    protected QClearBuffers(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QClearBuffers instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QClearBuffers(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QClearBuffers() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #buffers()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QClearBuffers.@NonNull BufferType getBuffers() {
        return buffers();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #clearColor()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.gui.@NonNull QColor getClearColor() {
        return clearColor();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #clearDepthValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final float getClearDepthValue() {
        return clearDepthValue();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #clearStencilValue()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final int getClearStencilValue() {
        return clearStencilValue();
    }
    
    /**
     * <p>Kotlin property getter. In Java use {@link #colorBuffer()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.@Nullable QRenderTargetOutput getColorBuffer() {
        return colorBuffer();
    }
}
