package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>Class to emplace a memory barrier</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html">Qt3DRender::QMemoryBarrier</a></code></p>
 */
public class QMemoryBarrier extends io.qt.qt3d.render.QFrameGraphNode
{
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QMemoryBarrier.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::QMemoryBarrier::Operation</a></code></p>
     * 
     * @see Operations
     */
    public enum Operation implements QtFlagEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>None</a></code></p>
         */
        None(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>VertexAttributeArray</a></code></p>
         */
        VertexAttributeArray(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>ElementArray</a></code></p>
         */
        ElementArray(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>Uniform</a></code></p>
         */
        Uniform(4),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>TextureFetch</a></code></p>
         */
        TextureFetch(8),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>ShaderImageAccess</a></code></p>
         */
        ShaderImageAccess(16),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>Command</a></code></p>
         */
        Command(32),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>PixelBuffer</a></code></p>
         */
        PixelBuffer(64),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>TextureUpdate</a></code></p>
         */
        TextureUpdate(128),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>BufferUpdate</a></code></p>
         */
        BufferUpdate(256),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>FrameBuffer</a></code></p>
         */
        FrameBuffer(512),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>TransformFeedback</a></code></p>
         */
        TransformFeedback(1024),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>AtomicCounter</a></code></p>
         */
        AtomicCounter(2048),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>ShaderStorage</a></code></p>
         */
        ShaderStorage(4096),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>QueryBuffer</a></code></p>
         */
        QueryBuffer(8192),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qmemorybarrier.html#Operation-enum">Qt3DRender::<wbr/>QMemoryBarrier::<wbr/>All</a></code></p>
         */
        All(-1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private Operation(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Create a QFlags of the enum entry.
         * @return QFlags
         */
        @Override
        public @NonNull Operations asFlags() {
            return new Operations(value);
        }

        /**
         * Combines this entry with other enum entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull Operations combined(@NonNull Operation e) {
            return asFlags().setFlag(e, true);
        }

        /**
         * Excludes other enum entry from a flag of this entry.
         * @param e enum entry
         * @return new flag
         */
        public @NonNull Operations cleared(@NonNull Operation e) {
            return asFlags().setFlag(e, false);
        }

        /**
         * Creates a new {@link Operations} from the entries.
         * @param values entries
         * @return new flag
         */
        public static @NonNull Operations flags(@Nullable Operation @NonNull... values) {
            return new Operations(values);
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull Operation resolve(int value) {
            switch (value) {
            case 0: return None;
            case 1: return VertexAttributeArray;
            case 2: return ElementArray;
            case 4: return Uniform;
            case 8: return TextureFetch;
            case 16: return ShaderImageAccess;
            case 32: return Command;
            case 64: return PixelBuffer;
            case 128: return TextureUpdate;
            case 256: return BufferUpdate;
            case 512: return FrameBuffer;
            case 1024: return TransformFeedback;
            case 2048: return AtomicCounter;
            case 4096: return ShaderStorage;
            case 8192: return QueryBuffer;
            case -1: return All;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * {@link QFlags} type for enum {@link Operation}
     */
    public static final class Operations extends QFlags<Operation> implements Comparable<Operations> {
        private static final long serialVersionUID = 0xf54c38a476f13420L;
        static {
            QtJambi_LibraryUtilities.initialize();
        }

        /**
         * Creates a new Operations where the flags in <code>args</code> are set.
         * @param args enum entries
         */
        public Operations(@Nullable Operation @NonNull... args){
            super(args);
        }

        /**
         * Creates a new Operations with given <code>value</code>.
         * @param value
         */
        public Operations(int value) {
            super(value);
        }

        /**
         * Combines this flags with enum entry.
         * @param e enum entry
         * @return new Operations
         */
        @Override
        public final @NonNull Operations combined(@StrictNonNull Operation e){
            return new Operations(value() | e.value());
        }

        /**
         * Sets the flag <code>e</code>
         * @param e enum entry
         * @return this
         */
        @Override
        public final @NonNull Operations setFlag(@Nullable Operation e){
            return setFlag(e, true);
        }

        /**
         * Sets or clears the flag <code>flag</code>
         * @param e enum entry
         * @param on set (true) or clear (false)
         * @return this
         */
        @Override
        public final @NonNull Operations setFlag(@Nullable Operation e, boolean on){
            if (on) {
            	setValue(value() | e.value());
            }else {
            	setValue(value() & ~e.value());
            }
            return this;
        }

        /**
         * Returns an array of flag objects represented by this Operations.
         * @return array of enum entries
         */
        @Override
        public final @NonNull Operation @NonNull[] flags(){
            return super.flags(Operation.values());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final @NonNull Operations clone(){
            return new Operations(value());
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public final int compareTo(@StrictNonNull Operations other){
            return Integer.compare(value(), other.value());
        }
    }
    

    /**
     * <p>See <code>Qt3DRender::QMemoryBarrier::<wbr/>waitOperationsChanged(Qt3DRender::QMemoryBarrier::Operations)</code></p>
     */
    public final @NonNull Signal1<io.qt.qt3d.render.QMemoryBarrier.@NonNull Operations> waitOperationsChanged = new Signal1<>();
    
    /**
     * <p>See <code>Qt3DRender::QMemoryBarrier::<wbr/>QMemoryBarrier(Qt3DCore::QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QMemoryBarrier(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QMemoryBarrier instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code>Qt3DRender::QMemoryBarrier::<wbr/>setWaitOperations(Qt3DRender::QMemoryBarrier::Operations)</code></p>
     */
    public final void setWaitOperations(io.qt.qt3d.render.QMemoryBarrier.@NonNull Operations operations){
        setWaitOperations_native_Qt3DRender_QMemoryBarrier_Operations(QtJambi_LibraryUtilities.internal.nativeId(this), operations.value());
    }
    
    private native void setWaitOperations_native_Qt3DRender_QMemoryBarrier_Operations(long __this__nativeId, int operations);
    
    /**
     * <p>See <code>Qt3DRender::QMemoryBarrier::<wbr/>waitOperations()const</code></p>
     */
    @QtUninvokable
    public final io.qt.qt3d.render.QMemoryBarrier.@NonNull Operations waitOperations(){
        return new io.qt.qt3d.render.QMemoryBarrier.Operations(waitOperations_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int waitOperations_native_constfct(long __this__nativeId);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QMemoryBarrier(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QMemoryBarrier(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QMemoryBarrier instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QMemoryBarrier(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QMemoryBarrier() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * <p>Overloaded function for {@link #setWaitOperations(io.qt.qt3d.render.QMemoryBarrier.Operations)}.</p>
     */
    public final void setWaitOperations(io.qt.qt3d.render.QMemoryBarrier.@NonNull Operation @NonNull... operations) {
        setWaitOperations(new io.qt.qt3d.render.QMemoryBarrier.Operations(operations));
    }
}
