package io.qt.qt3d.render;

import io.qt.*;


/**
 * <p>An abstract base class for ray casting in 3d scenes</p>
 * <p>Java wrapper for Qt class <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html">Qt3DRender::QAbstractRayCaster</a></code></p>
 */
public class QAbstractRayCaster extends io.qt.qt3d.core.QComponent
{
    static {
        QtJambi_LibraryUtilities.initialize();
    }
    
    
    /**
     * This variable stores the meta-object for the class.
     */
    public static final io.qt.core.@NonNull QMetaObject staticMetaObject = io.qt.core.QMetaObject.forType(QAbstractRayCaster.class);
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#FilterMode-enum">Qt3DRender::QAbstractRayCaster::FilterMode</a></code></p>
     */
    public enum FilterMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#FilterMode-enum">Qt3DRender::<wbr/>QAbstractRayCaster::<wbr/>AcceptAnyMatchingLayers</a></code></p>
         */
        AcceptAnyMatchingLayers(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#FilterMode-enum">Qt3DRender::<wbr/>QAbstractRayCaster::<wbr/>AcceptAllMatchingLayers</a></code></p>
         */
        AcceptAllMatchingLayers(1),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#FilterMode-enum">Qt3DRender::<wbr/>QAbstractRayCaster::<wbr/>DiscardAnyMatchingLayers</a></code></p>
         */
        DiscardAnyMatchingLayers(2),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#FilterMode-enum">Qt3DRender::<wbr/>QAbstractRayCaster::<wbr/>DiscardAllMatchingLayers</a></code></p>
         */
        DiscardAllMatchingLayers(3);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private FilterMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull FilterMode resolve(int value) {
            switch (value) {
            case 0: return AcceptAnyMatchingLayers;
            case 1: return AcceptAllMatchingLayers;
            case 2: return DiscardAnyMatchingLayers;
            case 3: return DiscardAllMatchingLayers;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    
    /**
     * <p>Java wrapper for Qt enum <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#RunMode-enum">Qt3DRender::QAbstractRayCaster::RunMode</a></code></p>
     */
    public enum RunMode implements QtEnumerator {
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#RunMode-enum">Qt3DRender::<wbr/>QAbstractRayCaster::<wbr/>Continuous</a></code></p>
         */
        Continuous(0),
        /**
         * <p>Representing <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#RunMode-enum">Qt3DRender::<wbr/>QAbstractRayCaster::<wbr/>SingleShot</a></code></p>
         */
        SingleShot(1);

        static {
            QtJambi_LibraryUtilities.initialize();
        }

        private RunMode(int value) {
            this.value = value;
        }

        /**
         * {@inheritDoc}
         */
        @Override
        public int value() {
            return value;
        }

        /**
         * Returns the corresponding enum entry for the given value.
         * @param value
         * @return enum entry
         */
        public static @NonNull RunMode resolve(int value) {
            switch (value) {
            case 0: return Continuous;
            case 1: return SingleShot;
            default: throw new QNoSuchEnumValueException(value);
            }
        }


        private final int value;
    }
    

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#filterMode-prop">Qt3DRender::QAbstractRayCaster::<wbr/>filterModeChanged(Qt3DRender::QAbstractRayCaster::FilterMode)</a></code></p>
     */
    @QtPropertyNotify(name="filterMode")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractRayCaster.@NonNull FilterMode> filterModeChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#hits-prop">Qt3DRender::QAbstractRayCaster::<wbr/>hitsChanged(Qt3DRender::QAbstractRayCaster::Hits)</a></code></p>
     */
    @QtPropertyNotify(name="hits")
    public final @NonNull Signal1<java.util.@NonNull List<io.qt.qt3d.render.@NonNull QRayCasterHit>> hitsChanged = new Signal1<>();

    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#runMode-prop">Qt3DRender::QAbstractRayCaster::<wbr/>runModeChanged(Qt3DRender::QAbstractRayCaster::RunMode)</a></code></p>
     */
    @QtPropertyNotify(name="runMode")
    public final @NonNull Signal1<io.qt.qt3d.render.QAbstractRayCaster.@NonNull RunMode> runModeChanged = new Signal1<>();
    
    /**
     * <p>See <code>Qt3DRender::QAbstractRayCaster::<wbr/>QAbstractRayCaster(QNode*)</code></p>
     */
    @SuppressWarnings({"exports"})
    public QAbstractRayCaster(io.qt.qt3d.core.@Nullable QNode parent){
        super((QPrivateConstructor)null);
        initialize_native(this, parent);
    }
    
    private native static void initialize_native(QAbstractRayCaster instance, io.qt.qt3d.core.QNode parent);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#addLayer">Qt3DRender::QAbstractRayCaster::<wbr/>addLayer(Qt3DRender::QLayer*)</a></code></p>
     */
    @QtUninvokable
    public final void addLayer(io.qt.qt3d.render.@Nullable QLayer layer){
        addLayer_native_Qt3DRender_QLayer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(layer));
    }
    
    @QtUninvokable
    private native void addLayer_native_Qt3DRender_QLayer_ptr(long __this__nativeId, long layer);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#filterMode-prop">Qt3DRender::QAbstractRayCaster::<wbr/>filterMode()const</a></code></p>
     */
    @QtPropertyReader(name="filterMode")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractRayCaster.@NonNull FilterMode filterMode(){
        return io.qt.qt3d.render.QAbstractRayCaster.FilterMode.resolve(filterMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int filterMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#hits-prop">Qt3DRender::QAbstractRayCaster::<wbr/>hits()const</a></code></p>
     */
    @QtPropertyReader(name="hits")
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@NonNull QRayCasterHit> hits(){
        return hits_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QRayCasterHit> hits_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#layers">Qt3DRender::QAbstractRayCaster::<wbr/>layers()const</a></code></p>
     */
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@Nullable QLayer> layers(){
        return layers_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this));
    }
    
    @QtUninvokable
    private native io.qt.core.QList<io.qt.qt3d.render.QLayer> layers_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#removeLayer">Qt3DRender::QAbstractRayCaster::<wbr/>removeLayer(Qt3DRender::QLayer*)</a></code></p>
     */
    @QtUninvokable
    public final void removeLayer(io.qt.qt3d.render.@Nullable QLayer layer){
        removeLayer_native_Qt3DRender_QLayer_ptr(QtJambi_LibraryUtilities.internal.nativeId(this), QtJambi_LibraryUtilities.internal.checkedNativeId(layer));
    }
    
    @QtUninvokable
    private native void removeLayer_native_Qt3DRender_QLayer_ptr(long __this__nativeId, long layer);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#runMode-prop">Qt3DRender::QAbstractRayCaster::<wbr/>runMode()const</a></code></p>
     */
    @QtPropertyReader(name="runMode")
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractRayCaster.@NonNull RunMode runMode(){
        return io.qt.qt3d.render.QAbstractRayCaster.RunMode.resolve(runMode_native_constfct(QtJambi_LibraryUtilities.internal.nativeId(this)));
    }
    
    @QtUninvokable
    private native int runMode_native_constfct(long __this__nativeId);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#filterMode-prop">Qt3DRender::QAbstractRayCaster::<wbr/>setFilterMode(Qt3DRender::QAbstractRayCaster::FilterMode)</a></code></p>
     */
    @QtPropertyWriter(name="filterMode")
    public final void setFilterMode(io.qt.qt3d.render.QAbstractRayCaster.@NonNull FilterMode filterMode){
        setFilterMode_native_Qt3DRender_QAbstractRayCaster_FilterMode(QtJambi_LibraryUtilities.internal.nativeId(this), filterMode.value());
    }
    
    private native void setFilterMode_native_Qt3DRender_QAbstractRayCaster_FilterMode(long __this__nativeId, int filterMode);
    
    /**
     * <p>See <code><a href="https://doc.qt.io/qt/qt3drender-qabstractraycaster.html#runMode-prop">Qt3DRender::QAbstractRayCaster::<wbr/>setRunMode(Qt3DRender::QAbstractRayCaster::RunMode)</a></code></p>
     */
    @QtPropertyWriter(name="runMode")
    public final void setRunMode(io.qt.qt3d.render.QAbstractRayCaster.@NonNull RunMode runMode){
        setRunMode_native_Qt3DRender_QAbstractRayCaster_RunMode(QtJambi_LibraryUtilities.internal.nativeId(this), runMode.value());
    }
    
    private native void setRunMode_native_Qt3DRender_QAbstractRayCaster_RunMode(long __this__nativeId, int runMode);
    
    /**
     * Constructor for internal use only.
     * @param p expected to be <code>null</code>.
     * @hidden
     */
    @NativeAccess
    protected QAbstractRayCaster(QPrivateConstructor p) { super(p); } 
    
    /**
     * Constructor for internal use only.
     * It is not allowed to call the declarative constructor from inside Java.
     * @hidden
     */
    @NativeAccess
    protected QAbstractRayCaster(QDeclarativeConstructor constructor) {
        super((QPrivateConstructor)null);
        initialize_native(this, constructor);
    } 
    
    @QtUninvokable
    private static native void initialize_native(QAbstractRayCaster instance, QDeclarativeConstructor constructor);
    
    
    /**
     * <p>Overloaded constructor for {@link #QAbstractRayCaster(io.qt.qt3d.core.QNode)}
     *  with <code>parent = null</code>.</p>
     */
    public QAbstractRayCaster() {
        this((io.qt.qt3d.core.QNode)null);
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #filterMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractRayCaster.@NonNull FilterMode getFilterMode() {
        return filterMode();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #hits()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.core.@NonNull QList<io.qt.qt3d.render.@NonNull QRayCasterHit> getHits() {
        return hits();
    }
    
    /**
     * @hidden
     * <p>Kotlin property getter. In Java use {@link #runMode()} instead.</p>
     */
    @QtPropertyReader(enabled=false)
    @QtUninvokable
    public final io.qt.qt3d.render.QAbstractRayCaster.@NonNull RunMode getRunMode() {
        return runMode();
    }
}
